/*
 * Decompiled with CFR 0.152.
 */
package com.ib.controller;

import com.ib.client.Contract;
import com.ib.client.EClientErrors;
import com.ib.client.EClientSocket;
import com.ib.client.EJavaSignal;
import com.ib.client.EMessage;
import com.ib.client.EWrapper;
import com.ib.client.Order;
import java.io.IOException;
import java.nio.charset.StandardCharsets;

public class ApiConnection
extends EClientSocket {
    public static final char EOL = '\u0000';
    public static final char LOG_EOL = '_';
    private final ILogger m_inLogger;
    private final ILogger m_outLogger;
    private static final EJavaSignal m_signal = new EJavaSignal();

    public ApiConnection(EWrapper eWrapper, ILogger iLogger, ILogger iLogger2) {
        super(eWrapper, m_signal);
        this.m_inLogger = iLogger;
        this.m_outLogger = iLogger2;
    }

    @Override
    protected void sendMsg(EMessage eMessage) throws IOException {
        super.sendMsg(eMessage);
        byte[] byArray = eMessage.getRawData();
        if (this.m_outLogger != null) {
            this.m_outLogger.log(new String(byArray, 0, byArray.length, StandardCharsets.UTF_8));
        }
    }

    @Override
    public int readInt() throws IOException {
        int n = super.readInt();
        if (this.m_inLogger != null) {
            this.m_inLogger.log(String.valueOf((char)n));
        }
        return n;
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = super.read(byArray, n, n2);
        if (this.m_inLogger != null) {
            this.m_inLogger.log(new String(byArray, 0, n3, StandardCharsets.UTF_8));
        }
        return n3;
    }

    public synchronized void placeOrder(Contract contract, Order order) {
        if (!this.isConnected()) {
            this.notConnected();
            return;
        }
        if (this.serverVersion() < 66) {
            this.error(-1, EClientErrors.UPDATE_TWS, "ApiController requires TWS build 932 or higher to place orders.");
            return;
        }
        this.placeOrder(order.orderId(), contract, order);
    }

    public static interface ILogger {
        public void log(String var1);
    }
}

