/*
 * Decompiled with CFR 0.152.
 */
package com.ib.controller;

import com.ib.client.Types;
import com.ib.controller.Alias;
import com.ib.controller.Group;
import com.ib.controller.Profile;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;

public class AdvisorUtil {
    static List<Group> getGroups(String string) {
        try {
            return AdvisorUtil.getGroups_(string);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
    }

    static List<Group> getGroups_(String string) throws IOException {
        String string2;
        ArrayList<Group> arrayList = new ArrayList<Group>();
        Group group = null;
        BufferedReader bufferedReader = new BufferedReader(new StringReader(string));
        int n = 0;
        block6: while ((string2 = bufferedReader.readLine()) != null) {
            string2 = string2.trim();
            switch (n) {
                case 0: {
                    if (!string2.equals("<ListOfGroups>")) continue block6;
                    n = 1;
                    continue block6;
                }
                case 1: {
                    if (string2.equals("<Group>")) {
                        group = new Group();
                        n = 2;
                        continue block6;
                    }
                    if (string2.equals("</ListOfGroups>")) {
                        n = 0;
                        continue block6;
                    }
                    AdvisorUtil.err(string2);
                    continue block6;
                }
                case 2: {
                    if (string2.startsWith("<name>")) {
                        group.name(AdvisorUtil.getVal(string2));
                        continue block6;
                    }
                    if (string2.startsWith("<defaultMethod>")) {
                        group.defaultMethod(Types.Method.valueOf(AdvisorUtil.getVal(string2)));
                        continue block6;
                    }
                    if (string2.startsWith("<ListOfAccts")) {
                        n = 3;
                        continue block6;
                    }
                    if (string2.equals("</Group>")) {
                        arrayList.add(group);
                        n = 1;
                        continue block6;
                    }
                    AdvisorUtil.err(string2);
                    continue block6;
                }
                case 3: {
                    if (string2.equals("</ListOfAccts>")) {
                        n = 2;
                        continue block6;
                    }
                    group.addAccount(AdvisorUtil.getVal(string2));
                    continue block6;
                }
            }
        }
        return arrayList;
    }

    static List<Profile> getProfiles(String string) {
        try {
            return AdvisorUtil.getProfiles_(string);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
    }

    static List<Profile> getProfiles_(String string) throws IOException {
        String string2;
        ArrayList<Profile> arrayList = new ArrayList<Profile>();
        Profile profile = null;
        Profile.Allocation allocation = null;
        BufferedReader bufferedReader = new BufferedReader(new StringReader(string));
        int n = 0;
        block7: while ((string2 = bufferedReader.readLine()) != null) {
            string2 = string2.trim();
            switch (n) {
                case 0: {
                    if (!string2.equals("<ListOfAllocationProfiles>")) continue block7;
                    n = 1;
                    continue block7;
                }
                case 1: {
                    if (string2.equals("<AllocationProfile>")) {
                        profile = new Profile();
                        n = 2;
                        continue block7;
                    }
                    if (string2.equals("</ListOfAllocationProfiles>")) {
                        n = 0;
                        continue block7;
                    }
                    AdvisorUtil.err(string2);
                    continue block7;
                }
                case 2: {
                    if (string2.startsWith("<name>")) {
                        profile.name(AdvisorUtil.getVal(string2));
                        continue block7;
                    }
                    if (string2.startsWith("<type>")) {
                        int n2 = Integer.parseInt(AdvisorUtil.getVal(string2));
                        profile.type(Profile.Type.get(n2));
                        continue block7;
                    }
                    if (string2.startsWith("<ListOfAllocations")) {
                        n = 3;
                        continue block7;
                    }
                    if (string2.equals("</AllocationProfile>")) {
                        arrayList.add(profile);
                        n = 1;
                        continue block7;
                    }
                    AdvisorUtil.err(string2);
                    continue block7;
                }
                case 3: {
                    if (string2.equals("<Allocation>")) {
                        allocation = new Profile.Allocation();
                        n = 4;
                        continue block7;
                    }
                    if (string2.equals("</ListOfAllocations>")) {
                        n = 2;
                        continue block7;
                    }
                    AdvisorUtil.err(string2);
                    continue block7;
                }
                case 4: {
                    if (string2.startsWith("<acct>")) {
                        allocation.account(AdvisorUtil.getVal(string2));
                        continue block7;
                    }
                    if (string2.startsWith("<amount>")) {
                        allocation.amount(AdvisorUtil.getVal(string2));
                        continue block7;
                    }
                    if (string2.startsWith("<posEff>")) continue block7;
                    if (string2.equals("</Allocation>")) {
                        profile.add(allocation);
                        n = 3;
                        continue block7;
                    }
                    AdvisorUtil.err(string2);
                    continue block7;
                }
            }
        }
        return arrayList;
    }

    static List<Alias> getAliases(String string) {
        try {
            return AdvisorUtil.getAliases_(string);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
    }

    static List<Alias> getAliases_(String string) throws IOException {
        String string2;
        ArrayList<Alias> arrayList = new ArrayList<Alias>();
        Alias alias = null;
        BufferedReader bufferedReader = new BufferedReader(new StringReader(string));
        int n = 0;
        block5: while ((string2 = bufferedReader.readLine()) != null) {
            string2 = string2.trim();
            switch (n) {
                case 0: {
                    if (!string2.equals("<ListOfAccountAliases>")) continue block5;
                    n = 1;
                    continue block5;
                }
                case 1: {
                    if (string2.equals("<AccountAlias>")) {
                        alias = new Alias();
                        n = 2;
                        continue block5;
                    }
                    if (string2.equals("</ListOfAccountAliases>")) {
                        n = 0;
                        continue block5;
                    }
                    AdvisorUtil.err(string2);
                    continue block5;
                }
                case 2: {
                    if (string2.startsWith("<account>")) {
                        alias.account(AdvisorUtil.getVal(string2));
                        continue block5;
                    }
                    if (string2.startsWith("<alias>")) {
                        alias.alias(AdvisorUtil.getVal(string2));
                        continue block5;
                    }
                    if (string2.equals("</AccountAlias>")) {
                        arrayList.add(alias);
                        n = 1;
                        continue block5;
                    }
                    AdvisorUtil.err(string2);
                    continue block5;
                }
            }
        }
        return arrayList;
    }

    private static String getVal(String string) {
        int n = string.indexOf(62);
        int n2 = string.indexOf(60, 1);
        return string.substring(n + 1, n2);
    }

    private static void err(String string) {
        System.out.println("error " + string);
    }

    public static void main(String[] stringArray) {
        String string = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<ListOfAccountAliases>\n\t<AccountAlias>\n\t\t<account>DF109948</account>\n\t\t<alias>DF109948</alias>\n\t</AccountAlias>\n\t<AccountAlias>\n\t\t<account>DU109949</account>\n\t\t<alias>DU109949</alias>\n\t</AccountAlias>\n\t<AccountAlias>\n\t\t<account>DU109950</account>\n\t\t<alias>DU109950</alias>\n\t</AccountAlias>\n\t<AccountAlias>\n\t\t<account>DU110156</account>\n\t\t<alias>DU110156</alias>\n\t</AccountAlias>\n\t<AccountAlias>\n\t\t<account>DU110157</account>\n\t\t<alias>DU110157</alias>\n\t</AccountAlias>\n\t<AccountAlias>\n\t\t<account>DU110158</account>\n\t\t<alias>DU110158</alias>\n\t</AccountAlias>\n</ListOfAccountAliases>\n\n";
        List<Alias> list = AdvisorUtil.getAliases(string);
        if (list != null) {
            AdvisorUtil.err(list.toString());
        }
    }

    public static String getGroupsXml(List<Group> list) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        stringBuilder.append("<ListOfGroups>\n");
        for (Group group : list) {
            stringBuilder.append("<Group>\n");
            stringBuilder.append(String.format("<name>%s</name>%n", group.name()));
            stringBuilder.append(String.format("<defaultMethod>%s</defaultMethod>%n", group.defaultMethod()));
            stringBuilder.append("<ListOfAccts varName=\"list\"\n>");
            for (String string : group.accounts()) {
                stringBuilder.append(String.format("<String>%s</String>%n", string));
            }
            stringBuilder.append("</ListOfAccts>\n");
            stringBuilder.append("</Group>\n");
        }
        stringBuilder.append("</ListOfGroups>\n");
        return stringBuilder.toString();
    }

    public static String getProfilesXml(List<Profile> list) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        stringBuilder.append("<ListOfProfiles>\n");
        for (Profile profile : list) {
            stringBuilder.append("<Profile>\n");
            stringBuilder.append(String.format("<name>%s</name>%n", profile.name()));
            stringBuilder.append(String.format("<type>%s</type>%n", profile.type().ordinal()));
            stringBuilder.append("<ListOfAllocations varName=\"listOfAllocations\">\n");
            for (Profile.Allocation allocation : profile.allocations()) {
                stringBuilder.append("<Allocation>\n");
                stringBuilder.append(String.format("<acct>%s</acct>%n", allocation.account()));
                stringBuilder.append(String.format("<amount>%s</amount>%n", allocation.amount()));
                stringBuilder.append("</Allocation>\n");
            }
            stringBuilder.append("</ListOfAllocations>\n");
            stringBuilder.append("</Profile>\n");
        }
        stringBuilder.append("</ListOfProfiles>\n");
        return stringBuilder.toString();
    }
}

