/*
 * Decompiled with CFR 0.152.
 */
package com.ib.client;

import com.ib.client.IApiEnum;
import java.util.Arrays;

public class Types {
    public static <T extends Enum<?>> T getValueOf(String string, T[] TArray, T t) {
        for (T t2 : TArray) {
            if (!((IApiEnum)t2).getApiString().equals(string)) continue;
            return t2;
        }
        return t;
    }

    public static <T extends Enum<T>> T getEnum(int n, T[] TArray) {
        if (n == Integer.MAX_VALUE) {
            return null;
        }
        for (T t : TArray) {
            if (((Enum)t).ordinal() != n) continue;
            return t;
        }
        String string = String.format("Error: %s is not a valid value for enum %s", n, TArray[0].getClass().getName());
        throw new IllegalArgumentException(string);
    }

    public static enum UsePriceMgmtAlgo {
        Default(null),
        NotUse(false),
        Use(true);

        private Boolean value;

        private UsePriceMgmtAlgo(Boolean bl) {
            this.value = bl;
        }

        public Boolean toBoolean() {
            return this.value;
        }
    }

    public static enum Method implements IApiEnum
    {
        None,
        EqualQuantity,
        AvailableEquity,
        NetLiq,
        PctChange;


        public static Method get(String string) {
            return (Method)Types.getValueOf((String)string, (Enum[])Method.values(), (Enum)None);
        }

        @Override
        public String getApiString() {
            return this == None ? "" : super.toString();
        }
    }

    public static enum MktDataType {
        Unknown,
        Realtime,
        Frozen,
        Delayed,
        DelayedFrozen;


        public static MktDataType get(int n) {
            return (MktDataType)Types.getEnum((int)n, (Enum[])MktDataType.values());
        }
    }

    public static enum SecType implements IApiEnum
    {
        None,
        STK,
        OPT,
        FUT,
        CONTFUT,
        CASH,
        BOND,
        CFD,
        FOP,
        WAR,
        IOPT,
        FWD,
        BAG,
        IND,
        BILL,
        FUND,
        FIXED,
        SLB,
        NEWS,
        CMDTY,
        BSK,
        ICU,
        ICS,
        CRYPTO;


        public static SecType get(String string) {
            return (SecType)Types.getValueOf((String)string, (Enum[])SecType.values(), (Enum)None);
        }

        @Override
        public String getApiString() {
            return this == None ? "" : super.toString();
        }
    }

    public static enum SecIdType implements IApiEnum
    {
        None,
        CUSIP,
        SEDOL,
        ISIN,
        RIC;


        public static SecIdType get(String string) {
            return (SecIdType)Types.getValueOf((String)string, (Enum[])SecIdType.values(), (Enum)None);
        }

        @Override
        public String getApiString() {
            return this == None ? "" : super.toString();
        }
    }

    public static enum FADataType {
        UNUSED,
        GROUPS,
        PROFILES,
        ALIASES;


        public static FADataType get(int n) {
            return (FADataType)Types.getEnum((int)n, (Enum[])FADataType.values());
        }
    }

    public static enum NewsType {
        UNKNOWN,
        BBS,
        LIVE_EXCH,
        DEAD_EXCH,
        HTML,
        POPUP_TEXT,
        POPUP_HTML;


        public static NewsType get(int n) {
            return (NewsType)Types.getEnum((int)n, (Enum[])NewsType.values());
        }
    }

    public static enum DeepSide {
        SELL,
        BUY;


        public static DeepSide get(int n) {
            return (DeepSide)Types.getEnum((int)n, (Enum[])DeepSide.values());
        }
    }

    public static enum DeepType {
        INSERT,
        UPDATE,
        DELETE;


        public static DeepType get(int n) {
            return (DeepType)Types.getEnum((int)n, (Enum[])DeepType.values());
        }
    }

    public static enum DurationUnit {
        SECOND,
        DAY,
        WEEK,
        MONTH,
        YEAR;

    }

    public static enum BarSize {
        _1_secs("1 secs"),
        _5_secs("5 secs"),
        _10_secs("10 secs"),
        _15_secs("15 secs"),
        _30_secs("30 secs"),
        _1_min("1 min"),
        _2_mins("2 mins"),
        _3_mins("3 mins"),
        _5_mins("5 mins"),
        _10_mins("10 mins"),
        _15_mins("15 mins"),
        _20_mins("20 mins"),
        _30_mins("30 mins"),
        _1_hour("1 hour"),
        _2_hours("2 hours"),
        _4_hours("4 hours"),
        _1_day("1 day"),
        _1_week("1 week"),
        _1_month("1 month");

        private final String description;

        private BarSize(String string2) {
            this.description = string2;
        }

        public String toString() {
            return this.description;
        }
    }

    public static enum WhatToShow {
        TRADES,
        MIDPOINT,
        BID,
        ASK,
        BID_ASK,
        HISTORICAL_VOLATILITY,
        OPTION_IMPLIED_VOLATILITY,
        YIELD_ASK,
        YIELD_BID,
        YIELD_BID_ASK,
        YIELD_LAST,
        ADJUSTED_LAST,
        SCHEDULE,
        AGGTRADES;

    }

    public static enum FundamentalType {
        ReportSnapshot("Company overview"),
        ReportsFinSummary("Financial summary"),
        ReportRatios("Financial ratios"),
        ReportsFinStatements("Financial statements"),
        RESC("Analyst estimates"),
        CalendarReport("Company calendar"),
        ReportsOwnership("Company ownership");

        private final String description;

        private FundamentalType(String string2) {
            this.description = string2;
        }

        public String getApiString() {
            return super.toString();
        }

        public String toString() {
            return this.description;
        }
    }

    public static enum ExerciseType {
        None,
        Exercise,
        Lapse;

    }

    public static enum TimeInForce implements IApiEnum
    {
        DAY,
        GTC,
        OPG,
        IOC,
        GTD,
        GTT,
        AUC,
        FOK,
        GTX,
        DTC,
        Minutes;


        public static TimeInForce get(String string) {
            return (TimeInForce)Types.getValueOf((String)string, (Enum[])TimeInForce.values(), null);
        }

        @Override
        public String getApiString() {
            return this.toString();
        }
    }

    public static enum OcaType implements IApiEnum
    {
        None,
        CancelWithBlocking,
        ReduceWithBlocking,
        ReduceWithoutBlocking;


        public static OcaType get(int n) {
            return (OcaType)Types.getEnum((int)n, (Enum[])OcaType.values());
        }

        @Override
        public String getApiString() {
            return String.valueOf(this.ordinal());
        }
    }

    public static enum Rule80A implements IApiEnum
    {
        None(""),
        Individual("I"),
        Agency("A"),
        AgentOtherMember("W"),
        IndividualPTIA("J"),
        AgencyPTIA("U"),
        AgentOtherMemberPTIA("M"),
        IndividualPT("K"),
        AgencyPT("Y"),
        AgentOtherMemberPT("N");

        private String m_apiString;

        private Rule80A(String string2) {
            this.m_apiString = string2;
        }

        public static Rule80A get(String string) {
            return (Rule80A)Types.getValueOf((String)string, (Enum[])Rule80A.values(), (Enum)None);
        }

        @Override
        public String getApiString() {
            return this.m_apiString;
        }
    }

    public static enum Action implements IApiEnum
    {
        BUY,
        SELL,
        SSHORT;


        public static Action get(String string) {
            return (Action)Types.getValueOf((String)string, (Enum[])Action.values(), null);
        }

        @Override
        public String getApiString() {
            return this.toString();
        }
    }

    public static enum TriggerMethod implements IApiEnum
    {
        Default(0),
        DoubleBidAsk(1),
        Last(2),
        DoubleLast(3),
        BidAsk(4),
        LastOrBidAsk(7),
        Midpoint(8);

        int m_val;

        public int val() {
            return this.m_val;
        }

        private TriggerMethod(int n2) {
            this.m_val = n2;
        }

        public static TriggerMethod get(int n) {
            for (TriggerMethod triggerMethod : TriggerMethod.values()) {
                if (triggerMethod.m_val != n) continue;
                return triggerMethod;
            }
            return null;
        }

        @Override
        public String getApiString() {
            return String.valueOf(this.m_val);
        }
    }

    public static enum ReferencePriceType implements IApiEnum
    {
        None,
        Midpoint,
        BidOrAsk;


        public static ReferencePriceType get(int n) {
            return (ReferencePriceType)Types.getEnum((int)n, (Enum[])ReferencePriceType.values());
        }

        @Override
        public String getApiString() {
            return String.valueOf(this.ordinal());
        }
    }

    public static enum VolatilityType implements IApiEnum
    {
        None,
        Daily,
        Annual;


        public static VolatilityType get(int n) {
            return n == Integer.MAX_VALUE ? None : (VolatilityType)Types.getEnum((int)n, (Enum[])VolatilityType.values());
        }

        @Override
        public String getApiString() {
            return String.valueOf(this.ordinal());
        }
    }

    public static enum Right implements IApiEnum
    {
        None,
        Put,
        Call;


        public static Right get(String string) {
            if (string != null && string.length() > 0) {
                switch (string.charAt(0)) {
                    case 'P': {
                        return Put;
                    }
                    case 'C': {
                        return Call;
                    }
                }
            }
            return None;
        }

        @Override
        public String getApiString() {
            return this == None ? "" : String.valueOf(this.toString().charAt(0));
        }
    }

    public static enum HedgeType implements IApiEnum
    {
        None,
        Delta,
        Beta,
        Fx,
        Pair;


        public static HedgeType get(String string) {
            return (HedgeType)Types.getValueOf((String)string, (Enum[])HedgeType.values(), (Enum)None);
        }

        @Override
        public String getApiString() {
            return this == None ? "" : String.valueOf(super.toString().charAt(0));
        }
    }

    public static enum AlgoStrategy implements IApiEnum
    {
        None(new AlgoParam[0]),
        Vwap(AlgoParam.startTime, AlgoParam.endTime, AlgoParam.maxPctVol, AlgoParam.noTakeLiq, AlgoParam.getDone, AlgoParam.noTradeAhead, AlgoParam.useOddLots),
        Twap(AlgoParam.startTime, AlgoParam.endTime, AlgoParam.allowPastEndTime, AlgoParam.strategyType),
        ArrivalPx(AlgoParam.startTime, AlgoParam.endTime, AlgoParam.allowPastEndTime, AlgoParam.maxPctVol, AlgoParam.riskAversion, AlgoParam.forceCompletion),
        DarkIce(AlgoParam.startTime, AlgoParam.endTime, AlgoParam.allowPastEndTime, AlgoParam.displaySize),
        PctVol(AlgoParam.startTime, AlgoParam.endTime, AlgoParam.pctVol, AlgoParam.noTakeLiq),
        AD(AlgoParam.activeTimeStart, AlgoParam.activeTimeEnd, AlgoParam.componentSize, AlgoParam.timeBetweenOrders, AlgoParam.randomizeTime20, AlgoParam.randomizeSize55, AlgoParam.giveUp, AlgoParam.catchUp, AlgoParam.waitForFill);

        private AlgoParam[] m_params;

        public AlgoParam[] params() {
            return Arrays.copyOf(this.m_params, this.m_params.length);
        }

        private AlgoStrategy(AlgoParam ... algoParamArray) {
            this.m_params = Arrays.copyOf(algoParamArray, algoParamArray.length);
        }

        public static AlgoStrategy get(String string) {
            return (AlgoStrategy)Types.getValueOf((String)string, (Enum[])AlgoStrategy.values(), (Enum)None);
        }

        @Override
        public String getApiString() {
            return this == None ? "" : super.toString();
        }
    }

    public static enum AlgoParam {
        startTime,
        endTime,
        allowPastEndTime,
        maxPctVol,
        pctVol,
        strategyType,
        noTakeLiq,
        riskAversion,
        forceCompletion,
        displaySize,
        getDone,
        noTradeAhead,
        useOddLots,
        componentSize,
        timeBetweenOrders,
        randomizeTime20,
        randomizeSize55,
        giveUp,
        catchUp,
        waitForFill,
        activeTimeStart,
        activeTimeEnd;

    }

    public static enum ComboParam {
        NonGuaranteed,
        PriceCondConid,
        CondPriceMax,
        CondPriceMin,
        ChangeToMktTime1,
        ChangeToMktTime2,
        DiscretionaryPct,
        DontLeginNext,
        LeginPrio,
        MaxSegSize;

    }

    public static enum TickByTickType {
        None,
        Last,
        AllLast,
        BidAsk,
        MidPoint;

    }
}

