/*
 * Decompiled with CFR 0.152.
 */
package com.ib.client;

public enum TickType {
    BID_SIZE(0, "bidSize"),
    BID(1, "bidPrice"),
    ASK(2, "askPrice"),
    ASK_SIZE(3, "askSize"),
    LAST(4, "lastPrice"),
    LAST_SIZE(5, "lastSize"),
    HIGH(6, "high"),
    LOW(7, "low"),
    VOLUME(8, "volume"),
    CLOSE(9, "close"),
    BID_OPTION(10, "bidOptComp"),
    ASK_OPTION(11, "askOptComp"),
    LAST_OPTION(12, "lastOptComp"),
    MODEL_OPTION(13, "modelOptComp"),
    OPEN(14, "open"),
    LOW_13_WEEK(15, "13WeekLow"),
    HIGH_13_WEEK(16, "13WeekHigh"),
    LOW_26_WEEK(17, "26WeekLow"),
    HIGH_26_WEEK(18, "26WeekHigh"),
    LOW_52_WEEK(19, "52WeekLow"),
    HIGH_52_WEEK(20, "52WeekHigh"),
    AVG_VOLUME(21, "AvgVolume"),
    OPEN_INTEREST(22, "OpenInterest"),
    OPTION_HISTORICAL_VOL(23, "OptionHistoricalVolatility"),
    OPTION_IMPLIED_VOL(24, "OptionImpliedVolatility"),
    OPTION_BID_EXCH(25, "OptionBidExchStr"),
    OPTION_ASK_EXCH(26, "OptionAskExchStr"),
    OPTION_CALL_OPEN_INTEREST(27, "OptionCallOpenInterest"),
    OPTION_PUT_OPEN_INTEREST(28, "OptionPutOpenInterest"),
    OPTION_CALL_VOLUME(29, "OptionCallVolume"),
    OPTION_PUT_VOLUME(30, "OptionPutVolume"),
    INDEX_FUTURE_PREMIUM(31, "IndexFuturePremium"),
    BID_EXCH(32, "bidExch"),
    ASK_EXCH(33, "askExch"),
    AUCTION_VOLUME(34, "auctionVolume"),
    AUCTION_PRICE(35, "auctionPrice"),
    AUCTION_IMBALANCE(36, "auctionImbalance"),
    MARK_PRICE(37, "markPrice"),
    BID_EFP_COMPUTATION(38, "bidEFP"),
    ASK_EFP_COMPUTATION(39, "askEFP"),
    LAST_EFP_COMPUTATION(40, "lastEFP"),
    OPEN_EFP_COMPUTATION(41, "openEFP"),
    HIGH_EFP_COMPUTATION(42, "highEFP"),
    LOW_EFP_COMPUTATION(43, "lowEFP"),
    CLOSE_EFP_COMPUTATION(44, "closeEFP"),
    LAST_TIMESTAMP(45, "lastTimestamp"),
    SHORTABLE(46, "shortable"),
    FUNDAMENTAL_RATIOS(47, "fundamentals"),
    RT_VOLUME(48, "RTVolume"),
    HALTED(49, "halted"),
    BID_YIELD(50, "bidYield"),
    ASK_YIELD(51, "askYield"),
    LAST_YIELD(52, "lastYield"),
    CUST_OPTION_COMPUTATION(53, "custOptComp"),
    TRADE_COUNT(54, "tradeCount"),
    TRADE_RATE(55, "tradeRate"),
    VOLUME_RATE(56, "volumeRate"),
    LAST_RTH_TRADE(57, "lastRTHTrade"),
    RT_HISTORICAL_VOL(58, "RTHistoricalVol"),
    IB_DIVIDENDS(59, "IBDividends"),
    BOND_FACTOR_MULTIPLIER(60, "bondFactorMultiplier"),
    REGULATORY_IMBALANCE(61, "regulatoryImbalance"),
    NEWS_TICK(62, "newsTick"),
    SHORT_TERM_VOLUME_3_MIN(63, "shortTermVolume3Min"),
    SHORT_TERM_VOLUME_5_MIN(64, "shortTermVolume5Min"),
    SHORT_TERM_VOLUME_10_MIN(65, "shortTermVolume10Min"),
    DELAYED_BID(66, "delayedBid"),
    DELAYED_ASK(67, "delayedAsk"),
    DELAYED_LAST(68, "delayedLast"),
    DELAYED_BID_SIZE(69, "delayedBidSize"),
    DELAYED_ASK_SIZE(70, "delayedAskSize"),
    DELAYED_LAST_SIZE(71, "delayedLastSize"),
    DELAYED_HIGH(72, "delayedHigh"),
    DELAYED_LOW(73, "delayedLow"),
    DELAYED_VOLUME(74, "delayedVolume"),
    DELAYED_CLOSE(75, "delayedClose"),
    DELAYED_OPEN(76, "delayedOpen"),
    RT_TRD_VOLUME(77, "rtTrdVolume"),
    CREDITMAN_MARK_PRICE(78, "creditmanMarkPrice"),
    CREDITMAN_SLOW_MARK_PRICE(79, "creditmanSlowMarkPrice"),
    DELAYED_BID_OPTION(80, "delayedBidOptComp"),
    DELAYED_ASK_OPTION(81, "delayedAskOptComp"),
    DELAYED_LAST_OPTION(82, "delayedLastOptComp"),
    DELAYED_MODEL_OPTION(83, "delayedModelOptComp"),
    LAST_EXCH(84, "lastExchange"),
    LAST_REG_TIME(85, "lastRegTime"),
    FUTURES_OPEN_INTEREST(86, "futuresOpenInterest"),
    AVG_OPT_VOLUME(87, "avgOptVolume"),
    DELAYED_LAST_TIMESTAMP(88, "delayedLastTimestamp"),
    SHORTABLE_SHARES(89, "shortableShares"),
    DELAYED_HALTED(90, "delayedHalted"),
    REUTERS_2_MUTUAL_FUNDS(91, "reuters2MutualFunds"),
    ETF_NAV_CLOSE(92, "etfNavClose"),
    ETF_NAV_PRIOR_CLOSE(93, "etfNavPriorClose"),
    ETF_NAV_BID(94, "etfNavBid"),
    ETF_NAV_ASK(95, "etfNavAsk"),
    ETF_NAV_LAST(96, "etfNavLast"),
    ETF_FROZEN_NAV_LAST(97, "etfFrozenNavLast"),
    ETF_NAV_HIGH(98, "etfNavHigh"),
    ETF_NAV_LOW(99, "etfNavLow"),
    SOCIAL_MARKET_ANALYTICS(100, "socialMarketAnalytics"),
    ESTIMATED_IPO_MIDPOINT(101, "estimatedIPOMidpoint"),
    FINAL_IPO_LAST(102, "finalIPOLast"),
    UNKNOWN(Integer.MAX_VALUE, "unknown");

    private int m_ndx;
    private String m_field;

    public int index() {
        return this.m_ndx;
    }

    public String field() {
        return this.m_field;
    }

    private TickType(int n2, String string2) {
        this.m_ndx = n2;
        this.m_field = string2;
    }

    public static TickType get(int n) {
        for (TickType tickType : TickType.values()) {
            if (tickType.m_ndx != n) continue;
            return tickType;
        }
        return UNKNOWN;
    }

    public static String getField(int n) {
        return TickType.get(n).field();
    }

    public static int getType(String string) {
        for (TickType tickType : TickType.values()) {
            if (!tickType.m_field.equalsIgnoreCase(string)) continue;
            return tickType.m_ndx;
        }
        return TickType.UNKNOWN.m_ndx;
    }
}

