/*
 * Decompiled with CFR 0.152.
 */
package com.ib.client;

import com.ib.client.Decimal;
import com.ib.client.TickAttribBidAsk;
import com.ib.client.TickAttribLast;

public class TickByTick {
    private int m_tickType;
    private long m_time;
    private double m_price;
    private Decimal m_size;
    private TickAttribLast m_tickAttribLast;
    private TickAttribBidAsk m_tickAttribBidAsk;
    private String m_exchange;
    private String m_specialConditions;
    private double m_bidPrice;
    private Decimal m_bidSize;
    private double m_askPrice;
    private Decimal m_askSize;
    private double m_midPoint;

    public TickByTick(int n, long l, double d, Decimal decimal, TickAttribLast tickAttribLast, String string, String string2) {
        this.m_tickType = n;
        this.m_time = l;
        this.m_price = d;
        this.m_size = decimal;
        this.m_tickAttribLast = tickAttribLast;
        this.m_exchange = string;
        this.m_specialConditions = string2;
    }

    public TickByTick(long l, double d, Decimal decimal, double d2, Decimal decimal2, TickAttribBidAsk tickAttribBidAsk) {
        this.m_tickType = 3;
        this.m_time = l;
        this.m_bidPrice = d;
        this.m_bidSize = decimal;
        this.m_askPrice = d2;
        this.m_askSize = decimal2;
        this.m_tickAttribBidAsk = tickAttribBidAsk;
    }

    public TickByTick(long l, double d) {
        this.m_tickType = 4;
        this.m_time = l;
        this.m_midPoint = d;
    }

    public int tickType() {
        return this.m_tickType;
    }

    public long time() {
        return this.m_time;
    }

    public double price() {
        return this.m_price;
    }

    public Decimal size() {
        return this.m_size;
    }

    public TickAttribLast tickAttribLast() {
        return this.m_tickAttribLast;
    }

    public TickAttribBidAsk tickAttribBidAsk() {
        return this.m_tickAttribBidAsk;
    }

    public String tickAttribLastStr() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.m_tickAttribLast.pastLimit() ? "PastLimit " : "");
        stringBuilder.append(this.m_tickAttribLast.unreported() ? "Unreported " : "");
        return stringBuilder.toString();
    }

    public String tickAttribBidAskStr() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.m_tickAttribBidAsk.bidPastLow() ? "BidPastLow " : "");
        stringBuilder.append(this.m_tickAttribBidAsk.askPastHigh() ? "AskPastHigh " : "");
        return stringBuilder.toString();
    }

    public String exchange() {
        return this.m_exchange;
    }

    public String specialConditions() {
        return this.m_specialConditions;
    }

    public double bidPrice() {
        return this.m_bidPrice;
    }

    public Decimal bidSize() {
        return this.m_bidSize;
    }

    public double askPrice() {
        return this.m_askPrice;
    }

    public Decimal askSize() {
        return this.m_askSize;
    }

    public double midPoint() {
        return this.m_midPoint;
    }
}

