/*
 * Decompiled with CFR 0.152.
 */
package com.ib.client;

import com.ib.client.Decimal;
import com.ib.client.OrderComboLeg;
import com.ib.client.OrderCondition;
import com.ib.client.OrderType;
import com.ib.client.SoftDollarTier;
import com.ib.client.TagValue;
import com.ib.client.Types;
import com.ib.client.Util;
import java.util.ArrayList;
import java.util.List;

public class Order {
    public static final int CUSTOMER = 0;
    public static final int FIRM = 1;
    public static final char OPT_UNKNOWN = '?';
    public static final char OPT_BROKER_DEALER = 'b';
    public static final char OPT_CUSTOMER = 'c';
    public static final char OPT_FIRM = 'f';
    public static final char OPT_ISEMM = 'm';
    public static final char OPT_FARMM = 'n';
    public static final char OPT_SPECIALIST = 'y';
    public static final int AUCTION_MATCH = 1;
    public static final int AUCTION_IMPROVEMENT = 2;
    public static final int AUCTION_TRANSPARENT = 3;
    public static final String EMPTY_STR = "";
    public static final double COMPETE_AGAINST_BEST_OFFSET_UP_TO_MID = Double.POSITIVE_INFINITY;
    private int m_clientId;
    private int m_orderId;
    private int m_permId;
    private int m_parentId;
    private String m_action = "BUY";
    private Decimal m_totalQuantity = Decimal.INVALID;
    private int m_displaySize;
    private String m_orderType = "LMT";
    private double m_lmtPrice = Double.MAX_VALUE;
    private double m_auxPrice = Double.MAX_VALUE;
    private String m_tif = "DAY";
    private String m_account;
    private String m_settlingFirm;
    private String m_clearingAccount;
    private String m_clearingIntent;
    private boolean m_allOrNone;
    private boolean m_blockOrder;
    private boolean m_hidden;
    private boolean m_outsideRth = false;
    private boolean m_sweepToFill;
    private double m_percentOffset = Double.MAX_VALUE;
    private double m_trailingPercent = Double.MAX_VALUE;
    private double m_trailStopPrice = Double.MAX_VALUE;
    private int m_minQty = Integer.MAX_VALUE;
    private String m_goodAfterTime;
    private String m_goodTillDate;
    private String m_ocaGroup;
    private String m_orderRef;
    private String m_rule80A = "";
    private int m_ocaType = 0;
    private int m_triggerMethod = 0;
    private String m_activeStartTime = "";
    private String m_activeStopTime = "";
    private String m_faGroup;
    private String m_faMethod = "";
    private String m_faPercentage;
    private String m_faProfile;
    private double m_volatility = Double.MAX_VALUE;
    private int m_volatilityType = Integer.MAX_VALUE;
    private int m_continuousUpdate;
    private int m_referencePriceType = Integer.MAX_VALUE;
    private String m_deltaNeutralOrderType = "";
    private double m_deltaNeutralAuxPrice = Double.MAX_VALUE;
    private int m_deltaNeutralConId = 0;
    private String m_deltaNeutralOpenClose = "";
    private boolean m_deltaNeutralShortSale = false;
    private int m_deltaNeutralShortSaleSlot = 0;
    private String m_deltaNeutralDesignatedLocation = "";
    private int m_scaleInitLevelSize = Integer.MAX_VALUE;
    private int m_scaleSubsLevelSize = Integer.MAX_VALUE;
    private double m_scalePriceIncrement = Double.MAX_VALUE;
    private double m_scalePriceAdjustValue = Double.MAX_VALUE;
    private int m_scalePriceAdjustInterval = Integer.MAX_VALUE;
    private double m_scaleProfitOffset = Double.MAX_VALUE;
    private boolean m_scaleAutoReset = false;
    private int m_scaleInitPosition = Integer.MAX_VALUE;
    private int m_scaleInitFillQty = Integer.MAX_VALUE;
    private boolean m_scaleRandomPercent = false;
    private String m_scaleTable = "";
    private String m_hedgeType = "";
    private String m_hedgeParam;
    private String m_algoStrategy = "";
    private List<TagValue> m_algoParams = new ArrayList<TagValue>();
    private String m_algoId = "";
    private List<TagValue> m_smartComboRoutingParams = new ArrayList<TagValue>();
    private List<OrderComboLeg> m_orderComboLegs = new ArrayList<OrderComboLeg>();
    private boolean m_whatIf = false;
    private boolean m_transmit = true;
    private boolean m_overridePercentageConstraints;
    private String m_openClose = "";
    private int m_origin = 0;
    private int m_shortSaleSlot;
    private String m_designatedLocation = "";
    private int m_exemptCode = -1;
    private String m_deltaNeutralSettlingFirm = "";
    private String m_deltaNeutralClearingAccount = "";
    private String m_deltaNeutralClearingIntent = "";
    private double m_discretionaryAmt = Double.MAX_VALUE;
    private boolean m_optOutSmartRouting = false;
    private int m_auctionStrategy;
    private double m_startingPrice;
    private double m_stockRefPrice;
    private double m_delta = Double.MAX_VALUE;
    private double m_stockRangeLower;
    private double m_stockRangeUpper;
    private double m_basisPoints;
    private int m_basisPointsType;
    private boolean m_notHeld = false;
    private List<TagValue> m_orderMiscOptions;
    private boolean m_solicited = false;
    private boolean m_randomizeSize = false;
    private boolean m_randomizePrice = false;
    private int m_referenceContractId;
    private double m_peggedChangeAmount;
    private boolean m_isPeggedChangeAmountDecrease;
    private double m_referenceChangeAmount;
    private String m_referenceExchangeId;
    private OrderType m_adjustedOrderType;
    private double m_triggerPrice = Double.MAX_VALUE;
    private double m_adjustedStopPrice = Double.MAX_VALUE;
    private double m_adjustedStopLimitPrice = Double.MAX_VALUE;
    private double m_adjustedTrailingAmount = Double.MAX_VALUE;
    private int m_adjustableTrailingUnit;
    private double m_lmtPriceOffset = Double.MAX_VALUE;
    private List<OrderCondition> m_conditions = new ArrayList<OrderCondition>();
    private boolean m_conditionsCancelOrder;
    private boolean m_conditionsIgnoreRth;
    private String m_modelCode;
    private String m_extOperator = "";
    private SoftDollarTier m_softDollarTier;
    private double m_cashQty = Double.MAX_VALUE;
    private String m_mifid2DecisionMaker = "";
    private String m_mifid2DecisionAlgo = "";
    private String m_mifid2ExecutionTrader = "";
    private String m_mifid2ExecutionAlgo = "";
    private boolean m_dontUseAutoPriceForHedge = false;
    private boolean m_isOmsContainer = false;
    private boolean m_discretionaryUpToLimitPrice = false;
    private String m_autoCancelDate = "";
    private Decimal m_filledQuantity;
    private int m_refFuturesConId = 0;
    private boolean m_autoCancelParent = false;
    private String m_shareholder = "";
    private boolean m_imbalanceOnly = false;
    private boolean m_routeMarketableToBbo = false;
    private long m_parentPermId = 0L;
    private Boolean m_usePriceMgmtAlgo = null;
    private int m_duration;
    private int m_postToAts;
    private String m_advancedErrorOverride = "";
    private String m_manualOrderTime = "";
    private int m_minTradeQty;
    private int m_minCompeteSize;
    private double m_competeAgainstBestOffset;
    private double m_midOffsetAtWhole;
    private double m_midOffsetAtHalf;

    public Types.Action action() {
        return Types.Action.get(this.m_action);
    }

    public String getAction() {
        return this.m_action;
    }

    public boolean allOrNone() {
        return this.m_allOrNone;
    }

    public boolean blockOrder() {
        return this.m_blockOrder;
    }

    public boolean hidden() {
        return this.m_hidden;
    }

    public boolean outsideRth() {
        return this.m_outsideRth;
    }

    public boolean notHeld() {
        return this.m_notHeld;
    }

    public boolean solicited() {
        return this.m_solicited;
    }

    public boolean optOutSmartRouting() {
        return this.m_optOutSmartRouting;
    }

    public boolean scaleAutoReset() {
        return this.m_scaleAutoReset;
    }

    public boolean scaleRandomPercent() {
        return this.m_scaleRandomPercent;
    }

    public boolean sweepToFill() {
        return this.m_sweepToFill;
    }

    public boolean transmit() {
        return this.m_transmit;
    }

    public boolean whatIf() {
        return this.m_whatIf;
    }

    public double auxPrice() {
        return this.m_auxPrice;
    }

    public double delta() {
        return this.m_delta;
    }

    public double deltaNeutralAuxPrice() {
        return this.m_deltaNeutralAuxPrice;
    }

    public double discretionaryAmt() {
        return this.m_discretionaryAmt;
    }

    public double lmtPrice() {
        return this.m_lmtPrice;
    }

    public double percentOffset() {
        return this.m_percentOffset;
    }

    public double scalePriceAdjustValue() {
        return this.m_scalePriceAdjustValue;
    }

    public double scalePriceIncrement() {
        return this.m_scalePriceIncrement;
    }

    public double scaleProfitOffset() {
        return this.m_scaleProfitOffset;
    }

    public double startingPrice() {
        return this.m_startingPrice;
    }

    public double stockRangeLower() {
        return this.m_stockRangeLower;
    }

    public double stockRangeUpper() {
        return this.m_stockRangeUpper;
    }

    public double stockRefPrice() {
        return this.m_stockRefPrice;
    }

    public double basisPoints() {
        return this.m_basisPoints;
    }

    public int basisPointsType() {
        return this.m_basisPointsType;
    }

    public double trailingPercent() {
        return this.m_trailingPercent;
    }

    public double trailStopPrice() {
        return this.m_trailStopPrice;
    }

    public double volatility() {
        return this.m_volatility;
    }

    public int clientId() {
        return this.m_clientId;
    }

    public int continuousUpdate() {
        return this.m_continuousUpdate;
    }

    public int deltaNeutralConId() {
        return this.m_deltaNeutralConId;
    }

    public String deltaNeutralOpenClose() {
        return this.m_deltaNeutralOpenClose;
    }

    public boolean deltaNeutralShortSale() {
        return this.m_deltaNeutralShortSale;
    }

    public int deltaNeutralShortSaleSlot() {
        return this.m_deltaNeutralShortSaleSlot;
    }

    public String deltaNeutralDesignatedLocation() {
        return this.m_deltaNeutralDesignatedLocation;
    }

    public int displaySize() {
        return this.m_displaySize;
    }

    public int minQty() {
        return this.m_minQty;
    }

    public int orderId() {
        return this.m_orderId;
    }

    public int parentId() {
        return this.m_parentId;
    }

    public int scaleInitFillQty() {
        return this.m_scaleInitFillQty;
    }

    public int scaleInitLevelSize() {
        return this.m_scaleInitLevelSize;
    }

    public int scaleInitPosition() {
        return this.m_scaleInitPosition;
    }

    public int scalePriceAdjustInterval() {
        return this.m_scalePriceAdjustInterval;
    }

    public int scaleSubsLevelSize() {
        return this.m_scaleSubsLevelSize;
    }

    public Decimal totalQuantity() {
        return this.m_totalQuantity;
    }

    public int permId() {
        return this.m_permId;
    }

    public Types.Method faMethod() {
        return Types.Method.get(this.m_faMethod);
    }

    public String getFaMethod() {
        return this.m_faMethod;
    }

    public Types.OcaType ocaType() {
        return Types.OcaType.get(this.m_ocaType);
    }

    public int getOcaType() {
        return this.m_ocaType;
    }

    public OrderType orderType() {
        return OrderType.get(this.m_orderType);
    }

    public String getOrderType() {
        return this.m_orderType;
    }

    public Types.Rule80A rule80A() {
        return Types.Rule80A.get(this.m_rule80A);
    }

    public String getRule80A() {
        return this.m_rule80A;
    }

    public String account() {
        return this.m_account;
    }

    public String settlingFirm() {
        return this.m_settlingFirm;
    }

    public String clearingAccount() {
        return this.m_clearingAccount;
    }

    public String clearingIntent() {
        return this.m_clearingIntent;
    }

    public Types.AlgoStrategy algoStrategy() {
        return Types.AlgoStrategy.get(this.m_algoStrategy);
    }

    public String getAlgoStrategy() {
        return this.m_algoStrategy;
    }

    public String algoId() {
        return this.m_algoId;
    }

    public String faGroup() {
        return this.m_faGroup;
    }

    public String faPercentage() {
        return this.m_faPercentage;
    }

    public String faProfile() {
        return this.m_faProfile;
    }

    public String goodAfterTime() {
        return this.m_goodAfterTime;
    }

    public String goodTillDate() {
        return this.m_goodTillDate;
    }

    public String hedgeParam() {
        return this.m_hedgeParam;
    }

    public Types.HedgeType hedgeType() {
        return Types.HedgeType.get(this.m_hedgeType);
    }

    public String getHedgeType() {
        return this.m_hedgeType;
    }

    public String ocaGroup() {
        return this.m_ocaGroup;
    }

    public String orderRef() {
        return this.m_orderRef;
    }

    public Types.TimeInForce tif() {
        return Types.TimeInForce.get(this.m_tif);
    }

    public String getTif() {
        return this.m_tif;
    }

    public String scaleTable() {
        return this.m_scaleTable;
    }

    public int auctionStrategy() {
        return this.m_auctionStrategy;
    }

    public Types.VolatilityType volatilityType() {
        return Types.VolatilityType.get(this.m_volatilityType);
    }

    public int getVolatilityType() {
        return this.m_volatilityType;
    }

    public Types.TriggerMethod triggerMethod() {
        return Types.TriggerMethod.get(this.m_triggerMethod);
    }

    public int getTriggerMethod() {
        return this.m_triggerMethod;
    }

    public String activeStartTime() {
        return this.m_activeStartTime;
    }

    public String activeStopTime() {
        return this.m_activeStopTime;
    }

    public OrderType deltaNeutralOrderType() {
        return OrderType.get(this.m_deltaNeutralOrderType);
    }

    public String getDeltaNeutralOrderType() {
        return this.m_deltaNeutralOrderType;
    }

    public List<OrderComboLeg> orderComboLegs() {
        return this.m_orderComboLegs;
    }

    public boolean overridePercentageConstraints() {
        return this.m_overridePercentageConstraints;
    }

    public String openClose() {
        return this.m_openClose;
    }

    public int origin() {
        return this.m_origin;
    }

    public int shortSaleSlot() {
        return this.m_shortSaleSlot;
    }

    public String designatedLocation() {
        return this.m_designatedLocation;
    }

    public int exemptCode() {
        return this.m_exemptCode;
    }

    public String deltaNeutralSettlingFirm() {
        return this.m_deltaNeutralSettlingFirm;
    }

    public String deltaNeutralClearingAccount() {
        return this.m_deltaNeutralClearingAccount;
    }

    public String deltaNeutralClearingIntent() {
        return this.m_deltaNeutralClearingIntent;
    }

    public Types.ReferencePriceType referencePriceType() {
        return Types.ReferencePriceType.get(this.m_referencePriceType);
    }

    public int getReferencePriceType() {
        return this.m_referencePriceType;
    }

    public List<TagValue> smartComboRoutingParams() {
        return this.m_smartComboRoutingParams;
    }

    public List<TagValue> orderMiscOptions() {
        return this.m_orderMiscOptions;
    }

    public boolean randomizeSize() {
        return this.m_randomizeSize;
    }

    public boolean randomizePrice() {
        return this.m_randomizePrice;
    }

    public int referenceContractId() {
        return this.m_referenceContractId;
    }

    public boolean isPeggedChangeAmountDecrease() {
        return this.m_isPeggedChangeAmountDecrease;
    }

    public double peggedChangeAmount() {
        return this.m_peggedChangeAmount;
    }

    public double referenceChangeAmount() {
        return this.m_referenceChangeAmount;
    }

    public String referenceExchangeId() {
        return this.m_referenceExchangeId;
    }

    public OrderType adjustedOrderType() {
        return this.m_adjustedOrderType;
    }

    public double triggerPrice() {
        return this.m_triggerPrice;
    }

    public double adjustedStopPrice() {
        return this.m_adjustedStopPrice;
    }

    public double adjustedStopLimitPrice() {
        return this.m_adjustedStopLimitPrice;
    }

    public double adjustedTrailingAmount() {
        return this.m_adjustedTrailingAmount;
    }

    public int adjustableTrailingUnit() {
        return this.m_adjustableTrailingUnit;
    }

    public double lmtPriceOffset() {
        return this.m_lmtPriceOffset;
    }

    public List<OrderCondition> conditions() {
        return this.m_conditions;
    }

    public boolean conditionsIgnoreRth() {
        return this.m_conditionsIgnoreRth;
    }

    public boolean conditionsCancelOrder() {
        return this.m_conditionsCancelOrder;
    }

    public String modelCode() {
        return this.m_modelCode;
    }

    public String extOperator() {
        return this.m_extOperator;
    }

    public SoftDollarTier softDollarTier() {
        return this.m_softDollarTier;
    }

    public double cashQty() {
        return this.m_cashQty;
    }

    public String mifid2DecisionMaker() {
        return this.m_mifid2DecisionMaker;
    }

    public String mifid2DecisionAlgo() {
        return this.m_mifid2DecisionAlgo;
    }

    public String mifid2ExecutionTrader() {
        return this.m_mifid2ExecutionTrader;
    }

    public String mifid2ExecutionAlgo() {
        return this.m_mifid2ExecutionAlgo;
    }

    public boolean dontUseAutoPriceForHedge() {
        return this.m_dontUseAutoPriceForHedge;
    }

    public boolean isOmsContainer() {
        return this.m_isOmsContainer;
    }

    public boolean discretionaryUpToLimitPrice() {
        return this.m_discretionaryUpToLimitPrice;
    }

    public String autoCancelDate() {
        return this.m_autoCancelDate;
    }

    public Decimal filledQuantity() {
        return this.m_filledQuantity;
    }

    public int refFuturesConId() {
        return this.m_refFuturesConId;
    }

    public boolean autoCancelParent() {
        return this.m_autoCancelParent;
    }

    public String shareholder() {
        return this.m_shareholder;
    }

    public boolean imbalanceOnly() {
        return this.m_imbalanceOnly;
    }

    public boolean routeMarketableToBbo() {
        return this.m_routeMarketableToBbo;
    }

    public long parentPermId() {
        return this.m_parentPermId;
    }

    public Boolean usePriceMgmtAlgo() {
        return this.m_usePriceMgmtAlgo;
    }

    public int duration() {
        return this.m_duration;
    }

    public int postToAts() {
        return this.m_postToAts;
    }

    public String advancedErrorOverride() {
        return this.m_advancedErrorOverride;
    }

    public String manualOrderTime() {
        return this.m_manualOrderTime;
    }

    public int minTradeQty() {
        return this.m_minTradeQty;
    }

    public int minCompeteSize() {
        return this.m_minCompeteSize;
    }

    public double competeAgainstBestOffset() {
        return this.m_competeAgainstBestOffset;
    }

    public boolean isCompeteAgainstBestOffsetUpToMid() {
        return this.m_competeAgainstBestOffset == Double.POSITIVE_INFINITY;
    }

    public double midOffsetAtWhole() {
        return this.m_midOffsetAtWhole;
    }

    public double midOffsetAtHalf() {
        return this.m_midOffsetAtHalf;
    }

    public void referenceContractId(int n) {
        this.m_referenceContractId = n;
    }

    public void account(String string) {
        this.m_account = string;
    }

    public void settlingFirm(String string) {
        this.m_settlingFirm = string;
    }

    public void clearingAccount(String string) {
        this.m_clearingAccount = string;
    }

    public void clearingIntent(String string) {
        this.m_clearingIntent = string;
    }

    public void action(Types.Action action) {
        this.m_action = action == null ? null : action.getApiString();
    }

    public void action(String string) {
        this.m_action = string;
    }

    public void algoStrategy(Types.AlgoStrategy algoStrategy) {
        this.m_algoStrategy = algoStrategy == null ? null : algoStrategy.getApiString();
    }

    public void algoStrategy(String string) {
        this.m_algoStrategy = string;
    }

    public void algoId(String string) {
        this.m_algoId = string;
    }

    public void allOrNone(boolean bl) {
        this.m_allOrNone = bl;
    }

    public void auxPrice(double d) {
        this.m_auxPrice = d;
    }

    public void blockOrder(boolean bl) {
        this.m_blockOrder = bl;
    }

    public void clientId(int n) {
        this.m_clientId = n;
    }

    public void continuousUpdate(int n) {
        this.m_continuousUpdate = n;
    }

    public void delta(double d) {
        this.m_delta = d;
    }

    public void deltaNeutralAuxPrice(double d) {
        this.m_deltaNeutralAuxPrice = d;
    }

    public void deltaNeutralConId(int n) {
        this.m_deltaNeutralConId = n;
    }

    public void deltaNeutralOpenClose(String string) {
        this.m_deltaNeutralOpenClose = string;
    }

    public void deltaNeutralShortSale(boolean bl) {
        this.m_deltaNeutralShortSale = bl;
    }

    public void deltaNeutralShortSaleSlot(int n) {
        this.m_deltaNeutralShortSaleSlot = n;
    }

    public void deltaNeutralDesignatedLocation(String string) {
        this.m_deltaNeutralDesignatedLocation = string;
    }

    public void deltaNeutralOrderType(OrderType orderType) {
        this.m_deltaNeutralOrderType = orderType == null ? null : orderType.getApiString();
    }

    public void deltaNeutralOrderType(String string) {
        this.m_deltaNeutralOrderType = string;
    }

    public void discretionaryAmt(double d) {
        this.m_discretionaryAmt = d;
    }

    public void displaySize(int n) {
        this.m_displaySize = n;
    }

    public void faGroup(String string) {
        this.m_faGroup = string;
    }

    public void faMethod(Types.Method method) {
        this.m_faMethod = method == null ? null : method.getApiString();
    }

    public void faMethod(String string) {
        this.m_faMethod = string;
    }

    public void faPercentage(String string) {
        this.m_faPercentage = string;
    }

    public void faProfile(String string) {
        this.m_faProfile = string;
    }

    public void goodAfterTime(String string) {
        this.m_goodAfterTime = string;
    }

    public void goodTillDate(String string) {
        this.m_goodTillDate = string;
    }

    public void hedgeParam(String string) {
        this.m_hedgeParam = string;
    }

    public void hedgeType(Types.HedgeType hedgeType) {
        this.m_hedgeType = hedgeType == null ? null : hedgeType.getApiString();
    }

    public void hedgeType(String string) {
        this.m_hedgeType = string;
    }

    public void hidden(boolean bl) {
        this.m_hidden = bl;
    }

    public void lmtPrice(double d) {
        this.m_lmtPrice = d;
    }

    public void minQty(int n) {
        this.m_minQty = n;
    }

    public void notHeld(boolean bl) {
        this.m_notHeld = bl;
    }

    public void solicited(boolean bl) {
        this.m_solicited = bl;
    }

    public void ocaGroup(String string) {
        this.m_ocaGroup = string;
    }

    public void ocaType(Types.OcaType ocaType) {
        this.m_ocaType = ocaType == null ? 0 : ocaType.ordinal();
    }

    public void ocaType(int n) {
        this.m_ocaType = n;
    }

    public void optOutSmartRouting(boolean bl) {
        this.m_optOutSmartRouting = bl;
    }

    public void orderId(int n) {
        this.m_orderId = n;
    }

    public void orderRef(String string) {
        this.m_orderRef = string;
    }

    public void orderType(OrderType orderType) {
        this.m_orderType = orderType == null ? null : orderType.getApiString();
    }

    public void orderType(String string) {
        this.m_orderType = string;
    }

    public void outsideRth(boolean bl) {
        this.m_outsideRth = bl;
    }

    public void overridePercentageConstraints(boolean bl) {
        this.m_overridePercentageConstraints = bl;
    }

    public void openClose(String string) {
        this.m_openClose = string;
    }

    public void origin(int n) {
        this.m_origin = n;
    }

    public void shortSaleSlot(int n) {
        this.m_shortSaleSlot = n;
    }

    public void designatedLocation(String string) {
        this.m_designatedLocation = string;
    }

    public void exemptCode(int n) {
        this.m_exemptCode = n;
    }

    public void parentId(int n) {
        this.m_parentId = n;
    }

    public void percentOffset(double d) {
        this.m_percentOffset = d;
    }

    public void permId(int n) {
        this.m_permId = n;
    }

    public void referencePriceType(Types.ReferencePriceType referencePriceType) {
        this.m_referencePriceType = referencePriceType == null ? 0 : referencePriceType.ordinal();
    }

    public void referencePriceType(int n) {
        this.m_referencePriceType = n;
    }

    public void rule80A(Types.Rule80A rule80A) {
        this.m_rule80A = rule80A == null ? null : rule80A.getApiString();
    }

    public void rule80A(String string) {
        this.m_rule80A = string;
    }

    public void scaleAutoReset(boolean bl) {
        this.m_scaleAutoReset = bl;
    }

    public void scaleInitFillQty(int n) {
        this.m_scaleInitFillQty = n;
    }

    public void scaleInitLevelSize(int n) {
        this.m_scaleInitLevelSize = n;
    }

    public void scaleInitPosition(int n) {
        this.m_scaleInitPosition = n;
    }

    public void scalePriceAdjustInterval(int n) {
        this.m_scalePriceAdjustInterval = n;
    }

    public void scalePriceAdjustValue(double d) {
        this.m_scalePriceAdjustValue = d;
    }

    public void scalePriceIncrement(double d) {
        this.m_scalePriceIncrement = d;
    }

    public void scaleProfitOffset(double d) {
        this.m_scaleProfitOffset = d;
    }

    public void scaleRandomPercent(boolean bl) {
        this.m_scaleRandomPercent = bl;
    }

    public void scaleSubsLevelSize(int n) {
        this.m_scaleSubsLevelSize = n;
    }

    public void startingPrice(double d) {
        this.m_startingPrice = d;
    }

    public void stockRangeLower(double d) {
        this.m_stockRangeLower = d;
    }

    public void stockRangeUpper(double d) {
        this.m_stockRangeUpper = d;
    }

    public void stockRefPrice(double d) {
        this.m_stockRefPrice = d;
    }

    public void basisPoints(double d) {
        this.m_basisPoints = d;
    }

    public void basisPointsType(int n) {
        this.m_basisPointsType = n;
    }

    public void sweepToFill(boolean bl) {
        this.m_sweepToFill = bl;
    }

    public void tif(Types.TimeInForce timeInForce) {
        this.m_tif = timeInForce == null ? null : timeInForce.getApiString();
    }

    public void tif(String string) {
        this.m_tif = string;
    }

    public void totalQuantity(Decimal decimal) {
        this.m_totalQuantity = decimal;
    }

    public void trailingPercent(double d) {
        this.m_trailingPercent = d;
    }

    public void trailStopPrice(double d) {
        this.m_trailStopPrice = d;
    }

    public void transmit(boolean bl) {
        this.m_transmit = bl;
    }

    public void triggerMethod(Types.TriggerMethod triggerMethod) {
        this.m_triggerMethod = triggerMethod == null ? 0 : triggerMethod.val();
    }

    public void triggerMethod(int n) {
        this.m_triggerMethod = n;
    }

    public void activeStartTime(String string) {
        this.m_activeStartTime = string;
    }

    public void activeStopTime(String string) {
        this.m_activeStopTime = string;
    }

    public void algoParams(List<TagValue> list) {
        this.m_algoParams = list;
    }

    public void volatility(double d) {
        this.m_volatility = d;
    }

    public void volatilityType(Types.VolatilityType volatilityType) {
        this.m_volatilityType = volatilityType == null ? 0 : volatilityType.ordinal();
    }

    public void volatilityType(int n) {
        this.m_volatilityType = n;
    }

    public void whatIf(boolean bl) {
        this.m_whatIf = bl;
    }

    public void scaleTable(String string) {
        this.m_scaleTable = string;
    }

    public void auctionStrategy(int n) {
        this.m_auctionStrategy = n;
    }

    public void orderComboLegs(List<OrderComboLeg> list) {
        this.m_orderComboLegs = list;
    }

    public void deltaNeutralSettlingFirm(String string) {
        this.m_deltaNeutralSettlingFirm = string;
    }

    public void deltaNeutralClearingAccount(String string) {
        this.m_deltaNeutralClearingAccount = string;
    }

    public void deltaNeutralClearingIntent(String string) {
        this.m_deltaNeutralClearingIntent = string;
    }

    public void smartComboRoutingParams(List<TagValue> list) {
        this.m_smartComboRoutingParams = list;
    }

    public void orderMiscOptions(List<TagValue> list) {
        this.m_orderMiscOptions = list;
    }

    public void randomizeSize(boolean bl) {
        this.m_randomizeSize = bl;
    }

    public void randomizePrice(boolean bl) {
        this.m_randomizePrice = bl;
    }

    public void modelCode(String string) {
        this.m_modelCode = string;
    }

    public void isPeggedChangeAmountDecrease(boolean bl) {
        this.m_isPeggedChangeAmountDecrease = bl;
    }

    public void peggedChangeAmount(double d) {
        this.m_peggedChangeAmount = d;
    }

    public void referenceChangeAmount(double d) {
        this.m_referenceChangeAmount = d;
    }

    public void referenceExchangeId(String string) {
        this.m_referenceExchangeId = string;
    }

    public void adjustedOrderType(OrderType orderType) {
        this.m_adjustedOrderType = orderType;
    }

    public void triggerPrice(double d) {
        this.m_triggerPrice = d;
    }

    public void adjustedStopPrice(double d) {
        this.m_adjustedStopPrice = d;
    }

    public void adjustedStopLimitPrice(double d) {
        this.m_adjustedStopLimitPrice = d;
    }

    public void adjustedTrailingAmount(double d) {
        this.m_adjustedTrailingAmount = d;
    }

    public void adjustableTrailingUnit(int n) {
        this.m_adjustableTrailingUnit = n;
    }

    public void lmtPriceOffset(double d) {
        this.m_lmtPriceOffset = d;
    }

    public void conditions(List<OrderCondition> list) {
        this.m_conditions = list;
    }

    public void conditionsIgnoreRth(boolean bl) {
        this.m_conditionsIgnoreRth = bl;
    }

    public void conditionsCancelOrder(boolean bl) {
        this.m_conditionsCancelOrder = bl;
    }

    public void extOperator(String string) {
        this.m_extOperator = string;
    }

    public void softDollarTier(SoftDollarTier softDollarTier) {
        this.m_softDollarTier = softDollarTier;
    }

    public void cashQty(double d) {
        this.m_cashQty = d;
    }

    public void mifid2DecisionMaker(String string) {
        this.m_mifid2DecisionMaker = string;
    }

    public void mifid2DecisionAlgo(String string) {
        this.m_mifid2DecisionAlgo = string;
    }

    public void mifid2ExecutionTrader(String string) {
        this.m_mifid2ExecutionTrader = string;
    }

    public void mifid2ExecutionAlgo(String string) {
        this.m_mifid2ExecutionAlgo = string;
    }

    public void dontUseAutoPriceForHedge(boolean bl) {
        this.m_dontUseAutoPriceForHedge = bl;
    }

    public void isOmsContainer(boolean bl) {
        this.m_isOmsContainer = bl;
    }

    public void discretionaryUpToLimitPrice(boolean bl) {
        this.m_discretionaryUpToLimitPrice = bl;
    }

    public void autoCancelDate(String string) {
        this.m_autoCancelDate = string;
    }

    public void filledQuantity(Decimal decimal) {
        this.m_filledQuantity = decimal;
    }

    public void refFuturesConId(int n) {
        this.m_refFuturesConId = n;
    }

    public void autoCancelParent(boolean bl) {
        this.m_autoCancelParent = bl;
    }

    public void shareholder(String string) {
        this.m_shareholder = string;
    }

    public void imbalanceOnly(boolean bl) {
        this.m_imbalanceOnly = bl;
    }

    public void routeMarketableToBbo(boolean bl) {
        this.m_routeMarketableToBbo = bl;
    }

    public void parentPermId(long l) {
        this.m_parentPermId = l;
    }

    public void usePriceMgmtAlgo(Boolean bl) {
        this.m_usePriceMgmtAlgo = bl;
    }

    public void duration(int n) {
        this.m_duration = n;
    }

    public void postToAts(int n) {
        this.m_postToAts = n;
    }

    public void advancedErrorOverride(String string) {
        this.m_advancedErrorOverride = string;
    }

    public void manualOrderTime(String string) {
        this.m_manualOrderTime = string;
    }

    public void minTradeQty(int n) {
        this.m_minTradeQty = n;
    }

    public void minCompeteSize(int n) {
        this.m_minCompeteSize = n;
    }

    public void competeAgainstBestOffset(double d) {
        this.m_competeAgainstBestOffset = d;
    }

    public void setCompeteAgainstBestOffsetUpToMid() {
        this.m_competeAgainstBestOffset = Double.POSITIVE_INFINITY;
    }

    public void midOffsetAtWhole(double d) {
        this.m_midOffsetAtWhole = d;
    }

    public void midOffsetAtHalf(double d) {
        this.m_midOffsetAtHalf = d;
    }

    public Order() {
        this.m_startingPrice = Double.MAX_VALUE;
        this.m_stockRefPrice = Double.MAX_VALUE;
        this.m_stockRangeLower = Double.MAX_VALUE;
        this.m_stockRangeUpper = Double.MAX_VALUE;
        this.m_basisPoints = Double.MAX_VALUE;
        this.m_basisPointsType = Integer.MAX_VALUE;
        this.m_softDollarTier = new SoftDollarTier(EMPTY_STR, EMPTY_STR, EMPTY_STR);
        this.m_filledQuantity = Decimal.INVALID;
        this.m_duration = Integer.MAX_VALUE;
        this.m_postToAts = Integer.MAX_VALUE;
        this.m_minTradeQty = Integer.MAX_VALUE;
        this.m_minCompeteSize = Integer.MAX_VALUE;
        this.m_competeAgainstBestOffset = Double.MAX_VALUE;
        this.m_midOffsetAtWhole = Double.MAX_VALUE;
        this.m_midOffsetAtHalf = Double.MAX_VALUE;
    }

    public List<TagValue> algoParams() {
        if (this.m_algoParams == null) {
            this.m_algoParams = new ArrayList<TagValue>();
        }
        return this.m_algoParams;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Order)) {
            return false;
        }
        Order order = (Order)object;
        if (this.m_permId == order.m_permId) {
            return true;
        }
        if (this.m_orderId != order.m_orderId || this.m_clientId != order.m_clientId || this.m_totalQuantity != order.m_totalQuantity || this.m_lmtPrice != order.m_lmtPrice || this.m_auxPrice != order.m_auxPrice || this.m_ocaType != order.m_ocaType || this.m_transmit != order.m_transmit || this.m_parentId != order.m_parentId || this.m_blockOrder != order.m_blockOrder || this.m_sweepToFill != order.m_sweepToFill || this.m_displaySize != order.m_displaySize || this.m_triggerMethod != order.m_triggerMethod || this.m_outsideRth != order.m_outsideRth || this.m_hidden != order.m_hidden || this.m_overridePercentageConstraints != order.m_overridePercentageConstraints || this.m_allOrNone != order.m_allOrNone || this.m_minQty != order.m_minQty || this.m_percentOffset != order.m_percentOffset || this.m_trailStopPrice != order.m_trailStopPrice || this.m_trailingPercent != order.m_trailingPercent || this.m_origin != order.m_origin || this.m_shortSaleSlot != order.m_shortSaleSlot || this.m_discretionaryAmt != order.m_discretionaryAmt || this.m_optOutSmartRouting != order.m_optOutSmartRouting || this.m_auctionStrategy != order.m_auctionStrategy || this.m_startingPrice != order.m_startingPrice || this.m_stockRefPrice != order.m_stockRefPrice || this.m_delta != order.m_delta || this.m_stockRangeLower != order.m_stockRangeLower || this.m_stockRangeUpper != order.m_stockRangeUpper || this.m_volatility != order.m_volatility || this.m_volatilityType != order.m_volatilityType || this.m_continuousUpdate != order.m_continuousUpdate || this.m_referencePriceType != order.m_referencePriceType || this.m_deltaNeutralAuxPrice != order.m_deltaNeutralAuxPrice || this.m_deltaNeutralConId != order.m_deltaNeutralConId || this.m_deltaNeutralShortSale != order.m_deltaNeutralShortSale || this.m_deltaNeutralShortSaleSlot != order.m_deltaNeutralShortSaleSlot || this.m_basisPoints != order.m_basisPoints || this.m_basisPointsType != order.m_basisPointsType || this.m_scaleInitLevelSize != order.m_scaleInitLevelSize || this.m_scaleSubsLevelSize != order.m_scaleSubsLevelSize || this.m_scalePriceIncrement != order.m_scalePriceIncrement || this.m_scalePriceAdjustValue != order.m_scalePriceAdjustValue || this.m_scalePriceAdjustInterval != order.m_scalePriceAdjustInterval || this.m_scaleProfitOffset != order.m_scaleProfitOffset || this.m_scaleAutoReset != order.m_scaleAutoReset || this.m_scaleInitPosition != order.m_scaleInitPosition || this.m_scaleInitFillQty != order.m_scaleInitFillQty || this.m_scaleRandomPercent != order.m_scaleRandomPercent || this.m_whatIf != order.m_whatIf || this.m_notHeld != order.m_notHeld || this.m_exemptCode != order.m_exemptCode || this.m_randomizePrice != order.m_randomizePrice || this.m_randomizeSize != order.m_randomizeSize || this.m_solicited != order.m_solicited || this.m_referenceContractId != order.m_referenceContractId || this.m_peggedChangeAmount != order.m_peggedChangeAmount || this.m_referenceChangeAmount != order.m_referenceChangeAmount || this.m_adjustedOrderType != order.m_adjustedOrderType || this.m_triggerPrice != order.m_triggerPrice || this.m_adjustedStopPrice != order.m_adjustedStopPrice || this.m_adjustedStopLimitPrice != order.m_adjustedStopLimitPrice || this.m_adjustedTrailingAmount != order.m_adjustedTrailingAmount || this.m_adjustableTrailingUnit != order.m_adjustableTrailingUnit || this.m_lmtPriceOffset != order.m_lmtPriceOffset || !this.m_softDollarTier.equals(order.m_softDollarTier) || this.m_cashQty != order.m_cashQty || this.m_dontUseAutoPriceForHedge != order.m_dontUseAutoPriceForHedge || this.m_isOmsContainer != order.m_isOmsContainer || this.m_usePriceMgmtAlgo != order.m_usePriceMgmtAlgo || this.m_discretionaryUpToLimitPrice != order.m_discretionaryUpToLimitPrice || this.m_filledQuantity != order.m_filledQuantity || this.m_refFuturesConId != order.m_refFuturesConId || this.m_autoCancelParent != order.m_autoCancelParent || this.m_imbalanceOnly != order.m_imbalanceOnly || this.m_routeMarketableToBbo != order.m_routeMarketableToBbo || this.m_parentPermId != order.m_parentPermId || this.m_duration != order.m_duration || this.m_postToAts != order.m_postToAts || this.m_minTradeQty != order.m_minTradeQty || this.m_minCompeteSize != order.m_minCompeteSize || this.m_competeAgainstBestOffset != order.m_competeAgainstBestOffset || this.m_midOffsetAtWhole != order.m_midOffsetAtWhole || this.m_midOffsetAtHalf != order.m_midOffsetAtHalf) {
            return false;
        }
        if (Util.StringCompare(this.m_action, order.m_action) != 0 || Util.StringCompare(this.m_orderType, order.m_orderType) != 0 || Util.StringCompare(this.m_tif, order.m_tif) != 0 || Util.StringCompare(this.m_activeStartTime, order.m_activeStartTime) != 0 || Util.StringCompare(this.m_activeStopTime, order.m_activeStopTime) != 0 || Util.StringCompare(this.m_ocaGroup, order.m_ocaGroup) != 0 || Util.StringCompare(this.m_orderRef, order.m_orderRef) != 0 || Util.StringCompare(this.m_goodAfterTime, order.m_goodAfterTime) != 0 || Util.StringCompare(this.m_goodTillDate, order.m_goodTillDate) != 0 || Util.StringCompare(this.m_rule80A, order.m_rule80A) != 0 || Util.StringCompare(this.m_faGroup, order.m_faGroup) != 0 || Util.StringCompare(this.m_faProfile, order.m_faProfile) != 0 || Util.StringCompare(this.m_faMethod, order.m_faMethod) != 0 || Util.StringCompare(this.m_faPercentage, order.m_faPercentage) != 0 || Util.StringCompare(this.m_openClose, order.m_openClose) != 0 || Util.StringCompare(this.m_designatedLocation, order.m_designatedLocation) != 0 || Util.StringCompare(this.m_deltaNeutralOrderType, order.m_deltaNeutralOrderType) != 0 || Util.StringCompare(this.m_deltaNeutralSettlingFirm, order.m_deltaNeutralSettlingFirm) != 0 || Util.StringCompare(this.m_deltaNeutralClearingAccount, order.m_deltaNeutralClearingAccount) != 0 || Util.StringCompare(this.m_deltaNeutralClearingIntent, order.m_deltaNeutralClearingIntent) != 0 || Util.StringCompare(this.m_deltaNeutralOpenClose, order.m_deltaNeutralOpenClose) != 0 || Util.StringCompare(this.m_deltaNeutralDesignatedLocation, order.m_deltaNeutralDesignatedLocation) != 0 || Util.StringCompare(this.m_hedgeType, order.m_hedgeType) != 0 || Util.StringCompare(this.m_hedgeParam, order.m_hedgeParam) != 0 || Util.StringCompare(this.m_account, order.m_account) != 0 || Util.StringCompare(this.m_settlingFirm, order.m_settlingFirm) != 0 || Util.StringCompare(this.m_clearingAccount, order.m_clearingAccount) != 0 || Util.StringCompare(this.m_clearingIntent, order.m_clearingIntent) != 0 || Util.StringCompare(this.m_algoStrategy, order.m_algoStrategy) != 0 || Util.StringCompare(this.m_algoId, order.m_algoId) != 0 || Util.StringCompare(this.m_scaleTable, order.m_scaleTable) != 0 || Util.StringCompare(this.m_modelCode, order.m_modelCode) != 0 || Util.StringCompare(this.m_referenceExchangeId, order.m_referenceExchangeId) != 0 || Util.StringCompare(this.m_extOperator, order.m_extOperator) != 0 || Util.StringCompare(this.m_mifid2DecisionMaker, order.m_mifid2DecisionMaker) != 0 || Util.StringCompare(this.m_mifid2DecisionAlgo, order.m_mifid2DecisionAlgo) != 0 || Util.StringCompare(this.m_mifid2ExecutionTrader, order.m_mifid2ExecutionTrader) != 0 || Util.StringCompare(this.m_mifid2ExecutionAlgo, order.m_mifid2ExecutionAlgo) != 0 || Util.StringCompare(this.m_autoCancelDate, order.m_autoCancelDate) != 0 || Util.StringCompare(this.m_shareholder, order.m_shareholder) != 0 || Util.StringCompare(this.m_advancedErrorOverride, order.m_advancedErrorOverride) != 0 || Util.StringCompare(this.m_manualOrderTime, order.m_manualOrderTime) != 0) {
            return false;
        }
        if (!Util.listsEqualUnordered(this.m_algoParams, order.m_algoParams)) {
            return false;
        }
        if (!Util.listsEqualUnordered(this.m_smartComboRoutingParams, order.m_smartComboRoutingParams)) {
            return false;
        }
        if (!Util.listsEqualUnordered(this.m_orderComboLegs, order.m_orderComboLegs)) {
            return false;
        }
        return Util.listsEqualUnordered(this.m_conditions, order.m_conditions);
    }

    public int hashCode() {
        return this.m_permId ^ this.m_permId >>> 32;
    }
}

