/*
 * Decompiled with CFR 0.152.
 */
package com.ib.client;

import com.ib.client.OrderCondition;
import com.ib.client.OrderConditionType;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class ExecutionCondition
extends OrderCondition {
    public static final OrderConditionType conditionType = OrderConditionType.Execution;
    private String m_exchange;
    private String m_secType;
    private String m_symbol;

    protected ExecutionCondition() {
    }

    @Override
    public void readFrom(ObjectInput objectInput) throws IOException {
        super.readFrom(objectInput);
        this.m_secType = objectInput.readUTF();
        this.m_exchange = objectInput.readUTF();
        this.m_symbol = objectInput.readUTF();
    }

    @Override
    public String toString() {
        return "trade occurs for " + this.m_symbol + " symbol on " + this.m_exchange + " exchange for " + this.m_secType + " security type";
    }

    @Override
    public void writeTo(ObjectOutput objectOutput) throws IOException {
        super.writeTo(objectOutput);
        objectOutput.writeUTF(this.m_secType);
        objectOutput.writeUTF(this.m_exchange);
        objectOutput.writeUTF(this.m_symbol);
    }

    public String exchange() {
        return this.m_exchange;
    }

    public void exchange(String string) {
        this.m_exchange = string;
    }

    public String secType() {
        return this.m_secType;
    }

    public void secType(String string) {
        this.m_secType = string;
    }

    public String symbol() {
        return this.m_symbol;
    }

    public void symbol(String string) {
        this.m_symbol = string;
    }
}

