/*
 * Decompiled with CFR 0.152.
 */
package com.ib.client;

import com.ib.client.DefaultEWrapper;
import com.ib.client.EClient;
import com.ib.client.EClientErrors;
import com.ib.client.EClientSocket;
import com.ib.client.EDecoder;
import com.ib.client.EMessage;
import com.ib.client.EReaderSignal;
import com.ib.client.EWrapper;
import java.io.EOFException;
import java.io.IOException;
import java.util.Arrays;
import java.util.Deque;
import java.util.LinkedList;

public class EReader
extends Thread {
    private EClientSocket m_clientSocket;
    private EReaderSignal m_signal;
    private EDecoder m_processMsgsDecoder;
    private static final EWrapper defaultWrapper = new DefaultEWrapper();
    private static final int IN_BUF_SIZE_DEFAULT = 8192;
    private byte[] m_iBuf = new byte[8192];
    private int m_iBufLen = 0;
    private final Deque<EMessage> m_msgQueue = new LinkedList<EMessage>();
    static final int MAX_MSG_LENGTH = 0xFFFFFF;

    protected boolean isUseV100Plus() {
        return this.m_clientSocket.isUseV100Plus();
    }

    protected EClient parent() {
        return this.m_clientSocket;
    }

    private EWrapper eWrapper() {
        return this.parent().wrapper();
    }

    public EReader(EClientSocket eClientSocket, EReaderSignal eReaderSignal) {
        this.m_clientSocket = eClientSocket;
        this.m_signal = eReaderSignal;
        this.m_processMsgsDecoder = new EDecoder(eClientSocket.serverVersion(), eClientSocket.wrapper(), eClientSocket);
    }

    @Override
    public void run() {
        try {
            while (!this.isInterrupted() && this.putMessageToQueue()) {
            }
        }
        catch (Exception exception) {
            if (exception instanceof EOFException) {
                this.eWrapper().error(-1, EClientErrors.BAD_LENGTH.code(), EClientErrors.BAD_LENGTH.msg() + " " + exception.getMessage(), null);
            } else {
                this.eWrapper().error(exception);
            }
            this.parent().eDisconnect();
        }
        this.m_signal.issueSignal();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean putMessageToQueue() throws IOException {
        EMessage eMessage = this.readSingleMessage();
        if (eMessage == null) {
            return false;
        }
        Deque<EMessage> deque = this.m_msgQueue;
        synchronized (deque) {
            this.m_msgQueue.addFirst(eMessage);
        }
        this.m_signal.issueSignal();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected EMessage getMsg() {
        Deque<EMessage> deque = this.m_msgQueue;
        synchronized (deque) {
            return this.m_msgQueue.isEmpty() ? null : this.m_msgQueue.removeLast();
        }
    }

    public void processMsgs() throws IOException {
        EMessage eMessage = this.getMsg();
        while (eMessage != null && this.m_processMsgsDecoder.processMsg(eMessage) > 0) {
            eMessage = this.getMsg();
        }
    }

    private EMessage readSingleMessage() throws IOException {
        Object object;
        Object object2;
        int n;
        if (this.isUseV100Plus()) {
            int n2 = 0;
            try {
                n2 = this.m_clientSocket.readInt();
            }
            catch (Exception exception) {
                if (exception instanceof EOFException) {
                    this.parent().connectionError();
                    this.parent().eDisconnect();
                }
                return null;
            }
            if (n2 > 0xFFFFFF) {
                throw new InvalidMessageLengthException("message is too long: " + n2);
            }
            byte[] byArray = new byte[n2];
            for (int i = 0; i < n2; i += this.m_clientSocket.read(byArray, i, n2 - i)) {
            }
            return new EMessage(byArray, byArray.length);
        }
        if (this.m_iBufLen == 0) {
            this.m_iBufLen = this.appendIBuf();
        }
        while (true) {
            try {
                n = 0;
                if (this.m_iBufLen <= 0) break;
                object2 = new EDecoder(this.m_clientSocket.serverVersion(), defaultWrapper);
                object = null;
                try {
                    n = ((EDecoder)object2).processMsg(new EMessage(this.m_iBuf, this.m_iBufLen));
                }
                catch (Throwable throwable) {
                    object = throwable;
                    throw throwable;
                }
                finally {
                    if (object2 != null) {
                        if (object != null) {
                            try {
                                ((EDecoder)object2).close();
                            }
                            catch (Throwable throwable) {
                                object.addSuppressed(throwable);
                            }
                        } else {
                            ((EDecoder)object2).close();
                        }
                    }
                }
            }
            catch (IOException iOException) {
                if (this.m_iBufLen >= this.m_iBuf.length * 3 / 4) {
                    object = new byte[this.m_iBuf.length * 2];
                    System.arraycopy(this.m_iBuf, 0, object, 0, this.m_iBuf.length);
                    this.m_iBuf = object;
                }
                this.m_iBufLen += this.appendIBuf();
                continue;
            }
            break;
        }
        if (n == 0) {
            return null;
        }
        object2 = new EMessage(this.m_iBuf, n);
        System.arraycopy(Arrays.copyOfRange(this.m_iBuf, n, this.m_iBuf.length), 0, this.m_iBuf, 0, this.m_iBuf.length - n);
        this.m_iBufLen -= n;
        if (this.m_iBufLen < 8192 && this.m_iBuf.length > 8192) {
            object = new byte[8192];
            System.arraycopy(this.m_iBuf, 0, object, 0, ((byte[])object).length);
            this.m_iBuf = object;
        }
        return object2;
    }

    protected int appendIBuf() throws IOException {
        return this.m_clientSocket.read(this.m_iBuf, this.m_iBufLen, this.m_iBuf.length - this.m_iBufLen);
    }

    private static class InvalidMessageLengthException
    extends IOException {
        private static final long serialVersionUID = 1L;

        InvalidMessageLengthException(String string) {
            super(string);
        }
    }
}

