/*
 * Decompiled with CFR 0.152.
 */
package com.ib.client;

import com.ib.client.Contract;
import com.ib.client.EClientErrors;
import com.ib.client.EClientException;
import com.ib.client.IApiEnum;
import com.ib.client.TagValue;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectOutput;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

class Builder
implements ObjectOutput {
    private static final char SEP = '\u0000';
    private static final byte[] EMPTY_LENGTH_HEADER = new byte[4];
    private final ByteBuffer m_sb;

    public Builder(int n) {
        this.m_sb = new ByteBuffer(n);
    }

    public void send(int n) throws EClientException {
        this.send(String.valueOf(n));
    }

    public void sendMax(int n) throws EClientException {
        this.send(n == Integer.MAX_VALUE ? "" : String.valueOf(n));
    }

    public void send(double d) throws EClientException {
        this.send(String.valueOf(d));
    }

    public void sendMax(double d) throws EClientException {
        this.send(d == Double.MAX_VALUE ? "" : String.valueOf(d));
    }

    public void send(Boolean bl) throws EClientException {
        this.sendMax(bl == null ? Integer.MAX_VALUE : (bl != false ? 1 : 0));
    }

    public void send(IApiEnum iApiEnum) throws EClientException {
        this.send(iApiEnum == null ? null : iApiEnum.getApiString());
    }

    public void send(String string) throws EClientException {
        if (string != null && !Builder.isAsciiPrintable(string)) {
            throw new EClientException(EClientErrors.INVALID_SYMBOL, string);
        }
        if (string != null) {
            byte[] byArray = string.getBytes(StandardCharsets.UTF_8);
            this.m_sb.write(byArray, 0, byArray.length);
        }
        this.m_sb.write(0);
    }

    public void send(byte[] byArray) {
        if (byArray != null) {
            this.m_sb.write(byArray, 0, byArray.length);
        }
    }

    public void send(List<TagValue> list) throws EClientException {
        String string3 = ((List)Optional.ofNullable(list).orElse(new ArrayList())).stream().map(tagValue -> tagValue.m_tag + "=" + tagValue.m_value + ";").reduce("", (string, string2) -> string + string2);
        this.send(string3);
    }

    public void send(Contract contract) throws EClientException {
        this.send(contract.conid());
        this.send(contract.symbol());
        this.send(contract.getSecType());
        this.send(contract.lastTradeDateOrContractMonth());
        this.send(contract.strike());
        this.send(contract.getRight());
        this.send(contract.multiplier());
        this.send(contract.exchange());
        this.send(contract.primaryExch());
        this.send(contract.currency());
        this.send(contract.localSymbol());
        this.send(contract.tradingClass());
        this.send(contract.includeExpired() ? 1 : 0);
    }

    public int allocateLengthHeader() {
        int n = this.m_sb.size();
        this.m_sb.write(EMPTY_LENGTH_HEADER, 0, EMPTY_LENGTH_HEADER.length);
        return n;
    }

    public void updateLength(int n) {
        this.m_sb.updateLength(n);
    }

    public void writeTo(DataOutputStream dataOutputStream) throws IOException {
        this.m_sb.writeTo(dataOutputStream);
    }

    static void intToBytes(int n, byte[] byArray, int n2) {
        byArray[n2] = (byte)(0xFF & n >> 24);
        byArray[n2 + 1] = (byte)(0xFF & n >> 16);
        byArray[n2 + 2] = (byte)(0xFF & n >> 8);
        byArray[n2 + 3] = (byte)(0xFF & n);
    }

    private static boolean isAsciiPrintable(String string) {
        if (string == null) {
            return false;
        }
        for (int i = 0; i < string.length(); ++i) {
            if (Builder.isAsciiPrintable(string.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private static boolean isAsciiPrintable(char c) {
        return c >= ' ' && c < '\u007f';
    }

    @Override
    public void writeBoolean(boolean bl) throws IOException {
        this.send(bl);
    }

    @Override
    public void writeByte(int n) throws IOException {
        this.send(n);
    }

    @Override
    public void writeBytes(String string) throws IOException {
        this.send(string);
    }

    @Override
    public void writeChar(int n) throws IOException {
        this.send(n);
    }

    @Override
    public void writeChars(String string) throws IOException {
        this.send(string);
    }

    @Override
    public void writeDouble(double d) throws IOException {
        this.send(d);
    }

    @Override
    public void writeFloat(float f) throws IOException {
        this.send(f);
    }

    @Override
    public void writeInt(int n) throws IOException {
        this.send(n);
    }

    @Override
    public void writeLong(long l) throws IOException {
        this.send(l);
    }

    @Override
    public void writeShort(int n) throws IOException {
        this.send(n);
    }

    @Override
    public void writeUTF(String string) throws IOException {
        this.send(string);
    }

    @Override
    public void close() throws IOException {
        this.m_sb.close();
    }

    @Override
    public void flush() throws IOException {
    }

    @Override
    public void write(int n) throws IOException {
    }

    @Override
    public void write(byte[] byArray) throws IOException {
    }

    @Override
    public void write(byte[] byArray, int n, int n2) throws IOException {
    }

    @Override
    public void writeObject(Object object) throws IOException {
    }

    private static class ByteBuffer
    extends ByteArrayOutputStream {
        private final int paddingSize;

        ByteBuffer(int n) {
            super(n);
            this.paddingSize = 1;
        }

        void updateLength(int n) {
            int n2;
            int n3 = this.count - EMPTY_LENGTH_HEADER.length - n;
            if (this.paddingSize > 1 && (n2 = this.paddingSize - n3 % this.paddingSize) < this.paddingSize) {
                this.write(EMPTY_LENGTH_HEADER, 0, this.paddingSize);
                n3 = this.count - EMPTY_LENGTH_HEADER.length - n;
            }
            Builder.intToBytes(n3, this.buf, n);
        }

        void writeTo(DataOutputStream dataOutputStream) throws IOException {
            dataOutputStream.write(this.buf, 0, this.count);
        }
    }
}

