/*
 * Decompiled with CFR 0.152.
 */
package com.fxcm.util.jmx.impl.gauges;

import com.fxcm.util.jmx.impl.IGaugeNode;
import com.fxcm.util.jmx.impl.StatisticEvent;
import com.fxcm.util.jmx.impl.gauges.AGaugeNode;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class PerformanceNode
extends AGaugeNode {
    protected long mTimestamp = 0L;
    protected String mInfo = null;
    protected long mMin = 0L;
    protected long mMax = 0L;
    protected long mAvg = 0L;
    protected long mCount = 0L;
    protected long mRegistrationSequence = 0L;
    protected Map<String, Long> mRegistrations = null;

    public PerformanceNode(String pk) {
        super(pk);
    }

    @Override
    public Long getMin() {
        return this.mMin;
    }

    @Override
    public Long getMax() {
        return this.mMax;
    }

    @Override
    public Long getAvg() {
        return this.mAvg;
    }

    @Override
    public long getTimestamp() {
        return this.mTimestamp;
    }

    @Override
    public Long getCount() {
        return this.mCount;
    }

    @Override
    public String getInfo() {
        return this.mInfo;
    }

    @Override
    public void clear() {
        this.mTimestamp = 0L;
        this.mInfo = null;
        this.mMin = 0L;
        this.mMax = 0L;
        this.mAvg = 0L;
        this.mCount = 0L;
        if (this.mRegistrations != null) {
            this.mRegistrations.clear();
        }
    }

    @Override
    public void apply(StatisticEvent event) {
        if (this.mRegistrations == null) {
            this.mRegistrations = new HashMap<String, Long>();
        }
        if (event.getData() >= 0L) {
            String subkey2 = event.getSubkey2();
            if (subkey2 == null) {
                subkey2 = this.getNodeRegistrationKey();
            }
            Long r = this.mRegistrations.get(subkey2);
            this.mRegistrations.put(subkey2, event.getData());
            if (this.mRegistrations.size() == 1) {
                this.mTimestamp = event.getTimestamp();
                this.mInfo = event.getInfo();
                this.mMax = this.mAvg = event.getData().longValue();
                this.mMin = this.mAvg;
            } else {
                if (this.mMax <= event.getData()) {
                    this.mTimestamp = event.getTimestamp();
                    this.mInfo = event.getInfo();
                    this.mMax = event.getData();
                }
                if (this.mMin > event.getData()) {
                    this.mMin = event.getData();
                }
                this.mAvg = (this.mAvg * this.mCount + event.getData()) / (long)this.mRegistrations.size();
            }
            this.mCount = this.mRegistrations.size();
        }
    }

    private synchronized String getNodeRegistrationKey() {
        return String.valueOf(++this.mRegistrationSequence);
    }

    @Override
    public void apply(IGaugeNode gauge) {
        if (this.mPk == null) {
            this.mPk = gauge.getPK();
        }
        if (gauge.getCount() > 0L) {
            if (this.mCount == 0L) {
                this.mTimestamp = gauge.getTimestamp();
                this.mInfo = this.buildInfo(gauge);
                this.mMin = gauge.getMin();
                this.mMax = gauge.getMax();
                this.mAvg = gauge.getAvg();
                this.mCount = gauge.getCount();
            } else {
                if (this.mMax <= gauge.getMax()) {
                    this.mTimestamp = gauge.getTimestamp();
                    this.mInfo = this.buildInfo(gauge);
                    this.mMax = gauge.getMax();
                }
                if (this.mMin > gauge.getMin()) {
                    this.mMin = gauge.getMin();
                }
                this.mAvg = (this.mAvg * this.mCount + gauge.getAvg() * gauge.getCount()) / (this.mCount + gauge.getCount());
                this.mCount += gauge.getCount().longValue();
            }
        }
    }

    @Override
    public Long getSimpleValue() {
        return this.getMax();
    }

    @Override
    public Object[] getCompositeValues() {
        return new Object[]{this.getMin(), this.getMax(), this.getAvg(), this.getCount(), this.getTimestamp() == 0L ? null : new Date(this.getTimestamp()), this.getInfo()};
    }

    @Override
    public Object[] getRowValues() {
        return new Object[]{this.getPK(), this.getMin(), this.getMax(), this.getAvg(), this.getCount(), this.getTimestamp() == 0L ? null : new Date(this.getTimestamp()), this.getInfo()};
    }

    private String buildInfo(IGaugeNode gauge) {
        if (this.isTop()) {
            return gauge.getPK() + (String)(gauge.getInfo() == null || gauge.getInfo().length() == 0 ? "" : ":" + gauge.getInfo());
        }
        return gauge.getInfo();
    }
}

