/*
 * Decompiled with CFR 0.152.
 */
package com.fxcm.util.jmx.impl.gauges;

import com.fxcm.util.jmx.impl.IGaugeNode;
import com.fxcm.util.jmx.impl.StatisticEvent;
import com.fxcm.util.jmx.impl.gauges.AGaugeNode;
import java.util.Date;

public class MeasurerNode
extends AGaugeNode {
    protected long mTimestamp = 0L;
    protected long mData = 0L;
    protected String mInfo = null;
    protected long mCount = 0L;

    public MeasurerNode(String pk) {
        super(pk);
    }

    @Override
    public long getTimestamp() {
        return this.mTimestamp;
    }

    @Override
    public Long getData() {
        return this.mData;
    }

    @Override
    public Long getCount() {
        return this.mCount;
    }

    @Override
    public String getInfo() {
        return this.mInfo;
    }

    @Override
    public void clear() {
        this.mTimestamp = 0L;
        this.mData = 0L;
        this.mInfo = null;
        this.mCount = 0L;
    }

    @Override
    public void apply(StatisticEvent event) {
        this.mTimestamp = event.getTimestamp();
        this.mData = event.getData();
        this.mInfo = event.getInfo();
        ++this.mCount;
    }

    @Override
    public void apply(IGaugeNode gauge) {
        if (this.mPk == null) {
            this.mPk = gauge.getPK();
        }
        if (gauge.getCount() > 0L || gauge.getData() > 0L) {
            this.mData = this.isTop() ? (this.mData += gauge.getData().longValue()) : gauge.getData();
            if (this.mTimestamp <= gauge.getTimestamp()) {
                this.mTimestamp = gauge.getTimestamp();
                this.mInfo = gauge.getInfo();
            }
        }
    }

    @Override
    public Long getSimpleValue() {
        return this.getData();
    }

    @Override
    public Object[] getCompositeValues() {
        return new Object[]{this.getData(), this.getTimestamp() == 0L ? null : new Date(this.getTimestamp()), this.getInfo()};
    }

    @Override
    public Object[] getRowValues() {
        return new Object[]{this.getPK(), this.getData(), this.getTimestamp() == 0L ? null : new Date(this.getTimestamp()), this.getInfo()};
    }
}

