/*
 * Decompiled with CFR 0.152.
 */
package com.fxcm.util.jmx.impl.gauges;

import com.fxcm.util.jmx.impl.IGaugeNode;
import com.fxcm.util.jmx.impl.StatisticEvent;
import com.fxcm.util.jmx.impl.gauges.AGaugeNode;
import java.util.Date;

public class CounterNode
extends AGaugeNode {
    protected long mTimestamp = 0L;
    protected long mCount = 0L;
    protected String mInfo = null;

    public CounterNode(String pk) {
        super(pk);
    }

    @Override
    public long getTimestamp() {
        return this.mTimestamp;
    }

    @Override
    public Long getCount() {
        return this.mCount;
    }

    @Override
    public String getInfo() {
        return this.mInfo;
    }

    @Override
    public void clear() {
        this.mTimestamp = 0L;
        this.mCount = 0L;
        Object mInfo = null;
    }

    @Override
    public void apply(StatisticEvent event) {
        this.mTimestamp = event.getTimestamp();
        this.mCount += event.getData().longValue();
        this.mInfo = event.getInfo();
        this.mInfo = event.getSubkey() + ":" + event.getInfo();
    }

    @Override
    public void apply(IGaugeNode gauge) {
        if (this.mPk == null) {
            this.mPk = gauge.getPK();
        }
        long was = this.mCount;
        if (gauge.getCount() > 0L) {
            this.mCount += gauge.getCount().longValue();
            this.mTimestamp = gauge.getTimestamp();
            this.mInfo = gauge.getInfo();
        }
    }

    @Override
    public Long getSimpleValue() {
        return this.getCount();
    }

    @Override
    public Object[] getCompositeValues() {
        return new Object[]{this.getCount(), this.getTimestamp() == 0L ? null : new Date(this.getTimestamp()), this.getInfo()};
    }

    @Override
    public Object[] getRowValues() {
        return new Object[]{this.getPK(), this.getCount(), this.getTimestamp() == 0L ? null : new Date(this.getTimestamp()), this.getInfo()};
    }
}

