/*
 * Decompiled with CFR 0.152.
 */
package com.fxcm.util.jmx.impl.gauges;

import com.fxcm.util.jmx.impl.IGaugeNode;
import com.fxcm.util.jmx.impl.StatisticEvent;
import com.fxcm.util.jmx.impl.gauges.AGaugeNode;
import java.util.Date;

public class BandwidthOutgoingNode
extends AGaugeNode {
    long mAvg = 0L;
    long mMax = 0L;
    long mData = 0L;
    long mTimestampMax = 0L;
    String mInfoMax = null;
    long mCount = 0L;

    public BandwidthOutgoingNode(String pk) {
        super(pk);
    }

    @Override
    public void clear() {
        this.mMax = 0L;
        this.mAvg = 0L;
        this.mData = 0L;
        this.mCount = 0L;
        this.mTimestampMax = 0L;
        this.mInfoMax = null;
    }

    @Override
    public Long getMin() {
        return null;
    }

    @Override
    public Long getMax() {
        return this.mMax;
    }

    @Override
    public Long getAvg() {
        return this.mAvg;
    }

    @Override
    public Long getData() {
        return this.mData;
    }

    @Override
    public Long getCount() {
        return this.mCount;
    }

    @Override
    public String getInfo() {
        return this.mInfoMax;
    }

    @Override
    public long getTimestamp() {
        return this.mTimestampMax;
    }

    @Override
    public void apply(StatisticEvent event) {
        this.mMax = this.mAvg = event.getData().longValue();
        this.mData = this.mAvg;
        this.mTimestampMax = event.getTimestamp();
        this.mInfoMax = event.getInfo();
        this.mCount = 0L;
    }

    private String buildInfo(IGaugeNode gauge) {
        if (this.isTop()) {
            return gauge.getPK() + (String)(gauge.getInfo() == null || gauge.getInfo().length() == 0 ? "" : ":" + gauge.getInfo());
        }
        return gauge.getInfo();
    }

    @Override
    public void apply(IGaugeNode gauge) {
        if (this.mPk == null) {
            this.mPk = gauge.getPK();
        }
        if (this.isTop()) {
            if (this.mCount == 0L) {
                this.mAvg = gauge.getAvg();
            } else if (this.mCount > 0L && gauge.getCount() > 0L) {
                this.mAvg = (this.mAvg * this.mCount + gauge.getAvg() * gauge.getCount()) / (this.mCount + gauge.getCount());
            }
            this.mData += gauge.getData().longValue();
            this.mCount += gauge.getCount().longValue();
            if (this.mMax <= gauge.getMax()) {
                this.mMax = gauge.getMax();
                this.mTimestampMax = gauge.getTimestamp();
                this.mInfoMax = this.buildInfo(gauge);
            }
        } else {
            long data = gauge.getData();
            if (this.mCount > 0L) {
                this.mAvg = (this.mAvg * this.mCount + data) / (this.mCount + 1L);
                this.mData += data;
                if (this.mMax <= data) {
                    this.mMax = data;
                    this.mTimestampMax = gauge.getTimestamp();
                    this.mInfoMax = this.buildInfo(gauge);
                }
            } else {
                this.mMax = this.mAvg = gauge.getData().longValue();
                this.mData = this.mAvg;
                this.mTimestampMax = gauge.getTimestamp();
                this.mInfoMax = this.buildInfo(gauge);
            }
            ++this.mCount;
        }
    }

    @Override
    public Long getSimpleValue() {
        return this.getMax();
    }

    @Override
    public Object[] getCompositeValues() {
        return new Object[]{this.getMax(), this.getAvg(), this.getData(), this.getTimestamp() == 0L ? null : new Date(this.getTimestamp()), this.getInfo()};
    }

    @Override
    public Object[] getRowValues() {
        return new Object[]{this.getPK(), this.getMax(), this.getAvg(), this.getData(), this.getTimestamp() == 0L ? null : new Date(this.getTimestamp()), this.getInfo()};
    }
}

