/*
 * Decompiled with CFR 0.152.
 */
package com.fxcm.util.jmx.impl.gauges;

import com.fxcm.util.jmx.impl.IGaugeNode;
import com.fxcm.util.jmx.impl.StatisticEvent;
import com.fxcm.util.jmx.impl.gauges.AGaugeNode;
import java.util.Date;

public class BandwidthIncomingNode
extends AGaugeNode {
    protected long mTimestamp = 0L;
    protected long mData = 0L;
    protected String mInfo = null;

    public BandwidthIncomingNode(String pk) {
        super(pk);
    }

    @Override
    public long getTimestamp() {
        return this.mTimestamp;
    }

    @Override
    public Long getData() {
        return this.mData;
    }

    @Override
    public String getInfo() {
        return this.mInfo;
    }

    @Override
    public void clear() {
        this.mTimestamp = 0L;
        this.mData = 0L;
        this.mInfo = null;
    }

    @Override
    public void apply(StatisticEvent event) {
        this.mTimestamp = event.getTimestamp();
        this.mData += event.getData().longValue();
        this.mInfo = event.getInfo();
    }

    @Override
    public void apply(IGaugeNode gauge) {
        if (this.mPk == null) {
            this.mPk = gauge.getPK();
        }
        long was = this.mData;
        if (gauge.getData() > 0L) {
            this.mData += gauge.getData().longValue();
            this.mTimestamp = gauge.getTimestamp();
            this.mInfo = gauge.getInfo();
        }
    }

    @Override
    public Long getSimpleValue() {
        return this.getCount();
    }

    @Override
    public Object[] getCompositeValues() {
        return new Object[]{this.getCount(), this.getTimestamp() == 0L ? null : new Date(this.getTimestamp()), this.getInfo()};
    }

    @Override
    public Object[] getRowValues() {
        return new Object[]{this.getPK(), this.getCount(), this.getTimestamp() == 0L ? null : new Date(this.getTimestamp()), this.getInfo()};
    }
}

