/*
 * Decompiled with CFR 0.152.
 */
package com.fxcm.util.jmx.impl.gauges;

import com.fxcm.util.jmx.impl.IGauge;
import com.fxcm.util.jmx.impl.IGaugeNode;
import com.fxcm.util.jmx.impl.StatisticEvent;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public abstract class AGauge
implements IGauge {
    String mPk = null;
    Map<String, IGaugeNode> mNodes = new HashMap<String, IGaugeNode>();
    boolean mResetOnRead = false;
    boolean mSubKeyFull = false;

    @Override
    public void setSubKeyFull(boolean flag) {
        this.mSubKeyFull = flag;
    }

    protected abstract IGaugeNode createNodeGauge(String var1);

    protected abstract String getTopRowName();

    @Override
    public String getPK() {
        return this.mPk;
    }

    public void setResetOnRead(boolean aResetOnRead) {
        this.mResetOnRead = aResetOnRead;
    }

    public boolean getResetOnRead() {
        return this.mResetOnRead;
    }

    protected IGaugeNode findTopNode() {
        IGaugeNode node = null;
        if (this.mNodes.size() > 0) {
            node = this.mNodes.size() > 1 ? this.mNodes.get(this.getTopRowName()) : this.mNodes.values().iterator().next();
        }
        return node;
    }

    @Override
    public void clear() {
        for (IGaugeNode sm : this.mNodes.values()) {
            sm.clear();
        }
    }

    @Override
    public void apply(StatisticEvent event) {
        IGaugeNode node;
        String subkey;
        if (this.mPk == null) {
            String string = this.mPk = event.getKey() == null ? "na" : event.getKey();
        }
        if ((subkey = event.getSubkey()) == null) {
            subkey = "na";
        }
        String[] subkeys = subkey.split(":", 2);
        if (this.mSubKeyFull) {
            node = this.mNodes.get(subkey);
            if (node == null) {
                node = this.createNodeGauge(subkey);
                this.mNodes.put(node.getPK(), node);
            }
            node.apply(event);
        }
        if (subkeys.length > 1 || !this.mSubKeyFull) {
            node = this.mNodes.get(subkeys[0]);
            if (node == null) {
                node = this.createNodeGauge(subkeys[0]);
                this.mNodes.put(node.getPK(), node);
            }
            node.apply(event);
        }
    }

    @Override
    public void apply(IGauge gauge) {
        if (this.mPk == null) {
            this.mPk = gauge.getPK();
        }
        IGaugeNode top = this.mNodes.get(this.getTopRowName());
        if (gauge.getNodes() != null) {
            for (IGaugeNode node : gauge.getNodes()) {
                if (node.isTop()) continue;
                IGaugeNode here = this.mNodes.get(node.getPK());
                if (here == null) {
                    here = this.createNodeGauge(node.getPK());
                    this.mNodes.put(here.getPK(), here);
                }
                here.apply(node);
            }
        }
        if (this.mNodes.size() > 1 && top == null) {
            top = this.createNodeGauge(this.getTopRowName());
            top.setTop(true);
            this.mNodes.put(top.getPK(), top);
        }
        if (top != null) {
            top.clear();
            for (IGaugeNode node : this.mNodes.values()) {
                if (node.isTop()) continue;
                top.apply(node);
            }
        }
    }

    @Override
    public Collection<IGaugeNode> getNodes() {
        return this.mNodes.values();
    }

    @Override
    public IGaugeNode findNode(String nodePK) {
        IGaugeNode node = null;
        node = nodePK == null || nodePK.length() == 0 ? this.findTopNode() : this.mNodes.get(nodePK);
        return node;
    }
}

