/*
 * Decompiled with CFR 0.152.
 */
package com.fxcm.util.jmx.impl;

import com.fxcm.util.jmx.GaugeInfo;
import com.fxcm.util.jmx.IConsole;
import com.fxcm.util.jmx.IMBeanPod;
import com.fxcm.util.jmx.impl.GaugeFactory;
import com.fxcm.util.jmx.impl.IGauge;
import com.fxcm.util.jmx.impl.IGaugeDatabase;
import com.fxcm.util.jmx.impl.IMBean;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.Notification;
import javax.management.NotificationBroadcasterSupport;
import javax.management.ReflectionException;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.OpenMBeanAttributeInfo;
import javax.management.openmbean.OpenMBeanAttributeInfoSupport;
import javax.management.openmbean.OpenMBeanInfoSupport;
import javax.management.openmbean.OpenMBeanOperationInfo;
import javax.management.openmbean.OpenMBeanOperationInfoSupport;
import javax.management.openmbean.OpenMBeanParameterInfo;
import javax.management.openmbean.OpenMBeanParameterInfoSupport;
import javax.management.openmbean.SimpleType;
import javax.management.openmbean.TabularData;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class GenericMBean
extends NotificationBroadcasterSupport
implements IMBean {
    Log mLogger = LogFactory.getLog(GenericMBean.class.getName());
    private IConsole mConsole = null;
    private GaugeDatabaseReader mDatabaseReader = null;
    private MBeanInfo mMBeanInfo = null;
    private Map<String, GaugeInfo> mGaugeInfos = null;
    private long mEmitterId = 0L;
    private IMBeanPod mPod = null;

    @Override
    public void setGaugeInfo(List<GaugeInfo> infos) {
        this.mGaugeInfos = new HashMap<String, GaugeInfo>();
        for (GaugeInfo info : infos) {
            this.mGaugeInfos.put(info.getAttribteName(), info);
        }
    }

    @Override
    public void setMBeanPod(IMBeanPod aPod) {
        this.mPod = aPod;
    }

    @Override
    public void setConsole(IConsole console) {
        this.mConsole = console;
    }

    protected GaugeDatabaseReader getGaugeDatabaseReader() {
        return this.mDatabaseReader;
    }

    @Override
    public void sos(String type, String message) {
        this.sendNotification(new Notification(type, (Object)this, ++this.mEmitterId, message));
    }

    @Override
    public Object getAttribute(String attribute) throws AttributeNotFoundException, MBeanException, ReflectionException {
        Object ret = null;
        GaugeInfo info = this.mGaugeInfos.get(attribute);
        if (info != null) {
            ret = info.getAttributeType() == GaugeInfo.AttributeType.COMPOSITE ? this.mDatabaseReader.readComposite(attribute, info) : (info.getAttributeType() == GaugeInfo.AttributeType.TABULAR ? this.mDatabaseReader.readTabular(attribute, info) : this.mDatabaseReader.readSimple(attribute, info));
        }
        return ret;
    }

    @Override
    public void setAttribute(Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
    }

    @Override
    public AttributeList getAttributes(String[] attributes) {
        AttributeList list = new AttributeList();
        for (int i = 0; i < attributes.length; ++i) {
            Object value = null;
            try {
                value = this.getAttribute(attributes[i]);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (value == null) continue;
            list.add(new Attribute(attributes[i], value));
        }
        return list;
    }

    @Override
    public AttributeList setAttributes(AttributeList attributes) {
        return null;
    }

    @Override
    public Object invoke(String actionName, Object[] params, String[] signature) throws MBeanException, ReflectionException {
        String ret = null;
        if (this.mConsole != null && actionName.equals("commandLine") && params.length == 1) {
            ret = this.mConsole.commandLine((String)params[0]);
        } else if (actionName.equals("reset") && params.length == 1) {
            try {
                this.mDatabaseReader.reset((String)params[0]);
            }
            catch (Exception e) {
                this.mLogger.error("Failed to invoke " + actionName, e);
            }
        } else if (actionName.equals("enable") && params.length == 2) {
            try {
                this.mPod.enable((String)params[0], (Boolean)params[1]);
            }
            catch (Exception e) {
                this.mLogger.error("Failed to invoke " + actionName, e);
            }
        } else if (actionName.equals("resetOnRead") && params.length == 2) {
            try {
                this.mPod.resetOnRead((String)params[0], (Boolean)params[1]);
            }
            catch (Exception e) {
                this.mLogger.error("Failed to invoke " + actionName, e);
            }
        }
        return ret;
    }

    @Override
    public MBeanInfo getMBeanInfo() {
        if (this.mMBeanInfo == null) {
            OpenMBeanParameterInfo[] params = new OpenMBeanParameterInfoSupport[]{new OpenMBeanParameterInfoSupport("line", "command line input", SimpleType.STRING)};
            OpenMBeanParameterInfo[] params2 = new OpenMBeanParameterInfoSupport[]{new OpenMBeanParameterInfoSupport("attribute", "name of jmx attribute", SimpleType.STRING)};
            OpenMBeanParameterInfo[] params3 = new OpenMBeanParameterInfoSupport[]{new OpenMBeanParameterInfoSupport("attribute", "name of jmx attribute", SimpleType.STRING), new OpenMBeanParameterInfoSupport("flag", "enable/disable flag", SimpleType.BOOLEAN)};
            OpenMBeanOperationInfo[] opers = null;
            opers = this.mConsole == null ? new OpenMBeanOperationInfoSupport[]{new OpenMBeanOperationInfoSupport("reset", "reset gauge values", params2, SimpleType.VOID, 1), new OpenMBeanOperationInfoSupport("enable", "enable/disable statistic event", params3, SimpleType.VOID, 1), new OpenMBeanOperationInfoSupport("resetOnRead", "enable/disable resetOnRead flag", params3, SimpleType.VOID, 1)} : new OpenMBeanOperationInfoSupport[]{new OpenMBeanOperationInfoSupport("commandLine", "run console command line", params, SimpleType.STRING, 2), new OpenMBeanOperationInfoSupport("reset", "reset gauge values", params2, SimpleType.VOID, 1), new OpenMBeanOperationInfoSupport("enable", "enable/disable statistic event", params3, SimpleType.VOID, 1), new OpenMBeanOperationInfoSupport("resetOnRead", "enable/disable resetOnRead flag", params3, SimpleType.VOID, 1)};
            MBeanNotificationInfo[] notif = new MBeanNotificationInfo[]{new MBeanNotificationInfo(new String[]{"S.O.S."}, Notification.class.getName(), "This notification is emitted when service required an attention.")};
            this.mMBeanInfo = new OpenMBeanInfoSupport(this.getClass().getName(), "Statistics", this.getOpenMBeanAttributeInfo(), null, opers, notif);
        }
        return this.mMBeanInfo;
    }

    @Override
    public void setGaugeDatabase(IGaugeDatabase database) {
        this.mDatabaseReader = new GaugeDatabaseReader(database, this);
    }

    protected OpenMBeanAttributeInfo[] getOpenMBeanAttributeInfo() {
        ArrayList<OpenMBeanAttributeInfoSupport> list = new ArrayList<OpenMBeanAttributeInfoSupport>();
        for (GaugeInfo info : this.mGaugeInfos.values()) {
            list.add(new OpenMBeanAttributeInfoSupport(info.getAttribteName(), info.getAttributeDescription(), GaugeFactory.getOpenType(info.getGaugeType(), info.getAttributeType()), true, false, false));
        }
        OpenMBeanAttributeInfo[] ret = null;
        try {
            ret = new OpenMBeanAttributeInfo[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                ret[i] = (OpenMBeanAttributeInfo)list.get(i);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ret;
    }

    public class GaugeDatabaseReader {
        IGaugeDatabase mDatabase = null;
        GenericMBean mBean = null;

        GaugeDatabaseReader(IGaugeDatabase database, GenericMBean bean) {
            this.mDatabase = database;
            this.mBean = bean;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Long readSimple(String attributeName, GaugeInfo info) {
            Long ret = null;
            Map<String, IGauge> map = this.mDatabase.getGauges();
            synchronized (map) {
                IGauge gauge = this.mDatabase.getGauges().get(attributeName);
                if (gauge != null) {
                    ret = GaugeFactory.createSimpleData(gauge, info.getStatisticEventSubkey());
                    if (info.getResetOnRead()) {
                        gauge.clear();
                    }
                }
            }
            return ret;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public CompositeData readComposite(String attributeName, GaugeInfo info) {
            CompositeData ret = null;
            Map<String, IGauge> map = this.mDatabase.getGauges();
            synchronized (map) {
                IGauge gauge = this.mDatabase.getGauges().get(attributeName);
                if (gauge != null) {
                    ret = GaugeFactory.createCompositeData(gauge, info.getStatisticEventSubkey());
                    if (info.getResetOnRead()) {
                        gauge.clear();
                    }
                }
            }
            return ret;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public TabularData readTabular(String attributeName, GaugeInfo info) {
            TabularData ret = null;
            Map<String, IGauge> map = this.mDatabase.getGauges();
            synchronized (map) {
                IGauge gauge = this.mDatabase.getGauges().get(attributeName);
                if (gauge != null) {
                    ret = GaugeFactory.createTabularData(gauge);
                    if (info.getResetOnRead()) {
                        gauge.clear();
                    }
                }
            }
            return ret;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void reset(String attribute) {
            if (attribute == null || attribute.length() == 0 || "all".equalsIgnoreCase(attribute)) {
                Map<String, IGauge> map = this.mDatabase.getGauges();
                synchronized (map) {
                    for (IGauge gauge : this.mDatabase.getGauges().values()) {
                        if (gauge == null) continue;
                        gauge.clear();
                    }
                }
            }
            Map<String, IGauge> map = this.mDatabase.getGauges();
            synchronized (map) {
                IGauge gauge = this.mDatabase.getGauges().get(attribute);
                if (gauge != null) {
                    gauge.clear();
                }
            }
        }
    }
}

