/*
 * Decompiled with CFR 0.152.
 */
package com.fxcm.util.jmx.impl;

import com.fxcm.util.jmx.GaugeInfo;
import com.fxcm.util.jmx.impl.GaugeFactory;
import com.fxcm.util.jmx.impl.IGauge;
import com.fxcm.util.jmx.impl.IGaugeDatabase;
import com.fxcm.util.jmx.impl.StatisticEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class GenericGaugeDatabase
implements IGaugeDatabase {
    Map<String, IGauge> mInputGauges = new HashMap<String, IGauge>();
    Map<String, IGauge> mOutputGauges = new HashMap<String, IGauge>();
    Map<String, List<GaugeInfo>> mGaugeInfos = new HashMap<String, List<GaugeInfo>>();

    public GenericGaugeDatabase(List<GaugeInfo> infos) {
        for (GaugeInfo info : infos) {
            List<GaugeInfo> perType = this.mGaugeInfos.get(info.getStatisticEventKey());
            if (perType == null) {
                perType = new ArrayList<GaugeInfo>();
                this.mGaugeInfos.put(info.getStatisticEventKey(), perType);
            }
            perType.add(info);
        }
    }

    @Override
    public Map<String, IGauge> getGauges() {
        return this.mOutputGauges;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void idle() {
        Map<String, IGauge> map = this.mOutputGauges;
        synchronized (map) {
            for (String key : this.mInputGauges.keySet()) {
                IGauge input = this.mInputGauges.get(key);
                IGauge output = this.mOutputGauges.get(key);
                if (output == null) {
                    output = GaugeFactory.createGauge(input.getGaugeType(), true);
                    this.mOutputGauges.put(key, output);
                }
                output.apply(input);
                input.clear();
            }
        }
    }

    public void register(StatisticEvent event) {
        if (event.mKey == null) {
            return;
        }
        List<GaugeInfo> infos = this.mGaugeInfos.get(event.getKey());
        if (infos != null) {
            for (GaugeInfo info : infos) {
                IGauge gauge = this.mInputGauges.get(info.getAttribteName());
                if (gauge == null) {
                    gauge = GaugeFactory.createGauge(info.getGaugeType(), false);
                    gauge.setSubKeyFull(info.isSubKeyFull());
                    this.mInputGauges.put(info.getAttribteName(), gauge);
                }
                gauge.apply(event);
            }
        }
    }
}

