/*
 * Decompiled with CFR 0.152.
 */
package com.fxcm.util.jmx.impl;

import com.fxcm.util.concurrent.ArrayListQueueThread2;
import com.fxcm.util.concurrent.IQueueThread;
import com.fxcm.util.jmx.GaugeInfo;
import com.fxcm.util.jmx.IConsole;
import com.fxcm.util.jmx.IMBeanPod;
import com.fxcm.util.jmx.impl.GenericGaugeDatabase;
import com.fxcm.util.jmx.impl.GenericMBean;
import com.fxcm.util.jmx.impl.IMBean;
import com.fxcm.util.jmx.impl.StatisticEvent;
import java.lang.management.ManagementFactory;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class GenericBeanPod
implements IMBeanPod {
    Log mLogger = LogFactory.getLog(GenericBeanPod.class.getName());
    protected int mMaxHeapSize = 5000;
    protected int mHeapSize = 0;
    protected boolean mEnabled = true;
    protected IMBean mMBean = null;
    protected IQueueThread<StatisticEvent> mStatisticQueue = null;
    protected GenericGaugeDatabase mGaugeDatabase = null;
    protected Map<String, GaugeInfo> mGaugeInfos = null;
    protected List<StatisticEvent> mStatisticEventHeap = new LinkedList<StatisticEvent>();
    protected static final StatisticEvent IDLE_EVENT = new StatisticEvent(StatisticEvent.Kind.IDLE, null, null, null, null, null);
    protected volatile boolean mThreadCollection = false;
    protected volatile long mTurnOnTime = 0L;
    protected Map<Long, List<StatisticEvent>> mThreadEvents = null;

    public GenericBeanPod() {
        this.mStatisticQueue = new ArrayListQueueThread2((IQueueThread.IQueueElementProcessor)new StatisticEventProcessor(this), "StatisticEventQueue", (IQueueThread.IErrorElementListener)new StatisticErrorProcessor(this));
        this.mThreadEvents = new HashMap<Long, List<StatisticEvent>>();
    }

    @Override
    public void start() {
        if (this.mMBean != null) {
            this.mStatisticQueue.start();
        }
    }

    @Override
    public void stop() {
        if (this.mMBean != null) {
            this.mStatisticQueue.stop();
        }
    }

    @Override
    public boolean isEnabled() {
        return this.mMBean != null && this.mEnabled;
    }

    @Override
    public void setHeapSize(int aHeapSize) {
        this.mMaxHeapSize = aHeapSize;
    }

    @Override
    public boolean init(List<GaugeInfo> gaugeInfos, ObjectName name, String aDescription, IConsole console) {
        boolean ret = false;
        try {
            this.mGaugeDatabase = new GenericGaugeDatabase(gaugeInfos);
            MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
            this.mMBean = new GenericMBean();
            this.mMBean.setGaugeDatabase(this.mGaugeDatabase);
            this.mMBean.setConsole(console);
            this.mMBean.setMBeanPod(this);
            this.mGaugeInfos = new HashMap<String, GaugeInfo>();
            for (GaugeInfo info : gaugeInfos) {
                this.mGaugeInfos.put(info.getStatisticEventKey(), info);
            }
            this.mMBean.setGaugeInfo(gaugeInfos);
            mbs.registerMBean(this.mMBean, name);
            ret = true;
        }
        catch (Exception e) {
            this.mLogger.error("Failed to init JMX", e);
            ret = false;
        }
        if (!ret) {
            this.mMBean = null;
        }
        return ret;
    }

    @Override
    public void collectStatistics() {
        if (this.mMBean != null) {
            this.mStatisticQueue.put((Object)IDLE_EVENT);
        }
    }

    @Override
    public void registerStatisticEvent(String key, String subkey, String subkey2, Long data, String ref) {
        StatisticEvent event;
        GaugeInfo info;
        if (this.mMBean != null && this.mEnabled && (info = this.mGaugeInfos.get(key)) != null && info.isEnabled() && (event = this.createStatisticEvent(StatisticEvent.Kind.STATISTIC, key, subkey, subkey2, data, ref)) != null) {
            this.mStatisticQueue.put((Object)event);
        }
    }

    @Override
    public void registerNotificationEvent(String type, String message) {
        if (this.mMBean != null) {
            this.mStatisticQueue.put((Object)new StatisticEvent(StatisticEvent.Kind.NOTIFICATION, null, type, null, 0L, message));
        }
    }

    @Override
    public void enable(String attribute, Boolean flag) {
        if (attribute == null || attribute.length() == 0 || "all".equalsIgnoreCase(attribute)) {
            this.mEnabled = flag;
        } else {
            GaugeInfo info = this.mGaugeInfos.get(attribute);
            if (info != null) {
                info.setEnabled(flag);
            }
        }
    }

    @Override
    public void resetOnRead(String attribute, Boolean flag) {
        GaugeInfo info = this.mGaugeInfos.get(attribute);
        if (info != null) {
            info.setResetOnRead(flag);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StatisticEvent createStatisticEvent(StatisticEvent.Kind aKind, String aKey, String aSubkey, String aSubkey2, Long aData, String aInfo) {
        StatisticEvent ret = null;
        int arraySize = 0;
        int heapSize = 0;
        boolean toError = false;
        if (this.mMaxHeapSize > 0) {
            List<StatisticEvent> list = this.mStatisticEventHeap;
            synchronized (list) {
                arraySize = this.mStatisticEventHeap.size();
                if (arraySize > 0) {
                    ret = this.mStatisticEventHeap.remove(0);
                } else if (this.mHeapSize < this.mMaxHeapSize) {
                    ++this.mHeapSize;
                } else if (!this.mThreadCollection) {
                    this.mThreadCollection = true;
                    this.mTurnOnTime = System.currentTimeMillis();
                    toError = true;
                }
                heapSize = this.mHeapSize;
            }
            if (ret == null) {
                if (heapSize < this.mMaxHeapSize) {
                    ret = new StatisticEvent(aKind, aKey, aSubkey, aSubkey2, aData, aInfo);
                }
            } else {
                ret.fill(aKind, aKey, aSubkey, aSubkey2, aData, aInfo);
            }
            if (toError) {
                this.mLogger.error("StatisticEventMemory = " + heapSize + "(free:" + arraySize + ") overloaded");
                this.registerNotificationEvent("StatisticEventMemory", "Overloaded " + heapSize + "(free:" + arraySize + ")");
            } else if (heapSize - arraySize >= this.mMaxHeapSize) {
                this.mLogger.warn("StatisticEventMemory = " + heapSize + "(free:" + arraySize + ")");
            } else if (this.mLogger.isDebugEnabled() && heapSize - arraySize > 1) {
                this.mLogger.debug("StatisticEventMemory = " + heapSize + "(free:" + arraySize + ")");
            }
        } else {
            ret = new StatisticEvent(aKind, aKey, aSubkey, aSubkey2, aData, aInfo);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseStatisticEvent(StatisticEvent aEvent) {
        boolean toError = false;
        if (this.mMaxHeapSize > 0) {
            int size = 0;
            List<StatisticEvent> list = this.mStatisticEventHeap;
            synchronized (list) {
                this.mStatisticEventHeap.add(aEvent);
                size = this.mStatisticEventHeap.size();
            }
            if ((double)size >= (double)this.mMaxHeapSize * 0.9 && this.mThreadCollection && System.currentTimeMillis() > this.mTurnOnTime + 60000L) {
                this.mThreadCollection = false;
                toError = true;
            }
            if (toError) {
                this.mLogger.error("StatisticEventMemory freed " + size);
                this.registerNotificationEvent("StatisticEventMemory", "Freed " + size);
            }
        }
    }

    private class StatisticErrorProcessor
    implements IQueueThread.IErrorElementListener<StatisticEvent> {
        GenericBeanPod mPod = null;

        public StatisticErrorProcessor(GenericBeanPod aPod) {
            this.mPod = aPod;
        }

        public StatisticEvent onError(Throwable thrwbl, StatisticEvent event) {
            this.mPod.mLogger.error("Failed to process statistic event", thrwbl);
            return null;
        }
    }

    private class StatisticEventProcessor
    implements IQueueThread.IQueueElementProcessor<StatisticEvent> {
        GenericBeanPod mPod = null;

        public StatisticEventProcessor(GenericBeanPod aPod) {
            this.mPod = aPod;
        }

        public void process(StatisticEvent aEvent) {
            LinkedList events = new LinkedList();
            try {
                if (aEvent.getKind() == StatisticEvent.Kind.IDLE) {
                    GenericBeanPod.this.mGaugeDatabase.idle();
                } else if (aEvent.getKind() == StatisticEvent.Kind.NOTIFICATION) {
                    GenericBeanPod.this.mMBean.sos(aEvent.getSubkey(), aEvent.getInfo());
                } else if (aEvent.getKind() == StatisticEvent.Kind.STATISTIC) {
                    GenericBeanPod.this.mGaugeDatabase.register(aEvent);
                }
            }
            finally {
                if (aEvent.getKind() == StatisticEvent.Kind.STATISTIC) {
                    GenericBeanPod.this.releaseStatisticEvent(aEvent);
                }
            }
        }
    }
}

