/*
 * Decompiled with CFR 0.152.
 */
package com.fxcm.util.jmx.impl;

import com.fxcm.util.jmx.GaugeInfo;
import com.fxcm.util.jmx.impl.IGauge;
import com.fxcm.util.jmx.impl.IGaugeNode;
import com.fxcm.util.jmx.impl.gauges.AGauge;
import com.fxcm.util.jmx.impl.gauges.BandwidthIncoming;
import com.fxcm.util.jmx.impl.gauges.BandwidthOutgoing;
import com.fxcm.util.jmx.impl.gauges.Counter;
import com.fxcm.util.jmx.impl.gauges.Measurer;
import com.fxcm.util.jmx.impl.gauges.Performance;
import java.util.EnumMap;
import java.util.Map;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import javax.management.openmbean.TabularType;

public class GaugeFactory {
    private static final GaugeFactory cFactory = new GaugeFactory();
    private static final Map<GaugeInfo.GaugeType, CompositeType> cCompositeTypes = new EnumMap<GaugeInfo.GaugeType, CompositeType>(GaugeInfo.GaugeType.class);
    private static final Map<GaugeInfo.GaugeType, String[]> cCompositeNames = new EnumMap<GaugeInfo.GaugeType, String[]>(GaugeInfo.GaugeType.class);
    private static final Map<GaugeInfo.GaugeType, String[]> cCompositeDesc = new EnumMap<GaugeInfo.GaugeType, String[]>(GaugeInfo.GaugeType.class);
    private static final Map<GaugeInfo.GaugeType, CompositeType> cRowTypes = new EnumMap<GaugeInfo.GaugeType, CompositeType>(GaugeInfo.GaugeType.class);
    private static final Map<GaugeInfo.GaugeType, String[]> cRowNames = new EnumMap<GaugeInfo.GaugeType, String[]>(GaugeInfo.GaugeType.class);
    private static final Map<GaugeInfo.GaugeType, String[]> cRowDesc = new EnumMap<GaugeInfo.GaugeType, String[]>(GaugeInfo.GaugeType.class);
    private static final Map<GaugeInfo.GaugeType, TabularType> cTabularTypes = new EnumMap<GaugeInfo.GaugeType, TabularType>(GaugeInfo.GaugeType.class);

    public static IGauge createGauge(GaugeInfo.GaugeType gaugeType, boolean outgoing) {
        return cFactory.instance(gaugeType, outgoing);
    }

    public static OpenType getOpenType(GaugeInfo.GaugeType gaugeType, GaugeInfo.AttributeType attribiteType) {
        OpenType ret = SimpleType.LONG;
        if (attribiteType == GaugeInfo.AttributeType.TABULAR) {
            ret = cTabularTypes.get((Object)gaugeType);
        } else if (attribiteType == GaugeInfo.AttributeType.COMPOSITE) {
            ret = cCompositeTypes.get((Object)gaugeType);
        }
        return ret;
    }

    private IGauge instance(GaugeInfo.GaugeType gaugeType, boolean outgoing) {
        AGauge ret = null;
        if (gaugeType == GaugeInfo.GaugeType.MEASURER) {
            ret = new Measurer();
        } else if (gaugeType == GaugeInfo.GaugeType.COUNTER) {
            ret = new Counter();
        } else if (gaugeType == GaugeInfo.GaugeType.BANDWIDTH) {
            ret = outgoing ? new BandwidthOutgoing() : new BandwidthIncoming();
        } else if (gaugeType == GaugeInfo.GaugeType.PERFORMANCE) {
            ret = new Performance();
        }
        return ret;
    }

    public static Long createSimpleData(IGauge gauge, String nodePK) {
        Long ret = null;
        IGaugeNode node = gauge.findNode(nodePK);
        if (node != null) {
            ret = node.getSimpleValue();
        }
        return ret;
    }

    public static CompositeData createCompositeData(IGauge gauge, String nodePK) {
        CompositeDataSupport ret = null;
        try {
            IGaugeNode node = gauge.findNode(nodePK);
            if (node != null) {
                ret = new CompositeDataSupport(cCompositeTypes.get((Object)gauge.getGaugeType()), cCompositeNames.get((Object)gauge.getGaugeType()), node.getCompositeValues());
            }
        }
        catch (OpenDataException e) {
            e.printStackTrace();
        }
        return ret;
    }

    public static TabularData createTabularData(IGauge gauge) {
        TabularDataSupport ret = new TabularDataSupport(cTabularTypes.get((Object)gauge.getGaugeType()));
        try {
            for (IGaugeNode node : gauge.getNodes()) {
                ret.put(new CompositeDataSupport(cRowTypes.get((Object)gauge.getGaugeType()), cRowNames.get((Object)gauge.getGaugeType()), node.getRowValues()));
            }
        }
        catch (OpenDataException e) {
            e.printStackTrace();
        }
        return ret;
    }

    static {
        try {
            cCompositeNames.put(GaugeInfo.GaugeType.MEASURER, new String[]{"value", "time", "info"});
            cCompositeNames.put(GaugeInfo.GaugeType.COUNTER, new String[]{"value", "time", "info"});
            cCompositeNames.put(GaugeInfo.GaugeType.BANDWIDTH, new String[]{"max", "avg", "cound", "maxTime", "maxInfo"});
            cCompositeNames.put(GaugeInfo.GaugeType.PERFORMANCE, new String[]{"min", "max", "avg", "count", "maxTime", "maxInfo"});
            cCompositeDesc.put(GaugeInfo.GaugeType.MEASURER, new String[]{"value", "register time", "register info"});
            cCompositeDesc.put(GaugeInfo.GaugeType.COUNTER, new String[]{"value", "register time", "register info"});
            cCompositeDesc.put(GaugeInfo.GaugeType.BANDWIDTH, new String[]{"max bandwidth", "avg bandwidth", "total number of events", "Time when max registered", "Info of max registered"});
            cCompositeDesc.put(GaugeInfo.GaugeType.PERFORMANCE, new String[]{"min performance", "max performance", "avg performance", "total number of events", "Time when max registered", "Info of max registered"});
            cRowNames.put(GaugeInfo.GaugeType.MEASURER, new String[]{"id", "value", "time", "info"});
            cRowNames.put(GaugeInfo.GaugeType.COUNTER, new String[]{"id", "value", "time", "info"});
            cRowNames.put(GaugeInfo.GaugeType.BANDWIDTH, new String[]{"id", "max", "avg", "count", "maxTime", "maxInfo"});
            cRowNames.put(GaugeInfo.GaugeType.PERFORMANCE, new String[]{"id", "min", "max", "avg", "count", "maxTime", "maxInfo"});
            cRowDesc.put(GaugeInfo.GaugeType.MEASURER, new String[]{"id", "value", "register time", "register info"});
            cRowDesc.put(GaugeInfo.GaugeType.COUNTER, new String[]{"id", "value", "register time", "register info"});
            cRowDesc.put(GaugeInfo.GaugeType.BANDWIDTH, new String[]{"id", "max bandwidth", "avg bandwidth", "total number of events", "Time when max registered", "Info of max registered"});
            cRowDesc.put(GaugeInfo.GaugeType.PERFORMANCE, new String[]{"id", "min performance", "max performance", "avg performance", "total number of events", "Time when max registered", "Info of max registered"});
            cCompositeTypes.put(GaugeInfo.GaugeType.MEASURER, new CompositeType("Measurer", "Measurer Gauge", cCompositeNames.get((Object)GaugeInfo.GaugeType.MEASURER), cCompositeDesc.get((Object)GaugeInfo.GaugeType.MEASURER), new OpenType[]{SimpleType.LONG, SimpleType.DATE, SimpleType.STRING}));
            cCompositeTypes.put(GaugeInfo.GaugeType.COUNTER, new CompositeType("Counter", "Counter Gauge", cCompositeNames.get((Object)GaugeInfo.GaugeType.COUNTER), cCompositeDesc.get((Object)GaugeInfo.GaugeType.COUNTER), new OpenType[]{SimpleType.LONG, SimpleType.DATE, SimpleType.STRING}));
            cCompositeTypes.put(GaugeInfo.GaugeType.BANDWIDTH, new CompositeType("Bandwidth", "Bandwidth Gauge", cCompositeNames.get((Object)GaugeInfo.GaugeType.BANDWIDTH), cCompositeDesc.get((Object)GaugeInfo.GaugeType.BANDWIDTH), new OpenType[]{SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.DATE, SimpleType.STRING}));
            cCompositeTypes.put(GaugeInfo.GaugeType.PERFORMANCE, new CompositeType("Performance", "Performance Gauge", cCompositeNames.get((Object)GaugeInfo.GaugeType.PERFORMANCE), cCompositeDesc.get((Object)GaugeInfo.GaugeType.PERFORMANCE), new OpenType[]{SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.DATE, SimpleType.STRING}));
            cRowTypes.put(GaugeInfo.GaugeType.MEASURER, new CompositeType("Measurer", "Measurer Gauge", cRowNames.get((Object)GaugeInfo.GaugeType.MEASURER), cRowDesc.get((Object)GaugeInfo.GaugeType.MEASURER), new OpenType[]{SimpleType.STRING, SimpleType.LONG, SimpleType.DATE, SimpleType.STRING}));
            cRowTypes.put(GaugeInfo.GaugeType.COUNTER, new CompositeType("Counter", "Counter Gauge", cRowNames.get((Object)GaugeInfo.GaugeType.COUNTER), cRowDesc.get((Object)GaugeInfo.GaugeType.COUNTER), new OpenType[]{SimpleType.STRING, SimpleType.LONG, SimpleType.DATE, SimpleType.STRING}));
            cRowTypes.put(GaugeInfo.GaugeType.BANDWIDTH, new CompositeType("Bandwidth", "Bandwidth Gauge", cRowNames.get((Object)GaugeInfo.GaugeType.BANDWIDTH), cRowDesc.get((Object)GaugeInfo.GaugeType.BANDWIDTH), new OpenType[]{SimpleType.STRING, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.DATE, SimpleType.STRING}));
            cRowTypes.put(GaugeInfo.GaugeType.PERFORMANCE, new CompositeType("Performance", "Performance Gauge", cRowNames.get((Object)GaugeInfo.GaugeType.PERFORMANCE), cRowDesc.get((Object)GaugeInfo.GaugeType.PERFORMANCE), new OpenType[]{SimpleType.STRING, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.DATE, SimpleType.STRING}));
            cTabularTypes.put(GaugeInfo.GaugeType.MEASURER, new TabularType("Measurer Table", "Measurer Table", cRowTypes.get((Object)GaugeInfo.GaugeType.MEASURER), new String[]{cRowNames.get((Object)GaugeInfo.GaugeType.MEASURER)[0]}));
            cTabularTypes.put(GaugeInfo.GaugeType.COUNTER, new TabularType("Counter Table", "Counter Table", cRowTypes.get((Object)GaugeInfo.GaugeType.COUNTER), new String[]{cRowNames.get((Object)GaugeInfo.GaugeType.COUNTER)[0]}));
            cTabularTypes.put(GaugeInfo.GaugeType.BANDWIDTH, new TabularType("Bandwidth Table", "Bandwidth Table", cRowTypes.get((Object)GaugeInfo.GaugeType.BANDWIDTH), new String[]{cRowNames.get((Object)GaugeInfo.GaugeType.BANDWIDTH)[0]}));
            cTabularTypes.put(GaugeInfo.GaugeType.PERFORMANCE, new TabularType("Performance Table", "Performance Table", cRowTypes.get((Object)GaugeInfo.GaugeType.PERFORMANCE), new String[]{cRowNames.get((Object)GaugeInfo.GaugeType.PERFORMANCE)[0]}));
        }
        catch (OpenDataException e) {
            e.printStackTrace();
        }
    }
}

