/*
 * Decompiled with CFR 0.152.
 */
package com.fxcm.util.jmx.impl;

import com.fxcm.util.concurrent.lmax.DaemonThreadFactory;
import com.fxcm.util.concurrent.lmax.DisruptorUtils;
import com.fxcm.util.jmx.GaugeInfo;
import com.fxcm.util.jmx.IConsole;
import com.fxcm.util.jmx.IMBeanPod;
import com.fxcm.util.jmx.impl.GenericGaugeDatabase;
import com.fxcm.util.jmx.impl.GenericMBean;
import com.fxcm.util.jmx.impl.IMBean;
import com.fxcm.util.jmx.impl.StatisticEvent;
import com.lmax.disruptor.BlockingWaitStrategy;
import com.lmax.disruptor.EventFactory;
import com.lmax.disruptor.ExceptionHandler;
import com.lmax.disruptor.InsufficientCapacityException;
import com.lmax.disruptor.Sequence;
import com.lmax.disruptor.SequenceReportingEventHandler;
import com.lmax.disruptor.WaitStrategy;
import com.lmax.disruptor.dsl.Disruptor;
import com.lmax.disruptor.dsl.ProducerType;
import java.lang.management.ManagementFactory;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ThreadFactory;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DisruptorBeanPod
implements IMBeanPod {
    Log mLogger = LogFactory.getLog(DisruptorBeanPod.class.getName());
    protected int mHeapSize = 65536;
    protected boolean mEnabled = true;
    protected IMBean mMBean = null;
    protected Disruptor<StatisticEvent> mDisruptor = null;
    protected GenericGaugeDatabase mGaugeDatabase = null;
    protected Map<String, GaugeInfo> mGaugeInfos = null;

    public DisruptorBeanPod() {
        ProducerType test = ProducerType.MULTI;
    }

    @Override
    public void resetOnRead(String attribute, Boolean flag) {
        GaugeInfo info = this.mGaugeInfos.get(attribute);
        if (info != null) {
            info.setResetOnRead(flag);
        }
    }

    @Override
    public boolean isEnabled() {
        return this.mMBean != null && this.mEnabled;
    }

    @Override
    public void setHeapSize(int aHeapSize) {
        this.mHeapSize = DisruptorUtils.normalizeRingSize((int)aHeapSize);
    }

    @Override
    public boolean init(List<GaugeInfo> gaugeInfos, ObjectName name, String aDescription, IConsole console) {
        boolean ret = false;
        try {
            this.mGaugeDatabase = new GenericGaugeDatabase(gaugeInfos);
            MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
            this.mMBean = new GenericMBean();
            this.mMBean.setGaugeDatabase(this.mGaugeDatabase);
            this.mMBean.setConsole(console);
            this.mMBean.setMBeanPod(this);
            this.mGaugeInfos = new HashMap<String, GaugeInfo>();
            for (GaugeInfo info : gaugeInfos) {
                this.mGaugeInfos.put(info.getStatisticEventKey(), info);
            }
            this.mMBean.setGaugeInfo(gaugeInfos);
            mbs.registerMBean(this.mMBean, name);
            this.mDisruptor = new Disruptor((EventFactory)new StatisticEventFactory(), this.mHeapSize, (ThreadFactory)new DaemonThreadFactory(name + "-"), ProducerType.MULTI, (WaitStrategy)new BlockingWaitStrategy());
            this.mDisruptor.setDefaultExceptionHandler(new ExceptionHandlerWrapper(this));
            this.mDisruptor.handleEventsWith(new com.lmax.disruptor.EventHandler[]{new EventHandler(this)});
            this.mLogger.debug(name + " initated Statistic disruptor with ringbuffer size {}..." + this.mDisruptor.getRingBuffer().getBufferSize());
            ret = true;
        }
        catch (Exception e) {
            this.mLogger.error("Failed to init JMX", e);
            ret = false;
        }
        if (!ret) {
            this.mMBean = null;
        }
        return ret;
    }

    @Override
    public void start() {
        if (this.mMBean != null) {
            this.mDisruptor.start();
        }
    }

    @Override
    public void stop() {
        if (this.mMBean != null) {
            Disruptor<StatisticEvent> temp = this.mDisruptor;
            this.mDisruptor = null;
            if (temp != null) {
                temp.shutdown();
            }
        }
    }

    @Override
    public void collectStatistics() {
        if (this.mMBean != null) {
            try {
                long seq = this.mDisruptor.getRingBuffer().tryNext();
                StatisticEvent event = (StatisticEvent)this.mDisruptor.get(seq);
                event.fill(StatisticEvent.Kind.IDLE, null, null, null, null, null);
                this.mDisruptor.getRingBuffer().publish(seq);
            }
            catch (InsufficientCapacityException ex) {
                this.mLogger.error("JMX.InsufficientCapacityException. Skip Event");
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
    }

    @Override
    public void registerStatisticEvent(String key, String subkey, String subkey2, Long data, String ref) {
        GaugeInfo info;
        if (this.mMBean != null && this.mEnabled && (info = this.mGaugeInfos.get(key)) != null && info.isEnabled()) {
            try {
                long seq = this.mDisruptor.getRingBuffer().tryNext();
                StatisticEvent event = (StatisticEvent)this.mDisruptor.get(seq);
                event.fill(StatisticEvent.Kind.STATISTIC, key, subkey, subkey2, data, ref);
                this.mDisruptor.getRingBuffer().publish(seq);
            }
            catch (InsufficientCapacityException ex) {
                this.mLogger.error("JMX.InsufficientCapacityException. Skip Event");
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
    }

    @Override
    public void registerNotificationEvent(String type, String message) {
        if (this.mMBean != null) {
            try {
                long seq = this.mDisruptor.getRingBuffer().tryNext();
                StatisticEvent event = (StatisticEvent)this.mDisruptor.get(seq);
                event.fill(StatisticEvent.Kind.NOTIFICATION, null, type, null, 0L, message);
                this.mDisruptor.getRingBuffer().publish(seq);
            }
            catch (InsufficientCapacityException ex) {
                this.mLogger.error("JMX.InsufficientCapacityException. Skip Event");
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
    }

    @Override
    public void enable(String attribute, Boolean flag) {
        if (attribute == null || attribute.length() == 0 || "all".equalsIgnoreCase(attribute)) {
            this.mEnabled = flag;
        } else {
            GaugeInfo info = this.mGaugeInfos.get(attribute);
            if (info != null) {
                info.setEnabled(flag);
            }
        }
    }

    public class EventHandler
    implements SequenceReportingEventHandler<StatisticEvent> {
        private static final int NOTIFY_PROGRESS_THRESHOLD = 50;
        private Sequence mSequenceCallback;
        private int counter;
        DisruptorBeanPod mPod = null;

        public EventHandler(DisruptorBeanPod aPod) {
            this.mPod = aPod;
        }

        public void setSequenceCallback(Sequence sequenceCallback) {
            this.mSequenceCallback = sequenceCallback;
        }

        public void onEvent(StatisticEvent event, long sequence, boolean endOfBatch) throws Exception {
            if (event.getKind() == StatisticEvent.Kind.IDLE) {
                DisruptorBeanPod.this.mGaugeDatabase.idle();
            } else if (event.getKind() == StatisticEvent.Kind.NOTIFICATION) {
                DisruptorBeanPod.this.mMBean.sos(event.getSubkey(), event.getInfo());
            } else if (event.getKind() == StatisticEvent.Kind.STATISTIC) {
                DisruptorBeanPod.this.mGaugeDatabase.register(event);
            }
            event.clear();
            if (this.mSequenceCallback != null && ++this.counter > 50) {
                this.mSequenceCallback.set(sequence);
                this.counter = 0;
            }
        }
    }

    private class ExceptionHandlerWrapper<T>
    implements ExceptionHandler<T> {
        DisruptorBeanPod mPod = null;

        public ExceptionHandlerWrapper(DisruptorBeanPod aPod) {
            this.mPod = aPod;
        }

        public void handleEventException(Throwable thrwbl, long l, T o) {
            this.mPod.mLogger.error("JMXEventException", thrwbl);
        }

        public void handleOnStartException(Throwable thrwbl) {
            this.mPod.mLogger.error("JMXStartException", thrwbl);
        }

        public void handleOnShutdownException(Throwable thrwbl) {
            this.mPod.mLogger.error("JMXShutdownException", thrwbl);
        }
    }

    private class StatisticEventFactory
    implements EventFactory<StatisticEvent> {
        private StatisticEventFactory() {
        }

        public StatisticEvent newInstance() {
            return new StatisticEvent(StatisticEvent.Kind.NONE, null, null, null, null, null);
        }
    }
}

