/*
 * Decompiled with CFR 0.152.
 */
package com.fxcm.util.jmx;

import com.fxcm.util.jmx.IMBeanPod;
import com.fxcm.util.jmx.impl.DisruptorBeanPod;
import com.fxcm.util.jmx.impl.GenericBeanPod;
import java.util.ArrayList;
import java.util.List;

public class MBeanPodFactory {
    private static MBeanPodFactoryRunner cRunner = new MBeanPodFactoryRunner();

    private MBeanPodFactory() {
    }

    public static IMBeanPod createDefaultInstance() {
        IMBeanPod ret = null;
        try {
            ret = new DisruptorBeanPod();
        }
        catch (NoClassDefFoundError e) {
            ret = new GenericBeanPod();
        }
        cRunner.add(ret);
        return ret;
    }

    public static void addCollector(IMBeanPod pod) {
        cRunner.add(pod);
    }

    private static class MBeanPodFactoryRunner
    implements Runnable {
        private Thread mOwner = null;
        private boolean mStop = false;
        private final List<IMBeanPod> mPods = new ArrayList<IMBeanPod>();
        private Boolean mWait = new Boolean(false);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void add(IMBeanPod pod) {
            List<IMBeanPod> list = this.mPods;
            synchronized (list) {
                if (!this.mPods.contains(pod)) {
                    this.mPods.add(pod);
                }
            }
            this.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void stop() {
            this.mStop = true;
            Boolean bl = this.mWait;
            synchronized (bl) {
                this.mWait.notifyAll();
            }
        }

        public synchronized void start() {
            if (this.mOwner == null) {
                this.mOwner = new Thread((Runnable)this, "MBeanPodFactoryRunner");
                this.mOwner.setDaemon(true);
                this.mOwner.start();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!this.mStop) {
                try {
                    Object object = this.mWait;
                    synchronized (object) {
                        this.mWait.wait(1000L);
                    }
                    object = this.mPods;
                    synchronized (object) {
                        for (IMBeanPod pod : this.mPods) {
                            pod.collectStatistics();
                        }
                    }
                }
                catch (ThreadDeath td) {
                    throw td;
                }
                catch (InterruptedException interruptedException) {
                }
                catch (Throwable throwable) {
                }
            }
        }
    }
}

