/*
 * Decompiled with CFR 0.152.
 */
package com.fxcm.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Util {
    public static InputStream getFileAsStream(String aFileName) throws Exception {
        if (aFileName == null) {
            throw new Exception("Filename parameter is null");
        }
        String f = aFileName.trim();
        File mFile = new File(f);
        InputStream ret = mFile.exists() ? new FileInputStream(mFile) : Thread.currentThread().getContextClassLoader().getResourceAsStream(f);
        return ret;
    }

    public static Object callMethodOnObject(Object aObject, String aMethod, Class[] aMethodParams, Object[] aMethodArgs) throws Exception {
        Method method = aObject.getClass().getMethod(aMethod, aMethodParams);
        return method.invoke(aObject, aMethodArgs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getCurrentlyExecutingMethod() {
        if (Double.parseDouble(System.getProperty("java.specification.version")) >= 1.4) {
            try {
                StackTraceElement stackTraceElement = new Exception().getStackTrace()[1];
                return stackTraceElement.getClassName() + "." + stackTraceElement.getMethodName() + "()";
            }
            catch (Exception e) {
                return null;
            }
        }
        StringWriter sw = new StringWriter();
        try (PrintWriter pw = null;){
            pw = new PrintWriter(sw);
            new Exception().printStackTrace(pw);
            String input = sw.getBuffer().toString();
            StringTokenizer tok = new StringTokenizer(input, "\n");
            tok.nextToken();
            tok.nextToken();
            String line = tok.nextToken();
            int paren = line.indexOf(40);
            line = line.substring(0, paren);
            int at = line.indexOf("at");
            line = line.substring(at + 3);
            String string = line + "()";
            return string;
        }
    }

    public static Properties loadProperties(String aFileName) throws Exception {
        boolean found;
        if (aFileName == null) {
            throw new Exception("Filename parameter is null");
        }
        String f = aFileName.trim();
        InputStream is = Util.getFileAsStream(f);
        if (is == null) {
            throw new Exception("Could not open stream to file: " + f);
        }
        Properties ret = new Properties();
        ret.load(is);
        block0: do {
            found = false;
            Enumeration<Object> en = ret.keys();
            while (en.hasMoreElements()) {
                String key = (String)en.nextElement();
                if (!key.startsWith("include.file")) continue;
                found = true;
                Properties subRet = Util.loadProperties((String)ret.get(key));
                if (subRet != null) {
                    Enumeration<Object> sub = subRet.keys();
                    while (sub.hasMoreElements()) {
                        String subKey = (String)sub.nextElement();
                        if (ret.containsKey(subKey)) continue;
                        ret.put(subKey, subRet.get(subKey));
                    }
                }
                ret.remove(key);
                continue block0;
            }
        } while (found);
        is.close();
        return ret;
    }

    public static Vector split(String aStr, String aDelim) {
        Vector<String> v = new Vector<String>();
        if (aStr != null && aDelim != null) {
            StringBuffer sb = new StringBuffer("");
            char del = aDelim.charAt(0);
            for (int i = 0; i < aStr.length(); ++i) {
                char ch = aStr.charAt(i);
                if (ch == del) {
                    if (i == 0) continue;
                    v.addElement(sb.toString());
                    sb.delete(0, sb.length());
                    continue;
                }
                sb.append(ch);
                if (i != aStr.length() - 1) continue;
                v.addElement(sb.toString());
                sb.delete(0, sb.length());
                break;
            }
        }
        return v;
    }

    public static String[] splitToArray(String aStr, String aDelim) {
        Vector v = Util.split(aStr, aDelim);
        Object[] ret = new String[v.size()];
        v.copyInto(ret);
        return ret;
    }

    public static Log getLog(Class aClazz) {
        return LogFactory.getLog(aClazz);
    }

    public static Log getLog(String aLogName) {
        return LogFactory.getLog(aLogName);
    }

    public static Map parseParams(String aParams) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (aParams != null) {
            String[] lines = Util.splitToArray(aParams, "\n");
            for (int i = 0; i < lines.length; ++i) {
                String[] tokens = Util.splitToArray(lines[i], ";");
                for (int j = 0; j < tokens.length; ++j) {
                    String token = tokens[j];
                    String[] keyvalue = Util.splitToArray(token, "=");
                    if (keyvalue.length != 2) continue;
                    String key = keyvalue[0];
                    String value = keyvalue[1];
                    if (key == null || value == null) continue;
                    map.put(key, value);
                }
            }
        }
        return map;
    }

    public static String parseParams(Map aMap) {
        StringBuffer buffer = new StringBuffer();
        if (aMap != null) {
            Object[] objects = aMap.keySet().toArray();
            for (int i = 0; i < objects.length; ++i) {
                Object key = objects[i];
                buffer.append(key).append("=").append(aMap.get(key));
                if (i >= objects.length - 1) continue;
                buffer.append(";");
            }
        }
        return buffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getStackTraceAsString(Exception aException) {
        String ret;
        if (aException == null) {
            return "";
        }
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        try {
            pw.print(" [ ");
            pw.print(aException.getClass().getName());
            pw.print(" ] ");
            pw.print(aException.getMessage());
            aException.printStackTrace(pw);
            ret = sw.toString();
        }
        finally {
            try {
                pw.close();
                sw.close();
            }
            catch (Exception exception) {}
        }
        return ret;
    }

    public static boolean isEmpty(String aStr) {
        return aStr == null || aStr.trim().length() == 0;
    }

    public static boolean isBlank(String aStr) {
        int strLen;
        if (aStr == null || (strLen = aStr.length()) == 0) {
            return true;
        }
        for (int i = 0; i < strLen; ++i) {
            if (Character.isWhitespace(aStr.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static String getProjectVersion(Class clz) {
        return Util.getManifestValue(clz, "Project-Version");
    }

    public static String getManifestValue(Class clz, String name) {
        String ret = null;
        try {
            URL url = clz.getProtectionDomain().getCodeSource().getLocation();
            JarFile jarFile = new JarFile(url.getFile());
            Manifest manifest = jarFile.getManifest();
            ret = manifest.getMainAttributes().getValue(name);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ret;
    }

    public static void clearConsole() {
        try {
            if (System.getProperty("os.name").contains("Windows")) {
                new ProcessBuilder("cmd", "/c", "cls").inheritIO().start().waitFor();
            } else {
                Runtime.getRuntime().exec("clear");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static String avoidEmpty(String aStr, String aDefault) {
        return Util.isEmpty(aStr) ? aDefault : aStr;
    }

    public static String getJarVersion(String clzName) {
        String ret = "n/a";
        try {
            ret = Util.getJarVersion(Class.forName(clzName));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ret;
    }

    public static String getJarVersion(Class clz) {
        Object ret = clz.getPackage().getImplementationVersion();
        String prjVersion = Util.getProjectVersion(clz);
        if (prjVersion != null) {
            ret = (String)ret + " (" + prjVersion + ")";
        }
        return ret;
    }
}

