/*
 * Decompiled with CFR 0.152.
 */
package com.fxcm.util;

import com.fxcm.util.IDateTimeFormatter;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public class DateTimeFormatterMs
implements IDateTimeFormatter {
    public static final int FIX_OTHER_FORMAT = 0;
    public static final int FIX_TIMEONLY_FORMAT = 1;
    public static final int FIX_DATEONLY_FORMAT = 2;
    public static final int FIX_TIMESTAMP_FORMAT = 3;
    public static final int FIX_TIMEONLY_FORMAT_NMS = 4;
    public static final int FIX_TIMESTAMP_FORMAT_NMS = 5;
    public static final int DAS_FORMAT_MS = 6;
    public static final int DAS_FORMAT_NMS = 7;
    public static final int WS_FORMAT_MS = 8;
    public static final int WS_FORMAT_NMS = 9;
    public static final String DAS_PATTERN_MS = "ddMMyyyyHHmmssSSS";
    public static final String DAS_PATTERN_NMS = "ddMMyyyyHHmmss";
    public static final String WS_PATTERN_MS = "MM/dd/yyyy HH:mm:ss.SSS";
    public static final String WS_PATTERN_NMS = "MM/dd/yyyy HH:mm:ss";
    public static final String FIX_TIMEONLY_PATTERN_NMS = "HH:mm:ss";
    public static final String FIX_TIMEONLY_PATTERN = "HH:mm:ss.SSS";
    public static final String FIX_DATEONLY_PATTERN = "yyyyMMdd";
    public static final String FIX_TIMESTAMP_PATTERN = "yyyyMMdd-HH:mm:ss.SSS";
    public static final String FIX_TIMESTAMP_PATTERN_NMS = "yyyyMMdd-HH:mm:ss";
    public static final String ZERO = "0";
    private static final String EMPTY_DATE_CH = "00000000000000";
    private static final String EMPTY_DATE_PH = "00000000000000000";
    private String mSelectedPattern;
    private int mSelectedFormat;
    private Calendar mCalendar;
    private static TimeZone cUTCTimeZone = TimeZone.getTimeZone("UTC");
    private static final Calendar _cUTCCalendar = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
    private static final Calendar _cDefaultCalendar = Calendar.getInstance();
    private static final ThreadLocal<Calendar> cDefaultCalendar = ThreadLocal.withInitial(() -> (Calendar)_cDefaultCalendar.clone());
    private static final ThreadLocal<Calendar> cUTCCalendar = ThreadLocal.withInitial(() -> (Calendar)_cUTCCalendar.clone());
    private static final ThreadLocal<StringBuilder> cStringBuilder = new ThreadLocal<StringBuilder>(){

        @Override
        protected StringBuilder initialValue() {
            return new StringBuilder();
        }

        @Override
        public StringBuilder get() {
            StringBuilder ret = (StringBuilder)super.get();
            if (ret.length() > 0) {
                ret.setLength(0);
            }
            return ret;
        }
    };

    public DateTimeFormatterMs(int aFormat) throws Exception {
        this(aFormat, null);
    }

    public DateTimeFormatterMs(int aFormat, Calendar aCalendar) throws Exception {
        this.mCalendar = aCalendar;
        if (this.mCalendar == null) {
            this.mCalendar = cDefaultCalendar.get();
        }
        switch (aFormat) {
            case 1: {
                this.mSelectedFormat = aFormat;
                this.mSelectedPattern = FIX_TIMEONLY_PATTERN;
                break;
            }
            case 2: {
                this.mSelectedFormat = aFormat;
                this.mSelectedPattern = FIX_DATEONLY_PATTERN;
                break;
            }
            case 3: {
                this.mSelectedFormat = aFormat;
                this.mSelectedPattern = FIX_TIMESTAMP_PATTERN;
                break;
            }
            case 4: {
                this.mSelectedFormat = aFormat;
                this.mSelectedPattern = FIX_TIMEONLY_PATTERN_NMS;
                break;
            }
            case 5: {
                this.mSelectedFormat = aFormat;
                this.mSelectedPattern = FIX_TIMESTAMP_PATTERN_NMS;
                break;
            }
            case 7: {
                this.mSelectedFormat = aFormat;
                this.mSelectedPattern = DAS_PATTERN_NMS;
                break;
            }
            case 6: {
                this.mSelectedFormat = aFormat;
                this.mSelectedPattern = DAS_PATTERN_MS;
                break;
            }
            case 9: {
                this.mSelectedFormat = aFormat;
                this.mSelectedPattern = WS_PATTERN_NMS;
                break;
            }
            case 8: {
                this.mSelectedFormat = aFormat;
                this.mSelectedPattern = WS_PATTERN_MS;
                break;
            }
            default: {
                throw new Exception("Invalid format.  To specify custom format use init (String pattern)");
            }
        }
    }

    public DateTimeFormatterMs(String aPattern) throws Exception {
        this(aPattern, null);
    }

    public DateTimeFormatterMs(String aPattern, Calendar aCalendar) throws Exception {
        this.mCalendar = aCalendar;
        if (this.mCalendar == null) {
            this.mCalendar = cDefaultCalendar.get();
        }
        if (aPattern.equals(FIX_TIMEONLY_PATTERN)) {
            this.mSelectedFormat = 1;
            this.mSelectedPattern = FIX_TIMEONLY_PATTERN;
        } else if (aPattern.equals(FIX_DATEONLY_PATTERN)) {
            this.mSelectedFormat = 2;
            this.mSelectedPattern = FIX_DATEONLY_PATTERN;
        } else if (aPattern.equals(FIX_TIMESTAMP_PATTERN)) {
            this.mSelectedFormat = 3;
            this.mSelectedPattern = FIX_TIMESTAMP_PATTERN;
        } else if (aPattern.equals(FIX_TIMEONLY_PATTERN_NMS)) {
            this.mSelectedFormat = 4;
            this.mSelectedPattern = FIX_TIMEONLY_PATTERN_NMS;
        } else if (aPattern.equals(FIX_TIMESTAMP_PATTERN_NMS)) {
            this.mSelectedFormat = 5;
            this.mSelectedPattern = FIX_TIMESTAMP_PATTERN_NMS;
        } else if (aPattern.equals(DAS_PATTERN_NMS)) {
            this.mSelectedFormat = 7;
            this.mSelectedPattern = DAS_PATTERN_NMS;
        } else if (aPattern.equals(DAS_PATTERN_MS)) {
            this.mSelectedFormat = 6;
            this.mSelectedPattern = DAS_PATTERN_MS;
        } else if (aPattern.equals(WS_PATTERN_NMS)) {
            this.mSelectedFormat = 9;
            this.mSelectedPattern = WS_PATTERN_NMS;
        } else if (aPattern.equals(WS_PATTERN_MS)) {
            this.mSelectedFormat = 8;
            this.mSelectedPattern = WS_PATTERN_MS;
        } else {
            try {
                new SimpleDateFormat(aPattern);
                this.mSelectedFormat = 0;
                this.mSelectedPattern = aPattern;
            }
            catch (Exception e) {
                throw new Exception("Invalid pattern specified: " + aPattern);
            }
        }
    }

    private static Calendar getDefaultCalendar() {
        return cDefaultCalendar.get();
    }

    private static Calendar getUTCCalendar() {
        return cUTCCalendar.get();
    }

    public Calendar getCalendar() {
        return this.mCalendar;
    }

    public int getFormatAsInt() {
        return this.mSelectedFormat;
    }

    @Override
    public String getFormatAsString() {
        return this.mSelectedPattern;
    }

    public Date parse(String aDate) throws ParseException {
        Date ret = null;
        switch (this.getFormatAsInt()) {
            case 0: {
                ret = this.parseOther(aDate, this.mCalendar);
                break;
            }
            default: {
                ret = new Date(this.parseInMillis(aDate));
            }
        }
        return ret;
    }

    public long parseInMillis(String aDate) throws ParseException {
        long ret = 0L;
        switch (this.getFormatAsInt()) {
            case 2: {
                ret = DateTimeFormatterMs.parseDateInMillis(aDate, this.mCalendar);
                break;
            }
            case 1: {
                ret = DateTimeFormatterMs.parseTimeInMillis(aDate, this.mCalendar, true);
                break;
            }
            case 4: {
                ret = DateTimeFormatterMs.parseTimeInMillis(aDate, this.mCalendar, false);
                break;
            }
            case 3: {
                ret = DateTimeFormatterMs.parseDateTimeInMillis(aDate, this.mCalendar, true);
                break;
            }
            case 5: {
                ret = DateTimeFormatterMs.parseDateTimeInMillis(aDate, this.mCalendar, false);
                break;
            }
            case 7: {
                ret = DateTimeFormatterMs.parseDasDateInMillis(aDate, this.mCalendar, false);
                break;
            }
            case 6: {
                ret = DateTimeFormatterMs.parseDasDateInMillis(aDate, this.mCalendar, false);
                break;
            }
            case 9: {
                ret = DateTimeFormatterMs.parseWsDateInMillis(aDate, this.mCalendar, false);
                break;
            }
            case 8: {
                ret = DateTimeFormatterMs.parseWsDateInMillis(aDate, this.mCalendar, true);
                break;
            }
            case 0: {
                ret = this.parseOther(aDate, this.mCalendar).getTime();
            }
        }
        return ret;
    }

    @Override
    public Date parseUTC(String aDate) throws ParseException {
        Date ret = null;
        switch (this.getFormatAsInt()) {
            case 0: {
                ret = this.parseOther(aDate, DateTimeFormatterMs.getUTCCalendar());
                break;
            }
            default: {
                ret = new Date(this.parseUTCInMillis(aDate));
            }
        }
        return ret;
    }

    @Override
    public long parseUTCInMillis(String aDate) throws ParseException {
        long ret = 0L;
        switch (this.getFormatAsInt()) {
            case 2: {
                ret = DateTimeFormatterMs.parseDateInMillis(aDate, DateTimeFormatterMs.getUTCCalendar());
                break;
            }
            case 1: {
                ret = DateTimeFormatterMs.parseTimeInMillis(aDate, DateTimeFormatterMs.getUTCCalendar(), true);
                break;
            }
            case 4: {
                ret = DateTimeFormatterMs.parseTimeInMillis(aDate, DateTimeFormatterMs.getUTCCalendar(), false);
                break;
            }
            case 3: {
                ret = DateTimeFormatterMs.parseDateTimeInMillis(aDate, DateTimeFormatterMs.getUTCCalendar(), true);
                break;
            }
            case 5: {
                ret = DateTimeFormatterMs.parseDateTimeInMillis(aDate, DateTimeFormatterMs.getUTCCalendar(), false);
                break;
            }
            case 7: {
                ret = DateTimeFormatterMs.parseDasDateInMillis(aDate, DateTimeFormatterMs.getUTCCalendar(), false);
                break;
            }
            case 6: {
                ret = DateTimeFormatterMs.parseDasDateInMillis(aDate, DateTimeFormatterMs.getUTCCalendar(), false);
                break;
            }
            case 9: {
                ret = DateTimeFormatterMs.parseWsDateInMillis(aDate, DateTimeFormatterMs.getUTCCalendar(), false);
                break;
            }
            case 8: {
                ret = DateTimeFormatterMs.parseWsDateInMillis(aDate, DateTimeFormatterMs.getUTCCalendar(), true);
            }
            case 0: {
                ret = this.parseOther(aDate, DateTimeFormatterMs.getUTCCalendar()).getTime();
            }
        }
        return ret;
    }

    public String format(Date aDate) throws ParseException {
        String ret = null;
        switch (this.getFormatAsInt()) {
            case 0: {
                ret = this.formatOther(aDate, this.mCalendar);
                break;
            }
            default: {
                ret = this.formatInMillis(aDate.getTime());
            }
        }
        return ret;
    }

    public String formatInMillis(long aDate) throws ParseException {
        String ret = null;
        switch (this.getFormatAsInt()) {
            case 2: {
                ret = this.formatDateInMillis(aDate, this.mCalendar);
                break;
            }
            case 1: {
                ret = DateTimeFormatterMs.formatTimeInMillis(aDate, this.mCalendar, true);
                break;
            }
            case 4: {
                ret = DateTimeFormatterMs.formatTimeInMillis(aDate, this.mCalendar, false);
                break;
            }
            case 3: {
                ret = DateTimeFormatterMs.formatDateTimeInMillis(aDate, this.mCalendar, true);
                break;
            }
            case 5: {
                ret = DateTimeFormatterMs.formatDateTimeInMillis(aDate, this.mCalendar, false);
                break;
            }
            case 7: {
                ret = DateTimeFormatterMs.formatDASDateInSec(aDate, this.mCalendar, false);
                break;
            }
            case 6: {
                ret = DateTimeFormatterMs.formatDASDateInMillis(aDate, this.mCalendar, false);
                break;
            }
            case 9: {
                ret = DateTimeFormatterMs.formatWsDateInMillis(aDate, this.mCalendar, false);
                break;
            }
            case 8: {
                ret = DateTimeFormatterMs.formatWsDateInMillis(aDate, this.mCalendar, true);
                break;
            }
            case 0: {
                ret = this.formatOther(new Date(aDate), this.mCalendar);
            }
        }
        return ret;
    }

    @Override
    public String formatUTC(Date aDate) throws ParseException {
        String ret = null;
        switch (this.getFormatAsInt()) {
            case 0: {
                ret = this.formatOther(aDate, DateTimeFormatterMs.getUTCCalendar());
                break;
            }
            default: {
                ret = this.formatUTCInMillis(aDate.getTime());
            }
        }
        return ret;
    }

    @Override
    public String formatUTCInMillis(long aDate) throws ParseException {
        String ret = null;
        switch (this.getFormatAsInt()) {
            case 2: {
                ret = this.formatDateInMillis(aDate, DateTimeFormatterMs.getUTCCalendar());
                break;
            }
            case 1: {
                ret = DateTimeFormatterMs.formatTimeInMillis(aDate, DateTimeFormatterMs.getUTCCalendar(), true);
                break;
            }
            case 4: {
                ret = DateTimeFormatterMs.formatTimeInMillis(aDate, DateTimeFormatterMs.getUTCCalendar(), false);
                break;
            }
            case 3: {
                ret = DateTimeFormatterMs.formatDateTimeInMillis(aDate, DateTimeFormatterMs.getUTCCalendar(), true);
                break;
            }
            case 5: {
                ret = DateTimeFormatterMs.formatDateTimeInMillis(aDate, DateTimeFormatterMs.getUTCCalendar(), false);
                break;
            }
            case 7: {
                ret = DateTimeFormatterMs.formatDASDateInSec(aDate, DateTimeFormatterMs.getUTCCalendar(), false);
                break;
            }
            case 6: {
                ret = DateTimeFormatterMs.formatDASDateInMillis(aDate, DateTimeFormatterMs.getUTCCalendar(), false);
                break;
            }
            case 9: {
                ret = DateTimeFormatterMs.formatWsDateInMillis(aDate, DateTimeFormatterMs.getUTCCalendar(), false);
                break;
            }
            case 8: {
                ret = DateTimeFormatterMs.formatWsDateInMillis(aDate, DateTimeFormatterMs.getUTCCalendar(), true);
                break;
            }
            case 0: {
                ret = this.formatOther(new Date(aDate), DateTimeFormatterMs.getUTCCalendar());
            }
        }
        return ret;
    }

    public static Date convertDBStringToDate(String date, boolean isTick) {
        return DateTimeFormatterMs.convertDBStringToDate(date, isTick, DateTimeFormatterMs.getDefaultCalendar(), false);
    }

    public static Date convertDBStringToDateUTC(String date, boolean isTick) {
        return DateTimeFormatterMs.convertDBStringToDate(date, isTick, DateTimeFormatterMs.getUTCCalendar(), false);
    }

    public static String convertDBDateToString(Date date, boolean isTick) {
        return DateTimeFormatterMs.convertDBDateToString(date, isTick, DateTimeFormatterMs.getDefaultCalendar(), false);
    }

    public static String convertDBDateToStringUTC(Date date, boolean isTick) {
        return DateTimeFormatterMs.convertDBDateToString(date, isTick, DateTimeFormatterMs.getUTCCalendar(), false);
    }

    public static String convertDBDateToStringUTC(long date, boolean isTick) {
        return DateTimeFormatterMs.convertDBDateToString(date, isTick, DateTimeFormatterMs.getUTCCalendar(), false);
    }

    private static long parseDateInMillis(String aDate, Calendar aCalendar) throws ParseException {
        int year = 0;
        int month = 0;
        int day = 0;
        try {
            char[] buffer = new char[8];
            aDate.getChars(0, aDate.length() > 8 ? 9 : aDate.length(), buffer, 0);
            year = DateTimeFormatterMs.parse4(buffer, 0);
            month = DateTimeFormatterMs.parse2(buffer, 4);
            day = DateTimeFormatterMs.parse2(buffer, 6);
        }
        catch (Exception e) {
            throw new ParseException("Unable to parse Date: " + aDate, 0);
        }
        Calendar cal = aCalendar;
        cal.clear();
        cal.set(1, year);
        cal.set(2, month - 1);
        cal.set(5, day);
        long dt = cal.getTimeInMillis();
        cal = null;
        return dt;
    }

    private static long parseTimeInMillis(String aDate, Calendar aCalendar, boolean aMillis) throws ParseException {
        int hour = 0;
        int minute = 0;
        int second = 0;
        int msecond = 0;
        try {
            char[] buffer = new char[12];
            aDate.getChars(0, aDate.length() > 12 ? 13 : aDate.length(), buffer, 0);
            hour = DateTimeFormatterMs.parse2(buffer, 0);
            minute = DateTimeFormatterMs.parse2(buffer, 3);
            second = DateTimeFormatterMs.parse2(buffer, 6);
            if (aMillis && aDate.length() >= 12) {
                msecond = DateTimeFormatterMs.parse3(buffer, 9);
            }
        }
        catch (Exception e) {
            throw new ParseException("Unable to parse Time: " + aDate, 0);
        }
        Calendar cal = aCalendar;
        cal.clear();
        cal.setTimeInMillis(System.currentTimeMillis());
        cal.set(11, hour);
        cal.set(12, minute);
        cal.set(13, second);
        cal.set(14, msecond);
        long dt = cal.getTimeInMillis();
        cal = null;
        return dt;
    }

    private static int parse1(char a) throws ParseException {
        int ret = 0;
        ret = a - 48;
        if (ret < 0) {
            ret = 0;
        }
        if (ret > 9) {
            throw new ParseException("Unable to parse '" + a + "'", 0);
        }
        return ret;
    }

    private static int parse2(char[] buffer, int pos) throws ParseException {
        int ret = 0;
        ret = DateTimeFormatterMs.parse1(buffer[pos]) * 10;
        return ret += DateTimeFormatterMs.parse1(buffer[pos + 1]);
    }

    private static int parse3(char[] buffer, int pos) throws ParseException {
        int ret = 0;
        ret = DateTimeFormatterMs.parse1(buffer[pos]) * 100;
        ret += DateTimeFormatterMs.parse1(buffer[pos + 1]) * 10;
        return ret += DateTimeFormatterMs.parse1(buffer[pos + 2]);
    }

    private static int parse4(char[] buffer, int pos) throws ParseException {
        int ret = 0;
        ret = DateTimeFormatterMs.parse1(buffer[pos]) * 1000;
        ret += DateTimeFormatterMs.parse1(buffer[pos + 1]) * 100;
        ret += DateTimeFormatterMs.parse1(buffer[pos + 2]) * 10;
        return ret += DateTimeFormatterMs.parse1(buffer[pos + 3]);
    }

    private static long parseDateTimeInMillis(String aDate, Calendar aCalendar, boolean aMillis) throws ParseException {
        int year = 0;
        int month = 0;
        int day = 0;
        int hour = 0;
        int minute = 0;
        int second = 0;
        int msecond = 0;
        try {
            char[] buffer = new char[21];
            aDate.getChars(0, aDate.length() > 21 ? 21 : aDate.length(), buffer, 0);
            year = DateTimeFormatterMs.parse4(buffer, 0);
            month = DateTimeFormatterMs.parse2(buffer, 4);
            day = DateTimeFormatterMs.parse2(buffer, 6);
            hour = DateTimeFormatterMs.parse2(buffer, 9);
            minute = DateTimeFormatterMs.parse2(buffer, 12);
            second = DateTimeFormatterMs.parse2(buffer, 15);
            if (aMillis && aDate.length() >= 21) {
                msecond = DateTimeFormatterMs.parse3(buffer, 18);
            }
        }
        catch (Exception e) {
            throw new ParseException("Unable to parse Date: " + aDate, 0);
        }
        Calendar cal = aCalendar;
        cal.clear();
        cal.set(year, month - 1, day, hour, minute, second);
        cal.set(14, msecond);
        long dt = cal.getTimeInMillis();
        cal = null;
        return dt;
    }

    private static long parseWsDateInMillis(String aDate, Calendar aCalendar, boolean aMillis) throws ParseException {
        int year = 0;
        int month = 0;
        int day = 0;
        int hour = 0;
        int minute = 0;
        int second = 0;
        int msecond = 0;
        try {
            char[] buffer = new char[21];
            aDate.getChars(0, aDate.length() > 23 ? 23 : aDate.length(), buffer, 0);
            month = DateTimeFormatterMs.parse2(buffer, 0);
            day = DateTimeFormatterMs.parse2(buffer, 3);
            year = DateTimeFormatterMs.parse4(buffer, 6);
            hour = DateTimeFormatterMs.parse2(buffer, 11);
            minute = DateTimeFormatterMs.parse2(buffer, 14);
            second = DateTimeFormatterMs.parse2(buffer, 17);
            if (aMillis && aDate.length() >= 23) {
                msecond = DateTimeFormatterMs.parse3(buffer, 20);
            }
        }
        catch (Exception e) {
            throw new ParseException("Unable to parse Date: " + aDate, 0);
        }
        Calendar cal = aCalendar;
        cal.clear();
        cal.set(year, month - 1, day, hour, minute, second);
        cal.set(14, msecond);
        long dt = cal.getTimeInMillis();
        cal = null;
        return dt;
    }

    private Date parseOther(String aDate, Calendar aCalendar) throws ParseException {
        SimpleDateFormat sdf = new SimpleDateFormat(this.mSelectedPattern);
        sdf.setCalendar(aCalendar);
        Date ret = null;
        try {
            ret = sdf.parse(aDate);
        }
        catch (Exception e) {
            throw new ParseException("Unable to format date: " + aDate, 0);
        }
        sdf = null;
        return ret;
    }

    private static void appendWithLeadingZero(StringBuilder sb, int data) {
        if (data < 10) {
            sb.append('0');
        }
        sb.append(data);
    }

    private static void appendWithLeadingZero2(StringBuilder sb, int data) {
        if (data < 100) {
            sb.append('0');
        }
        if (data < 10) {
            sb.append('0');
        }
        sb.append(data);
    }

    private String formatDateInMillis(long aDate, Calendar aCalendar) {
        StringBuilder sb = cStringBuilder.get();
        Calendar cal = aCalendar;
        cal.setTimeInMillis(aDate);
        sb.append(cal.get(1));
        DateTimeFormatterMs.appendWithLeadingZero(sb, cal.get(2) + 1);
        DateTimeFormatterMs.appendWithLeadingZero(sb, cal.get(5));
        return sb.toString();
    }

    private static String formatTimeInMillis(long aDate, Calendar aCalendar, boolean aMillis) {
        StringBuilder sb = cStringBuilder.get();
        Calendar cal = aCalendar;
        cal.setTimeInMillis(aDate);
        DateTimeFormatterMs.appendWithLeadingZero(sb, cal.get(11));
        sb.append(':');
        DateTimeFormatterMs.appendWithLeadingZero(sb, cal.get(12));
        sb.append(':');
        DateTimeFormatterMs.appendWithLeadingZero(sb, cal.get(13));
        if (aMillis) {
            int imsecond = cal.get(14);
            sb.append('.');
            DateTimeFormatterMs.appendWithLeadingZero2(sb, imsecond);
        }
        return sb.toString();
    }

    private static String formatDateTimeInMillis(long aDate, Calendar aCalendar, boolean aMillis) {
        StringBuilder sb = cStringBuilder.get();
        Calendar cal = aCalendar;
        cal.setTimeInMillis(aDate);
        sb.append(cal.get(1));
        DateTimeFormatterMs.appendWithLeadingZero(sb, cal.get(2) + 1);
        DateTimeFormatterMs.appendWithLeadingZero(sb, cal.get(5));
        sb.append('-');
        DateTimeFormatterMs.appendWithLeadingZero(sb, cal.get(11));
        sb.append(':');
        DateTimeFormatterMs.appendWithLeadingZero(sb, cal.get(12));
        sb.append(':');
        DateTimeFormatterMs.appendWithLeadingZero(sb, cal.get(13));
        if (aMillis) {
            int imsecond = cal.get(14);
            sb.append('.');
            DateTimeFormatterMs.appendWithLeadingZero2(sb, imsecond);
        }
        return sb.toString();
    }

    private static String formatWsDateInMillis(long aDate, Calendar aCalendar, boolean aMillis) {
        StringBuilder sb = cStringBuilder.get();
        Calendar cal = aCalendar;
        cal.setTimeInMillis(aDate);
        DateTimeFormatterMs.appendWithLeadingZero(sb, cal.get(2) + 1);
        sb.append("/");
        DateTimeFormatterMs.appendWithLeadingZero(sb, cal.get(5));
        sb.append("/");
        sb.append(cal.get(1));
        sb.append(" ");
        DateTimeFormatterMs.appendWithLeadingZero(sb, cal.get(11));
        sb.append(':');
        DateTimeFormatterMs.appendWithLeadingZero(sb, cal.get(12));
        sb.append(':');
        DateTimeFormatterMs.appendWithLeadingZero(sb, cal.get(13));
        if (aMillis) {
            int imsecond = cal.get(14);
            sb.append('.');
            DateTimeFormatterMs.appendWithLeadingZero2(sb, imsecond);
        }
        return sb.toString();
    }

    private String formatOther(Date aDate, Calendar aCalendar) throws ParseException {
        SimpleDateFormat sdf = new SimpleDateFormat(this.mSelectedPattern);
        sdf.setCalendar(aCalendar);
        String ret = null;
        try {
            ret = sdf.format(aDate);
        }
        catch (Exception e) {
            throw new ParseException("Unable to format date: " + aDate, 0);
        }
        sdf = null;
        return ret;
    }

    public static Date convertDBStringToDate(String aDate, boolean aIsTick, Calendar aCal) {
        return DateTimeFormatterMs.convertDBStringToDate(aDate, aIsTick, aCal, true);
    }

    public static Date convertDBStringToDate(String aDate, boolean aIsTick, Calendar aCal, boolean aMakeClone) {
        Date ret = null;
        if (aDate.equals(aIsTick ? EMPTY_DATE_PH : EMPTY_DATE_CH)) {
            return ret;
        }
        int year = Integer.parseInt(aDate.substring(0, 4));
        int month = Integer.parseInt(aDate.substring(4, 6));
        int day = Integer.parseInt(aDate.substring(6, 8));
        int hour = Integer.parseInt(aDate.substring(8, 10));
        int minute = Integer.parseInt(aDate.substring(10, 12));
        int second = Integer.parseInt(aDate.substring(12, 14));
        int msecond = 0;
        if (aIsTick) {
            try {
                msecond = Integer.parseInt(aDate.substring(14, 17));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        Calendar cal = aCal;
        if (aMakeClone) {
            cal = (Calendar)cal.clone();
        }
        cal.set(year, month - 1, day, hour, minute, second);
        cal.set(14, msecond);
        ret = cal.getTime();
        return ret;
    }

    public static String convertDBDateToString(Date aDate, boolean aIsTick, Calendar aCal) {
        return DateTimeFormatterMs.convertDBDateToString(aDate, aIsTick, aCal, true);
    }

    public static String convertDBDateToString(Date aDate, boolean aIsTick, Calendar aCal, boolean aMakeClone) {
        String dateAsString;
        String string = dateAsString = aIsTick ? EMPTY_DATE_PH : EMPTY_DATE_CH;
        if (aDate == null) {
            return dateAsString;
        }
        return DateTimeFormatterMs.convertDBDateToString(aDate.getTime(), aIsTick, aCal, aMakeClone);
    }

    public static String convertDBDateToString(long aDate, boolean aIsTick, Calendar aCal, boolean aMakeClone) {
        String dateAsString;
        String string = dateAsString = aIsTick ? EMPTY_DATE_PH : EMPTY_DATE_CH;
        if (aDate == 0L) {
            return dateAsString;
        }
        Calendar cal = aCal;
        if (aMakeClone) {
            cal = (Calendar)cal.clone();
        }
        cal.setTimeInMillis(aDate);
        StringBuilder sb = cStringBuilder.get();
        sb.append(cal.get(1));
        DateTimeFormatterMs.appendWithLeadingZero(sb, cal.get(2) + 1);
        DateTimeFormatterMs.appendWithLeadingZero(sb, cal.get(5));
        DateTimeFormatterMs.appendWithLeadingZero(sb, cal.get(11));
        DateTimeFormatterMs.appendWithLeadingZero(sb, cal.get(12));
        DateTimeFormatterMs.appendWithLeadingZero(sb, cal.get(13));
        if (aIsTick) {
            DateTimeFormatterMs.appendWithLeadingZero2(sb, cal.get(14));
        }
        return sb.toString();
    }

    public static String formatDASDate(Date aDate) {
        return DateTimeFormatterMs.formatDASDate(aDate, null, false);
    }

    public static String formatDASDate(Date aDate, Calendar aCalendar) {
        return DateTimeFormatterMs.formatDASDate(aDate, aCalendar, true);
    }

    public static String formatDASDate(Date aDate, Calendar aCalendar, boolean aMakeClone) {
        return DateTimeFormatterMs.formatDASDateInMillis(aDate == null ? 0L : aDate.getTime(), aCalendar, aMakeClone);
    }

    public static String formatDASDateInMillis(long aDate, Calendar aCalendar, boolean aMakeClone) {
        if (aDate == 0L) {
            return EMPTY_DATE_CH;
        }
        Calendar cal = null;
        if (aCalendar != null) {
            cal = aCalendar;
            if (aMakeClone) {
                cal = (Calendar)cal.clone();
            }
        } else {
            cal = DateTimeFormatterMs.getDefaultCalendar();
        }
        cal.setTimeInMillis(aDate);
        StringBuilder sb = cStringBuilder.get();
        DateTimeFormatterMs.appendWithLeadingZero(sb, cal.get(2) + 1);
        DateTimeFormatterMs.appendWithLeadingZero(sb, cal.get(5));
        sb.append(cal.get(1));
        DateTimeFormatterMs.appendWithLeadingZero(sb, cal.get(11));
        DateTimeFormatterMs.appendWithLeadingZero(sb, cal.get(12));
        DateTimeFormatterMs.appendWithLeadingZero(sb, cal.get(13));
        DateTimeFormatterMs.appendWithLeadingZero2(sb, cal.get(14));
        cal = null;
        return sb.toString();
    }

    public static String formatDASDateInSec(long aDate, Calendar aCalendar, boolean aMakeClone) {
        if (aDate == 0L) {
            return EMPTY_DATE_CH;
        }
        Calendar cal = null;
        if (aCalendar != null) {
            cal = aCalendar;
            if (aMakeClone) {
                cal = (Calendar)cal.clone();
            }
        } else {
            cal = DateTimeFormatterMs.getDefaultCalendar();
        }
        cal.setTimeInMillis(aDate);
        StringBuilder sb = cStringBuilder.get();
        DateTimeFormatterMs.appendWithLeadingZero(sb, cal.get(2) + 1);
        DateTimeFormatterMs.appendWithLeadingZero(sb, cal.get(5));
        sb.append(cal.get(1));
        DateTimeFormatterMs.appendWithLeadingZero(sb, cal.get(11));
        DateTimeFormatterMs.appendWithLeadingZero(sb, cal.get(12));
        DateTimeFormatterMs.appendWithLeadingZero(sb, cal.get(13));
        cal = null;
        return sb.toString();
    }

    public static Date parseDasDate(String aDate) {
        return DateTimeFormatterMs.parseDasDate(aDate, null, false);
    }

    public static Date parseDasDate(String aDate, Calendar aCalendar) {
        return DateTimeFormatterMs.parseDasDate(aDate, aCalendar, true);
    }

    public static Date parseDasDate(String aDate, Calendar aCalendar, boolean aMakeClone) {
        return new Date(DateTimeFormatterMs.parseDasDateInMillis(aDate, aCalendar, aMakeClone));
    }

    public static long parseDasDateInMillis(String aDate, Calendar aCalendar, boolean aMakeClone) {
        long ret = 0L;
        if (aDate != null && aDate.length() > 13) {
            int month = 0;
            int day = 0;
            int year = 0;
            int hour = 0;
            int minute = 0;
            int second = 0;
            int msecond = 0;
            try {
                char[] buffer = new char[21];
                aDate.getChars(0, aDate.length() > 16 ? 17 : aDate.length(), buffer, 0);
                month = DateTimeFormatterMs.parse2(buffer, 0);
                day = DateTimeFormatterMs.parse2(buffer, 2);
                year = DateTimeFormatterMs.parse4(buffer, 4);
                hour = DateTimeFormatterMs.parse2(buffer, 8);
                minute = DateTimeFormatterMs.parse2(buffer, 10);
                second = DateTimeFormatterMs.parse2(buffer, 12);
                msecond = 0;
                if (aDate.length() >= 16) {
                    msecond = DateTimeFormatterMs.parse3(buffer, 14);
                }
            }
            catch (Exception buffer) {
                // empty catch block
            }
            Calendar cal = null;
            if (aCalendar != null) {
                cal = aCalendar;
                if (aMakeClone) {
                    cal = (Calendar)cal.clone();
                }
            } else {
                cal = DateTimeFormatterMs.getDefaultCalendar();
            }
            cal.clear();
            cal.set(2, month - 1);
            cal.set(5, day);
            cal.set(1, year);
            cal.set(11, hour);
            cal.set(12, minute);
            cal.set(13, second);
            cal.set(14, msecond);
            ret = cal.getTimeInMillis();
        }
        return ret;
    }

    public static String formatDefault(Date aDate, String aTimeZone) {
        String year = null;
        Object month = null;
        Object day = null;
        Object hour = null;
        Object minute = null;
        Object second = null;
        Object millisecond = null;
        Calendar cal = Calendar.getInstance(TimeZone.getTimeZone(aTimeZone));
        cal.setTime(aDate);
        year = Integer.toString(cal.get(1));
        month = Integer.toString(cal.get(2) + 1);
        day = Integer.toString(cal.get(5));
        hour = Integer.toString(cal.get(11));
        minute = Integer.toString(cal.get(12));
        second = Integer.toString(cal.get(13));
        millisecond = Integer.toString(cal.get(14));
        cal = null;
        if (((String)month).length() == 1) {
            month = ZERO + (String)month;
        }
        if (((String)day).length() == 1) {
            day = ZERO + (String)day;
        }
        if (((String)hour).length() == 1) {
            hour = ZERO + (String)hour;
        }
        if (((String)minute).length() == 1) {
            minute = ZERO + (String)minute;
        }
        if (((String)second).length() == 1) {
            second = ZERO + (String)second;
        }
        if (((String)millisecond).length() == 1) {
            millisecond = "00" + (String)millisecond;
        } else if (((String)millisecond).length() == 2) {
            millisecond = ZERO + (String)millisecond;
        }
        String datePart = (String)month + "/" + (String)day + "/" + year;
        String timePart = (String)hour + ":" + (String)minute + ":" + (String)second + "." + (String)millisecond;
        String ret = datePart + " " + timePart;
        year = null;
        month = null;
        day = null;
        hour = null;
        minute = null;
        second = null;
        return ret;
    }
}

