/*
 * Decompiled with CFR 0.152.
 */
package com.fxcm.util;

import com.fxcm.util.IDateTimeFormatter;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public class DateTimeFormatter
implements IDateTimeFormatter {
    public static final int FIX_OTHER_FORMAT = 0;
    public static final int FIX_TIMEONLY_FORMAT = 1;
    public static final int FIX_DATEONLY_FORMAT = 2;
    public static final int FIX_TIMESTAMP_FORMAT = 3;
    private static final String FIX_TIMEONLY_PATTERN = "HH:mm:ss";
    private static final String FIX_DATEONLY_PATTERN = "yyyyMMdd";
    private static final String FIX_TIMESTAMP_PATTERN = "yyyyMMdd-HH:mm:ss";
    public static final String ZERO = "0";
    private static final String EMPTY_DATE_CH = "00000000000000";
    private static final String EMPTY_DATE_PH = "00000000000000000";
    private String mSelectedPattern;
    private int mSelectedFormat;
    private static TimeZone cUTCTimeZone = TimeZone.getTimeZone("UTC");
    private static Calendar _cUTCCalendar = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
    private static Calendar _cDefaultCalendar = Calendar.getInstance();
    private static final ThreadLocal<Calendar> cDefaultCalendar = new ThreadLocal<Calendar>(){

        @Override
        protected Calendar initialValue() {
            return (Calendar)_cDefaultCalendar.clone();
        }
    };
    private static final ThreadLocal<Calendar> cUTCCalendar = new ThreadLocal<Calendar>(){

        @Override
        protected Calendar initialValue() {
            return (Calendar)_cUTCCalendar.clone();
        }
    };

    public DateTimeFormatter(int aFormat) throws Exception {
        switch (aFormat) {
            case 1: {
                this.mSelectedFormat = aFormat;
                this.mSelectedPattern = FIX_TIMEONLY_PATTERN;
                break;
            }
            case 2: {
                this.mSelectedFormat = aFormat;
                this.mSelectedPattern = FIX_DATEONLY_PATTERN;
                break;
            }
            case 3: {
                this.mSelectedFormat = aFormat;
                this.mSelectedPattern = FIX_TIMESTAMP_PATTERN;
                break;
            }
            default: {
                throw new Exception("Invalid format.  To specify custom format use init (String pattern)");
            }
        }
    }

    public DateTimeFormatter(String aPattern) throws Exception {
        if (aPattern.equals(FIX_TIMEONLY_PATTERN)) {
            new DateTimeFormatter(1);
        } else if (aPattern.equals(FIX_DATEONLY_PATTERN)) {
            new DateTimeFormatter(2);
        } else if (aPattern.equals(FIX_TIMESTAMP_PATTERN)) {
            new DateTimeFormatter(3);
        } else {
            try {
                new SimpleDateFormat(aPattern);
                this.mSelectedFormat = 0;
                this.mSelectedPattern = aPattern;
            }
            catch (Exception e) {
                throw new Exception("Invalid pattern specified: " + aPattern);
            }
        }
    }

    public int getFormatAsInt() {
        return this.mSelectedFormat;
    }

    @Override
    public String getFormatAsString() {
        return this.mSelectedPattern;
    }

    public Date parse(String aDate) throws ParseException {
        Date ret = null;
        switch (this.getFormatAsInt()) {
            case 2: {
                ret = this.parseDate(aDate, false);
                break;
            }
            case 1: {
                ret = this.parseTime(aDate, false);
                break;
            }
            case 3: {
                ret = this.parseDateTime(aDate, false);
                break;
            }
            case 0: {
                ret = this.parseOther(aDate, false);
            }
        }
        return ret;
    }

    @Override
    public Date parseUTC(String aDate) throws ParseException {
        Date ret = null;
        switch (this.getFormatAsInt()) {
            case 2: {
                ret = this.parseDate(aDate, true);
                break;
            }
            case 1: {
                ret = this.parseTime(aDate, true);
                break;
            }
            case 3: {
                ret = this.parseDateTime(aDate, true);
                break;
            }
            case 0: {
                ret = this.parseOther(aDate, true);
            }
        }
        return ret;
    }

    public String format(Date aDate) throws ParseException {
        String ret = null;
        switch (this.getFormatAsInt()) {
            case 2: {
                ret = this.formatDate(aDate, false);
                break;
            }
            case 1: {
                ret = this.formatTime(aDate, false);
                break;
            }
            case 3: {
                ret = this.formatDateTime(aDate, false);
                break;
            }
            case 0: {
                ret = this.formatOther(aDate, false);
            }
        }
        return ret;
    }

    @Override
    public String formatUTC(Date aDate) throws ParseException {
        String ret = null;
        switch (this.getFormatAsInt()) {
            case 2: {
                ret = this.formatDate(aDate, true);
                break;
            }
            case 1: {
                ret = this.formatTime(aDate, true);
                break;
            }
            case 3: {
                ret = this.formatDateTime(aDate, true);
                break;
            }
            case 0: {
                ret = this.formatOther(aDate, true);
            }
        }
        return ret;
    }

    private static Calendar getDefaultCalendar() {
        return cDefaultCalendar.get();
    }

    private static Calendar getUTCCalendar() {
        return cUTCCalendar.get();
    }

    public static Date convertDBStringToDate(String date, boolean isTick) {
        return DateTimeFormatter.convertDBStringToDate(date, isTick, DateTimeFormatter.getDefaultCalendar(), false);
    }

    public static Date convertDBStringToDateUTC(String date, boolean isTick) {
        return DateTimeFormatter.convertDBStringToDate(date, isTick, DateTimeFormatter.getUTCCalendar(), false);
    }

    public static String convertDBDateToString(Date date, boolean isTick) {
        return DateTimeFormatter.convertDBDateToString(date, isTick, DateTimeFormatter.getDefaultCalendar(), false);
    }

    public static String convertDBDateToStringUTC(Date date, boolean isTick) {
        return DateTimeFormatter.convertDBDateToString(date, isTick, DateTimeFormatter.getUTCCalendar(), false);
    }

    private Date parseDate(String aDate, boolean aUtc) throws ParseException {
        int year = 0;
        int month = 0;
        int day = 0;
        try {
            year = Integer.parseInt(aDate.substring(0, 4));
            String s = aDate.substring(4, 6);
            if (s.charAt(0) == ' ') {
                s = String.valueOf(s.charAt(1));
            }
            month = Integer.parseInt(s) - 1;
            s = aDate.substring(6, 8);
            if (s.charAt(0) == ' ') {
                s = String.valueOf(s.charAt(1));
            }
            day = Integer.parseInt(s);
        }
        catch (Exception e) {
            throw new ParseException("Unable to parse Date: " + aDate, 0);
        }
        Calendar cal = aUtc ? DateTimeFormatter.getUTCCalendar() : DateTimeFormatter.getDefaultCalendar();
        cal.clear();
        cal.set(1, year);
        cal.set(2, month);
        cal.set(5, day);
        Date dt = cal.getTime();
        cal = null;
        return dt;
    }

    private Date parseTime(String aDate, boolean aUtc) throws ParseException {
        int hour = 0;
        int minute = 0;
        int second = 0;
        try {
            String s = aDate.substring(0, 2);
            if (s.charAt(0) == ' ') {
                s = String.valueOf(s.charAt(1));
            }
            hour = Integer.parseInt(s);
            s = aDate.substring(3, 5);
            if (s.charAt(0) == ' ') {
                s = String.valueOf(s.charAt(1));
            }
            minute = Integer.parseInt(s);
            s = aDate.substring(6, 8);
            if (s.charAt(0) == ' ') {
                s = String.valueOf(s.charAt(1));
            }
            second = Integer.parseInt(s);
        }
        catch (Exception e) {
            throw new ParseException("Unable to parse Time: " + aDate, 0);
        }
        Calendar cal = aUtc ? DateTimeFormatter.getUTCCalendar() : DateTimeFormatter.getDefaultCalendar();
        cal.setTime(new Date());
        cal.set(11, hour);
        cal.set(12, minute);
        cal.set(13, second);
        cal.set(14, 0);
        Date dt = cal.getTime();
        cal = null;
        return dt;
    }

    private Date parseDateTime(String aDate, boolean aUtc) throws ParseException {
        int year = 0;
        int month = 0;
        int day = 0;
        int hour = 0;
        int minute = 0;
        int second = 0;
        try {
            year = Integer.parseInt(aDate.substring(0, 4));
            String s = aDate.substring(4, 6);
            if (s.charAt(0) == ' ') {
                s = String.valueOf(s.charAt(1));
            }
            month = Integer.parseInt(s);
            s = aDate.substring(6, 8);
            if (s.charAt(0) == ' ') {
                s = String.valueOf(s.charAt(1));
            }
            day = Integer.parseInt(s);
            s = aDate.substring(9, 11);
            if (s.charAt(0) == ' ') {
                s = String.valueOf(s.charAt(1));
            }
            hour = Integer.parseInt(s);
            s = aDate.substring(12, 14);
            if (s.charAt(0) == ' ') {
                s = String.valueOf(s.charAt(1));
            }
            minute = Integer.parseInt(s);
            s = aDate.substring(15, 17);
            if (s.charAt(0) == ' ') {
                s = String.valueOf(s.charAt(1));
            }
            second = Integer.parseInt(s);
        }
        catch (Exception e) {
            throw new ParseException("Unable to parse Date: " + aDate, 0);
        }
        Calendar cal = null;
        cal = aUtc ? DateTimeFormatter.getUTCCalendar() : DateTimeFormatter.getDefaultCalendar();
        cal.clear();
        cal.set(year, month - 1, day, hour, minute, second);
        Date dt = cal.getTime();
        cal = null;
        return dt;
    }

    private Date parseOther(String aDate, boolean aUtc) throws ParseException {
        SimpleDateFormat sdf = new SimpleDateFormat(this.mSelectedPattern);
        if (aUtc) {
            sdf.setTimeZone(cUTCTimeZone);
        }
        Date ret = null;
        try {
            ret = sdf.parse(aDate);
        }
        catch (Exception e) {
            throw new ParseException("Unable to format date: " + aDate, 0);
        }
        sdf = null;
        return ret;
    }

    private String formatDate(Date aDate, boolean aUtc) {
        String year = null;
        Object month = null;
        Object day = null;
        Calendar cal = aUtc ? DateTimeFormatter.getUTCCalendar() : DateTimeFormatter.getDefaultCalendar();
        cal.setTime(aDate);
        year = Integer.toString(cal.get(1));
        month = Integer.toString(cal.get(2) + 1);
        day = Integer.toString(cal.get(5));
        cal = null;
        if (((String)month).length() == 1) {
            month = ZERO + (String)month;
        }
        if (((String)day).length() == 1) {
            day = ZERO + (String)day;
        }
        String ret = year + (String)month + (String)day;
        year = null;
        month = null;
        day = null;
        return ret;
    }

    private String formatTime(Date aDate, boolean aUtc) {
        Object hour = null;
        Object minute = null;
        Object second = null;
        Calendar cal = null;
        cal = aUtc ? DateTimeFormatter.getUTCCalendar() : DateTimeFormatter.getDefaultCalendar();
        cal.setTime(aDate);
        hour = Integer.toString(cal.get(11));
        minute = Integer.toString(cal.get(12));
        second = Integer.toString(cal.get(13));
        cal = null;
        if (((String)hour).length() == 1) {
            hour = ZERO + (String)hour;
        }
        if (((String)minute).length() == 1) {
            minute = ZERO + (String)minute;
        }
        if (((String)second).length() == 1) {
            second = ZERO + (String)second;
        }
        String ret = (String)hour + ":" + (String)minute + ":" + (String)second;
        hour = null;
        minute = null;
        second = null;
        return ret;
    }

    private String formatDateTime(Date aDate, boolean aUtc) {
        String year = null;
        Object month = null;
        Object day = null;
        Object hour = null;
        Object minute = null;
        Object second = null;
        Calendar cal = null;
        cal = aUtc ? DateTimeFormatter.getUTCCalendar() : DateTimeFormatter.getDefaultCalendar();
        cal.setTime(aDate);
        year = Integer.toString(cal.get(1));
        month = Integer.toString(cal.get(2) + 1);
        day = Integer.toString(cal.get(5));
        hour = Integer.toString(cal.get(11));
        minute = Integer.toString(cal.get(12));
        second = Integer.toString(cal.get(13));
        cal = null;
        if (((String)month).length() == 1) {
            month = ZERO + (String)month;
        }
        if (((String)day).length() == 1) {
            day = ZERO + (String)day;
        }
        if (((String)hour).length() == 1) {
            hour = ZERO + (String)hour;
        }
        if (((String)minute).length() == 1) {
            minute = ZERO + (String)minute;
        }
        if (((String)second).length() == 1) {
            second = ZERO + (String)second;
        }
        String datePart = year + (String)month + (String)day;
        String timePart = (String)hour + ":" + (String)minute + ":" + (String)second;
        String ret = datePart + "-" + timePart;
        year = null;
        month = null;
        day = null;
        hour = null;
        minute = null;
        second = null;
        return ret;
    }

    private String formatOther(Date aDate, boolean aUtc) throws ParseException {
        SimpleDateFormat sdf = new SimpleDateFormat(this.mSelectedPattern);
        if (aUtc) {
            sdf.setTimeZone(cUTCTimeZone);
        }
        String ret = null;
        try {
            ret = sdf.format(aDate);
        }
        catch (Exception e) {
            throw new ParseException("Unable to format date: " + aDate, 0);
        }
        sdf = null;
        return ret;
    }

    public static Date convertDBStringToDate(String aDate, boolean aIsTick, Calendar aCal) {
        return DateTimeFormatter.convertDBStringToDate(aDate, aIsTick, aCal, true);
    }

    public static Date convertDBStringToDate(String aDate, boolean aIsTick, Calendar aCal, boolean aMakeClone) {
        Date ret = null;
        if (aDate.equals(aIsTick ? EMPTY_DATE_PH : EMPTY_DATE_CH)) {
            return ret;
        }
        int year = Integer.parseInt(aDate.substring(0, 4));
        int month = Integer.parseInt(aDate.substring(4, 6));
        int day = Integer.parseInt(aDate.substring(6, 8));
        int hour = Integer.parseInt(aDate.substring(8, 10));
        int minute = Integer.parseInt(aDate.substring(10, 12));
        int second = Integer.parseInt(aDate.substring(12, 14));
        Calendar cal = aCal;
        if (aMakeClone) {
            cal = (Calendar)cal.clone();
        }
        cal.set(year, month - 1, day, hour, minute, second);
        cal.set(14, 0);
        ret = cal.getTime();
        cal = null;
        return ret;
    }

    public static String convertDBDateToString(Date aDate, boolean aIsTick, Calendar aCal) {
        return DateTimeFormatter.convertDBDateToString(aDate, aIsTick, aCal, true);
    }

    public static String convertDBDateToString(Date aDate, boolean aIsTick, Calendar aCal, boolean aMakeClone) {
        Object dateAsString;
        Object object = dateAsString = aIsTick ? EMPTY_DATE_PH : EMPTY_DATE_CH;
        if (aDate == null) {
            return dateAsString;
        }
        Calendar cal = aCal;
        if (aMakeClone) {
            cal = (Calendar)cal.clone();
        }
        cal.setTime(aDate);
        String year = Integer.toString(cal.get(1));
        Object month = Integer.toString(cal.get(2) + 1);
        Object day = Integer.toString(cal.get(5));
        Object hour = Integer.toString(cal.get(11));
        Object minute = Integer.toString(cal.get(12));
        Object second = Integer.toString(cal.get(13));
        cal = null;
        if (((String)month).length() == 1) {
            month = ZERO + (String)month;
        }
        if (((String)day).length() == 1) {
            day = ZERO + (String)day;
        }
        if (((String)hour).length() == 1) {
            hour = ZERO + (String)hour;
        }
        if (((String)minute).length() == 1) {
            minute = ZERO + (String)minute;
        }
        if (((String)second).length() == 1) {
            second = ZERO + (String)second;
        }
        dateAsString = year + (String)month + (String)day + (String)hour + (String)minute + (String)second;
        if (aIsTick) {
            dateAsString = (String)dateAsString + "000";
        }
        year = null;
        month = null;
        day = null;
        hour = null;
        minute = null;
        second = null;
        return dateAsString;
    }

    public static String formatDASDate(Date aDate) {
        return DateTimeFormatter.formatDASDate(aDate, null, false);
    }

    public static String formatDASDate(Date aDate, Calendar aCalendar) {
        return DateTimeFormatter.formatDASDate(aDate, aCalendar, true);
    }

    public static String formatDASDate(Date aDate, Calendar aCalendar, boolean aMakeClone) {
        if (aDate == null) {
            return EMPTY_DATE_CH;
        }
        Calendar cal = aCalendar;
        if (cal != null) {
            if (aMakeClone) {
                cal = (Calendar)cal.clone();
            }
        } else {
            DateTimeFormatter.getDefaultCalendar();
        }
        cal.setTime(aDate);
        String year = Integer.toString(cal.get(1));
        Object month = Integer.toString(cal.get(2) + 1);
        Object day = Integer.toString(cal.get(5));
        Object hour = Integer.toString(cal.get(11));
        Object minute = Integer.toString(cal.get(12));
        Object second = Integer.toString(cal.get(13));
        cal = null;
        if (((String)month).length() == 1) {
            month = ZERO + (String)month;
        }
        if (((String)day).length() == 1) {
            day = ZERO + (String)day;
        }
        if (((String)hour).length() == 1) {
            hour = ZERO + (String)hour;
        }
        if (((String)minute).length() == 1) {
            minute = ZERO + (String)minute;
        }
        if (((String)second).length() == 1) {
            second = ZERO + (String)second;
        }
        String dateAsString = (String)month + (String)day + year + (String)hour + (String)minute + (String)second;
        year = null;
        month = null;
        day = null;
        hour = null;
        minute = null;
        second = null;
        return dateAsString;
    }

    public static String formatDefault(Date aDate, String aTimeZone) {
        String year = null;
        Object month = null;
        Object day = null;
        Object hour = null;
        Object minute = null;
        Object second = null;
        Calendar cal = Calendar.getInstance(TimeZone.getTimeZone(aTimeZone));
        cal.setTime(aDate);
        year = Integer.toString(cal.get(1));
        month = Integer.toString(cal.get(2) + 1);
        day = Integer.toString(cal.get(5));
        hour = Integer.toString(cal.get(11));
        minute = Integer.toString(cal.get(12));
        second = Integer.toString(cal.get(13));
        cal = null;
        if (((String)month).length() == 1) {
            month = ZERO + (String)month;
        }
        if (((String)day).length() == 1) {
            day = ZERO + (String)day;
        }
        if (((String)hour).length() == 1) {
            hour = ZERO + (String)hour;
        }
        if (((String)minute).length() == 1) {
            minute = ZERO + (String)minute;
        }
        if (((String)second).length() == 1) {
            second = ZERO + (String)second;
        }
        String datePart = (String)month + "/" + (String)day + "/" + year;
        String timePart = (String)hour + ":" + (String)minute + ":" + (String)second;
        String ret = datePart + " " + timePart;
        year = null;
        month = null;
        day = null;
        hour = null;
        minute = null;
        second = null;
        return ret;
    }

    @Override
    public long parseUTCInMillis(String aDate) throws ParseException {
        return this.parseUTC(aDate).getTime();
    }

    @Override
    public String formatUTCInMillis(long aMillis) throws ParseException {
        return this.formatUTC(new Date(aMillis));
    }
}

