/*
 * Decompiled with CFR 0.152.
 */
package com.fxcm.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;

public class ByteArrayOutputStreamWithWriter
extends ByteArrayOutputStream {
    protected static final int MAX_ARRAYSIZE = 0x7FFFFFF7;
    protected Writer wr;
    protected int initalCapacity;

    public ByteArrayOutputStreamWithWriter() {
        this(4096);
    }

    public ByteArrayOutputStreamWithWriter(int size) {
        super(size > 0x7FFFFFF7 ? 0x7FFFFFF7 : size);
        this.initalCapacity = this.buf.length;
        this.wr = new OutputStreamWriter((OutputStream)this, Charset.forName("UTF-8"));
    }

    public Writer getWriter() {
        return this.wr;
    }

    public byte[] getBuffer() {
        try {
            this.wr.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this.buf;
    }

    @Override
    public void reset() {
        try {
            this.wr.flush();
            super.reset();
            if (this.buf.length > this.initalCapacity) {
                this.buf = new byte[this.initalCapacity];
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public byte[] toByteArray() {
        try {
            this.wr.flush();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return super.toByteArray();
    }
}

