/*
 * Decompiled with CFR 0.152.
 */
package com.fxcm.util;

import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Base64t {
    private static final byte[] maTable = new byte[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 43, 47};
    private static int[] maBackTable = null;

    public static byte[] encode(byte[] aBytes) {
        return Base64t.encode(aBytes, aBytes.length);
    }

    public static byte[] encode(byte[] aBytes, int aiSize) {
        int iOrgLength = aBytes.length;
        if (aiSize < iOrgLength) {
            iOrgLength = aiSize;
        }
        int iLength = iOrgLength / 3;
        if (iOrgLength % 3 != 0) {
            ++iLength;
        }
        byte[] aDst = new byte[(iLength *= 3) / 3 * 4];
        int j = 0;
        for (int i = 0; i < iLength; ++i) {
            int b0 = aBytes[i++] & 0xFF;
            int b1 = i < iOrgLength ? aBytes[i] & 0xFF : 0;
            int b2 = ++i < iOrgLength ? aBytes[i] & 0xFF : 0;
            int c0 = b0 >> 2;
            int c1 = (b0 & 3) << 4 | b1 >> 4;
            int c2 = (b1 & 0xF) << 2 | b2 >> 6;
            int c3 = b2 & 0x3F;
            aDst[j++] = maTable[c0];
            aDst[j++] = maTable[c1];
            aDst[j++] = maTable[c2];
            aDst[j++] = maTable[c3];
        }
        if (iOrgLength % 3 == 1) {
            aDst[j - 2] = 61;
        }
        if (iOrgLength % 3 >= 1) {
            aDst[j - 1] = 61;
        }
        return aDst;
    }

    public static byte[] decode(byte[] aBytes) throws Exception {
        int b1;
        int b0;
        int c2;
        int c1;
        int c0;
        int iGroupsCnt;
        int i;
        if (aBytes.length % 4 != 0) {
            throw new Exception();
        }
        if (maBackTable == null) {
            maBackTable = new int[256];
            Arrays.fill(maBackTable, -1);
            for (i = 0; i < maTable.length; ++i) {
                Base64t.maBackTable[Base64t.maTable[i]] = i;
            }
        }
        int iFullGroupsCnt = iGroupsCnt = aBytes.length / 4;
        int iLastGroupCharsCnt = 3;
        if (aBytes.length != 0) {
            if (aBytes[aBytes.length - 1] == 61) {
                --iLastGroupCharsCnt;
                --iFullGroupsCnt;
            }
            if (aBytes[aBytes.length - 2] == 61) {
                --iLastGroupCharsCnt;
            }
        }
        byte[] aDst = new byte[3 * (iGroupsCnt - 1) + iLastGroupCharsCnt];
        i = 0;
        int j = 0;
        for (int iGroup = 0; i < aBytes.length && iGroup < iFullGroupsCnt; ++iGroup) {
            c0 = aBytes[i++];
            c1 = aBytes[i++];
            c2 = aBytes[i++];
            int c3 = aBytes[i++];
            c0 = maBackTable[c0];
            c1 = maBackTable[c1];
            c2 = maBackTable[c2];
            c3 = maBackTable[c3];
            b0 = c0 << 2 | c1 >> 4;
            b1 = (c1 & 0xF) << 4 | c2 >> 2;
            int b2 = (c2 & 3) << 6 | c3;
            aDst[j++] = (byte)b0;
            aDst[j++] = (byte)b1;
            aDst[j++] = (byte)b2;
        }
        if (iLastGroupCharsCnt < 3) {
            c0 = aBytes[i++];
            c1 = aBytes[i++];
            c0 = maBackTable[c0];
            c1 = maBackTable[c1];
            b0 = c0 << 2 | c1 >> 4;
            aDst[j++] = (byte)b0;
            if (iLastGroupCharsCnt == 2) {
                c2 = aBytes[i++];
                c2 = maBackTable[c2];
                b1 = (c1 & 0xF) << 4 | c2 >> 2;
                aDst[j++] = (byte)b1;
            }
        }
        return aDst;
    }

    static void printByteArray(byte[] aBytes) {
        Object s = "";
        for (int i = 0; i < aBytes.length; ++i) {
            s = (String)s + aBytes[i] + ",";
        }
        LogFactory.getLog(Base64t.class).info(s);
    }

    static void printCharCodes(byte[] aBytes) {
        Object s = "";
        for (int i = 0; i < aBytes.length; ++i) {
            s = (String)s + (char)aBytes[i];
        }
        LogFactory.getLog(Base64t.class).info(s);
    }

    static void unittest(byte[] aData) {
        Log log = LogFactory.getLog(Base64t.class);
        log.info("--------------------------------------------------------");
        Base64t.printByteArray(aData);
        byte[] a1 = Base64t.encode(aData);
        Base64t.printCharCodes(a1);
        try {
            byte[] a2 = Base64t.decode(a1);
            Base64t.printByteArray(a2);
        }
        catch (Exception e) {
            log.error("Decoding exception");
        }
    }

    public static void main(String[] args) {
        byte[] t = new byte[]{1, 2, 3, 4, 5};
        Base64t.unittest(t);
        t = new byte[]{1, 2, 3, 4, 5, 6};
        Base64t.unittest(t);
        t = new byte[]{1, 2, 3, 4, 5, 6, 7};
        Base64t.unittest(t);
        t = new byte[256];
        for (int i = 0; i < 256; ++i) {
            t[i] = (byte)i;
        }
        Base64t.unittest(t);
    }
}

