/*
 * Decompiled with CFR 0.152.
 */
package com.fxcm.messaging.util.web;

import com.fxcm.messaging.util.web.HttpException;
import com.fxcm.messaging.util.web.HttpParameter;
import com.fxcm.util.logging.Utils;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.net.ssl.SSLSocketFactory;
import org.apache.commons.logging.Log;

public class HttpContentGetter {
    private final Log mLogger = Utils.getLog(HttpContentGetter.class);
    private int mProxyPort;
    private String mProxyAddr = "";
    private boolean mUseSSL;
    private String mUserID = "";
    private String mPassword = "";
    private String mProxyUserID = "";
    private String mProxyPasswd = "";
    private String mHost = "";
    private int mPort = 80;

    public void setBasicAuth(String aUserID, String aPassword) {
        this.mUserID = "";
        this.mPassword = "";
        if (aUserID != null) {
            this.mUserID = aUserID;
        }
        if (aPassword != null) {
            this.mPassword = aPassword;
        }
    }

    public void setProxyServer(String aAddress, int aPort) {
        this.mProxyAddr = "";
        this.mProxyPort = -1;
        if (aAddress != null) {
            this.mProxyAddr = aAddress;
        }
        if (aPort > 0) {
            this.mProxyPort = aPort;
        }
    }

    public void setBasicProxyAuth(String aUserID, String aPassword) {
        this.mProxyUserID = "";
        this.mProxyPasswd = "";
        if (aUserID != null) {
            this.mProxyUserID = aUserID;
        }
        if (aPassword != null) {
            this.mProxyPasswd = aPassword;
        }
    }

    public String getTextContent(String aURL, boolean aPost, Vector aParameters) throws HttpException {
        if (aURL == null) {
            throw new HttpException(2);
        }
        if ("".equalsIgnoreCase((String)aURL)) {
            throw new HttpException(2);
        }
        String protocol = "http";
        String output = "";
        int index = 0;
        Object request = "";
        boolean isHttps = false;
        boolean isHttp = false;
        index = ((String)aURL).indexOf("://");
        if (index != -1) {
            protocol = ((String)aURL).substring(0, index);
            isHttps = "https".equalsIgnoreCase(protocol);
            isHttp = "http".equalsIgnoreCase(protocol);
            if (!(isHttp || isHttps || "file".equalsIgnoreCase(protocol))) {
                throw new HttpException(3, "Unsuppported protocol:" + protocol);
            }
        } else {
            aURL = protocol + "://" + (String)aURL;
        }
        if (this.mLogger.isDebugEnabled()) {
            this.mLogger.debug("URL:" + (String)aURL);
        }
        if (isHttp || isHttps) {
            URL url = null;
            String response = "";
            Object parameters = "";
            String path = "";
            Object query = "";
            String ref = "";
            Object relPath = "";
            Object absPath = "";
            try {
                url = new URL((String)aURL);
                this.mPort = url.getPort();
                if (this.mPort == -1) {
                    if (isHttps) {
                        this.mUseSSL = true;
                        this.mPort = 443;
                    } else {
                        this.mUseSSL = false;
                        this.mPort = 80;
                    }
                }
                this.mHost = url.getHost();
            }
            catch (MalformedURLException eUrl) {
                throw new HttpException(2, "Invalid URL:" + (String)aURL);
            }
            try {
                String basicCookie;
                if (aParameters != null) {
                    for (int i = 0; i < aParameters.size(); ++i) {
                        if (i != 0) {
                            parameters = (String)parameters + "&";
                        }
                        parameters = (String)parameters + ((HttpParameter)aParameters.get((int)i)).sName;
                        parameters = (String)parameters + "=" + ((HttpParameter)aParameters.get((int)i)).sValue;
                    }
                }
                request = aPost ? "POST " : "GET ";
                absPath = protocol + "://" + url.getHost();
                if (url.getPort() != -1) {
                    absPath = (String)absPath + ":" + url.getPort();
                }
                if (url.getPath() != null && !url.getPath().isEmpty()) {
                    path = url.getPath();
                    relPath = (String)relPath + path;
                } else {
                    relPath = "/";
                }
                if (url.getQuery() != null && !url.getQuery().isEmpty()) {
                    query = url.getQuery();
                    if (!aPost && parameters != null && !((String)parameters).isEmpty()) {
                        query = (String)query + "&" + (String)parameters;
                    }
                } else if (!aPost) {
                    query = parameters;
                }
                if (query != null && !((String)query).isEmpty()) {
                    relPath = (String)relPath + "?" + (String)query;
                }
                if (url.getRef() != null && !url.getRef().isEmpty()) {
                    ref = url.getRef();
                    relPath = (String)relPath + "#" + ref;
                }
                request = this.mProxyAddr != null && !this.mProxyAddr.isEmpty() ? (String)request + (String)absPath + (String)relPath + " HTTP/1.0\r\n" : (String)request + (String)relPath + " HTTP/1.0\r\n";
                request = (String)request + "Host: " + this.mHost + "\r\n";
                request = (String)request + "Pragma: no-cache\r\n";
                request = (String)request + "Connection: Close\r\n";
                request = (String)request + "Accept: Accept: */*\r\n";
                request = (String)request + "User-Agent: JavaAPI\r\n";
                if (this.mUserID != null && !this.mUserID.isEmpty()) {
                    String userIDPass = this.mUserID + ":" + this.mPassword;
                    basicCookie = HttpContentGetter.encodeToBase64(userIDPass);
                    request = (String)request + "Authorization: Basic " + basicCookie + "\r\n";
                }
                if (this.mProxyUserID != null && !this.mProxyUserID.isEmpty()) {
                    String userIDPass = this.mProxyUserID + ":" + this.mProxyPasswd;
                    basicCookie = HttpContentGetter.encodeToBase64(userIDPass);
                    request = (String)request + "Proxy-Authorization: Basic " + basicCookie + "\r\n";
                }
                if (aPost) {
                    request = (String)request + "Content-Length: " + ((String)parameters).length() + "\r\n";
                    request = (String)request + "Content-Type: application/x-www-form-urlencoded\r\n\r\n";
                    request = (String)request + (String)parameters;
                } else {
                    request = (String)request + "Content-Length: 0\r\n\r\n";
                }
                if (this.mLogger.isDebugEnabled()) {
                    this.mLogger.debug("Request:" + (String)request);
                }
                response = this.sendRequest((String)request);
                output = this.processResponse(response);
            }
            catch (HttpException e) {
                if (this.mLogger.isDebugEnabled()) {
                    this.mLogger.debug("", e);
                }
                throw e;
            }
            catch (Exception e) {
                if (this.mLogger.isDebugEnabled()) {
                    this.mLogger.debug("", e);
                }
                throw new HttpException(1);
            }
        }
        String filename = "";
        File file = null;
        filename = ((String)aURL).substring(7);
        try {
            file = new File(filename);
        }
        catch (Exception ex) {
            throw new HttpException(4, "File:" + filename + " does not exist");
        }
        try {
            FileInputStream fileInputStream = new FileInputStream(filename);
            byte[] arrBuf = null;
            int nlength = (int)file.length();
            arrBuf = new byte[nlength];
            fileInputStream.read(arrBuf);
            fileInputStream.close();
            output = new String(arrBuf);
        }
        catch (Exception e) {
            if (this.mLogger.isDebugEnabled()) {
                this.mLogger.debug("", e);
            }
            throw new HttpException(5, "Error during reading file:" + filename);
        }
        return output;
    }

    private String sendRequest(String aRequest) throws HttpException {
        InputStream input = null;
        OutputStream output = null;
        String response = "";
        InputStreamReader reader = null;
        Socket socket = null;
        try {
            if (this.mProxyAddr != null && !this.mProxyAddr.isEmpty()) {
                if (this.mLogger.isDebugEnabled()) {
                    this.mLogger.debug("Using proxy:" + this.mProxyAddr + " port:" + this.mProxyPort);
                }
                socket = new Socket(this.mProxyAddr, this.mProxyPort);
            } else {
                if (this.mLogger.isDebugEnabled()) {
                    this.mLogger.debug("Direct connect:" + this.mHost + " port:" + this.mPort);
                }
                socket = this.mUseSSL ? SSLSocketFactory.getDefault().createSocket(this.mHost, this.mPort) : new Socket(this.mHost, this.mPort);
            }
            input = socket.getInputStream();
            output = socket.getOutputStream();
            output.write(aRequest.getBytes());
            output.flush();
            StringBuilder buffer = new StringBuilder();
            reader = new InputStreamReader(input);
            char[] arrBuf = null;
            arrBuf = new char[65536];
            int read = 0;
            do {
                buffer.append(arrBuf, 0, read);
            } while ((read = reader.read(arrBuf, 0, 65536)) != -1);
            response = buffer.toString();
        }
        catch (UnknownHostException eHost) {
            throw new HttpException(5, "Can not connect to host:" + (this.mProxyAddr != null && this.mProxyAddr.isEmpty() ? this.mHost : this.mProxyAddr));
        }
        catch (Exception e) {
            this.mLogger.error(e.getMessage(), e);
            throw new HttpException(1);
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
                if (output != null) {
                    output.close();
                }
                if (input != null) {
                    input.close();
                }
                if (socket != null) {
                    socket.close();
                }
            }
            catch (Exception exception) {}
        }
        return response;
    }

    private String processResponse(String aHttpResponse) throws HttpException {
        String input = aHttpResponse;
        String response = "";
        String crlf = "\r\n";
        int index = 0;
        int statusCode = 0;
        String statusLine = "";
        String reasonPhrase = "";
        HashMap<String, String> headers = null;
        try {
            headers = new HashMap<String, String>();
            index = input.indexOf(crlf);
            if (index != -1) {
                statusLine = input.substring(0, index);
                input = input.substring(index + 1);
            }
            if (this.mLogger.isDebugEnabled()) {
                this.mLogger.debug("Status Line:" + statusLine + "!");
            }
            index = statusLine.indexOf(32);
            statusLine = statusLine.substring(index + 1);
            index = statusLine.indexOf(32);
            String code = "";
            if (index == -1) {
                code = statusLine;
            } else {
                code = statusLine.substring(0, index);
                reasonPhrase = statusLine = statusLine.substring(index + 1);
            }
            statusCode = Integer.parseInt(code);
            if (this.mLogger.isDebugEnabled()) {
                this.mLogger.debug("Code:" + statusCode + " Reason:" + reasonPhrase + "!");
            }
            String sHeaders = "";
            index = input.indexOf(crlf + crlf, index + 1);
            if (index != -1) {
                sHeaders = input.substring(0, index);
                input = input.substring(index + 4);
            }
            if (this.mLogger.isDebugEnabled()) {
                this.mLogger.debug("Headers:" + sHeaders + "!");
                this.mLogger.debug(aHttpResponse);
            }
            StringTokenizer eHeaders = new StringTokenizer(sHeaders, crlf);
            while (eHeaders.hasMoreElements()) {
                String nameValue = (String)eHeaders.nextElement();
                int pos = nameValue.indexOf(":");
                String sName = nameValue.substring(0, pos);
                String sValue = nameValue.substring(pos + 1);
                headers.put(sName.toLowerCase(), sValue);
            }
        }
        catch (Exception e) {
            throw new HttpException(1);
        }
        switch (statusCode) {
            case 200: {
                if (headers.get("content-type") == null) break;
                response = input;
                break;
            }
            default: {
                if (reasonPhrase != null && reasonPhrase.isEmpty()) {
                    throw new HttpException(statusCode);
                }
                throw new HttpException(statusCode, reasonPhrase);
            }
        }
        return response;
    }

    private static String encodeToBase64(String aSource) {
        byte[] map = new byte[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 43, 47};
        if (aSource == null) {
            return null;
        }
        byte[] arrSrc = null;
        arrSrc = aSource.getBytes();
        byte[] arrDst = new byte[(arrSrc.length + 2) / 3 * 4];
        int iSrc = 0;
        int iDst = 0;
        while (arrSrc.length - iSrc > 2) {
            arrDst[iDst++] = map[arrSrc[iSrc] >>> 2];
            arrDst[iDst++] = map[arrSrc[iSrc] << 4 & 0x30 | arrSrc[iSrc + 1] >>> 4];
            arrDst[iDst++] = map[arrSrc[iSrc + 1] << 2 & 0x3F | arrSrc[iSrc + 2] >>> 6];
            arrDst[iDst++] = map[arrSrc[iSrc + 2] & 0x3F];
            iSrc += 3;
        }
        if (iSrc < arrSrc.length) {
            if (arrSrc.length - iSrc == 2) {
                arrDst[iDst++] = map[arrSrc[iSrc] >>> 2];
                arrDst[iDst++] = map[arrSrc[iSrc] << 4 & 0x30 | arrSrc[iSrc + 1] >>> 4];
                arrDst[iDst++] = map[arrSrc[iSrc + 1] << 2 & 0x3F];
            } else {
                arrDst[iDst++] = map[arrSrc[iSrc] >>> 2];
                arrDst[iDst++] = map[arrSrc[iSrc] << 4 & 0x30];
            }
        }
        while (iDst < arrDst.length) {
            arrDst[iDst] = 61;
            ++iDst;
        }
        return new String(arrDst);
    }
}

