/*
 * Decompiled with CFR 0.152.
 */
package com.fxcm.messaging.util.versioning;

import java.util.HashMap;
import java.util.Map;

public class FXCMVersion
implements Comparable {
    public static final String FUNC_BATCH_MESSAGES = "batchMessages";
    public static final String UNKNOWN = "Unknown Implementation Version";
    private static final Map cSupportedFunctions = new HashMap();
    private String[] mVersions = new String[]{"", "", "", ""};
    private String mClientType = "J";

    public FXCMVersion() {
        String version = UNKNOWN;
        Package pkg = FXCMVersion.class.getPackage();
        if (pkg != null && pkg.getImplementationVersion() != null) {
            version = pkg.getImplementationVersion();
        }
        this.setVersion(this.mClientType + version);
    }

    private FXCMVersion(String aVersionNo) {
        this.setVersion(aVersionNo);
    }

    private void setVersion(String aVersionNo) {
        if (aVersionNo != null) {
            String ver = aVersionNo;
            if (Character.isLetter(ver.charAt(0))) {
                this.mClientType = ver.substring(0, 1);
                ver = ver.substring(1);
            }
            String[] versions = ver.split("\\.", 5);
            this.setVersions(versions);
        }
    }

    public static FXCMVersion valueOf(String aVer) {
        return new FXCMVersion(aVer);
    }

    public boolean isSupported(String aFunctionName) {
        FXCMVersion minVer = (FXCMVersion)cSupportedFunctions.get(aFunctionName);
        if (minVer == null) {
            return false;
        }
        return this.compareTo(minVer) >= 0;
    }

    public String getClientType() {
        return this.mClientType;
    }

    private void setVersions(String[] aVersions) {
        for (int i = 0; i < aVersions.length && i < this.mVersions.length; ++i) {
            this.mVersions[i] = aVersions[i];
        }
    }

    public String getMajor() {
        return this.mVersions[0];
    }

    public String getMinor() {
        return this.mVersions[1];
    }

    public String getBuild() {
        return this.mVersions[2] + this.mVersions[3];
    }

    public String toString() {
        StringBuffer version = new StringBuffer();
        if (this.mClientType != null) {
            version.append(this.mClientType);
        }
        version.append(this.mVersions[0]);
        for (int i = 1; i < this.mVersions.length; ++i) {
            version.append('.');
            version.append(this.mVersions[i]);
        }
        return version.toString();
    }

    public int compareTo(Object aObject) {
        if (aObject instanceof FXCMVersion) {
            FXCMVersion aVersion = (FXCMVersion)aObject;
            int res = 0;
            for (int i = 0; i < this.mVersions.length && i < aVersion.mVersions.length; ++i) {
                String v1 = this.mVersions[i];
                String v2 = aVersion.mVersions[i];
                try {
                    long lv1 = Long.parseLong(v1);
                    long lv2 = Long.parseLong(v2);
                    res = lv1 == lv2 ? 0 : (lv1 > lv2 ? 1 : -1);
                }
                catch (NumberFormatException e) {
                    res = v1.compareToIgnoreCase(v2);
                }
                if (res != 0) break;
            }
            return res;
        }
        return -1;
    }

    public int hashCode() {
        return 0;
    }

    static {
        cSupportedFunctions.put(FUNC_BATCH_MESSAGES, FXCMVersion.valueOf("J5.0.0509.2824"));
    }
}

