/*
 * Decompiled with CFR 0.152.
 */
package com.fxcm.messaging.util.pdas.xml;

import com.fxcm.GenericException;
import com.fxcm.messaging.IFieldGroup;
import com.fxcm.messaging.IFieldGroupList;
import com.fxcm.messaging.IMessage;
import com.fxcm.messaging.util.pdas.PDasMessageFactory;
import com.fxcm.messaging.util.pdas.PStream;
import java.io.ByteArrayInputStream;
import java.util.Stack;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.AttributeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import uk.co.wilson.xml.MinML;

public class PXmlParser
extends MinML {
    private Log moLog = LogFactory.getLog(PXmlParser.class);
    public static final String WS = " \t\n\r";
    public static final String TAG_ROOT = "fxmsg";
    public static final String TAG_MESSAGE = "m";
    public static final String TAG_FIELD = "f";
    public static final String TAG_GROUP = "g";
    public static final String TAG_LIST = "l";
    public static final String ATTR_VERSION = "v";
    public static final String ATTR_NAME = "n";
    public static final String ATTR_TYPE = "t";
    public static final String TYPE_LONG = "l";
    public static final String TYPE_INTEGER = "i";
    public static final String TYPE_DOUBLE = "d";
    public static final String TYPE_STRING = "s";
    private Stack mFieldGroupListEnvelopStack;
    private boolean mbInsideF;
    private boolean mbInsideG;
    private boolean mbInsideL;
    private String msFldName;
    private String msFldType;
    Vector mMessages;
    Stack mStkFieldGroup;
    private StringBuffer mDataChars;
    private String msDataFormat;

    public PXmlParser(String aDataFormat) {
        super(256, 128);
        this.msDataFormat = aDataFormat != null ? aDataFormat : "pdas";
    }

    public Vector fromXml(PStream aXml) throws GenericException {
        Vector pMessages = null;
        this.mMessages = new Vector();
        this.mStkFieldGroup = new Stack();
        this.mFieldGroupListEnvelopStack = new Stack();
        this.mDataChars = new StringBuffer();
        try {
            byte[] buffer = aXml.getBuffer();
            if (this.moLog.isDebugEnabled()) {
                String sPresntation = new String(buffer, 0, aXml.getDataLen());
                this.moLog.debug("Parsing:\n" + sPresntation);
            }
            this.parse(new InputSource(new ByteArrayInputStream(buffer, 0, aXml.getDataLen())));
        }
        catch (Exception e) {
            this.moLog.error("Exception of xml formed message parsing:", e);
            throw new GenericException("Exception of xml formed message parsing: " + e.getClass().getName() + " " + e.getMessage(), e);
        }
        if (this.mMessages.size() > 0) {
            pMessages = this.mMessages;
        }
        this.mDataChars = null;
        this.mStkFieldGroup = null;
        this.mFieldGroupListEnvelopStack = null;
        this.mMessages = null;
        return pMessages;
    }

    @Override
    public void startElement(String asLocalName, AttributeList aAtts) throws SAXException {
        this.mDataChars.setLength(0);
        if (this.moLog.isDebugEnabled()) {
            this.moLog.debug("start " + asLocalName);
        }
        if (TAG_ROOT.equals(asLocalName)) {
            boolean bVer = false;
            String sAttr = aAtts.getValue(ATTR_VERSION);
            if (sAttr != null) {
                bVer = this.msDataFormat.equals(sAttr);
            }
            if (!bVer) {
                throw new SAXException("Received data format is not supported.");
            }
        } else if (TAG_MESSAGE.equals(asLocalName)) {
            IMessage pMessage = PDasMessageFactory.getInstance().createMessage(null, null);
            this.mMessages.add(pMessage);
        } else if (TAG_FIELD.equals(asLocalName)) {
            String sAttr;
            if (!this.mbInsideF && (sAttr = aAtts.getValue(ATTR_NAME)) != null) {
                this.mbInsideF = true;
                this.msFldName = sAttr;
                sAttr = aAtts.getValue(ATTR_TYPE);
                this.msFldType = sAttr != null ? sAttr : TYPE_STRING;
            }
        } else if ("l".equals(asLocalName)) {
            String sAttr = aAtts.getValue(ATTR_NAME);
            if (sAttr != null) {
                this.mbInsideL = true;
                this.mFieldGroupListEnvelopStack.push(new FieldGroupListEnvelop(sAttr, PDasMessageFactory.getInstance().createFieldGroupList()));
            }
        } else if (TAG_GROUP.equals(asLocalName)) {
            this.mbInsideG = true;
            IFieldGroup pFieldGroup = PDasMessageFactory.getInstance().createFieldGroup();
            this.mStkFieldGroup.push(pFieldGroup);
        } else {
            throw new SAXException("Incorect response format. Unexpected tag in response");
        }
    }

    @Override
    public void endElement(String asLocalName) throws SAXException {
        String sDataChars = this.mDataChars.toString().trim();
        if (this.moLog.isDebugEnabled()) {
            this.moLog.debug("end " + asLocalName);
        }
        if (TAG_FIELD.equals(asLocalName)) {
            IFieldGroup pFieldGroup = null;
            if (this.mbInsideF) {
                if (this.mStkFieldGroup.size() > 0) {
                    pFieldGroup = (IFieldGroup)this.mStkFieldGroup.peek();
                }
                if (pFieldGroup == null) {
                    pFieldGroup = (IFieldGroup)this.mMessages.lastElement();
                }
                if (pFieldGroup != null) {
                    if (sDataChars.length() > 0) {
                        if (TYPE_DOUBLE.equals(this.msFldType)) {
                            pFieldGroup.setValue(this.msFldName, Double.parseDouble(this.mDataChars.toString()));
                        } else if ("l".equals(this.msFldType)) {
                            pFieldGroup.setValue(this.msFldName, Long.parseLong(this.mDataChars.toString()));
                        } else if (TYPE_INTEGER.equals(this.msFldType)) {
                            pFieldGroup.setValue(this.msFldName, Integer.parseInt(this.mDataChars.toString()));
                        } else {
                            pFieldGroup.setValue(this.msFldName, this.mDataChars.toString());
                        }
                    }
                    this.mbInsideF = false;
                }
            }
        } else if (TAG_GROUP.equals(asLocalName)) {
            IFieldGroup pFieldGroup = (IFieldGroup)this.mStkFieldGroup.pop();
            FieldGroupListEnvelop envelop = (FieldGroupListEnvelop)this.mFieldGroupListEnvelopStack.peek();
            if (pFieldGroup != null && envelop != null) {
                envelop.mFieldGroupList.put(pFieldGroup);
            }
            this.mbInsideG = false;
        } else if ("l".equals(asLocalName)) {
            IFieldGroup pFieldGroup = null;
            FieldGroupListEnvelop envelop = (FieldGroupListEnvelop)this.mFieldGroupListEnvelopStack.pop();
            if (this.mStkFieldGroup.size() > 0) {
                pFieldGroup = (IFieldGroup)this.mStkFieldGroup.peek();
            }
            if (pFieldGroup == null) {
                pFieldGroup = (IFieldGroup)this.mMessages.lastElement();
            }
            if (pFieldGroup != null && envelop != null) {
                pFieldGroup.setValue(envelop.msName, envelop.mFieldGroupList);
            }
            this.mbInsideL = false;
        }
    }

    @Override
    public void characters(char[] aCh, int aiStart, int aiLength) {
        if (this.mbInsideF) {
            this.mDataChars.append(aCh, aiStart, aiLength);
        }
    }

    private class FieldGroupListEnvelop {
        IFieldGroupList mFieldGroupList;
        String msName;

        FieldGroupListEnvelop(String asName, IFieldGroupList aFieldGroupList) {
            this.mFieldGroupList = aFieldGroupList;
            this.msName = asName;
        }
    }
}

