/*
 * Decompiled with CFR 0.152.
 */
package com.fxcm.messaging.util.pdas.statemachine;

import com.fxcm.messaging.util.pdas.Event;
import com.fxcm.messaging.util.pdas.ThreadContainer;
import com.fxcm.messaging.util.pdas.communicator.UniComm;
import com.fxcm.messaging.util.pdas.statemachine.IJob;
import com.fxcm.messaging.util.pdas.statemachine.JobStateEnum;
import java.util.LinkedList;
import java.util.Vector;

public class StateMachine
implements Runnable {
    private LinkedList mList;
    protected long mTimeout = 100L;
    protected final Object mLockQueue;
    protected UniComm mUniComm;
    private final Event mEvent = Event.synchronizeEvent();
    private ThreadContainer mThreadContainer;
    private boolean mRun = true;

    public StateMachine(UniComm aUniComm) {
        this.mUniComm = aUniComm;
        this.mLockQueue = new Object();
        this.mList = new LinkedList();
        this.mThreadContainer = new ThreadContainer();
        this.mThreadContainer.start(new Thread((Runnable)this){

            @Override
            public void interrupt() {
                super.interrupt();
                StateMachine.this.mRun = false;
                StateMachine.this.mEvent.setEvent(-2);
            }
        });
    }

    public void dispose() {
        this.clearQueue();
        this.mThreadContainer.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean cancelWaitingJobs() {
        Object object = this.mLockQueue;
        synchronized (object) {
            for (int i = 0; i < this.mList.size(); ++i) {
                IJob pJob = (IJob)this.mList.get(i);
                if (pJob == null) continue;
                pJob.setCancel(true);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean clearQueue() {
        this.mUniComm.clearQueue();
        this.cancelWaitingJobs();
        Object object = this.mLockQueue;
        synchronized (object) {
            this.mList.clear();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Vector<IJob> queue = new Vector<IJob>();
        Vector<IJob> unicomQueue = new Vector<IJob>();
        while (this.mRun) {
            int i;
            if (this.mEvent.waitAll(this.mTimeout) == -2) {
                this.mRun = false;
                break;
            }
            Object object = this.mLockQueue;
            synchronized (object) {
                for (int i2 = 0; i2 < this.mList.size(); ++i2) {
                    IJob pJob = (IJob)this.mList.get(i2);
                    if (pJob == null) continue;
                    queue.addElement(pJob);
                }
            }
            for (i = 0; i < queue.size(); ++i) {
                IJob pJob = (IJob)queue.elementAt(i);
                if (pJob.getCancel() && (pJob.getState() == JobStateEnum.jobWaiting || pJob.getState() == JobStateEnum.jobReadyToWork || pJob.getState() == JobStateEnum.jobReadyToCommunicate)) {
                    pJob.setState(JobStateEnum.jobCancelling);
                }
                if (pJob.getState() == JobStateEnum.jobWaiting) {
                    pJob.onTick();
                }
                if (pJob.getState() == JobStateEnum.jobReadyToWork) {
                    pJob.onStartWork();
                }
                if (pJob.getState() != JobStateEnum.jobReadyToCommunicate) continue;
                pJob.onStartCommunication();
                pJob.setState(JobStateEnum.jobStartedCommunicaton);
                unicomQueue.addElement(pJob);
            }
            if (!unicomQueue.isEmpty()) {
                this.mUniComm.addJobs(unicomQueue);
                unicomQueue.removeAllElements();
            }
            for (i = 0; i < queue.size(); ++i) {
                Object object2;
                IJob pJob = (IJob)queue.elementAt(i);
                if (pJob.getState() == JobStateEnum.jobCancelling) {
                    pJob.onCancel();
                }
                if (pJob.getState() == JobStateEnum.jobFinishedCommunicaton) {
                    pJob.onFinishCommunication();
                }
                if (pJob.getState() == JobStateEnum.jobReschedule) {
                    object2 = this.mLockQueue;
                    synchronized (object2) {
                        this.mList.remove(pJob);
                        this.mList.add(pJob);
                    }
                    pJob.onReschedule();
                }
                if (pJob.getState() != JobStateEnum.jobDestroy) continue;
                object2 = this.mLockQueue;
                synchronized (object2) {
                    this.mList.remove(pJob);
                }
                pJob.onDestroy();
            }
            queue.removeAllElements();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addJob(IJob aJob) {
        Object object = this.mLockQueue;
        synchronized (object) {
            return this.mList.add(aJob);
        }
    }
}

