/*
 * Decompiled with CFR 0.152.
 */
package com.fxcm.messaging.util.pdas.statemachine;

import com.fxcm.GenericException;
import com.fxcm.fix.FixObjectFactory;
import com.fxcm.messaging.IMessage;
import com.fxcm.messaging.util.UniversalUserSession;
import com.fxcm.messaging.util.pdas.session.PDasTransportSession;
import com.fxcm.messaging.util.pdas.statemachine.AJob;
import com.fxcm.messaging.util.pdas.statemachine.JobStateEnum;
import com.fxcm.util.logging.Utils;
import org.apache.commons.logging.Log;

public class JobKeepAlive
extends AJob {
    private final Log mLogger = Utils.getLog(JobKeepAlive.class);
    private final Log mTraceMessageLogger = Utils.getLog("develop.trace.message." + UniversalUserSession.class.getName());
    protected long mTestRequestTimeout;
    protected String mRequestID;
    protected IMessage mRequestMsg;
    protected int mUnansweredRequests;

    public JobKeepAlive(PDasTransportSession aDasTransportSession, long aTestRequestTimeout) {
        super(aDasTransportSession);
        this.mTestRequestTimeout = aTestRequestTimeout;
        this.mCommChannelFirst = 0;
        this.mCommChannelLast = 0;
        this.mRequestID = null;
        this.mRequestMsg = null;
        this.mUnansweredRequests = 0;
        this.getTimeInterval(true);
    }

    @Override
    public void onTick() {
        if (this.mSession.getSessionState() == 2) {
            long now = System.currentTimeMillis() - (this.mSession.getLastInActivity() < this.mSession.getLastOutActivity() ? this.mSession.getLastInActivity() : this.mSession.getLastOutActivity());
            if (now > this.mTestRequestTimeout) {
                if (this.getTimeInterval(false) > this.mTestRequestTimeout) {
                    String serverVersion = this.mSession.getServerVersion();
                    if (serverVersion == null || "1.".equals(serverVersion.substring(0, 2))) {
                        if (this.mLogger.isDebugEnabled()) {
                            this.mLogger.debug("PDas server does not support 'SessionKeepAlive' feature. PDas server version is " + serverVersion);
                        }
                        this.setState(JobStateEnum.jobReschedule);
                        return;
                    }
                    this.mLogger.debug("mUnansweredRequests::" + this.mUnansweredRequests);
                    if (this.mUnansweredRequests < 6) {
                        this.setState(JobStateEnum.jobReadyToCommunicate);
                    } else {
                        this.setState(JobStateEnum.jobReschedule);
                        this.mLogger.debug("Keep Alive forced job rescedule 1");
                        this.mSession.onClosed();
                        this.mLogger.debug("Keep Alive forced job rescedule 2");
                    }
                }
            } else if (this.mUnansweredRequests > 0) {
                this.mLogger.debug("reset mUnansweredRequests::" + this.mUnansweredRequests);
                this.mUnansweredRequests = 0;
            }
        }
    }

    @Override
    public void onStartCommunication() {
        this.mRequestID = this.mSession.getNextRequestID();
        this.mRequestMsg = this.mSession.getMessageFactory().createMessage(this.mSession.getSessionID(), "1");
        this.mRequestMsg.setSessionID(this.mSession.getSessionID());
        this.mRequestMsg.setValue("336", this.mSession.getTradingSessionID());
        this.mRequestMsg.setValue("625", this.mSession.getTradingSessionSubID());
        this.mRequestMsg.setValue("112", this.mRequestID);
        String sign = this.mSession.getRequestSignature(this.mRequestID);
        if (sign != null) {
            this.mRequestMsg.setValue("9097", sign);
        }
        this.mLogger.debug("JobKeepAlive.onStartCommunication() sending = " + this.mRequestMsg);
        this.mSession.setLastOutActivity(System.currentTimeMillis());
    }

    @Override
    public boolean onAcceptResponse(IMessage aResponse, String aRID) {
        this.mLogger.debug("JobKeepAlive.onAcceptResponse()");
        if (aRID != null && aRID.equalsIgnoreCase(this.mRequestID)) {
            this.mUnansweredRequests = 0;
            return true;
        }
        return false;
    }

    @Override
    public void onFinishCommunication() {
        this.mLogger.debug("JobKeepAlive.onFinishCommunication() sent = " + this.mRequestMsg);
        if (this.mTraceMessageLogger.isTraceEnabled()) {
            this.mTraceMessageLogger.trace("out >>> " + FixObjectFactory.toObject(this.mRequestMsg));
        }
        this.setState(JobStateEnum.jobReschedule);
    }

    @Override
    public void onReschedule() {
        this.mLogger.debug("JobKeepAlive.onReschedule()");
        this.getTimeInterval(true);
        this.setState(JobStateEnum.jobWaiting);
    }

    @Override
    public void onSendRequest() {
        ++this.mUnansweredRequests;
        this.setState(JobStateEnum.jobWaitingForResponse);
    }

    @Override
    public IMessage getRequest() {
        return this.mRequestMsg;
    }

    @Override
    public void onStartWork() {
    }

    @Override
    public void onError(GenericException aException) {
    }
}

