/*
 * Decompiled with CFR 0.152.
 */
package com.fxcm.messaging.util.pdas.statemachine;

import com.fxcm.GenericException;
import com.fxcm.messaging.IMessage;
import com.fxcm.messaging.util.pdas.session.PDasTransportSession;
import com.fxcm.messaging.util.pdas.statemachine.AJob;
import com.fxcm.messaging.util.pdas.statemachine.JobStateEnum;

public class JobDasRequest
extends AJob {
    private String mRequestID;
    private IMessage mRequestMsg;
    private IMessage mResponseMsg;

    public JobDasRequest(PDasTransportSession aDasTransportSession, IMessage aRequestMsg) {
        super(aDasTransportSession);
        this.mRequestMsg = aDasTransportSession.getMessageFactory().createMessage(aRequestMsg);
        this.mRequestID = this.mRequestMsg.getValueString("112");
        String sign = this.mSession.getRequestSignature(this.mRequestID);
        if (sign != null) {
            this.mRequestMsg.setValue("9097", sign);
        }
        this.mResponseMsg = null;
        this.setState(JobStateEnum.jobReadyToCommunicate);
    }

    @Override
    public void onStartCommunication() {
        this.mRequestMsg.setSessionID(this.mSession.getSessionID());
        this.mRequestMsg.setValue("336", this.mSession.getTradingSessionID());
        this.mRequestMsg.setValue("625", this.mSession.getTradingSessionSubID());
        this.setState(JobStateEnum.jobWaitingForResponse);
    }

    @Override
    public boolean onAcceptResponse(IMessage aResponse, String aRID) {
        if (aRID != null && this.mRequestID.equalsIgnoreCase(aRID)) {
            this.mResponseMsg = aResponse;
            return true;
        }
        return false;
    }

    @Override
    public void onFinishCommunication() {
        this.setState(JobStateEnum.jobDone);
    }

    @Override
    public IMessage getRequest() {
        return this.mRequestMsg;
    }

    public IMessage getResponse() {
        return this.mResponseMsg;
    }

    @Override
    public void onError(GenericException aException) {
        this.mResponseMsg = this.mSession.getMessageFactory().createMessage(this.mSession.getSessionID(), "BF");
        this.mResponseMsg.setValue("336", this.mSession.getTradingSessionID());
        this.mResponseMsg.setValue("625", this.mSession.getTradingSessionSubID());
        this.mResponseMsg.setValue("112", this.mRequestMsg.getValueString("112"));
        this.mResponseMsg.setValue("9028", this.mRequestMsg.getValueInt("9028"));
        this.mResponseMsg.setValue("926", 2);
        this.mResponseMsg.setValue("927", aException.getMessage());
    }

    @Override
    public void onReschedule() {
    }

    @Override
    public void onStartWork() {
    }

    @Override
    public void onTick() {
    }
}

