/*
 * Decompiled with CFR 0.152.
 */
package com.fxcm.messaging.util.pdas.statemachine;

import com.fxcm.GenericException;
import com.fxcm.messaging.IFieldGroup;
import com.fxcm.messaging.IFieldGroupList;
import com.fxcm.messaging.IMessage;
import com.fxcm.messaging.util.pdas.session.PDasTransportSession;
import com.fxcm.messaging.util.pdas.statemachine.AJob;
import com.fxcm.messaging.util.pdas.statemachine.JobStateEnum;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JobDasPinger
extends AJob {
    private final Log mLogger = LogFactory.getLog(JobDasPinger.class);
    protected long mPingTimeout;
    protected long mPingTimer;
    protected String mRequestID;
    protected IMessage mRequestMsg;

    public JobDasPinger(PDasTransportSession aDasTransportSession, long aPingTimeout) {
        super(aDasTransportSession);
        this.mPingTimeout = aPingTimeout;
        this.mPingTimer = aPingTimeout;
        this.mRequestID = null;
        this.mRequestMsg = null;
        this.getTimeInterval(true);
    }

    @Override
    public void onTick() {
        if (this.mSession.getSessionState() == 2) {
            this.mPingTimer -= this.getTimeInterval(true);
            if (this.mPingTimer <= 0L) {
                this.mLogger.debug("onTick()");
                this.setState(JobStateEnum.jobReadyToCommunicate);
            }
        }
    }

    @Override
    public void onStartCommunication() {
        this.mLogger.debug("onStartCommunication() start");
        this.mRequestID = this.mSession.getNextRequestID();
        this.mRequestMsg = this.mSession.getMessageFactory().createMessage(this.mSession.getSessionID(), "U54");
        this.mRequestMsg.setSessionID(this.mSession.getSessionID());
        this.mRequestMsg.setValue("336", this.mSession.getTradingSessionID());
        this.mRequestMsg.setValue("625", this.mSession.getTradingSessionSubID());
        this.mRequestMsg.setValue("112", this.mRequestID);
        this.mRequestMsg.setValue("9028", "37");
        String sign = this.mSession.getRequestSignature(this.mRequestID);
        if (sign != null) {
            this.mRequestMsg.setValue("9097", sign);
        }
        IFieldGroupList list = this.mSession.getMessageFactory().createFieldGroupList();
        IFieldGroup group = this.mSession.getMessageFactory().createFieldGroup();
        group.setValue("9017", "BrcastID");
        group.setValue("9018", this.mSession.getBrcastID());
        list.put(group);
        group = this.mSession.getMessageFactory().createFieldGroup();
        group.setValue("9017", "MsgID");
        group.setValue("9018", this.mSession.getMsgID());
        list.put(group);
        group = this.mSession.getMessageFactory().createFieldGroup();
        group.setValue("9017", "MailID");
        group.setValue("9018", this.mSession.getMailID());
        list.put(group);
        this.mRequestMsg.setValue("9016", list);
        this.mSession.setLastOutActivity(System.currentTimeMillis());
        this.mLogger.debug("onStartCommunication() finish");
    }

    @Override
    public boolean onAcceptResponse(IMessage aResponse, String aRID) {
        this.mLogger.debug("onAcceptResponse()");
        return aRID != null && this.mRequestID.equalsIgnoreCase(aRID);
    }

    @Override
    public void onFinishCommunication() {
        this.mLogger.debug("onFinishCommunication()");
        this.mPingTimer = this.mPingTimeout;
        this.setState(JobStateEnum.jobReschedule);
    }

    @Override
    public void onReschedule() {
        this.mLogger.debug("onReschedule()");
        this.setState(JobStateEnum.jobWaiting);
    }

    @Override
    public IMessage getRequest() {
        return this.mRequestMsg;
    }

    @Override
    public void onStartWork() {
    }

    @Override
    public void onError(GenericException aException) {
    }
}

