/*
 * Decompiled with CFR 0.152.
 */
package com.fxcm.messaging.util.pdas.statemachine;

import com.fxcm.GenericException;
import com.fxcm.messaging.IFieldGroup;
import com.fxcm.messaging.IFieldGroupList;
import com.fxcm.messaging.IMessage;
import com.fxcm.messaging.util.pdas.session.PDasTransportSession;
import com.fxcm.messaging.util.pdas.statemachine.AJob;
import com.fxcm.messaging.util.pdas.statemachine.JobStateEnum;
import com.fxcm.util.Util;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JobDasMessage
extends AJob {
    private final Log mLogger = LogFactory.getLog(JobDasMessage.class);
    public static final int IBRCAST_ID = 0;
    public static final int IMSG_ID = 1;
    public static final int IMAIL_ID = 2;
    protected long mPullingInterval;
    protected long mPullSticking;
    protected long mPullTimer;
    protected String mRequestID;
    protected IMessage mRequestMsg;

    public JobDasMessage(PDasTransportSession aDasTransportSession, long aPullingInterval, long aPullSticking) {
        super(aDasTransportSession);
        this.mPullingInterval = aPullingInterval;
        this.mPullSticking = aPullSticking;
        this.mCommChannelFirst = 0;
        this.mCommChannelLast = 0;
        this.mPullTimer = this.mPullingInterval;
        this.mRequestID = null;
        this.mRequestMsg = null;
        this.getTimeInterval(true);
    }

    @Override
    public void onTick() {
        if (this.mSession.getSessionState() == 2) {
            this.mPullTimer -= this.getTimeInterval(true);
            if (this.mPullTimer <= 0L) {
                this.setState(JobStateEnum.jobReadyToCommunicate);
            }
        }
    }

    @Override
    public void onStartCommunication() {
        this.mLogger.debug("JobDasMessage::onStartCommunication() start");
        this.mRequestID = this.mSession.getNextRequestID();
        this.mRequestMsg = this.mSession.getMessageFactory().createMessage(this.mSession.getSessionID(), "U54");
        this.mRequestMsg.setSessionID(this.mSession.getSessionID());
        this.mRequestMsg.setValue("336", this.mSession.getTradingSessionID());
        this.mRequestMsg.setValue("625", this.mSession.getTradingSessionSubID());
        this.mRequestMsg.setValue("112", this.mRequestID);
        this.mRequestMsg.setValue("9028", "0");
        String sign = this.mSession.getRequestSignature(this.mRequestID);
        if (sign != null) {
            this.mRequestMsg.setValue("9097", sign);
        }
        if (this.mPullSticking > 0L) {
            this.mRequestMsg.setValue("WaitTime", this.mPullSticking);
        }
        IFieldGroupList list = this.mSession.getMessageFactory().createFieldGroupList();
        IFieldGroup group = this.mSession.getMessageFactory().createFieldGroup();
        group.setValue("9017", "BrcastID");
        group.setValue("9018", this.mSession.getBrcastID());
        list.put(group);
        group = this.mSession.getMessageFactory().createFieldGroup();
        group.setValue("9017", "MsgID");
        group.setValue("9018", this.mSession.getMsgID());
        list.put(group);
        group = this.mSession.getMessageFactory().createFieldGroup();
        group.setValue("9017", "MailID");
        group.setValue("9018", this.mSession.getMailID());
        list.put(group);
        group = this.mSession.getMessageFactory().createFieldGroup();
        group.setValue("9017", "MessageFlags");
        group.setValue("9018", Long.toString(this.mSession.getConParams().mlMsgFlags));
        list.put(group);
        String pollVal = this.mSession.getParameter("POLL_INSTRUMENT");
        if (pollVal != null && pollVal.length() > 0) {
            this.mLogger.debug("POLL_INSTRUMENT = " + pollVal);
            group = this.mSession.getMessageFactory().createFieldGroup();
            group.setValue("9017", "POLL_INSTRUMENT");
            group.setValue("9018", pollVal);
            list.put(group);
        }
        group = this.mSession.getMessageFactory().createFieldGroup();
        group.setValue("9017", "TimeOut");
        group.setValue("9018", this.mPullSticking);
        list.put(group);
        this.mRequestMsg.setValue("9016", list);
        this.mLogger.debug("JobDasMessage::onStartCommunication() finish");
    }

    @Override
    public boolean onAcceptResponse(IMessage aResponse, String aRID) {
        if (aRID != null && this.mRequestID.equalsIgnoreCase(aRID)) {
            String msgType = aResponse.getValueString("35");
            if (msgType != null && msgType.equals("U60")) {
                String sDasLikeMessage;
                String forceGetMessages = aResponse.getValueString("9011");
                if (forceGetMessages != null) {
                    this.mPullTimer = Integer.parseInt(forceGetMessages);
                }
                if ((sDasLikeMessage = aResponse.getValueString("58")) == null) {
                    return true;
                }
                StringTokenizer lines = new StringTokenizer(sDasLikeMessage, "\n");
                if (lines.countTokens() == 0) {
                    return true;
                }
                for (int i = 0; lines.hasMoreTokens() && i < 1; ++i) {
                    String sLine = lines.nextToken().trim();
                    if (sLine.length() == 1) {
                        if (lines.hasMoreTokens()) {
                            sLine = lines.nextToken();
                        } else {
                            return true;
                        }
                    }
                    if (i != 0) continue;
                    String[] header = Util.splitToArray(sLine, ";");
                    if (header.length == 0) {
                        return true;
                    }
                    this.mSession.onReceiving(0);
                    String[] fields = new String[3];
                    if (header.length > 2) {
                        fields[0] = header[2];
                    }
                    if (header.length > 3) {
                        fields[1] = header[3];
                    }
                    if (header.length > 4) {
                        fields[2] = header[4];
                    }
                    if (fields[0] != null && fields[1] != null) {
                        this.mSession.setBrcastID(fields[0]);
                        this.mSession.setMsgID(fields[1]);
                        this.mSession.setMailID(fields[2]);
                        continue;
                    }
                    return true;
                }
                this.mSession.onReceived(0);
            } else {
                this.mLogger.debug("JobDasMessage::!!! Not a DASMESSAGE");
            }
            this.mSession.receiveMessage(aResponse);
            return true;
        }
        return false;
    }

    @Override
    public void onFinishCommunication() {
        this.mLogger.debug("onFinishCommunication()");
        this.setState(JobStateEnum.jobReschedule);
    }

    @Override
    public void onReschedule() {
        this.mLogger.debug("onReschedule()");
        if (this.mPullTimer < 0L) {
            this.mPullTimer = this.mPullingInterval;
        }
        this.setState(JobStateEnum.jobWaiting);
    }

    @Override
    public IMessage getRequest() {
        return this.mRequestMsg;
    }

    public void force(long aDelay) {
        if (aDelay < this.mPullTimer) {
            this.mPullTimer = aDelay;
        }
    }

    @Override
    public void onStartWork() {
    }

    @Override
    public void onError(GenericException aException) {
    }
}

