/*
 * Decompiled with CFR 0.152.
 */
package com.fxcm.messaging.util.pdas.statemachine;

import com.fxcm.GenericException;
import com.fxcm.messaging.IFieldGroup;
import com.fxcm.messaging.IFieldGroupList;
import com.fxcm.messaging.IMessage;
import com.fxcm.messaging.IMessageFactory;
import com.fxcm.messaging.util.pdas.session.PDasTransportSession;
import com.fxcm.messaging.util.pdas.statemachine.AJob;
import com.fxcm.messaging.util.pdas.statemachine.JobStateEnum;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JobDasCommand
extends AJob {
    private final Log mLogger = LogFactory.getLog(JobDasCommand.class);
    private String mRequestID;
    private int mFXCMCommandID;
    private IMessage mRequestMsg;

    public JobDasCommand(PDasTransportSession aDasTransportSession, IMessage aRequestMsg) {
        super(aDasTransportSession);
        this.mRequestMsg = aDasTransportSession.getMessageFactory().createMessage(aRequestMsg);
        this.mRequestID = this.mRequestMsg.getValueString("112");
        this.mFXCMCommandID = this.mRequestMsg.getValueInt("9028");
        this.mRequestMsg.setValue("336", this.mSession.getTradingSessionID());
        this.mRequestMsg.setValue("625", this.mSession.getTradingSessionSubID());
        String sign = this.mSession.getRequestSignature(this.mRequestID);
        if (sign != null) {
            this.mRequestMsg.setValue("9097", sign);
        }
        if (this.mFXCMCommandID == 37) {
            this.setState(JobStateEnum.jobReadyToWork);
        } else {
            this.setState(JobStateEnum.jobReadyToCommunicate);
        }
        if (this.mLogger.isDebugEnabled()) {
            this.mLogger.debug("JobDasCommand Request: \n" + this.mRequestMsg);
        }
    }

    public int getCommandID() {
        return this.mFXCMCommandID;
    }

    @Override
    public void onStartWork() {
        IMessage pResponseMsg = this.mSession.getMessageFactory().createMessage(this.mSession.getSessionID(), "U55");
        pResponseMsg.setValue("336", this.mSession.getTradingSessionID());
        pResponseMsg.setValue("625", this.mSession.getTradingSessionSubID());
        pResponseMsg.setValue("112", this.mRequestMsg.getValueString("112"));
        pResponseMsg.setValue("9028", this.mRequestMsg.getValueInt("9028"));
        IFieldGroupList list = this.mSession.getMessageFactory().createFieldGroupList();
        IFieldGroup group = this.mSession.getMessageFactory().createFieldGroup();
        group.setValue("9017", "DAS");
        group.setValue("9018", "0\n");
        list.put(group);
        pResponseMsg.setValue("9016", list);
        this.mSession.receiveMessage(pResponseMsg);
        this.setState(JobStateEnum.jobDestroy);
    }

    @Override
    public void onStartCommunication() {
        this.mSession.setLastOutActivity(System.currentTimeMillis());
    }

    @Override
    public boolean onAcceptResponse(IMessage aResponse, String aRID) {
        if (aRID != null && aRID.equals(this.mRequestID)) {
            if (this.mLogger.isDebugEnabled()) {
                this.mLogger.debug("JobDasCommand Response: \n" + aResponse);
            }
            this.mSession.receiveMessage(aResponse);
            return true;
        }
        return false;
    }

    @Override
    public void onFinishCommunication() {
        if (this.mSession != null) {
            this.mSession.force();
        }
        this.setState(JobStateEnum.jobDestroy);
    }

    @Override
    public IMessage getRequest() {
        return this.mRequestMsg;
    }

    @Override
    public void onCancel() {
        this.onError(new GenericException("0001: Request cancelled"));
        this.setState(JobStateEnum.jobDestroy);
    }

    @Override
    public void onError(GenericException aException) {
        if (this.getState().intValue() > JobStateEnum.jobWaitingForResponse.intValue()) {
            return;
        }
        IMessageFactory factory = this.mSession.getMessageFactory();
        IMessage pResponseMsg = factory.createMessage(this.mSession.getSessionID(), "U52");
        pResponseMsg.setValue("336", this.mSession.getTradingSessionID());
        pResponseMsg.setValue("625", this.mSession.getTradingSessionSubID());
        pResponseMsg.setValue("112", this.mRequestMsg.getValueString("112"));
        pResponseMsg.setValue("9028", this.mRequestMsg.getValueInt("9028"));
        if (this.mRequestMsg.getValueString("262") != null) {
            IFieldGroupList list = factory.createFieldGroupList();
            IFieldGroup group = factory.createFieldGroup();
            group.setValue("9017", "LIST_ID");
            group.setValue("9018", this.mRequestMsg.getValueString("262"));
            list.put(group);
            pResponseMsg.setValue("9016", list);
        }
        pResponseMsg.setValue("9025", -1);
        pResponseMsg.setValue("58", aException.getMessage());
        pResponseMsg.setValue("9029", aException.getMessage());
        this.mSession.receiveMessage(pResponseMsg);
    }

    @Override
    public void onReschedule() {
    }

    @Override
    public void onTick() {
    }
}

