/*
 * Decompiled with CFR 0.152.
 */
package com.fxcm.messaging.util.pdas.statemachine;

import com.fxcm.GenericException;
import com.fxcm.messaging.IMessage;
import com.fxcm.messaging.IMessageFactory;
import com.fxcm.messaging.util.pdas.session.PDasTransportSession;
import com.fxcm.messaging.util.pdas.statemachine.AJob;
import com.fxcm.messaging.util.pdas.statemachine.JobStateEnum;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JobAsyncUserRequest
extends AJob {
    private final Log mLogger = LogFactory.getLog(JobAsyncUserRequest.class);
    private String mRequestID;
    private int mUserRequestType;
    private IMessage mRequestMsg;

    public JobAsyncUserRequest(PDasTransportSession aDasTransportSession, IMessage aRequestMsg) {
        super(aDasTransportSession);
        this.mRequestMsg = aDasTransportSession.getMessageFactory().createMessage(aRequestMsg);
        this.mRequestID = this.mRequestMsg.getValueString("923");
        this.mUserRequestType = this.mRequestMsg.getValueInt("924");
        this.mRequestMsg.setValue("336", this.mSession.getTradingSessionID());
        this.mRequestMsg.setValue("625", this.mSession.getTradingSessionSubID());
        String sign = this.mSession.getRequestSignature(this.mRequestID);
        if (sign != null) {
            this.mRequestMsg.setValue("9097", sign);
        }
        this.setState(JobStateEnum.jobReadyToCommunicate);
        if (this.mLogger.isDebugEnabled()) {
            this.mLogger.debug("JobAsyncUserRequest Request: \n" + this.mRequestMsg);
        }
    }

    @Override
    public void onStartWork() {
    }

    @Override
    public void onStartCommunication() {
        this.mSession.setLastOutActivity(System.currentTimeMillis());
    }

    @Override
    public boolean onAcceptResponse(IMessage aResponse, String aRID) {
        if (aRID != null && aRID.equals(this.mRequestID)) {
            if (this.mLogger.isDebugEnabled()) {
                this.mLogger.debug("JobAsyncUserRequest Response: \n" + aResponse);
            }
            this.mSession.receiveMessage(aResponse);
            return true;
        }
        return false;
    }

    @Override
    public void onFinishCommunication() {
        if (this.mSession != null) {
            this.mSession.force();
        }
        this.setState(JobStateEnum.jobDestroy);
    }

    @Override
    public IMessage getRequest() {
        return this.mRequestMsg;
    }

    @Override
    public void onCancel() {
        this.onError(new GenericException("0001: Request cancelled"));
        this.setState(JobStateEnum.jobDestroy);
    }

    @Override
    public void onError(GenericException aException) {
        if (this.getState().intValue() > JobStateEnum.jobWaitingForResponse.intValue()) {
            return;
        }
        IMessageFactory factory = this.mSession.getMessageFactory();
        IMessage pResponseMsg = factory.createMessage(this.mSession.getSessionID(), "BF");
        pResponseMsg.setValue("336", this.mSession.getTradingSessionID());
        pResponseMsg.setValue("625", this.mSession.getTradingSessionSubID());
        pResponseMsg.setValue("923", this.mRequestMsg.getValueString("923"));
        pResponseMsg.setValue("924", this.mRequestMsg.getValueString("924"));
        pResponseMsg.setValue("926", 6);
        pResponseMsg.setValue("927", aException.getMessage());
        this.mSession.receiveMessage(pResponseMsg);
    }

    @Override
    public void onReschedule() {
    }

    @Override
    public void onTick() {
    }
}

