/*
 * Decompiled with CFR 0.152.
 */
package com.fxcm.messaging.util.pdas.statemachine;

import com.fxcm.messaging.util.pdas.Event;
import com.fxcm.messaging.util.pdas.session.PDasTransportSession;
import com.fxcm.messaging.util.pdas.statemachine.IJob;
import com.fxcm.messaging.util.pdas.statemachine.JobStateEnum;
import com.fxcm.messaging.util.pdas.statemachine.PriorityEnum;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AJob
implements IJob {
    private final Log mLogger = LogFactory.getLog(AJob.class);
    protected PDasTransportSession mSession;
    protected JobStateEnum mJobState;
    protected PriorityEnum mPriority;
    protected int mCommChannelFirst;
    protected int mCommChannelLast;
    private Event mJobExecWaitEvent;
    private final Object mStateLock;
    private boolean mCancelled;
    private long mLastTime;

    @Override
    public void onDestroy() {
        this.mLogger.debug("onDestroy() " + this.getRequest());
    }

    @Override
    public void onCancel() {
        this.mLogger.debug("onCancel() " + this.getRequest());
    }

    protected AJob(PDasTransportSession aDasTransportSession) {
        this.mSession = aDasTransportSession;
        this.mJobState = JobStateEnum.jobWaiting;
        this.mPriority = PriorityEnum.prioLow;
        this.mCommChannelFirst = 1;
        this.mCommChannelLast = -1;
        this.mJobExecWaitEvent = Event.synchronizeEvent();
        this.mStateLock = new Object();
        this.mLastTime = 0L;
        this.mCancelled = false;
    }

    @Override
    public void onSendRequest() {
        this.setState(JobStateEnum.jobWaitingForResponse);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JobStateEnum getState() {
        Object object = this.mStateLock;
        synchronized (object) {
            return this.mJobState;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JobStateEnum setState(JobStateEnum aJobState) {
        Object object = this.mStateLock;
        synchronized (object) {
            JobStateEnum prevState = this.getState();
            this.mJobState = aJobState;
            if (this.mLogger.isDebugEnabled()) {
                String s = null;
                if (this.getRequest() != null) {
                    s = this.getRequest().getMsgType() + " " + this.getRequest().getValueString("112");
                }
                this.mLogger.debug("State Change: " + aJobState.getType() + " " + s);
            }
            this.mJobExecWaitEvent.setEvent(aJobState.intValue());
            return prevState;
        }
    }

    @Override
    public PriorityEnum getPriority() {
        return this.mPriority;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean wait(JobStateEnum aJobState, long aTimeOut, boolean aSetCancel) {
        int state = this.mJobState.intValue();
        do {
            if (state == aJobState.intValue()) {
                return true;
            }
            state = this.mJobExecWaitEvent.waitAll(aTimeOut);
            if (state != -2) continue;
            return false;
        } while (state != -1);
        Object object = this.mStateLock;
        synchronized (object) {
            if (this.mJobState == aJobState) {
                return true;
            }
            this.setCancel(aSetCancel);
        }
        return false;
    }

    protected long getTimeInterval(boolean abReset) {
        long time = System.currentTimeMillis();
        long ret = time >= this.mLastTime ? time - this.mLastTime : time + 0L - this.mLastTime;
        if (abReset) {
            this.mLastTime = time;
        }
        return ret;
    }

    @Override
    public void setCancel(boolean aCancel) {
        this.mCancelled = aCancel;
        this.mJobExecWaitEvent.setEvent(-2);
    }

    @Override
    public boolean getCancel() {
        return this.mCancelled;
    }

    @Override
    public int getCommChannelFirst() {
        return this.mCommChannelFirst;
    }

    @Override
    public int getCommChannelLast() {
        return this.mCommChannelLast;
    }
}

