/*
 * Decompiled with CFR 0.152.
 */
package com.fxcm.messaging.util.pdas.session;

import com.fxcm.GenericException;
import com.fxcm.messaging.IFieldGroup;
import com.fxcm.messaging.IFieldGroupList;
import com.fxcm.messaging.IMessage;
import com.fxcm.messaging.IMessageFactory;
import com.fxcm.messaging.TradingSessionDesc;
import com.fxcm.messaging.util.AuthenticationException;
import com.fxcm.messaging.util.CommunicationException;
import com.fxcm.messaging.util.ConParams;
import com.fxcm.messaging.util.ITransportProvider;
import com.fxcm.messaging.util.ITransportSessionEx;
import com.fxcm.messaging.util.pdas.PDasMessageFactory;
import com.fxcm.messaging.util.pdas.TransportProvider;
import com.fxcm.messaging.util.pdas.communicator.ICommStatusListener;
import com.fxcm.messaging.util.pdas.communicator.IMessageReceiver;
import com.fxcm.messaging.util.pdas.communicator.ISessionStatusReceiver;
import com.fxcm.messaging.util.pdas.communicator.UniComm;
import com.fxcm.messaging.util.pdas.session.SessionParams;
import com.fxcm.messaging.util.pdas.session.TradingSessionDescEx;
import com.fxcm.messaging.util.pdas.statemachine.AJob;
import com.fxcm.messaging.util.pdas.statemachine.JobAsyncUserRequest;
import com.fxcm.messaging.util.pdas.statemachine.JobDasCommand;
import com.fxcm.messaging.util.pdas.statemachine.JobDasMessage;
import com.fxcm.messaging.util.pdas.statemachine.JobDasPinger;
import com.fxcm.messaging.util.pdas.statemachine.JobDasRequest;
import com.fxcm.messaging.util.pdas.statemachine.JobKeepAlive;
import com.fxcm.messaging.util.pdas.statemachine.JobStateEnum;
import com.fxcm.messaging.util.pdas.statemachine.StateMachine;
import com.fxcm.messaging.util.versioning.FXCMVersion;
import com.fxcm.util.Base64t;
import com.fxcm.util.Util;
import com.fxcm.util.logging.Utils;
import java.net.InetAddress;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.commons.logging.Log;

public abstract class PDasTransportSession
extends SessionParams
implements ISessionStatusReceiver,
ICommStatusListener,
IMessageReceiver,
ITransportSessionEx {
    private final Log mLogger = Utils.getLog(PDasTransportSession.class);
    private static long ciStartTick = System.currentTimeMillis();
    protected final UniComm mUniComm;
    protected final StateMachine mStateMachine;
    protected final ConParams mConParams;
    protected int mUserKind;
    protected int mUserID;
    protected final Object mStateLock;
    protected final Object mLogonLock;
    protected final Object mLogoutLock;
    protected long mRequestID;
    protected TradingSessionDescEx[] mTSDs;
    protected int mNoReconnectAttempts = 3;
    protected long mReconnectTimeout = 10000L;
    protected final long mLoginTimeout;
    protected long mForceMessagesDelay;
    protected JobDasMessage mJobDasMessage;
    protected JobDasPinger mJobDasPinger;
    protected JobKeepAlive mJobKeepAlive;
    protected String mServerVersion = null;
    protected Properties mParameters = new Properties();
    protected String mTokenKey;
    protected boolean mValidateRequestSignature;

    public static long getTickCount() {
        return System.currentTimeMillis() - ciStartTick;
    }

    protected PDasTransportSession(ConParams aParams) {
        this.mConParams = new ConParams(aParams);
        this.mStateLock = new Object();
        this.mLogonLock = new Object();
        this.mLogoutLock = new Object();
        this.mUniComm = new UniComm(this, this, this.mConParams);
        this.mStateMachine = new StateMachine(this.mUniComm);
        long pullingInterval = Long.parseLong(this.mConParams.getOptionalParameter("polling-interval", "3000"));
        long pullSticking = Long.parseLong(this.mConParams.getOptionalParameter("sticking-time", "0"));
        this.mJobDasMessage = new JobDasMessage(this, pullingInterval, pullSticking);
        this.mStateMachine.addJob(this.mJobDasMessage);
        long pingTimeout = Long.parseLong(this.mConParams.getOptionalParameter("session-ping-interval", "120000"));
        this.mJobDasPinger = new JobDasPinger(this, pingTimeout);
        this.mStateMachine.addJob(this.mJobDasPinger);
        this.mJobKeepAlive = new JobKeepAlive(this, 20000L);
        this.mStateMachine.addJob(this.mJobKeepAlive);
        this.mLoginTimeout = Long.parseLong(this.mConParams.getOptionalParameter("login-timeout", "180000"));
        this.mForceMessagesDelay = Long.parseLong(this.mConParams.getOptionalParameter("force-messages-delay", "500"));
        this.mValidateRequestSignature = "true".equalsIgnoreCase(this.mConParams.getOptionalParameter("validate-request-signature", "false"));
    }

    public void dispose() {
        if (this.mStateMachine != null) {
            this.mStateMachine.dispose();
        }
        this.closeCommunicator();
    }

    @Override
    public ConParams getConParams() {
        return this.mConParams;
    }

    @Override
    public ITransportProvider getTransportProvider() {
        return TransportProvider.getInstance();
    }

    @Override
    public TradingSessionDesc[] retrieveTradingSessions(String aServiceName, String aLoginID, String aPassword) throws GenericException {
        try {
            this.mLogger.debug("pdas: retrieveTradingSessions START");
            this.setTradingSessionID("FXCM");
            this.setTradingSessionSubID(aServiceName);
            this.updateStatus(this.mConParams.msName, "HTTP", this.mConParams.mbUseSecure ? "S" : "", 1, 9, this.mConParams.mbUseSecure);
            if (aServiceName == null || aLoginID == null) {
                this.updateStatus(-2, 4);
                throw new AuthenticationException("Login failed.");
            }
            try {
                this.openCommunicator();
            }
            catch (GenericException ex) {
                this.updateStatus(-2, 4);
                throw ex;
            }
            IMessage pRequestMsg = this.getMessageFactory().createMessage(null, "BE");
            if (this.mLogger.isDebugEnabled()) {
                this.mLogger.debug("pRequestMsg=" + pRequestMsg);
            }
            String pRequestID = this.getNextRequestID();
            pRequestMsg.setValue("923", pRequestID);
            pRequestMsg.setValue("112", pRequestID);
            pRequestMsg.setValue("924", 5);
            pRequestMsg.setValue("553", aLoginID);
            JobDasRequest pJobDasRequest = new JobDasRequest(this, pRequestMsg);
            this.mStateMachine.addJob(pJobDasRequest);
            if (!pJobDasRequest.wait(JobStateEnum.jobDone, this.mLoginTimeout, true)) {
                this.updateStatus(-2, 4);
                throw new AuthenticationException("Login timeout.");
            }
            IMessage pResponseMsg = pJobDasRequest.getResponse();
            pJobDasRequest.setState(JobStateEnum.jobDestroy);
            if (pResponseMsg == null) {
                this.updateStatus(-2, 4);
                throw new AuthenticationException("Login failed.");
            }
            String msgType = pResponseMsg.getValueString("35");
            if (msgType == null || !msgType.equals("BF")) {
                this.updateStatus(-2, 4);
                throw new AuthenticationException("Login failed.");
            }
            int userStatus = pResponseMsg.getValueInt("926");
            String userText = pResponseMsg.getValueString("927");
            if (this.mLogger.isDebugEnabled()) {
                this.mLogger.debug(" retrieveTradingSessions userText=" + userText);
            }
            switch (userStatus) {
                case 1: {
                    ArrayList<TradingSessionDescEx> tdss = new ArrayList<TradingSessionDescEx>();
                    IFieldGroupList sessions = pResponseMsg.getValueList("386");
                    if (sessions != null) {
                        for (IFieldGroup fg : sessions.values()) {
                            String id = fg.getValueString("336");
                            String subid = fg.getValueString("625");
                            String params = fg.getValueString("9018");
                            TradingSessionDescEx tsd = new TradingSessionDescEx(subid + ";" + id + ";" + params);
                            tdss.add(tsd);
                        }
                    }
                    this.mTSDs = new TradingSessionDescEx[tdss.size()];
                    for (int i = 0; i < tdss.size(); ++i) {
                        this.mTSDs[i] = (TradingSessionDescEx)tdss.get(i);
                    }
                    IFieldGroupList grList = pResponseMsg.getValueList("9016");
                    if (grList == null) break;
                    for (IFieldGroup gr : grList.values()) {
                        String aTSDName = gr.getValueString("9017");
                        String string = gr.getValueString("9018");
                    }
                    break;
                }
                default: {
                    this.updateStatus(-2, 4);
                    if (userText == null) break;
                    throw new AuthenticationException(userText);
                }
            }
            if (this.mTSDs == null) {
                this.updateStatus(-2, 4);
                throw new AuthenticationException("Login failed.");
            }
            TradingSessionDesc[] tradingSessionDescArray = this.mTSDs;
            return tradingSessionDescArray;
        }
        catch (Exception e) {
            this.mLogger.error(e.getMessage(), e);
            throw new GenericException(e.getMessage(), e);
        }
        finally {
            this.close();
        }
    }

    private static String toHex(int a) {
        char[] ac = new char[]{a < 10 ? (char)(a + 48) : (char)(a + 97 - 10)};
        return new String(ac);
    }

    @Override
    public String logon(String aServiceName, String aTradingSessionID, String aTradingSessionSubID, String aLoginID, String aPassword, String aStationName, String aExtraParams) throws GenericException {
        if (aPassword == null || aServiceName == null || aLoginID == null) {
            this.updateStatus(-2, 4);
            throw new AuthenticationException("Login failed.");
        }
        IMessage pRequestMsg = this.getMessageFactory().createMessage(null, "BE");
        pRequestMsg.setValue("553", aLoginID);
        pRequestMsg.setValue("554", aPassword);
        return this.logon(pRequestMsg, aServiceName, aTradingSessionID, aTradingSessionSubID, aStationName, aExtraParams);
    }

    @Override
    public String logonSso(String aServiceName, String aTradingSessionID, String aTradingSessionSubID, String aLoginID, String aSsoToken, String aStationName, String aExtraParams) throws GenericException {
        if (aSsoToken == null) {
            this.updateStatus(-2, 4);
            throw new AuthenticationException("Login failed.");
        }
        IMessage pRequestMsg = this.getMessageFactory().createMessage(null, "BE");
        if (aLoginID != null) {
            pRequestMsg.setValue("553", aLoginID);
        }
        pRequestMsg.setValue("556", aSsoToken);
        return this.logon(pRequestMsg, aServiceName, aTradingSessionID, aTradingSessionSubID, aStationName, aExtraParams);
    }

    @Override
    public String logonOpenToken(String aServiceName, String aTradingSessionID, String aTradingSessionSubID, String aOpenToken, String aStationName, String aExtraParams) throws GenericException {
        if (aOpenToken == null || aServiceName == null) {
            this.updateStatus(-2, 4);
            throw new AuthenticationException("Login failed.");
        }
        IMessage pRequestMsg = this.getMessageFactory().createMessage(null, "BE");
        pRequestMsg.setValue("556", aOpenToken);
        return this.logon(pRequestMsg, aServiceName, aTradingSessionID, aTradingSessionSubID, aStationName, aExtraParams);
    }

    private void setParam(IFieldGroupList grList, Map params, String name, String defaultValue) {
        String value;
        String string = value = params != null ? (String)params.get(name) : null;
        if (value == null) {
            value = defaultValue;
        }
        if (value != null) {
            try {
                IFieldGroup group = this.getMessageFactory().createFieldGroup();
                group.setValue("9017", name);
                group.setValue("9018", value);
                grList.put(group);
            }
            catch (Exception e) {
                this.mLogger.error("", e);
            }
        }
    }

    @Override
    public String logonOpenToken(String aServiceName, String aTradingSessionID, String aTradingSessionSubID, String aOpenToken, String aStationName) throws GenericException {
        return this.logonOpenToken(aServiceName, aTradingSessionID, aTradingSessionSubID, aOpenToken, aStationName, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String logon(IMessage pRequestMsg, String aServiceName, String aTradingSessionID, String aTradingSessionSubID, String aStationName, String aExtraParams) throws GenericException {
        Object object = this.mLogonLock;
        synchronized (object) {
            String pin;
            Map params;
            this.setSessionID(null);
            this.setTradingSessionID(aTradingSessionID);
            this.setTradingSessionSubID(aTradingSessionSubID);
            TradingSessionDescEx tsd = TradingSessionDescEx.getTSDBySubID(this.mTSDs, aTradingSessionSubID);
            if (tsd != null && (params = tsd.getProperties()) != null) {
                for (String sName : params.keySet()) {
                    String sValue = (String)params.get(sName);
                    if (sName == null || sValue == null) continue;
                    this.mUniComm.setParam(sName, sValue);
                }
            }
            this.mUserKind = 0;
            this.mUserID = 0;
            this.updateStatus(this.mConParams.msName, "HTTP", this.mConParams.mbUseSecure ? "S" : "", 1, 9, this.mConParams.mbUseSecure);
            try {
                this.openCommunicator();
            }
            catch (GenericException ex) {
                this.updateStatus(-2, 4);
                throw ex;
            }
            String pRequestID = this.getNextRequestID();
            pRequestMsg.setValue("923", pRequestID);
            pRequestMsg.setValue("112", pRequestID);
            pRequestMsg.setValue("924", 1);
            Map params2 = null;
            if (aExtraParams != null) {
                params2 = Util.parseParams(aExtraParams);
            }
            if (this.mLogger.isDebugEnabled()) {
                this.mLogger.debug(" mConParams.getOptionalParamters():\n" + this.mConParams.getOptionalParamters());
                this.mLogger.debug(" given aExtraParams:\n" + params2);
            }
            IFieldGroupList grList = this.getMessageFactory().createFieldGroupList();
            this.setParam(grList, null, "aClientTransport", new FXCMVersion().toString());
            this.setParam(grList, null, "MessageFlags", Long.toString(this.mConParams.mlMsgFlags));
            this.setParam(grList, null, "aRemoteAppName", this.mConParams.getOptionalParameter("com.fxcm.messaging.IConnectionManager.Agent", "JAVA-API"));
            this.setParam(grList, null, "aRemoteAppCode", aStationName);
            this.setParam(grList, params2, "TokenKeyRequired", "true");
            this.setParam(grList, params2, "TokenKey", null);
            this.setParam(grList, params2, "SID", null);
            this.setParam(grList, params2, "aMessageFlag", null);
            this.setParam(grList, params2, "asynch", "yes");
            this.setParam(grList, params2, "EXTRA", null);
            this.setParam(grList, params2, "mdt", null);
            String string = pin = params2 == null ? null : (String)params2.get("PIN");
            if (pin != null) {
                try {
                    MessageDigest mdAlgorithm = MessageDigest.getInstance("MD5");
                    mdAlgorithm.update(pin.getBytes());
                    byte[] bytes = Base64t.encode(mdAlgorithm.digest());
                    this.setParam(grList, null, "aPIN", new String(bytes));
                }
                catch (Exception mdAlgorithm) {
                    // empty catch block
                }
            }
            Object addr = this.mConParams.getOptionalParameter("client-connection-factory", "INCORRECT Hosts.jsp");
            try {
                InetAddress localhostAddr = InetAddress.getLocalHost();
                addr = (String)addr + ";" + localhostAddr.getHostName();
            }
            catch (Exception localhostAddr) {
                // empty catch block
            }
            if (System.getProperty("fcaddr") != null) {
                addr = System.getProperty("fcaddr");
            }
            this.setParam(grList, null, "aRemoteAddress", (String)addr);
            pRequestMsg.setValue("9016", grList);
            JobDasRequest request = new JobDasRequest(this, pRequestMsg);
            boolean ready = false;
            IMessage refreshMsg = null;
            do {
                this.mStateMachine.addJob(request);
                if (!request.wait(JobStateEnum.jobDone, this.mLoginTimeout, true)) {
                    this.updateStatus(-2, 4);
                    throw new AuthenticationException("Login timeout.");
                }
                ready = this.processResponse(request);
                if (this.getSessionID() == null) {
                    this.updateStatus(-2, 4);
                    throw new AuthenticationException("Login Failed");
                }
                long logonPollingInterval = Long.parseLong(this.mConParams.getOptionalParameter("logon-polling-interval", "500"));
                if (ready) continue;
                try {
                    Thread.sleep(logonPollingInterval);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (refreshMsg == null) {
                    refreshMsg = this.getMessageFactory().createMessage(null, "BE");
                    refreshMsg.setValue("553", pRequestMsg.getValueString("553"));
                    refreshMsg.setSessionID(this.getSessionID());
                    refreshMsg.setValue("924", 0);
                }
                pRequestID = this.getNextRequestID();
                refreshMsg.setValue("923", pRequestID);
                refreshMsg.setValue("112", pRequestID);
                request = new JobDasRequest(this, refreshMsg);
            } while (!ready);
            if (this.mLogger.isDebugEnabled()) {
                this.mLogger.debug("Logon SID=" + this.getSessionID());
            }
            this.setLastInActivity(System.currentTimeMillis());
            this.setLastOutActivity(System.currentTimeMillis());
            this.setSessionState(2);
            return this.getSessionID();
        }
    }

    private boolean processResponse(JobDasRequest aJobDasRequest) throws GenericException {
        boolean ret = false;
        IMessage pResponseMsg = this.getMessageFactory().createMessage(aJobDasRequest.getResponse());
        aJobDasRequest.setState(JobStateEnum.jobDestroy);
        if (pResponseMsg == null) {
            this.updateStatus(-2, 4);
            throw new AuthenticationException("Login failed.");
        }
        String msgType = pResponseMsg.getValueString("35");
        if (msgType == null || !msgType.equals("BF")) {
            this.updateStatus(-2, 4);
            throw new AuthenticationException("Login failed.");
        }
        int userStatus = pResponseMsg.getValueInt("926");
        String userText = pResponseMsg.getValueString("927");
        switch (userStatus) {
            case 0: {
                String messageBody;
                ret = true;
                if (userText == null || userText.length() <= 2) break;
                StringTokenizer st = new StringTokenizer(userText, "\r\n");
                if (!st.hasMoreTokens()) {
                    throw new GenericException("Login failed. Unknown format of server response. It is empty");
                }
                st.nextToken();
                if (!st.hasMoreTokens() || (messageBody = st.nextToken()).length() == 0) {
                    throw new GenericException("Login failed. Unknown format of server response. No message body.");
                }
                StringTokenizer semicolonDelemited = new StringTokenizer(messageBody, ";");
                boolean i = false;
                if (!semicolonDelemited.hasMoreTokens()) break;
                String sToken = semicolonDelemited.nextToken().trim();
                if (i) break;
                this.setSessionID(sToken);
                ret = false;
                break;
            }
            case 1: {
                ret = true;
                if (userText != null && userText.length() > 2) {
                    String messageBody;
                    StringTokenizer st = new StringTokenizer(userText, "\r\n");
                    if (!st.hasMoreTokens()) {
                        throw new GenericException("Login failed. Unknown format of server response. It is empty");
                    }
                    st.nextToken();
                    if (!st.hasMoreTokens() || (messageBody = st.nextToken()).length() == 0) {
                        throw new GenericException("Login failed. Unknown format of server response. No message body.");
                    }
                    StringTokenizer semicolonDelemited = new StringTokenizer(messageBody, ";");
                    int i = 0;
                    while (semicolonDelemited.hasMoreTokens()) {
                        String sToken = semicolonDelemited.nextToken().trim();
                        switch (i) {
                            case 0: {
                                this.setSessionID(sToken);
                                break;
                            }
                            case 1: {
                                try {
                                    this.mUserKind = Integer.parseInt(sToken);
                                    break;
                                }
                                catch (NumberFormatException e) {
                                    throw new GenericException("Login failed. Unknown format of server response. Kind.");
                                }
                            }
                            case 2: {
                                try {
                                    this.mUserID = Integer.parseInt(sToken);
                                    break;
                                }
                                catch (NumberFormatException e) {
                                    throw new GenericException("Login failed. Unknown format of server response. Id.");
                                }
                            }
                        }
                        ++i;
                    }
                }
                if (this.getSessionID() != null) {
                    int noParams = 0;
                    IFieldGroupList grList = pResponseMsg.getValueList("9016");
                    if (grList != null) {
                        for (IFieldGroup gr : grList.values()) {
                            String paramName = gr.getValueString("9017");
                            String paramValue = gr.getValueString("9018");
                            if (paramName == null || paramValue == null) continue;
                            if ("pdas".equalsIgnoreCase(paramName)) {
                                this.setServerVersion(paramValue);
                                ++noParams;
                            } else if ("force-messages-delay".equalsIgnoreCase(paramName)) {
                                this.setForceMessagesDelay(paramValue);
                                ++noParams;
                            } else if ("validate-request-signature".equalsIgnoreCase(paramName)) {
                                this.mValidateRequestSignature = "true".equalsIgnoreCase(paramValue);
                                ++noParams;
                            } else if ("TokenKey".equalsIgnoreCase(paramName)) {
                                this.mTokenKey = paramValue;
                                ++noParams;
                            }
                            if (noParams < 4) continue;
                            break;
                        }
                    }
                }
                this.receiveMessage(pResponseMsg);
                break;
            }
            default: {
                ret = true;
                if (userText == null) {
                    userText = "Login Failed";
                }
                throw new AuthenticationException(userText);
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean attach(String aSID, String aTradingSessionID, String aTradingSessionSubID, String aStationName, String aExtraParams) throws GenericException {
        Object object = this.mLogonLock;
        synchronized (object) {
            Map params;
            this.setSessionID(null);
            this.setTradingSessionID(aTradingSessionID);
            this.setTradingSessionSubID(aTradingSessionSubID);
            TradingSessionDescEx tsd = TradingSessionDescEx.getTSDBySubID(this.mTSDs, aTradingSessionSubID);
            if (tsd != null && (params = tsd.getProperties()) != null) {
                for (String sName : params.keySet()) {
                    String sValue = (String)params.get(sName);
                    if (sName == null || sValue == null) continue;
                    this.mUniComm.setParam(sName, sValue);
                }
            }
            this.mUserKind = 0;
            this.mUserID = 0;
            this.updateStatus(this.mConParams.msName, "HTTP", this.mConParams.mbUseSecure ? "S" : "", 1, 9, this.mConParams.mbUseSecure);
            try {
                this.openCommunicator();
            }
            catch (GenericException ex) {
                this.updateStatus(-2, 4);
                throw ex;
            }
            this.setSessionID(aSID);
            this.setLastInActivity(System.currentTimeMillis());
            this.setLastOutActivity(System.currentTimeMillis());
            this.setSessionState(2);
        }
        return true;
    }

    private void processAttachResponse(JobDasRequest aJobDasRequest) throws GenericException {
        IMessage pResponseMsg = this.getMessageFactory().createMessage(aJobDasRequest.getResponse());
        aJobDasRequest.setState(JobStateEnum.jobDestroy);
        if (pResponseMsg == null) {
            this.updateStatus(-2, 4);
            throw new AuthenticationException("Session attach failed.");
        }
        String msgType = pResponseMsg.getValueString("35");
        if (msgType == null || !msgType.equals("BF")) {
            this.updateStatus(-2, 4);
            throw new AuthenticationException("Session attach failed.");
        }
        int userStatus = pResponseMsg.getValueInt("926");
        String userText = pResponseMsg.getValueString("927");
        switch (userStatus) {
            case 1: {
                IFieldGroupList grList;
                if (this.getSessionID() == null || (grList = pResponseMsg.getValueList("9016")) == null) break;
                for (IFieldGroup gr : grList.values()) {
                    String paramName = gr.getValueString("9017");
                    String paramValue = gr.getValueString("9018");
                    if (paramName == null || paramValue == null) continue;
                    if ("pdas".equalsIgnoreCase(paramName)) {
                        this.setServerVersion(paramValue);
                        continue;
                    }
                    if (!"force-messages-delay".equalsIgnoreCase(paramName)) continue;
                    this.setForceMessagesDelay(paramValue);
                }
                break;
            }
            default: {
                if (userText == null) {
                    userText = "Session attach failed.";
                }
                throw new AuthenticationException(userText);
            }
        }
    }

    @Override
    public String logon(String aServiceName, String aTradingSessionID, String aTradingSessionSubID, String aLoginID, String aPassword, String aStationName) throws GenericException {
        return this.logon(aServiceName, aTradingSessionID, aTradingSessionSubID, aLoginID, aPassword, aStationName, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void logout() {
        this.mStateMachine.cancelWaitingJobs();
        this.mLogger.debug("logout start");
        Object object = this.mLogoutLock;
        synchronized (object) {
            if (this.getSessionState() != 2) {
                this.setSessionState(4);
                this.mLogger.debug("logout Exit");
                return;
            }
            this.setSessionState(3);
        }
        if (this.getSessionID() != null) {
            this.updateStatus(5, 13);
            try {
                IMessage pRequestMsg = this.getMessageFactory().createMessage(null, "BE");
                String pRequestID = this.getNextRequestID();
                pRequestMsg.setValue("923", pRequestID);
                pRequestMsg.setValue("112", pRequestID);
                pRequestMsg.setValue("924", 2);
                JobDasRequest pJobDasRequest = new JobDasRequest(this, pRequestMsg);
                this.mStateMachine.addJob(pJobDasRequest);
                pJobDasRequest.wait(JobStateEnum.jobDone, 1000L, true);
                pJobDasRequest.setState(JobStateEnum.jobDestroy);
            }
            catch (Exception e) {
                this.mLogger.debug("logout unhandled exeption", e);
            }
        }
        if (this.getSessionID() != null) {
            this.updateStatus(5, 14);
            this.updateStatus(-1, 14);
            this.setSessionID(null);
        }
        this.dispose();
        this.setSessionState(4);
        this.mLogger.debug("logout end");
    }

    @Override
    public String getSessionID() {
        return super.getSessionID();
    }

    @Override
    public boolean isValid() {
        return !this.isClosed();
    }

    @Override
    public boolean isClosed() {
        return this.mUniComm == null || !this.mUniComm.isOpened();
    }

    @Override
    public void force() {
        if (this.mForceMessagesDelay >= 0L) {
            this.force(this.mForceMessagesDelay);
        }
    }

    public void force(long aDelay) {
        this.mJobDasMessage.force(aDelay);
    }

    @Override
    public String postMessage(IMessage aMessage) throws GenericException {
        String ret = "send error";
        if (this.mUniComm.isOpened()) {
            if (this.getSessionState() == 4 || this.getSessionState() == 3) {
                return ret;
            }
            try {
                aMessage.setSessionID(this.getSessionID());
                this.updateStatus(2, 1);
                AJob job = null;
                job = aMessage.getMsgType().equals("BE") ? new JobAsyncUserRequest(this, aMessage) : new JobDasCommand(this, aMessage);
                this.mStateMachine.addJob(job);
                ret = "Posted to queue";
                this.updateStatus(0, 5);
            }
            catch (Exception e) {
                this.mLogger.debug("Send Unknown exception", e);
                throw new GenericException("Send failed");
            }
        }
        return ret;
    }

    @Override
    public String getNextRequestID() {
        StringBuilder ret = new StringBuilder();
        if (this.getSessionID() != null) {
            ret.append(this.getSessionID() + "-" + this.getNextID());
        } else {
            ret.append("NewSession-");
            ret.append(PDasTransportSession.getTickCount());
            ret.append("-");
            ret.append(Math.abs(ThreadLocalRandom.current().nextInt()));
            ret.append("-");
            ret.append(Thread.currentThread().getName());
        }
        return ret.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getNextID() {
        long val;
        Object object = this.mStateLock;
        synchronized (object) {
            ++this.mRequestID;
            if (this.mRequestID > 0x7FFFFF0L) {
                this.mRequestID = 1L;
            }
            val = this.mRequestID;
        }
        return val;
    }

    @Override
    public void close() {
        this.removeMessageListener(null);
        try {
            if (!this.isClosed()) {
                this.logout();
            }
        }
        catch (Exception e) {
            this.mLogger.debug("close logout unknown exception", e);
        }
        this.removeSessionStatusListener(null);
        this.stop();
        this.dispose();
    }

    protected abstract void stop();

    @Override
    public int getUserKind() {
        return this.mUserKind;
    }

    @Override
    public int getUserID() {
        return this.mUserID;
    }

    @Override
    public IMessageFactory getMessageFactory() {
        return PDasMessageFactory.getInstance();
    }

    public boolean openCommunicator() throws CommunicationException {
        return this.mUniComm.open();
    }

    private boolean closeCommunicator() {
        try {
            if (this.mUniComm != null) {
                this.mUniComm.close();
            }
        }
        catch (Exception e) {
            this.mLogger.debug("closeCommunicator unhandled exception", e);
        }
        return true;
    }

    public void setCommunicatorReconnect(int aNoReconnectAttempts, long aReconnectTimeout) {
        this.mNoReconnectAttempts = aNoReconnectAttempts;
        this.mReconnectTimeout = aReconnectTimeout;
    }

    @Override
    public void onOpening() {
    }

    @Override
    public void onOpened() {
        this.updateStatus(0, 12);
    }

    @Override
    public void onSending() {
        this.updateStatus(2, 1);
    }

    @Override
    public void onSent() {
    }

    @Override
    public void onReceiving() {
        this.updateStatus(3, 0);
    }

    public void onReceiving(int aiStatus) {
        this.updateStatus(3, aiStatus);
    }

    @Override
    public void onReceived() {
        this.updateStatus(0, 5);
    }

    public void onReceived(int aiStatus) {
        this.updateStatus(0, aiStatus);
    }

    @Override
    public void onClosing() {
    }

    @Override
    public void onClosed() {
        this.updateStatus(null, null, null, -1, 14, true);
    }

    @Override
    public void onError(GenericException aException) {
        this.updateStatus(-2, aException.getMessage());
        this.updateStatus(7, 0);
    }

    public String getServerVersion() {
        return this.mServerVersion;
    }

    protected void setServerVersion(String aValue) {
        if (aValue != null) {
            this.mServerVersion = aValue;
        }
    }

    void setForceMessagesDelay(String aValue) {
        long forceMessagesDelay;
        if (aValue != null && ((forceMessagesDelay = Long.parseLong(aValue)) < this.mForceMessagesDelay || this.mForceMessagesDelay < 0L)) {
            this.mForceMessagesDelay = forceMessagesDelay;
        }
    }

    @Override
    public void setParameter(String aName, String aVal) {
        this.mParameters.put(aName, aVal);
    }

    @Override
    public String getParameter(String aName) {
        return this.mParameters.getProperty(aName);
    }

    public String getRequestSignature(String aRequestID) {
        String ret = null;
        if (this.mValidateRequestSignature && this.mTokenKey != null && aRequestID != null) {
            try {
                int i;
                MessageDigest sha = MessageDigest.getInstance("SHA-1");
                byte[] reqDigest = null;
                byte[] request = aRequestID.getBytes();
                byte[] salt = this.mTokenKey.getBytes();
                byte[] reqSalted = new byte[request.length + salt.length];
                for (i = 0; i < request.length; ++i) {
                    reqSalted[i] = request[i];
                }
                for (i = 0; i < salt.length; ++i) {
                    reqSalted[request.length + i] = salt[i];
                }
                reqDigest = sha.digest(reqSalted);
                ret = new String(Base64t.encode(reqDigest));
            }
            catch (NoSuchAlgorithmException nsae) {
                this.mLogger.error("Unable to generate request signature", nsae);
            }
            catch (Exception ee) {
                this.mLogger.error("Unable to generate request signature", ee);
            }
        }
        return ret;
    }
}

