/*
 * Decompiled with CFR 0.152.
 */
package com.fxcm.messaging.util.pdas.session;

import com.fxcm.messaging.IMessage;
import com.fxcm.messaging.ISessionStatus;
import com.fxcm.messaging.util.ConParams;
import com.fxcm.messaging.util.GenericSessionStatus;
import com.fxcm.messaging.util.IMessageListener;
import com.fxcm.messaging.util.ISessionStatusListener;
import com.fxcm.messaging.util.pdas.Event;
import com.fxcm.messaging.util.pdas.ThreadContainer;
import com.fxcm.messaging.util.pdas.session.PDasTransportSession;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PDasSessionAdapter
extends PDasTransportSession
implements Runnable {
    private final Log mLogger = LogFactory.getLog(PDasSessionAdapter.class);
    private Vector mQueue;
    private final Event mQueueNotifier = Event.synchronizeEvent();
    private final Object mListenerLock = new Object();
    private final Object mSessionStateLock = new Object();
    private IMessageListener mMessageListener;
    private ISessionStatusListener mSessionStatusListener;
    private ThreadContainer mThreadContainer;
    protected long mLastTouchIn;
    protected long mLastTouchOut;
    private boolean mRun = true;

    public PDasSessionAdapter(ConParams aParams) {
        super(aParams);
        this.mQueue = new Vector();
        this.mLastTouchIn = System.currentTimeMillis();
        this.mLastTouchOut = System.currentTimeMillis();
        this.mThreadContainer = new ThreadContainer();
        this.mThreadContainer.start(new Thread((Runnable)this){

            @Override
            public void interrupt() {
                super.interrupt();
                PDasSessionAdapter.this.mRun = false;
                PDasSessionAdapter.this.mQueueNotifier.setEvent(-2);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addMessageListener(IMessageListener aListener) {
        Object object = this.mListenerLock;
        synchronized (object) {
            this.mMessageListener = aListener;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeMessageListener(IMessageListener aListener) {
        Object object = this.mListenerLock;
        synchronized (object) {
            this.mMessageListener = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addSessionStatusListener(ISessionStatusListener aListener) {
        Object object = this.mListenerLock;
        synchronized (object) {
            this.mSessionStatusListener = aListener;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeSessionStatusListener(ISessionStatusListener aListener) {
        Object object = this.mListenerLock;
        synchronized (object) {
            this.mSessionStatusListener = null;
        }
    }

    @Override
    public void receiveMessage(IMessage aMsg) {
        this.mQueue.addElement(new QueueElement(aMsg));
        this.updateQueueSize(this.getQueueSize() + 1);
        this.setLastInActivity(System.currentTimeMillis());
        this.mQueueNotifier.setEvent(-3);
    }

    @Override
    public long getLastInActivity() {
        return this.mLastTouchIn;
    }

    @Override
    public void setLastInActivity(long aLastTouchIn) {
        this.mLastTouchIn = aLastTouchIn;
    }

    @Override
    public long getLastOutActivity() {
        return this.mLastTouchOut;
    }

    @Override
    public void setLastOutActivity(long aLastTouchOut) {
        this.mLastTouchOut = aLastTouchOut;
    }

    @Override
    public void updateStatus(int aStatusCode, int aStatusMegID) {
        this.updateStatus(null, null, null, aStatusCode, aStatusMegID, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateStatus(int aStatusCode, String aStatusMessage) {
        GenericSessionStatus statObj = null;
        Object object = this.mSessionStateLock;
        synchronized (object) {
            this.setStatusCode(aStatusCode);
            this.setStatusName(GenericSessionStatus.getStatusName(aStatusCode));
            this.setStatusMessageID(0);
            this.setStatusMessage(aStatusMessage);
            statObj = new GenericSessionStatus(this);
        }
        this.mQueue.addElement(new QueueElement(statObj));
        this.mQueueNotifier.setEvent(-3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateStatus(String aConnName, String aConnProtocol, String aConnSecure, int aStatusCode, int aStatusMegID, boolean aDirect) {
        GenericSessionStatus statObj = null;
        Object object = this.mSessionStateLock;
        synchronized (object) {
            if (aConnName != null) {
                this.setConnectionName(aConnName);
            }
            if (aConnProtocol != null) {
                this.setProtocolName(aConnProtocol);
            }
            if (aConnSecure != null) {
                this.setSecureProtocolString(aConnSecure);
            }
            this.setStatusCode(aStatusCode);
            this.setStatusName(GenericSessionStatus.getStatusName(aStatusCode));
            this.setStatusMessageID(aStatusMegID);
            this.setStatusMessage(GenericSessionStatus.getStatusMessage(aStatusMegID));
            statObj = new GenericSessionStatus(this);
        }
        if (aDirect) {
            this.callStatusListener(statObj);
        } else {
            this.mQueue.addElement(new QueueElement(statObj));
            this.mQueueNotifier.setEvent(-3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void callStatusListener(ISessionStatus aStatus) {
        Object object = this.mListenerLock;
        synchronized (object) {
            if (aStatus != null && this.mSessionStatusListener != null) {
                this.mSessionStatusListener.update(aStatus);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void callMessageListener(IMessage aMessage) {
        boolean logoff = false;
        Object object = this.mListenerLock;
        synchronized (object) {
            String msgType = aMessage.getValueString("35");
            if (msgType != null && msgType.equalsIgnoreCase("BF") && 3 == aMessage.getValueInt("926")) {
                logoff = true;
            }
            if (!logoff && this.mMessageListener != null) {
                this.mMessageListener.update(aMessage);
            }
        }
        if (logoff) {
            String txt = aMessage.getValueString("927");
            if (txt != null) {
                txt = txt.replaceAll("\n", " ");
            }
            this.mLogger.error("onMessageRecieved::Force reconnect from server. Update session state::" + txt);
            this.updateStatus(-2, "Force reconnect from server: " + txt);
            this.updateStatus(5, "Force reconnect from server: " + txt);
            this.updateStatus(-1, "Force reconnect from server: " + txt);
        }
    }

    @Override
    protected void stop() {
        this.mThreadContainer.stop();
    }

    @Override
    public void run() {
        while (this.mRun) {
            if (this.mQueueNotifier.waitAll() == -2) {
                this.mRun = false;
                break;
            }
            if (this.mLogger.isDebugEnabled()) {
                this.mLogger.debug("UpdateProcessorThread. force");
            }
            while (!this.mQueue.isEmpty()) {
                QueueElement queueElement;
                if (this.mQueue.isEmpty() || (queueElement = (QueueElement)this.mQueue.remove(0)) == null) continue;
                if (queueElement.isMessage()) {
                    this.updateQueueSize(this.getQueueSize() - 1);
                    this.callMessageListener(queueElement.getMessage());
                    if (!this.mLogger.isDebugEnabled()) continue;
                    this.mLogger.debug("Message updated on Client");
                    continue;
                }
                this.callStatusListener(queueElement.getSessionStatus());
                if (!this.mLogger.isDebugEnabled()) continue;
                this.mLogger.debug("Status updated on Client");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateQueueSize(long aQueueSize) {
        Object object = this.mSessionStateLock;
        synchronized (object) {
            this.setQueueSize((int)aQueueSize);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getQueueSize() {
        Object object = this.mSessionStateLock;
        synchronized (object) {
            return super.getQueueSize();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ISessionStatus getCurrentStatus() {
        Object object = this.mSessionStateLock;
        synchronized (object) {
            return new GenericSessionStatus(this);
        }
    }

    private class QueueElement {
        protected boolean mEventType;
        protected IMessage mMessage;
        protected ISessionStatus mSessionStatus;

        public QueueElement(ISessionStatus aSessionStatus) {
            this.mSessionStatus = aSessionStatus;
            this.mMessage = null;
            this.mEventType = false;
            if (PDasSessionAdapter.this.mLogger.isDebugEnabled()) {
                PDasSessionAdapter.this.mLogger.debug("QueueElement( ISessionStatus *) = " + this.mSessionStatus + "\n");
            }
        }

        public QueueElement(IMessage aMessage) {
            this.mSessionStatus = null;
            this.mMessage = aMessage;
            this.mEventType = true;
            if (PDasSessionAdapter.this.mLogger.isDebugEnabled()) {
                PDasSessionAdapter.this.mLogger.debug("QueueElement( IMessage *) = " + this.mMessage);
            }
        }

        public IMessage getMessage() {
            return this.mMessage;
        }

        public ISessionStatus getSessionStatus() {
            return this.mSessionStatus;
        }

        public boolean isMessage() {
            return this.mEventType;
        }
    }
}

