/*
 * Decompiled with CFR 0.152.
 */
package com.fxcm.messaging.util.pdas.communicator.http;

import com.fxcm.messaging.http.HttpConnection;
import com.fxcm.messaging.http.IHttpRequest;
import com.fxcm.messaging.util.CommunicationException;
import com.fxcm.messaging.util.ConParams;
import com.fxcm.messaging.util.pdas.PStream;
import com.fxcm.messaging.util.pdas.session.PDasTransportSession;
import java.util.Enumeration;
import java.util.Vector;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HttpCommunicator {
    private static final Log LOG = LogFactory.getLog(HttpCommunicator.class);
    private static final int INIT_BUF_SIZE = 32768;
    private PStream mStrmAnswer = new PStream(32768);
    private HttpConnection mHttpConnection;
    private IHttpRequest mHttpRequest;
    private ConParams mParams;
    private String mServletPath;
    private Vector mHttpHeaders = new Vector();
    private boolean mUseRequestBody;
    private boolean mRequestCompression;

    public HttpCommunicator(ConParams aParams) {
        this.mParams = aParams;
        String pAcceptEncoding = aParams.getOptionalParameter("http-header-encoding", null);
        if (pAcceptEncoding != null) {
            this.mHttpHeaders.add(pAcceptEncoding);
        }
        this.mServletPath = aParams.getOptionalParameter("http-servlet-path", "servlet/pdas");
        this.mUseRequestBody = "true".equals(aParams.getOptionalParameter("use-req-body", "false"));
        this.mRequestCompression = "true".equals(aParams.getOptionalParameter("req-compression", "true"));
    }

    public void trnSetParam(String aName, String aValue) {
        if (aName != null && aValue != null) {
            if (aName.equals("http-servlet-path")) {
                this.mServletPath = aValue;
            } else if (aName.length() > 0 && aValue.length() > 0) {
                this.mHttpHeaders.add(aName + ": " + aValue);
            }
        }
    }

    public boolean trnOpen() throws CommunicationException {
        this.openHttpConnection();
        return true;
    }

    public boolean trnClose() {
        this.closeHttpConnection();
        return true;
    }

    public int trnSend(PStream aXmlMsg) throws CommunicationException {
        return this.httpSend(this.mServletPath, aXmlMsg);
    }

    public PStream trnReceive() throws CommunicationException {
        this.mStrmAnswer.clear();
        if (LOG.isDebugEnabled()) {
            LOG.debug("------------ before -------------------\n" + new String(this.mStrmAnswer.getBuffer(), 0, this.mStrmAnswer.getDataLen()) + "\n++++++++++++++++++++++++++++++++++++++++\n");
        }
        PStream pResponse = this.httpReceive(this.mStrmAnswer);
        if (LOG.isDebugEnabled()) {
            LOG.debug("------------ after -------------------\n" + new String(pResponse.getBuffer(), 0, pResponse.getDataLen()) + "\n++++++++++++++++++++++++++++++++++++++++\n");
        }
        return pResponse;
    }

    private boolean closeHttpConnection() {
        if (this.mHttpRequest != null) {
            this.mHttpRequest.close();
            this.mHttpRequest = null;
        }
        if (this.mHttpConnection != null) {
            this.mHttpConnection.close();
            this.mHttpConnection = null;
        }
        return true;
    }

    private boolean openHttpConnection() throws CommunicationException {
        if (this.mParams == null) {
            throw new CommunicationException("0001: Communication parameters must be initialized first");
        }
        String proxyHost = null;
        int proxyPort = -1;
        if (this.mParams.mbUseProxy) {
            proxyHost = this.mParams.msProxyHost;
            proxyPort = this.mParams.miProxyPort;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("opening http connection to = " + this.mParams);
        }
        this.mHttpConnection = HttpConnection.httpConnect(this.mParams.msHost, this.mParams.miPort, this.mParams.msHttpUid, this.mParams.msHttpPwd);
        if (this.mParams.mbUseProxy) {
            this.mHttpConnection.setProxyOptions(proxyHost, proxyPort, this.mParams.msProxyUid, this.mParams.msProxyPwd);
        }
        return true;
    }

    private int httpSend(String asPdas, PStream aStrmRequest) throws CommunicationException {
        PStream strmDasHeader;
        Object sSevletName = asPdas;
        String sRnd = Long.toHexString(PDasTransportSession.getTickCount());
        int iQustPos = ((String)sSevletName).indexOf("?");
        int iAmpPos = ((String)sSevletName).lastIndexOf("&");
        if (iQustPos < 0) {
            sSevletName = (String)sSevletName + "?";
        } else if (iQustPos != ((String)sSevletName).length() - 1 && iAmpPos != ((String)sSevletName).length() - 1 && iAmpPos < 0) {
            sSevletName = (String)sSevletName + "&";
        }
        sSevletName = (String)sSevletName + "rnd=" + sRnd;
        int fIgnoreCertCnInvalid = 16;
        if ("n".equals(this.mParams.getOptionalParameter("ssl.ignore.cn.invalid", null))) {
            fIgnoreCertCnInvalid = 0;
        }
        try {
            String trustVerifier = this.mParams.getOptionalParameter("ssl.trust", null);
            String httpImplementation = this.mParams.getOptionalParameter("com.fxcm.messaging.IConnectionManager.HttpImplementation", null);
            int timeout = Integer.parseInt(this.mParams.getOptionalParameter("com.fxcm.messaging.IConnectionManager.HttpTimeout", null));
            String acceptTypes = "Accept: */*";
            this.mHttpRequest = this.mHttpConnection.openRequest("POST", (String)sSevletName, acceptTypes, 0xF | fIgnoreCertCnInvalid | 0x20 | (this.mParams.mbUseSecure ? 64 : 0), trustVerifier, httpImplementation, timeout);
        }
        catch (Exception e) {
            throw new CommunicationException(e.getMessage());
        }
        Enumeration enHdrs = this.mHttpHeaders.elements();
        while (enHdrs.hasMoreElements()) {
            int iPos;
            String sHdr = (String)enHdrs.nextElement();
            if (sHdr == null || (iPos = sHdr.indexOf(58)) <= 0) continue;
            String name = sHdr.substring(0, iPos).trim();
            String value = sHdr.substring(iPos + 1).trim();
            this.mHttpRequest.addReqHeader(name, value);
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug("HTTP HEADER " + name + " : " + value);
        }
        this.mHttpRequest.addReqHeader("User-Agent", "PDas");
        if (this.mUseRequestBody) {
            this.mHttpRequest.addReqHeader("Content-Type", "text/xml");
            byte[] requestBytes = aStrmRequest.getBuffer();
            int requestLen = aStrmRequest.getDataLen();
            if (this.mRequestCompression) {
                int deflateResultLen;
                int nBufferLength = aStrmRequest.getDataLen() + 256;
                byte[] comprRequestBytes = new byte[nBufferLength];
                if (LOG.isDebugEnabled()) {
                    String outStr = new String(requestBytes, 0, aStrmRequest.getDataLen());
                    LOG.debug(outStr);
                }
                if ((deflateResultLen = HttpCommunicator.compress(comprRequestBytes, requestBytes, aStrmRequest.getDataLen())) < 0) {
                    deflateResultLen = aStrmRequest.getDataLen();
                    System.arraycopy(comprRequestBytes, 0, requestBytes, 0, deflateResultLen);
                }
                this.mHttpRequest.addReqHeader("Content-Encoding", "deflate");
                requestBytes = comprRequestBytes;
                requestLen = deflateResultLen;
            }
            try {
                this.mHttpRequest.send(requestBytes, 0, requestLen);
            }
            catch (Exception e) {
                LOG.debug("Communication Exception", e);
                throw new CommunicationException(e.getMessage());
            }
        }
        String sHeaderName = "PDAS_HEADER";
        if (aStrmRequest.getDataLen() >= 256) {
            int deflateResultLen;
            int nBufferLength = aStrmRequest.getDataLen() + 256;
            byte[] requestBytes = aStrmRequest.getBuffer();
            byte[] comprRequestBytes = new byte[nBufferLength];
            if (LOG.isDebugEnabled()) {
                String outStr = new String(requestBytes, 0, aStrmRequest.getDataLen());
                LOG.debug(outStr);
            }
            if ((deflateResultLen = HttpCommunicator.compress(comprRequestBytes, requestBytes, aStrmRequest.getDataLen())) < 0) {
                deflateResultLen = aStrmRequest.getDataLen();
                System.arraycopy(comprRequestBytes, 0, requestBytes, 0, deflateResultLen);
            }
            strmDasHeader = new PStream(deflateResultLen * 4 / 3 + 32);
            sHeaderName = "PDAS_HEADER_DEFLATE";
            strmDasHeader.appendBase64(comprRequestBytes, deflateResultLen);
        } else {
            strmDasHeader = new PStream(aStrmRequest.getDataLen() * 4 / 3 + 32);
            strmDasHeader.appendBase64(aStrmRequest);
        }
        String sRepresentation = new String(strmDasHeader.getBuffer(), 0, strmDasHeader.getDataLen());
        if (LOG.isDebugEnabled()) {
            LOG.debug(sHeaderName + "=\n" + sRepresentation + "\nlength=" + sRepresentation.length());
        }
        this.mHttpRequest.addReqHeader(sHeaderName, sRepresentation);
        try {
            this.mHttpRequest.send();
        }
        catch (Exception e) {
            LOG.debug("Communication Exception", e);
            throw new CommunicationException(e.getMessage());
        }
        return 0;
    }

    private PStream httpReceive(PStream aStrmAnswer) throws CommunicationException {
        if (this.mHttpRequest == null) {
            return aStrmAnswer;
        }
        PStream strmReponseBody = new PStream();
        int nErrorCode = this.mHttpRequest.getErrorStatus();
        if (nErrorCode != 0) {
            throw new CommunicationException("Error status is returned:" + nErrorCode);
        }
        int nSuccessCode = this.mHttpRequest.getSuccessStatus();
        if (nSuccessCode != 200) {
            throw new CommunicationException("No status 200 has been returned: " + nSuccessCode);
        }
        String sContentLengthOriginal = this.mHttpRequest.getRespHeader("Content-Length-Original");
        int iContentLengthOriginal = 0;
        if (sContentLengthOriginal != null) {
            try {
                iContentLengthOriginal = Integer.parseInt(sContentLengthOriginal);
            }
            catch (NumberFormatException e) {
                String msg = "Content-Length-Original field has invalid format: " + sContentLengthOriginal;
                throw new CommunicationException(msg);
            }
        }
        String sContentEncoding = this.mHttpRequest.getRespHeader("Content-Encoding");
        boolean bGzipEncoding = "gzip".equals(sContentEncoding);
        boolean bInflateEncoding = "deflate".equals(sContentEncoding);
        try {
            strmReponseBody.write(this.mHttpRequest.getResponseBody());
        }
        catch (Exception e) {
            throw new CommunicationException(e.getMessage());
        }
        if (bInflateEncoding) {
            byte[] outBuff;
            int inflateResultLen;
            if (iContentLengthOriginal == 0) {
                iContentLengthOriginal = strmReponseBody.getDataLen() * 10;
            }
            if ((inflateResultLen = HttpCommunicator.uncompress(outBuff = new byte[iContentLengthOriginal], strmReponseBody.getBuffer(), strmReponseBody.getDataLen())) < 0) {
                throw new CommunicationException("Cannnot uncompress received data");
            }
            aStrmAnswer.append(outBuff, inflateResultLen);
        } else if (bGzipEncoding) {
            byte[] outBuff = HttpCommunicator.gzipUncompress(strmReponseBody.getBuffer());
            if (outBuff == null) {
                throw new CommunicationException("Cannnot uncompress received gziped data");
            }
            aStrmAnswer.append(outBuff, outBuff.length);
        } else {
            aStrmAnswer.append(strmReponseBody);
        }
        return aStrmAnswer;
    }

    private static int compress(byte[] aComprBytes, byte[] aSourceBytes, int aiSourceLength) {
        Deflater deflater = new Deflater();
        deflater.setInput(aSourceBytes, 0, aiSourceLength);
        deflater.finish();
        int ret = deflater.deflate(aComprBytes);
        deflater.end();
        return ret;
    }

    private static int uncompress(byte[] aSourceBytes, byte[] aComprBytes, int aiComprLength) {
        Inflater inflater = new Inflater();
        inflater.setInput(aComprBytes, 0, aiComprLength);
        try {
            int ret = inflater.inflate(aSourceBytes);
            inflater.end();
            return ret;
        }
        catch (Exception e) {
            LOG.debug("!!!! uncompress ", e);
            return -1;
        }
    }

    /*
     * Exception decompiling
     */
    private static byte[] gzipUncompress(byte[] compressedData) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

