/*
 * Decompiled with CFR 0.152.
 */
package com.fxcm.messaging.util.pdas.communicator;

import com.fxcm.messaging.util.CommunicationException;
import com.fxcm.messaging.util.ConParams;
import com.fxcm.messaging.util.pdas.communicator.Communicator;
import com.fxcm.messaging.util.pdas.communicator.ICommStatusListener;
import com.fxcm.messaging.util.pdas.communicator.IMessageReceiver;
import com.fxcm.messaging.util.pdas.statemachine.IJob;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class UniComm {
    private static final Log moLogger = LogFactory.getLog(UniComm.class);
    private static final int MAX_CHANNELS = 8;
    private int mChannels;
    private Communicator[] mChannel;

    public UniComm(IMessageReceiver aReceiver, ICommStatusListener aListener, ConParams aParams) {
        this.mChannels = Integer.parseInt(aParams.getOptionalParameter("communication-channels", "1"));
        if (this.mChannels <= 0) {
            this.mChannels = 1;
        }
        if (this.mChannels > 8) {
            this.mChannels = 8;
        }
        this.mChannel = new Communicator[8];
        for (int i = 0; i < this.mChannels; ++i) {
            this.mChannel[i] = new Communicator(aReceiver, aListener, aParams, i);
        }
    }

    public UniComm() {
        this.mChannel = new Communicator[8];
    }

    public boolean clearQueue() {
        boolean ret = false;
        for (int i = 0; i < this.mChannels; ++i) {
            ret = this.mChannel[i].clearQueue();
        }
        return ret;
    }

    protected Communicator getCommunicator(int aChannelFirst, int aChannelLast) {
        if (aChannelFirst >= 0) {
            if (aChannelFirst >= this.mChannels) {
                aChannelFirst = this.mChannels - 1;
            }
        } else {
            aChannelFirst = 0;
        }
        if (aChannelLast >= 0) {
            if (aChannelLast >= this.mChannels) {
                aChannelLast = this.mChannels - 1;
            }
        } else {
            aChannelLast = this.mChannels - 1;
        }
        int nChannel = aChannelFirst;
        int nMinLoad = this.mChannel[nChannel].getQueueSize() + (this.mChannel[nChannel].isBusy() ? 1000 : 0);
        for (int i = aChannelFirst; i <= aChannelLast; ++i) {
            int nCurLoad = this.mChannel[i].getQueueSize() + (this.mChannel[i].isBusy() ? 1000 : 0);
            if (nCurLoad >= nMinLoad) continue;
            nMinLoad = nCurLoad;
            nChannel = i;
        }
        return this.mChannel[nChannel];
    }

    public boolean open() throws CommunicationException {
        boolean ret = this.mChannels > 0;
        for (int i = 0; i < this.mChannels; ++i) {
            ret = this.mChannel[i].open();
        }
        return ret;
    }

    public boolean isOpened() {
        return this.mChannel[0].isOpened();
    }

    public void close() throws CommunicationException {
        for (int i = 0; i < this.mChannels; ++i) {
            this.mChannel[i].close();
        }
    }

    public void addJobs(Vector aJobs) {
        int i;
        if (moLogger.isDebugEnabled()) {
            moLogger.debug("UniComm::addJobs Size=" + aJobs.size());
        }
        for (i = 0; i < aJobs.size(); ++i) {
            IJob pJob = (IJob)aJobs.elementAt(i);
            if (pJob == null) continue;
            this.getCommunicator(pJob.getCommChannelFirst(), pJob.getCommChannelLast()).addJob(pJob);
        }
        if (i > 0) {
            for (int j = 0; j < this.mChannels; ++j) {
                this.mChannel[j].force();
            }
        }
        moLogger.debug("UniComm::addJobs Exit");
    }

    public void setParam(String aName, String aValue) {
        for (int i = 0; i < this.mChannels; ++i) {
            this.mChannel[i].setParam(aName, aValue);
        }
    }
}

