/*
 * Decompiled with CFR 0.152.
 */
package com.fxcm.messaging.util.pdas.communicator;

import com.fxcm.GenericException;
import com.fxcm.messaging.IFieldGroupList;
import com.fxcm.messaging.IMessage;
import com.fxcm.messaging.util.CommunicationException;
import com.fxcm.messaging.util.ConParams;
import com.fxcm.messaging.util.pdas.Event;
import com.fxcm.messaging.util.pdas.PDasMessageFactory;
import com.fxcm.messaging.util.pdas.PStream;
import com.fxcm.messaging.util.pdas.ThreadContainer;
import com.fxcm.messaging.util.pdas.communicator.ICommStatusListener;
import com.fxcm.messaging.util.pdas.communicator.IMessageReceiver;
import com.fxcm.messaging.util.pdas.communicator.http.HttpCommunicator;
import com.fxcm.messaging.util.pdas.statemachine.IJob;
import com.fxcm.messaging.util.pdas.statemachine.JobStateEnum;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Communicator
extends HttpCommunicator
implements Runnable {
    private final Log mLogger = LogFactory.getLog(Communicator.class);
    private Log mTraceLog = LogFactory.getLog("develop.trace." + Communicator.class.getName());
    private final ICommStatusListener mCommStatusListener;
    private long mTimeout;
    private int mChannel;
    private boolean mOpened;
    private boolean mOpening;
    private boolean mBusy;
    private int mMaxBatchSize;
    private String mDataFormat;
    private final Event mEvent = Event.synchronizeEvent();
    private final Vector mLockedQueue;
    private ThreadContainer mThreadContainer;
    private IMessageReceiver mReceiver;
    private boolean mRun = true;

    public Communicator(IMessageReceiver aReceiver, ICommStatusListener aListener, ConParams aParams, int aChannel) {
        super(aParams);
        this.mCommStatusListener = aListener;
        this.mChannel = aChannel;
        this.mReceiver = aReceiver;
        this.mTimeout = 100L;
        this.mMaxBatchSize = 32;
        this.mDataFormat = aParams.getOptionalParameter("data-format", "pdas");
        this.mLockedQueue = new Vector();
        this.mThreadContainer = new ThreadContainer();
    }

    public boolean clearQueue() {
        this.mLockedQueue.removeAllElements();
        return this.isBusy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isBusy() {
        Vector vector = this.mLockedQueue;
        synchronized (vector) {
            return this.mBusy;
        }
    }

    public int getQueueSize() {
        return this.mLockedQueue.size();
    }

    public void setParam(String aName, String aValue) {
        this.trnSetParam(aName, aValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean open() throws CommunicationException {
        boolean opened;
        Vector vector = this.mLockedQueue;
        synchronized (vector) {
            if (this.mOpening) {
                String msg = "!!! Repeating attempt to open a Communicator that is being opened right now";
                throw new CommunicationException(msg);
            }
            if (this.mOpened) {
                return this.mOpened;
            }
            this.mOpening = true;
        }
        this.mCommStatusListener.onOpening();
        this.mThreadContainer.start(new Thread((Runnable)this){

            @Override
            public void interrupt() {
                super.interrupt();
                Communicator.this.mRun = false;
                Communicator.this.mEvent.setEvent(-2);
            }
        });
        try {
            opened = this.trnOpen();
        }
        catch (CommunicationException ex) {
            this.mCommStatusListener.onError(ex);
            throw ex;
        }
        Vector vector2 = this.mLockedQueue;
        synchronized (vector2) {
            this.mOpening = false;
            this.mOpened = opened;
            this.mCommStatusListener.onOpened();
            return this.mOpened;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean reconnect() throws CommunicationException {
        boolean bOpened;
        if (this.isOpening()) {
            throw new CommunicationException("!!! Attempt to reconnect a Communicator that is being opened right now");
        }
        try {
            this.trnClose();
        }
        catch (Exception e) {
            this.mLogger.error(e.getMessage(), e);
        }
        Vector e = this.mLockedQueue;
        synchronized (e) {
            this.mOpening = true;
            this.mOpened = false;
        }
        this.mCommStatusListener.onOpening();
        try {
            bOpened = this.trnOpen();
        }
        catch (CommunicationException ex) {
            this.mCommStatusListener.onError(ex);
            throw ex;
        }
        Vector vector = this.mLockedQueue;
        synchronized (vector) {
            this.mOpened = bOpened;
            this.mOpening = false;
            this.mCommStatusListener.onOpened();
            return this.mOpened;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isOpened() {
        Vector vector = this.mLockedQueue;
        synchronized (vector) {
            return this.mOpened;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isOpening() {
        Vector vector = this.mLockedQueue;
        synchronized (vector) {
            return this.mOpening;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws CommunicationException {
        Vector vector = this.mLockedQueue;
        synchronized (vector) {
            if (this.mOpening) {
                throw new CommunicationException("!!! Attempt to close a Communicator that is being opened right now");
            }
            if (!this.mOpened) {
                return;
            }
        }
        this.mCommStatusListener.onClosing();
        vector = this.mLockedQueue;
        synchronized (vector) {
            if (this.mOpened) {
                this.mOpened = false;
            }
        }
        this.clearQueue();
        try {
            this.trnClose();
        }
        catch (Exception e) {
            this.mLogger.error(e.getMessage(), e);
        }
        this.mCommStatusListener.onClosed();
        this.stop();
    }

    public void addJob(IJob aJob) {
        this.mLockedQueue.addElement(aJob);
    }

    public void force() {
        this.mEvent.setEvent(-3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Vector<IJob> queueSending = new Vector<IJob>();
        while (this.mRun) {
            if (this.mEvent.waitAll(this.mTimeout) == -2) {
                this.mRun = false;
                break;
            }
            while (!this.mLockedQueue.isEmpty() && this.isOpened()) {
                Vector vector = this.mLockedQueue;
                synchronized (vector) {
                    IJob[] jobs = this.mLockedQueue.toArray(new IJob[this.mLockedQueue.size()]);
                    int nBatchSize = 0;
                    for (int i = 0; i < jobs.length; ++i) {
                        IJob pJob = jobs[i];
                        if (pJob == null) continue;
                        if (pJob.getCancel()) {
                            this.mLockedQueue.removeElement(pJob);
                            pJob.setState(JobStateEnum.jobCancelling);
                            continue;
                        }
                        queueSending.addElement(pJob);
                        pJob.onSendRequest();
                        this.mLockedQueue.removeElement(pJob);
                        if ("U54.Batch.Req".equals(pJob.getRequest().getMsgType())) {
                            IFieldGroupList fgl = pJob.getRequest().getValueList("9036");
                            if (fgl != null) {
                                nBatchSize += fgl.size();
                            }
                        } else {
                            ++nBatchSize;
                        }
                        if (nBatchSize >= this.mMaxBatchSize) break;
                    }
                }
                if (queueSending.isEmpty()) continue;
                vector = this.mLockedQueue;
                synchronized (vector) {
                    this.mBusy = true;
                }
                Vector pResponses = null;
                try {
                    pResponses = this.request(queueSending);
                }
                catch (GenericException ex) {
                    for (int i = 0; i < queueSending.size(); ++i) {
                        IJob pJob = (IJob)queueSending.elementAt(i);
                        if (pJob == null) continue;
                        pJob.onError(ex);
                    }
                }
                if (pResponses != null) {
                    for (int i = 0; i < pResponses.size(); ++i) {
                        IMessage pMessage = (IMessage)pResponses.elementAt(i);
                        if (pMessage == null) continue;
                        String cmd = pMessage.getValueString("9028");
                        if (cmd != null && "0".equals(cmd) || pMessage.getMsgType().equals("W")) {
                            if (this.mTraceLog.isDebugEnabled()) {
                                this.mTraceLog.debug("<<< inc " + pMessage + "\n");
                            }
                        } else if (this.mLogger.isDebugEnabled()) {
                            this.mLogger.debug("<<< inc " + pMessage + "\n");
                        }
                        String pRID = pMessage.getValueString("112");
                        boolean accepted = false;
                        for (int j = 0; j < queueSending.size(); ++j) {
                            IJob pJob = (IJob)queueSending.elementAt(j);
                            if (pJob == null || pJob.getState() != JobStateEnum.jobWaitingForResponse || !(accepted = pJob.onAcceptResponse(pMessage, pRID))) continue;
                            pJob.setState(JobStateEnum.jobReceivedResponse);
                            break;
                        }
                        if (accepted) continue;
                        this.mReceiver.receiveMessage(pMessage);
                    }
                }
                for (int k = 0; k < queueSending.size(); ++k) {
                    IJob pJob = (IJob)queueSending.elementAt(k);
                    if (pJob == null) continue;
                    pJob.setState(JobStateEnum.jobFinishedCommunicaton);
                }
                queueSending.removeAllElements();
                Vector vector2 = this.mLockedQueue;
                synchronized (vector2) {
                    this.mBusy = false;
                }
            }
        }
    }

    public void stop() {
        this.mThreadContainer.stop();
    }

    public Vector request(Vector aJobs) throws GenericException {
        Vector responses = null;
        if (aJobs != null) {
            if ((this.mLogger.isDebugEnabled() || this.mTraceLog.isDebugEnabled()) && !aJobs.isEmpty()) {
                for (int i = 0; i < aJobs.size(); ++i) {
                    IJob o = (IJob)aJobs.get(i);
                    String cmd = o.getRequest().getValueString("9028");
                    if (cmd != null && "0".equals(cmd)) {
                        if (!this.mTraceLog.isDebugEnabled()) continue;
                        this.mTraceLog.debug("Channel " + this.mChannel + " Batch Size = " + aJobs.size());
                        this.mTraceLog.debug(">>> out " + o.getRequest());
                        continue;
                    }
                    if (!this.mLogger.isDebugEnabled()) continue;
                    this.mLogger.debug("Channel " + this.mChannel + " Batch Size = " + aJobs.size());
                    this.mLogger.debug(">>> out " + o.getRequest());
                }
            }
            PStream strmRequest = new PStream();
            try {
                PDasMessageFactory.toXml(strmRequest, aJobs, this.mDataFormat);
                this.mCommStatusListener.onSending();
                this.trnSend(strmRequest);
                this.mCommStatusListener.onSent();
                this.mCommStatusListener.onReceiving();
                PStream strmResponse = this.trnReceive();
                this.mCommStatusListener.onReceived();
                if (strmResponse != null) {
                    responses = PDasMessageFactory.fromXml(strmResponse, this.mDataFormat);
                }
            }
            catch (Exception ex) {
                StringBuffer requestsBuffer = new StringBuffer();
                for (int i = 0; i < aJobs.size(); ++i) {
                    IJob job = (IJob)aJobs.get(i);
                    requestsBuffer.append(job.getRequest());
                    requestsBuffer.append("\n");
                }
                this.mLogger.debug("Error: Communicator::request()");
                this.mLogger.error(ex.getMessage(), ex);
                this.mLogger.error(ex.getMessage() + ": " + requestsBuffer);
                GenericException ex1 = new GenericException("problem on communication request: " + ex.getMessage(), ex);
                this.mCommStatusListener.onError(ex1);
                throw ex1;
            }
        }
        return responses;
    }
}

