/*
 * Decompiled with CFR 0.152.
 */
package com.fxcm.messaging.util.pdas;

import com.fxcm.GenericException;
import com.fxcm.messaging.util.ConParams;
import com.fxcm.messaging.util.ITransportProvider;
import com.fxcm.messaging.util.ITransportSession;
import com.fxcm.messaging.util.pdas.session.PDasSessionAdapter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TransportProvider
implements ITransportProvider {
    private static Log moLogger = LogFactory.getLog(TransportProvider.class);
    public static final String PROVIDER_NAME = "pdas";
    private boolean mInitiated;
    protected Hashtable mProperties = new Hashtable();
    private static TransportProvider cTransportProvider;

    public static synchronized TransportProvider getInstance() {
        if (cTransportProvider == null) {
            cTransportProvider = new TransportProvider();
        }
        return cTransportProvider;
    }

    protected long getLongProperty(String aName, long aDefault) {
        long ret = aDefault;
        String res = (String)this.mProperties.get(aName);
        if (res != null && res.length() > 0) {
            try {
                ret = Long.parseLong(res);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return ret;
    }

    @Override
    public synchronized boolean init(Properties aProperties) {
        this.mInitiated = true;
        this.mProperties.clear();
        Enumeration<?> en = aProperties.propertyNames();
        while (en.hasMoreElements()) {
            String key = (String)en.nextElement();
            this.mProperties.put(key, aProperties.getProperty(key));
        }
        return true;
    }

    @Override
    public void cleanup() {
        this.mInitiated = false;
        cTransportProvider = null;
    }

    @Override
    public synchronized boolean isInitiated() {
        return this.mInitiated;
    }

    @Override
    public ConParams addExtra(ConParams aParams) {
        String httpTimeout;
        String httpImpl;
        String sslIgnoreCnInvalid;
        String sslTrust = (String)this.mProperties.get("ssl.trust");
        if (sslTrust != null) {
            aParams.mOptionalParams.put("ssl.trust", sslTrust);
        }
        if ((sslIgnoreCnInvalid = (String)this.mProperties.get("ssl.ignore.cn.invalid")) != null) {
            aParams.mOptionalParams.put("ssl.ignore.cn.invalid", sslIgnoreCnInvalid);
        }
        if ((httpImpl = (String)this.mProperties.get("com.fxcm.messaging.IConnectionManager.HttpImplementation")) != null) {
            aParams.mOptionalParams.put("com.fxcm.messaging.IConnectionManager.HttpImplementation", httpImpl);
        }
        if ((httpTimeout = (String)this.mProperties.get("com.fxcm.messaging.IConnectionManager.HttpTimeout")) != null) {
            aParams.mOptionalParams.put("com.fxcm.messaging.IConnectionManager.HttpTimeout", httpTimeout);
        }
        return aParams;
    }

    @Override
    public boolean isValid(ConParams aParams) {
        return aParams != null && !aParams.isEmpty() && PROVIDER_NAME.equalsIgnoreCase(aParams.msTransportProvider);
    }

    @Override
    public ITransportSession createSession(ConParams aParams) throws GenericException {
        try {
            GenericException err = null;
            PDasSessionAdapter ret = new PDasSessionAdapter(aParams);
            if (ret != null) {
                int noReconnectAttempts = (int)this.getLongProperty("com.fxcm.messaging.IConnectionManager.NoReconnectAttempts", 3L);
                long reconnectTimeout = this.getLongProperty("com.fxcm.messaging.IConnectionManager.ReconnectTimeout", 2000L);
                ret.setCommunicatorReconnect(noReconnectAttempts, reconnectTimeout);
            }
            try {
                ret.openCommunicator();
            }
            catch (GenericException ex) {
                moLogger.debug("createSession GenericException:", ex);
                err = ex;
            }
            if (!(err != null || ret != null && ret.isValid())) {
                err = new GenericException("Unable to open valid session");
            }
            if (err != null && ret != null) {
                try {
                    ret.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (err != null) {
                throw err;
            }
            return ret;
        }
        catch (RuntimeException e) {
            moLogger.debug("", e);
            throw e;
        }
    }
}

