/*
 * Decompiled with CFR 0.152.
 */
package com.fxcm.messaging.util.pdas;

import com.fxcm.GenericException;
import com.fxcm.messaging.IField;
import com.fxcm.messaging.IFieldGroup;
import com.fxcm.messaging.IMessage;
import com.fxcm.messaging.util.UniversalMessageFactory;
import com.fxcm.messaging.util.pdas.PStream;
import com.fxcm.messaging.util.pdas.statemachine.IJob;
import com.fxcm.messaging.util.pdas.xml.PXmlParser;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;

public class PDasMessageFactory
extends UniversalMessageFactory {
    static PDasMessageFactory cPDasMessageFactory = new PDasMessageFactory();
    static byte[] cFxmsgTail = "</fxmsg>".getBytes();
    static final Map<String, byte[]> cFxmsgHeaders = new HashMap<String, byte[]>(1);
    private static byte[] baF1;
    private static byte[] baEnd;
    private static byte[] baF2;
    private static byte[] baCDATA1;
    private static byte[] baCDATA2;
    private static byte[] baL1;
    private static byte[] baL2;
    private static byte[] baLS;
    private static byte[] baG1;
    private static byte[] baG2;
    private static byte[] baGS;
    private static byte[] baTint;
    private static byte[] baTlng;
    private static byte[] baTdbl;
    private static byte[] baMsg1;
    private static byte[] baMsg2;
    private static byte[] baMsgS;
    private static byte[] baMsg3;

    public static PDasMessageFactory getInstance() {
        return cPDasMessageFactory;
    }

    public static void batchHead(OutputStream os, int aMessages, String aDataFormat) {
        try {
            byte[] bts = cFxmsgHeaders.get(aDataFormat == null ? "pdas" : aDataFormat);
            if (bts == null) {
                bts = ("<fxmsg v=\"" + aDataFormat + "\">").getBytes();
                cFxmsgHeaders.put(aDataFormat, bts);
            }
            os.write(bts);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void batchTail(OutputStream os) {
        try {
            os.write(cFxmsgTail);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static boolean hasMarkupSymbols(String aData) {
        if (aData.indexOf(60) >= 0) {
            return true;
        }
        return aData.indexOf(38) >= 0;
    }

    public static Vector fromXml(PStream aXml, String aDataFormat) throws GenericException {
        PXmlParser pParser = new PXmlParser(aDataFormat);
        return pParser.fromXml(aXml);
    }

    public static boolean toXml(PStream aXml, Vector aJobs, String aDataFormat) {
        PDasMessageFactory.batchHead(aXml, aJobs.size(), aDataFormat);
        for (int i = 0; i < aJobs.size(); ++i) {
            IJob aJob = (IJob)aJobs.get(i);
            IMessage pMessage = aJob.getRequest();
            PDasMessageFactory.serializeMessage(pMessage, aXml);
        }
        PDasMessageFactory.batchTail(aXml);
        return true;
    }

    public static void serializeMessage(IMessage aMessage, PStream aPs) {
        PrintStream ps = new PrintStream(aPs);
        ps.print("<m t=\"" + aMessage.getMsgType() + "\" s=\"" + aMessage.size() + "\" q=\"0\">");
        PDasMessageFactory.serializeFieldGroup((IFieldGroup)aMessage, ps);
        ps.println("</m>");
        ps.flush();
    }

    public static void serializeMessage(IMessage aMessage, StringBuffer aBuff) {
        aBuff.append("<m t=\"").append(aMessage.getMsgType()).append("\" s=\"").append(aMessage.size()).append("\" q=\"0\">");
        PDasMessageFactory.serializeFieldGroup((IFieldGroup)aMessage, aBuff);
        aBuff.append("</m>");
    }

    public static void serializeMessage(IMessage aMessage, PrintStream ps) {
        ps.print("<m t=\"" + aMessage.getMsgType() + "\" s=\"" + aMessage.size() + "\" q=\"0\">");
        PDasMessageFactory.serializeFieldGroup((IFieldGroup)aMessage, ps);
        ps.println("</m>");
        ps.flush();
    }

    protected static void serializeFieldGroup(IFieldGroup aGroup, PrintStream aPs) {
        for (IField entry : aGroup.values()) {
            String key = entry.getName();
            if (entry.isNullValue()) continue;
            if (IField.DATATYPE_STRING.equals(entry.getDatatype())) {
                String val = entry.getValueString();
                if (PDasMessageFactory.hasMarkupSymbols(val)) {
                    aPs.print("<f n=\"" + key + "\"><![CDATA[" + val + "]]></f>");
                    continue;
                }
                aPs.print("<f n=\"" + key + "\">" + val + "</f>");
                continue;
            }
            if (IField.DATATYPE_LIST.equals(entry.getDatatype())) {
                aPs.print("<l n=\"" + key + "\" s=\"" + entry.getValueList().size() + "\">");
                for (IFieldGroup field : entry.getValueList().values()) {
                    if (field.size() != 2) {
                        aPs.print("<g s=\"" + field.size() + "\">");
                    } else {
                        aPs.print("<g>");
                    }
                    PDasMessageFactory.serializeFieldGroup(field, aPs);
                    aPs.print("</g>");
                }
                aPs.print("</l>");
                continue;
            }
            if (IField.DATATYPE_INT.equals(entry.getDatatype())) {
                aPs.print("<f n=\"" + key + "\" t=\"i\">" + entry.getValueString() + "</f>");
                continue;
            }
            if (IField.DATATYPE_LONG.equals(entry.getDatatype())) {
                aPs.print("<f n=\"" + key + "\" t=\"l\">" + entry.getValueString() + "</f>");
                continue;
            }
            if (IField.DATATYPE_DOUBLE.equals(entry.getDatatype())) {
                aPs.print("<f n=\"" + key + "\" t=\"d\">" + entry.getValueString() + "</f>");
                continue;
            }
            aPs.print("<f n=\"" + key + "\">" + entry.getValueString() + "</f>");
        }
    }

    protected static void serializeFieldGroup(IFieldGroup aGroup, StringBuffer aBuff) {
        for (IField entry : aGroup.values()) {
            String key = entry.getName();
            if (entry.isNullValue()) continue;
            if (IField.DATATYPE_STRING.equals(entry.getDatatype())) {
                String val = entry.getValueString();
                if (PDasMessageFactory.hasMarkupSymbols(val)) {
                    aBuff.append("<f n=\"").append(key).append("\"><![CDATA[").append(val).append("]]></f>");
                    continue;
                }
                aBuff.append("<f n=\"").append(key).append("\">").append(val).append("</f>");
                continue;
            }
            if (IField.DATATYPE_LIST.equals(entry.getDatatype())) {
                aBuff.append("<l n=\"").append(key).append("\" s=\"").append(entry.getValueList().size()).append("\">");
                for (IFieldGroup field : entry.getValueList().values()) {
                    if (field.size() != 2) {
                        aBuff.append("<g s=\"").append(field.size()).append("\">");
                    } else {
                        aBuff.append("<g>");
                    }
                    PDasMessageFactory.serializeFieldGroup(field, aBuff);
                    aBuff.append("</g>");
                }
                aBuff.append("</l>");
                continue;
            }
            if (IField.DATATYPE_INT.equals(entry.getDatatype())) {
                aBuff.append("<f n=\"").append(key).append("\" t=\"i\">").append(entry.getValueString()).append("</f>");
                continue;
            }
            if (IField.DATATYPE_LONG.equals(entry.getDatatype())) {
                aBuff.append("<f n=\"").append(key).append("\" t=\"l\">").append(entry.getValueString()).append("</f>");
                continue;
            }
            if (IField.DATATYPE_DOUBLE.equals(entry.getDatatype())) {
                aBuff.append("<f n=\"").append(key).append("\" t=\"d\">").append(entry.getValueString()).append("</f>");
                continue;
            }
            aBuff.append("<f n=\"").append(key).append("\">").append(entry.getValueString()).append("</f>");
        }
    }

    public static void serializeMessage(IMessage aMessage, Writer aWriter) throws IOException {
        aWriter.write("<m t=\"");
        aWriter.write(aMessage.getMsgType());
        aWriter.write("\" s=\"");
        aWriter.write(String.valueOf(aMessage.size()));
        aWriter.write("\" q=\"0\">");
        PDasMessageFactory.serializeFieldGroup((IFieldGroup)aMessage, aWriter);
        aWriter.write("</m>");
        aWriter.flush();
    }

    protected static void serializeFieldGroup(IFieldGroup aGroup, Writer aWriter) throws IOException {
        for (IField entry : aGroup.values()) {
            String key = entry.getName();
            if (entry.isNullValue()) continue;
            if (IField.DATATYPE_STRING.equals(entry.getDatatype())) {
                String val = entry.getValueString();
                if (PDasMessageFactory.hasMarkupSymbols(val)) {
                    aWriter.write("<f n=\"");
                    aWriter.write(key);
                    aWriter.write("\"><![CDATA[");
                    aWriter.write(val);
                    aWriter.write("]]></f>");
                    continue;
                }
                aWriter.write("<f n=\"");
                aWriter.write(key);
                aWriter.write("\">");
                aWriter.write(val);
                aWriter.write("</f>");
                continue;
            }
            if (IField.DATATYPE_LIST.equals(entry.getDatatype())) {
                aWriter.write("<l n=\"");
                aWriter.write(key);
                aWriter.write("\" s=\"");
                aWriter.write(String.valueOf(entry.getValueList().size()));
                aWriter.write("\">");
                for (IFieldGroup field : entry.getValueList().values()) {
                    if (field.size() != 2) {
                        aWriter.write("<g s=\"");
                        aWriter.write(String.valueOf(field.size()));
                        aWriter.write("\">");
                    } else {
                        aWriter.write("<g>");
                    }
                    PDasMessageFactory.serializeFieldGroup(field, aWriter);
                    aWriter.write("</g>");
                }
                aWriter.write("</l>");
                continue;
            }
            if (IField.DATATYPE_INT.equals(entry.getDatatype())) {
                aWriter.write("<f n=\"");
                aWriter.write(key);
                aWriter.write("\" t=\"i\">");
                aWriter.write(entry.getValueString());
                aWriter.write("</f>");
                continue;
            }
            if (IField.DATATYPE_LONG.equals(entry.getDatatype())) {
                aWriter.write("<f n=\"");
                aWriter.write(key);
                aWriter.write("\" t=\"l\">");
                aWriter.write(entry.getValueString());
                aWriter.write("</f>");
                continue;
            }
            if (IField.DATATYPE_DOUBLE.equals(entry.getDatatype())) {
                aWriter.write("<f n=\"");
                aWriter.write(key);
                aWriter.write("\" t=\"d\">");
                aWriter.write(entry.getValueString());
                aWriter.write("</f>");
                continue;
            }
            aWriter.write("<f n=\"");
            aWriter.write(key);
            aWriter.write("\">");
            aWriter.write(entry.getValueString());
            aWriter.write("</f>");
        }
    }

    public static void serializeMessage(IMessage aMessage, OutputStream aOS) throws IOException {
        aOS.write(baMsg1);
        aOS.write(aMessage.getMsgType().getBytes());
        aOS.write(baMsgS);
        aOS.write(Integer.toString(aMessage.size()).getBytes());
        aOS.write(baMsg2);
        PDasMessageFactory.serializeFieldGroup((IFieldGroup)aMessage, aOS);
        aOS.write(baMsg3);
    }

    protected static void serializeFieldGroup(IFieldGroup aGroup, OutputStream aOS) throws IOException {
        for (IField entry : aGroup.values()) {
            String key = entry.getName();
            byte[] keyBytes = key.getBytes();
            if (keyBytes == null) {
                keyBytes = key.getBytes();
            }
            if (entry.isNullValue()) continue;
            if (IField.DATATYPE_STRING.equals(entry.getDatatype())) {
                String val = entry.getValueString();
                if (PDasMessageFactory.hasMarkupSymbols(val)) {
                    aOS.write(baF1);
                    aOS.write(keyBytes);
                    aOS.write(baEnd);
                    aOS.write(baCDATA1);
                    aOS.write(val.getBytes("UTF-8"));
                    aOS.write(baCDATA2);
                    aOS.write(baF2);
                    continue;
                }
                aOS.write(baF1);
                aOS.write(keyBytes);
                aOS.write(baEnd);
                aOS.write(val.getBytes("UTF-8"));
                aOS.write(baF2);
                continue;
            }
            if (IField.DATATYPE_LIST.equals(entry.getDatatype())) {
                aOS.write(baL1);
                aOS.write(keyBytes);
                aOS.write(baLS);
                aOS.write(Integer.toString(entry.getValueList().size()).getBytes());
                aOS.write(baEnd);
                for (IFieldGroup field : entry.getValueList().values()) {
                    int sz = field.values().size();
                    if (sz == 2) {
                        aOS.write(baG1);
                    } else {
                        aOS.write(baGS);
                        aOS.write(Integer.toString(sz).getBytes());
                        aOS.write(baEnd);
                    }
                    PDasMessageFactory.serializeFieldGroup(field, aOS);
                    aOS.write(baG2);
                }
                aOS.write(baL2);
                continue;
            }
            if (IField.DATATYPE_INT.equals(entry.getDatatype())) {
                aOS.write(baF1);
                aOS.write(keyBytes);
                aOS.write(baTint);
                aOS.write(entry.getValueString().getBytes());
                aOS.write(baF2);
                continue;
            }
            if (IField.DATATYPE_LONG.equals(entry.getDatatype())) {
                aOS.write(baF1);
                aOS.write(keyBytes);
                aOS.write(baTlng);
                aOS.write(entry.getValueString().getBytes());
                aOS.write(baF2);
                continue;
            }
            if (IField.DATATYPE_DOUBLE.equals(entry.getDatatype())) {
                aOS.write(baF1);
                aOS.write(keyBytes);
                aOS.write(baTdbl);
                aOS.write(entry.getValueString().getBytes());
                aOS.write(baF2);
                continue;
            }
            aOS.write(baF1);
            aOS.write(keyBytes);
            aOS.write(baEnd);
            aOS.write(entry.getValueString().getBytes("UTF-8"));
            aOS.write(baF2);
        }
    }

    static {
        cFxmsgHeaders.put("pdas", "<fxmsg v=\"pdas\">".getBytes());
        baF1 = "<f n=\"".getBytes();
        baEnd = "\">".getBytes();
        baF2 = "</f>".getBytes();
        baCDATA1 = "<![CDATA[".getBytes();
        baCDATA2 = "]]>".getBytes();
        baL1 = "<l n=\"".getBytes();
        baL2 = "</l>".getBytes();
        baLS = "\" s=\"".getBytes();
        baG1 = "<g>".getBytes();
        baG2 = "</g>".getBytes();
        baGS = "<g s=\"".getBytes();
        baTint = "\" t=\"i\">".getBytes();
        baTlng = "\" t=\"l\">".getBytes();
        baTdbl = "\" t=\"d\">".getBytes();
        baMsg1 = "<m t=\"".getBytes();
        baMsg2 = "\" q=\"0\">".getBytes();
        baMsgS = "\" s=\"".getBytes();
        baMsg3 = "</m>".getBytes();
    }
}

