/*
 * Decompiled with CFR 0.152.
 */
package com.fxcm.messaging.util.pdas;

public class Event {
    public static final int TIMEOUT_EXPIRED = -1;
    public static final int INTERRUPTED = -2;
    public static final int NOTIFIED = -3;
    private int mCause;

    public void setEvent(int aCause) {
        this.mCause = aCause;
        this.notifyAll();
    }

    public static Event synchronizeEvent() {
        return new SynchEvent();
    }

    public int waitAll() {
        this.mCause = -1;
        try {
            this.wait();
            return this.mCause;
        }
        catch (InterruptedException e) {
            return -2;
        }
    }

    public int waitAll(long aTimeOut) {
        this.mCause = -1;
        try {
            this.wait(aTimeOut);
            return this.mCause;
        }
        catch (InterruptedException e) {
            return -2;
        }
    }

    private static class SynchEvent
    extends Event {
        private final Event mSourceEvent = new Event();

        SynchEvent() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setEvent(int aCause) {
            Event event = this.mSourceEvent;
            synchronized (event) {
                this.mSourceEvent.setEvent(aCause);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int waitAll() {
            Event event = this.mSourceEvent;
            synchronized (event) {
                return this.mSourceEvent.waitAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int waitAll(long alTimeOut) {
            Event event = this.mSourceEvent;
            synchronized (event) {
                return this.mSourceEvent.waitAll(alTimeOut);
            }
        }
    }
}

