/*
 * Decompiled with CFR 0.152.
 */
package com.fxcm.messaging.util.fix.response;

import com.fxcm.GenericException;
import com.fxcm.fix.CollInquiryResultFactory;
import com.fxcm.fix.CollInquiryStatusFactory;
import com.fxcm.fix.ExecTypeFactory;
import com.fxcm.fix.FXCMOrdStatusFactory;
import com.fxcm.fix.FXCMTimingIntervalFactory;
import com.fxcm.fix.IFXCMTimingInterval;
import com.fxcm.fix.Instrument;
import com.fxcm.fix.MDReqRejReasonFactory;
import com.fxcm.fix.OrdStatusFactory;
import com.fxcm.fix.Parameter;
import com.fxcm.fix.Parties;
import com.fxcm.fix.Party;
import com.fxcm.fix.PosReqResultFactory;
import com.fxcm.fix.PosReqStatusFactory;
import com.fxcm.fix.PriceStream;
import com.fxcm.fix.SideFactory;
import com.fxcm.fix.TradingSecurity;
import com.fxcm.fix.UTCTimestamp;
import com.fxcm.fix.custom.FXCMResponse;
import com.fxcm.fix.entity.MarketDataSnapshot;
import com.fxcm.fix.other.UserResponse;
import com.fxcm.fix.posttrade.CollateralInquiryAck;
import com.fxcm.fix.posttrade.CollateralReport;
import com.fxcm.fix.posttrade.PositionReport;
import com.fxcm.fix.posttrade.RequestForPositionsAck;
import com.fxcm.fix.pretrade.MarketDataRequestReject;
import com.fxcm.fix.trade.ExecutionReport;
import com.fxcm.messaging.ITransportable;
import com.fxcm.messaging.util.DBParamUtil;
import com.fxcm.messaging.util.fix.ExecutionReportEx;
import com.fxcm.messaging.util.fix.FXCMCommandType;
import com.fxcm.messaging.util.fix.IProcessor;
import com.fxcm.messaging.util.fix.ISessionStrategy;
import com.fxcm.messaging.util.fix.TradingSecurityAdj;
import com.fxcm.messaging.util.fix.TradingSessionStatusAdj;
import com.fxcm.util.Util;
import com.fxcm.util.logging.Utils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.apache.commons.logging.Log;

public class ResponseProcessor
implements IProcessor {
    private Log mLogger = Utils.getLog(this);
    private HashMap mProcessors = new HashMap();
    private ISessionStrategy mSession;

    protected void fillParties(Map aParams, Parties aParties) {
        if (aParams != null) {
            String p;
            String loginID;
            String acctID = (String)aParams.get("AcctID");
            if (acctID != null && aParties.getFXCMAcctID() == 0L) {
                try {
                    aParties.setFXCMAcctID(Long.parseLong(acctID));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if ((loginID = (String)aParams.get("LoginID")) != null && aParties.getFXCMTraderLoginId() == null) {
                aParties.setFXCMTraderLoginId(loginID);
            }
            if ((p = (String)aParams.get("PARTIES")) != null) {
                try {
                    String[] parties = Util.splitToArray(p, "[");
                    for (int i = 0; i < parties.length; ++i) {
                        String party = parties[i].substring(0, parties[i].length() - 1);
                        String[] tokens = Util.splitToArray(party, ",");
                        Party pty = new Party(tokens[0], tokens[1], tokens[2]);
                        for (int j = 3; j < tokens.length; ++j) {
                            pty.setSubParty(tokens[j], tokens[++j]);
                        }
                        aParties.addParty(pty);
                    }
                }
                catch (Exception e) {
                    this.mLogger.error(e.getMessage(), e);
                }
            }
        }
    }

    public ResponseProcessor(ISessionStrategy aSession) {
        AccountProcessor acctProcessor = new AccountProcessor();
        OrderProcessor orderProcessor = new OrderProcessor();
        OpenPositionProcessor oposProcessor = new OpenPositionProcessor();
        ClosedPositionProcessor cposProcessor = new ClosedPositionProcessor();
        OrderStatusProcessor orderStatusProcessor = new OrderStatusProcessor();
        OfferProcessor offerProcessor = new OfferProcessor();
        UserResponseProcessor userResponseProcessor = new UserResponseProcessor();
        SysParamsProcessor sysParamsProcessor = new SysParamsProcessor();
        PriceStreamProcessor priceStreamProcessor = new PriceStreamProcessor();
        TProfileProcessor tprofileProcessor = new TProfileProcessor();
        InstrumentProcessor instrumentProcessor = new InstrumentProcessor();
        this.mProcessors.put(FXCMCommandType.GET_TRADER_ACCOUNTS, acctProcessor);
        this.mProcessors.put(FXCMCommandType.GET_TRADER_ORDERS, orderProcessor);
        this.mProcessors.put(FXCMCommandType.GET_OFFERS, offerProcessor);
        this.mProcessors.put(FXCMCommandType.GET_SELECTED_OFFERS, offerProcessor);
        this.mProcessors.put(FXCMCommandType.GET_TRADER_OPENPOSITIONS, oposProcessor);
        this.mProcessors.put(FXCMCommandType.GET_INSTRUMENTS, instrumentProcessor);
        this.mProcessors.put(FXCMCommandType.GET_INSTRUMENTS_EX, instrumentProcessor);
        this.mProcessors.put(FXCMCommandType.GET_DEALER_ORDERS, orderProcessor);
        this.mProcessors.put(FXCMCommandType.GET_DEALER_OPENPOSITIONS, oposProcessor);
        this.mProcessors.put(FXCMCommandType.GET_LOGIN_OPENPOSITIONS, oposProcessor);
        this.mProcessors.put(FXCMCommandType.GET_ACCT_OPENPOSITIONS, oposProcessor);
        this.mProcessors.put(FXCMCommandType.GET_LOGIN_ORDERS, orderProcessor);
        this.mProcessors.put(FXCMCommandType.GET_ACCT_ORDERS, orderProcessor);
        this.mProcessors.put(FXCMCommandType.GET_ORDER_HISTORY, orderProcessor);
        this.mProcessors.put(FXCMCommandType.GET_TRADER_CLOSEDPOSITIONS, cposProcessor);
        this.mProcessors.put(FXCMCommandType.GET_LOGIN_CLOSEDPOSITIONS, cposProcessor);
        this.mProcessors.put(FXCMCommandType.GET_DEALER_CLOSEDPOSITIONS, cposProcessor);
        this.mProcessors.put(FXCMCommandType.GET_ACCT_CLOSEDPOSITIONS, cposProcessor);
        this.mProcessors.put(FXCMCommandType.GET_ACCT_ACCOUNTS, acctProcessor);
        this.mProcessors.put(FXCMCommandType.GET_LOGIN_ACCOUNTS, acctProcessor);
        this.mProcessors.put(FXCMCommandType.GET_POSID_OPENPOSITIONS, oposProcessor);
        this.mProcessors.put(FXCMCommandType.GET_ORDERID_OPENPOSITIONS, oposProcessor);
        this.mProcessors.put(FXCMCommandType.GET_QID_OPENPOSITIONS, oposProcessor);
        this.mProcessors.put(FXCMCommandType.GET_QTXT_OPENPOSITIONS, oposProcessor);
        this.mProcessors.put(FXCMCommandType.GET_POSID_CLOSEDPOSITIONS, cposProcessor);
        this.mProcessors.put(FXCMCommandType.GET_ORDERID_CLOSEDPOSITIONS, cposProcessor);
        this.mProcessors.put(FXCMCommandType.GET_QID_CLOSEDPOSITIONS, cposProcessor);
        this.mProcessors.put(FXCMCommandType.GET_QTXT_CLOSEDPOSITIONS, cposProcessor);
        this.mProcessors.put(FXCMCommandType.GET_DEALER_ACCOUNTS, acctProcessor);
        this.mProcessors.put(FXCMCommandType.GET_ORDER_STATUS, orderStatusProcessor);
        this.mProcessors.put(FXCMCommandType.GET_SNAPSHOT_CLOSEDPOSITIONS, cposProcessor);
        this.mProcessors.put(FXCMCommandType.GET_CHECK_SESSION, userResponseProcessor);
        this.mProcessors.put(FXCMCommandType.GET_SYSTEM_PARAMETERS, sysParamsProcessor);
        this.mProcessors.put(FXCMCommandType.GET_PRICESTREAMS, priceStreamProcessor);
        this.mProcessors.put(FXCMCommandType.GET_TPROFILES, tprofileProcessor);
        this.mSession = aSession;
    }

    private RequestForPositionsAck createAck(Map aParams, String aReqID, PositionReport[] aPositions, String aFxcmErrorDetails, String aText, String aTradingSessionID, String aTradingSessionSubID) {
        RequestForPositionsAck rpa = new RequestForPositionsAck();
        rpa.setAccount((String)aParams.get("AcctReportID"));
        rpa.setPosReqID(aReqID);
        if (aPositions.length > 0) {
            rpa.setPosMaintRptID(aPositions[0].getPosMaintRptID());
            rpa.setTotalNumPosReports(aPositions.length);
            rpa.setPosReqResult(PosReqResultFactory.VALID_REQUEST);
            rpa.setPosReqStatus(PosReqStatusFactory.COMPLETED);
        } else {
            rpa.setPosMaintRptID("0");
            rpa.setTotalNumPosReports(0);
            rpa.setFXCMErrorDetails(aFxcmErrorDetails);
            rpa.setFXCMRequestRejectReason(2);
            rpa.setPosReqResult(PosReqResultFactory.NO_POSITIONS_FOUND_THAT_MATCH_CRITERIA);
            rpa.setPosReqStatus(PosReqStatusFactory.REJECTED);
            rpa.setText(aText);
        }
        rpa.setTradingSessionID(aTradingSessionID);
        rpa.setTradingSessionSubID(aTradingSessionSubID);
        return rpa;
    }

    @Override
    public void process(ITransportable aObj) throws GenericException {
        FXCMResponse fxcmResponse = (FXCMResponse)aObj;
        FXCMCommandType key = FXCMCommandType.getCommandType(fxcmResponse.getFXCMCommandID());
        if (key == null && "V".equals(fxcmResponse.getRefMsgType())) {
            this.parseChartResponse(fxcmResponse);
        } else {
            IProcessor processor = (IProcessor)this.mProcessors.get(key);
            if (processor != null) {
                processor.process(aObj);
            }
        }
    }

    private void parseChartResponse(FXCMResponse aFxcmResponse) {
        String dasResponse = aFxcmResponse.getParam("DAS");
        TradingSecurity instrument = this.mSession.getParser().getTradingSessionStatus().getSecurity(aFxcmResponse.getParam("55"));
        IFXCMTimingInterval interval = FXCMTimingIntervalFactory.toCode(Integer.parseInt(aFxcmResponse.getParam("9011")));
        String[] rows = Util.splitToArray(dasResponse, "\n");
        for (int i = 0; i < rows.length; ++i) {
            String[] columns = Util.splitToArray(rows[i], ";");
            MarketDataSnapshot mds = new MarketDataSnapshot();
            mds.setMDReqID(aFxcmResponse.getRequestID());
            ((com.fxcm.fix.pretrade.MarketDataSnapshot)mds).setTradingSessionID(this.mSession.getTradingSessionID());
            ((com.fxcm.fix.pretrade.MarketDataSnapshot)mds).setTradingSessionSubID(this.mSession.getTradingSessionSubID());
            ((com.fxcm.fix.pretrade.MarketDataSnapshot)mds).setInstrument(instrument);
            ((com.fxcm.fix.pretrade.MarketDataSnapshot)mds).setFXCMTimingInterval(interval);
            if (i == rows.length - 1) {
                mds.setFXCMContinuousFlag(2);
            } else {
                mds.setFXCMContinuousFlag(1);
            }
            mds.setTradeable(false);
            mds.setComplete(true);
            mds.setOpenTimestamp(new UTCTimestamp(columns[0]));
            try {
                ((com.fxcm.fix.pretrade.MarketDataSnapshot)mds).setBidOpen(Double.parseDouble(columns[1]));
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                ((com.fxcm.fix.pretrade.MarketDataSnapshot)mds).setBidClose(Double.parseDouble(columns[2]));
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                ((com.fxcm.fix.pretrade.MarketDataSnapshot)mds).setBidHigh(Double.parseDouble(columns[3]));
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                ((com.fxcm.fix.pretrade.MarketDataSnapshot)mds).setBidLow(Double.parseDouble(columns[4]));
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                ((com.fxcm.fix.pretrade.MarketDataSnapshot)mds).setAskOpen(Double.parseDouble(columns[5]));
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                ((com.fxcm.fix.pretrade.MarketDataSnapshot)mds).setAskClose(Double.parseDouble(columns[6]));
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                ((com.fxcm.fix.pretrade.MarketDataSnapshot)mds).setAskHigh(Double.parseDouble(columns[7]));
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                ((com.fxcm.fix.pretrade.MarketDataSnapshot)mds).setAskLow(Double.parseDouble(columns[8]));
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.mSession.sendBackToUser(mds);
        }
    }

    private void sendPositions(PositionReport[] aPositions, String aReqID, List aMsgs, Map aParams) {
        if (aPositions.length > 0) {
            for (int i = 0; i < aPositions.length; ++i) {
                PositionReport pr = aPositions[i];
                pr.setPosReqID(aReqID);
                pr.setTotalNumPosReports(aPositions.length);
                this.fillParties(aParams, pr.getParties());
                if (i == aPositions.length - 1) {
                    pr.setLastRptRequested(true);
                } else {
                    pr.setLastRptRequested(false);
                }
                aMsgs.add(pr);
            }
        }
    }

    private class TProfileProcessor
    extends AMsgProcessor {
        private TProfileProcessor() {
        }

        @Override
        protected void onProcess(List aMsgs, String aMsg, String aReqID, String aTradingSessionID, String aTradingSessionSubID, int aUserKind, Map aParams) {
            String[] lines = Util.splitToArray(aMsg, "\n");
            String strtstr = ResponseProcessor.this.mSession.getTradingSessionStatus().getTradeProfileID() + "-";
            for (int i = 0; i < lines.length; ++i) {
                String tpid;
                if (!lines[i].startsWith(strtstr)) continue;
                ResponseProcessor.this.mLogger.debug("parsing tpoffer: '" + lines[i]);
                String[] tokens = Util.splitToArray(lines[i], ";");
                if (tokens.length <= 1 || !(tpid = tokens[1]).equalsIgnoreCase(ResponseProcessor.this.mSession.getTradingSessionStatus().getTradeProfileID())) continue;
                String offerid = tokens[2];
                TradingSecurityAdj securityAdj = ResponseProcessor.this.mSession.getTradingSessionStatus().getTradingSecurityAdj(Integer.parseInt(offerid));
                if (securityAdj == null) continue;
                String psid = tokens[3];
                String bidAdj = tokens[5];
                String askAdj = tokens[6];
                String baseUnitSize = tokens[8];
                String psname = tokens[10];
                ResponseProcessor.this.mLogger.debug("before " + securityAdj);
                try {
                    securityAdj.setFactor(Integer.parseInt(baseUnitSize));
                }
                catch (Exception aException) {
                    ResponseProcessor.this.mLogger.error(aException.getMessage(), aException);
                }
                try {
                    securityAdj.setBidAdjustment(Double.parseDouble(bidAdj));
                }
                catch (Exception aException) {
                    ResponseProcessor.this.mLogger.error(aException.getMessage(), aException);
                }
                try {
                    securityAdj.setAskAdjustment(Double.parseDouble(askAdj));
                }
                catch (Exception aException) {
                    ResponseProcessor.this.mLogger.error(aException.getMessage(), aException);
                }
                try {
                    securityAdj.setPriceStream(new PriceStream(Integer.parseInt(psid), psname));
                }
                catch (Exception aException) {
                    ResponseProcessor.this.mLogger.error(aException.getMessage(), aException);
                }
                ResponseProcessor.this.mLogger.debug("after  " + securityAdj);
            }
        }
    }

    private class PriceStreamProcessor
    extends AMsgProcessor {
        private PriceStreamProcessor() {
        }

        @Override
        protected void onProcess(List aMsgs, String aMsg, String aReqID, String aTradingSessionID, String aTradingSessionSubID, int aUserKind, Map aParams) {
            String[] lines = Util.splitToArray(aMsg, "\n");
            for (int i = 0; i < lines.length; ++i) {
                String[] tokens = Util.splitToArray(lines[i], ";");
                if (tokens.length != 2) continue;
                int key = Integer.parseInt(tokens[0]);
                String value = tokens[1];
                PriceStream priceStream = new PriceStream(key, value);
                ResponseProcessor.this.mLogger.debug("parsing pricestream: '" + lines[i] + "' " + priceStream);
                ResponseProcessor.this.mSession.getTradingSessionStatus().setPriceStream(priceStream);
            }
        }
    }

    private class SysParamsProcessor
    extends AMsgProcessor {
        private SysParamsProcessor() {
        }

        @Override
        protected void onProcess(List aMsgs, String aMsg, String aReqID, String aTradingSessionID, String aTradingSessionSubID, int aUserKind, Map aParams) {
            TradingSessionStatusAdj tssa = ResponseProcessor.this.mSession.getParser().getTradingSessionStatus();
            Parameter[] params = ResponseProcessor.this.mSession.getParser().parseSystemParameters(aMsg);
            if (params != null) {
                for (int i = 0; i < params.length; ++i) {
                    DBParamUtil.fill(tssa, params[i].getName(), params[i].getValue());
                }
            }
        }
    }

    private class UserResponseProcessor
    extends AMsgProcessor {
        private UserResponseProcessor() {
        }

        @Override
        protected void onProcess(List aMsgs, String aMsg, String aReqID, String aTradingSessionID, String aTradingSessionSubID, int aUserKind, Map aParams) {
            UserResponse resp = new UserResponse();
            resp.setUsername("[N/A]");
            resp.setUserRequestID(aReqID);
            resp.setUserStatus(1);
            aMsgs.add(resp);
        }
    }

    private class OfferProcessor
    extends AMsgProcessor {
        private OfferProcessor() {
        }

        @Override
        protected void onProcess(List aMsgs, String aMsg, String aReqID, String aTradingSessionID, String aTradingSessionSubID, int aUserKind, Map aParams) {
            com.fxcm.fix.pretrade.MarketDataSnapshot mds;
            int i;
            String symbols;
            com.fxcm.fix.pretrade.MarketDataSnapshot[] snapshots = ResponseProcessor.this.mSession.getParser().parseOffers(aMsg, aTradingSessionID, aTradingSessionSubID, aUserKind);
            Vector vector = null;
            if (aParams != null && (symbols = (String)aParams.get("symbols")) != null) {
                vector = Util.split(symbols, ",");
            }
            ArrayList<com.fxcm.fix.pretrade.MarketDataSnapshot> snapshotsToSend = new ArrayList<com.fxcm.fix.pretrade.MarketDataSnapshot>();
            for (i = 0; i < snapshots.length; ++i) {
                mds = snapshots[i];
                try {
                    if (vector != null && !vector.contains(mds.getInstrument().getSymbol())) continue;
                    snapshotsToSend.add(mds);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (snapshotsToSend.isEmpty()) {
                MarketDataRequestReject rej = new MarketDataRequestReject();
                rej.setMDReqID(aReqID);
                rej.setMDReqRejReason(MDReqRejReasonFactory.UNKNOWNSYMBOL);
                rej.setText("No symbols found matching this request: " + aParams.get("symbols"));
                rej.setInstrument(new Instrument("[N/A]"));
                aMsgs.add(rej);
            } else {
                for (i = 0; i < snapshotsToSend.size(); ++i) {
                    mds = (com.fxcm.fix.pretrade.MarketDataSnapshot)snapshotsToSend.get(i);
                    mds.setMDReqID(aReqID);
                    if (i == snapshotsToSend.size() - 1) {
                        mds.setFXCMContinuousFlag(2);
                    } else {
                        mds.setFXCMContinuousFlag(1);
                    }
                    aMsgs.add(mds);
                }
            }
        }
    }

    private class OrderStatusProcessor
    extends AMsgProcessor {
        private OrderStatusProcessor() {
        }

        @Override
        protected void onProcess(List aMsgs, String aMsg, String aReqID, String aTradingSessionID, String aTradingSessionSubID, int aUserKind, Map aParams) {
            ExecutionReportEx ep = ResponseProcessor.this.mSession.getParser().parseOrder(aMsg, aTradingSessionID, aTradingSessionSubID, aUserKind);
            ep.setOrdStatusReqID(aReqID);
            ep.setExecType(ExecTypeFactory.ORDER_STATUS);
            ResponseProcessor.this.fillParties(aParams, ep.getParties());
            aMsgs.add(ep);
        }
    }

    private class ClosedPositionProcessor
    extends AMsgProcessor {
        private ClosedPositionProcessor() {
        }

        @Override
        protected void onProcess(List aMsgs, String aMsg, String aReqID, String aTradingSessionID, String aTradingSessionSubID, int aUserKind, Map aParams) {
            PositionReport[] closedPositions = ResponseProcessor.this.mSession.getParser().parseClosedTrades(aMsg, aTradingSessionID, aTradingSessionSubID, aUserKind);
            RequestForPositionsAck rpa = ResponseProcessor.this.createAck(aParams, aReqID, closedPositions, "No close positions in response", "No trades in response", aTradingSessionID, aTradingSessionSubID);
            ResponseProcessor.this.fillParties(aParams, rpa.getParties());
            aMsgs.add(rpa);
            ResponseProcessor.this.sendPositions(closedPositions, aReqID, aMsgs, aParams);
        }
    }

    private class OpenPositionProcessor
    extends AMsgProcessor {
        private OpenPositionProcessor() {
        }

        @Override
        protected void onProcess(List aMsgs, String aMsg, String aReqID, String aTradingSessionID, String aTradingSessionSubID, int aUserKind, Map aParams) {
            PositionReport[] positions = ResponseProcessor.this.mSession.getParser().parseOpenTrades(aMsg, aTradingSessionID, aTradingSessionSubID, aUserKind);
            RequestForPositionsAck rpa = ResponseProcessor.this.createAck(aParams, aReqID, positions, "No open positions in response", "No positions in response", aTradingSessionID, aTradingSessionSubID);
            ResponseProcessor.this.fillParties(aParams, rpa.getParties());
            aMsgs.add(rpa);
            ResponseProcessor.this.sendPositions(positions, aReqID, aMsgs, aParams);
        }
    }

    private class OrderProcessor
    extends AMsgProcessor {
        private OrderProcessor() {
        }

        @Override
        protected void onProcess(List aMsgs, String aMsg, String aReqID, String aTradingSessionID, String aTradingSessionSubID, int aUserKind, Map aParams) {
            ExecutionReportEx[] orders = ResponseProcessor.this.mSession.getParser().parseOrders(aMsg, aTradingSessionID, aTradingSessionSubID, aUserKind);
            if (orders.length > 0) {
                for (int i = 0; i < orders.length; ++i) {
                    ExecutionReportEx ep = orders[i];
                    ep.setExecType(ExecTypeFactory.ORDER_STATUS);
                    ep.setMassStatusReqID(aReqID);
                    ep.setTotNumReports(orders.length);
                    ResponseProcessor.this.fillParties(aParams, ep.getParties());
                    if (i == orders.length - 1) {
                        ep.setLastRptRequested(true);
                    } else {
                        ep.setLastRptRequested(false);
                    }
                    aMsgs.add(ep);
                }
            } else {
                ExecutionReport ep = new ExecutionReport();
                ep.setAccount((String)aParams.get("AcctReportID"));
                ep.setOrderID("NONE");
                ep.setMassStatusReqID(aReqID);
                ep.setInstrument(new Instrument("[N/A]"));
                ResponseProcessor.this.fillParties(aParams, ep.getParties());
                ep.setTradingSessionID(aTradingSessionID);
                ep.setTradingSessionSubID(aTradingSessionSubID);
                ep.setTransactTime(new UTCTimestamp());
                ep.setExecID("0");
                ep.setExecType(ExecTypeFactory.ORDER_STATUS);
                ep.setLastRptRequested(true);
                ep.setOrdStatus(OrdStatusFactory.REJECTED);
                ep.setFXCMOrdStatus(FXCMOrdStatusFactory.REJECTED);
                ep.setOrderQty(0.0);
                ep.setPrice(0.0);
                ep.setSide(SideFactory.UNDISCLOSED);
                ep.setText("no order(s) found");
                ep.setTotNumReports(0);
                ep.setFXCMErrorDetails("no order(s) found");
                ep.setFXCMRequestRejectReason(2);
                aMsgs.add(ep);
            }
        }
    }

    private class AccountProcessor
    extends AMsgProcessor {
        private AccountProcessor() {
        }

        @Override
        protected void onProcess(List aMsgs, String aMsg, String aReqID, String aTradingSessionID, String aTradingSessionSubID, int aUserKind, Map aParams) {
            CollateralReport[] accts = ResponseProcessor.this.mSession.getParser().parseInitialAccountRetrieval(aMsg, aTradingSessionID, aTradingSessionSubID);
            CollateralInquiryAck cia = new CollateralInquiryAck();
            cia.setCollInquiryID(aReqID);
            cia.setAccount((String)aParams.get("AcctReportID"));
            ResponseProcessor.this.fillParties(aParams, cia.getParties());
            if (accts.length > 0) {
                cia.setCollInquiryResult(CollInquiryResultFactory.SUCCESSFUL);
                cia.setCollInquiryStatus(CollInquiryStatusFactory.COMPLETED);
                cia.setTotNumReports(accts.length);
            } else {
                cia.setCollInquiryResult(CollInquiryResultFactory.OTHER);
                cia.setCollInquiryStatus(CollInquiryStatusFactory.COMPLETED);
                cia.setFXCMErrorDetails("No account in response");
                cia.setFXCMRequestRejectReason(2);
                cia.setText("No Collateral Report in response");
                cia.setTotNumReports(0);
            }
            cia.setTradingSessionID(aTradingSessionID);
            cia.setTradingSessionSubID(aTradingSessionSubID);
            aMsgs.add(cia);
            for (int i = 0; i < accts.length; ++i) {
                CollateralReport cr = accts[i];
                cr.setCollInquiryID(aReqID);
                cr.setTotNumReports(accts.length);
                ResponseProcessor.this.fillParties(aParams, cr.getParties());
                if (i == accts.length - 1) {
                    cr.setLastRptRequested(true);
                } else {
                    cr.setLastRptRequested(false);
                }
                aMsgs.add(cr);
            }
        }
    }

    private class InstrumentProcessor
    extends AMsgProcessor {
        private InstrumentProcessor() {
        }

        @Override
        protected void onProcess(List aMsgs, String aMsg, String aReqID, String aTradingSessionID, String aTradingSessionSubID, int aUserKind, Map aParams) {
            ResponseProcessor.this.mSession.getParser().setInstruments(aMsg);
        }
    }

    private abstract class AMsgProcessor
    implements IProcessor {
        private AMsgProcessor() {
        }

        @Override
        public void process(ITransportable aObj) throws GenericException {
            FXCMResponse resp = (FXCMResponse)aObj;
            String msg = resp.getParam("DAS");
            String reqID = resp.getTestReqID();
            Vector msgs = new Vector();
            this.onProcess(msgs, msg, reqID, ResponseProcessor.this.mSession.getTradingSessionID(), ResponseProcessor.this.mSession.getTradingSessionSubID(), ResponseProcessor.this.mSession.getUserKind(), resp.getParams());
            if (!msgs.isEmpty()) {
                ResponseProcessor.this.mSession.sendBackToUser(msgs);
            }
        }

        protected abstract void onProcess(List var1, String var2, String var3, String var4, String var5, int var6, Map var7);
    }
}

