/*
 * Decompiled with CFR 0.152.
 */
package com.fxcm.messaging.util.fix.response;

import com.fxcm.GenericException;
import com.fxcm.fix.BusinessRejectReasonFactory;
import com.fxcm.fix.CollInquiryResultFactory;
import com.fxcm.fix.CollInquiryStatusFactory;
import com.fxcm.fix.CxlRejReasonFactory;
import com.fxcm.fix.CxlRejResponseToFactory;
import com.fxcm.fix.ExecTypeFactory;
import com.fxcm.fix.FXCMOrdStatusFactory;
import com.fxcm.fix.FXCMOrdTypeFactory;
import com.fxcm.fix.IFXCMOrdType;
import com.fxcm.fix.IOrdType;
import com.fxcm.fix.ISide;
import com.fxcm.fix.ITimeInForce;
import com.fxcm.fix.Instrument;
import com.fxcm.fix.OrdRejReasonFactory;
import com.fxcm.fix.OrdStatusFactory;
import com.fxcm.fix.OrdTypeFactory;
import com.fxcm.fix.Parties;
import com.fxcm.fix.PosReqResultFactory;
import com.fxcm.fix.PosReqStatusFactory;
import com.fxcm.fix.SideFactory;
import com.fxcm.fix.TimeInForceFactory;
import com.fxcm.fix.TradingSecurity;
import com.fxcm.fix.UTCTimestamp;
import com.fxcm.fix.custom.FXCMRequestReject;
import com.fxcm.fix.other.BusinessMessageReject;
import com.fxcm.fix.other.UserResponse;
import com.fxcm.fix.posttrade.CollateralInquiryAck;
import com.fxcm.fix.posttrade.RequestForPositionsAck;
import com.fxcm.fix.trade.ExecutionReport;
import com.fxcm.fix.trade.OrderCancelReject;
import com.fxcm.messaging.ITransportable;
import com.fxcm.messaging.util.fix.FXCMCommandType;
import com.fxcm.messaging.util.fix.FixFXMsgParser;
import com.fxcm.messaging.util.fix.IProcessor;
import com.fxcm.messaging.util.fix.ISessionStrategy;
import com.fxcm.util.logging.Utils;
import java.util.Hashtable;
import java.util.Map;
import org.apache.commons.logging.Log;

public class RejectProcessor
implements IProcessor {
    private Log mLogger;
    private Hashtable mProcessors;
    private ISessionStrategy mSession;

    public RejectProcessor(ISessionStrategy aSession) {
        this.mSession = aSession;
        this.mLogger = Utils.getLog(RejectProcessor.class);
        this.mProcessors = new Hashtable();
        CollateralInquiryAckProcessor ciaProcessor = new CollateralInquiryAckProcessor();
        ExecutionReportProcessor ermProcessor = new ExecutionReportProcessor("AF");
        ExecutionReportProcessor eroProcessor = new ExecutionReportProcessor("D");
        RequestForPositionsAckProcessor rpaProcessor = new RequestForPositionsAckProcessor();
        OrderCancelRejectProcessor ocrProcessor = new OrderCancelRejectProcessor("F");
        OrderCancelRejectProcessor ocrrProcessor = new OrderCancelRejectProcessor("G");
        OrderStatusRequestProcessor osrProcessor = new OrderStatusRequestProcessor();
        UserResponseProcessor urProcessor = new UserResponseProcessor();
        this.mProcessors.put(FXCMCommandType.GET_TRADER_ACCOUNTS, ciaProcessor);
        this.mProcessors.put(FXCMCommandType.GET_TRADER_ORDERS, ermProcessor);
        this.mProcessors.put(FXCMCommandType.GET_TRADER_OPENPOSITIONS, rpaProcessor);
        this.mProcessors.put(FXCMCommandType.REJECT_REQUOTE, new DummyProcessor());
        this.mProcessors.put(FXCMCommandType.DELETE_ORDER, ocrProcessor);
        this.mProcessors.put(FXCMCommandType.CHANGE_ORDER_RATE, ocrrProcessor);
        this.mProcessors.put(FXCMCommandType.GET_DEALER_ORDERS, ermProcessor);
        this.mProcessors.put(FXCMCommandType.GET_DEALER_OPENPOSITIONS, rpaProcessor);
        this.mProcessors.put(FXCMCommandType.ACCEPT_ORDER, eroProcessor);
        this.mProcessors.put(FXCMCommandType.CREATE_ORDER, eroProcessor);
        this.mProcessors.put(FXCMCommandType.GET_LOGIN_OPENPOSITIONS, rpaProcessor);
        this.mProcessors.put(FXCMCommandType.GET_ACCT_OPENPOSITIONS, rpaProcessor);
        this.mProcessors.put(FXCMCommandType.GET_LOGIN_ORDERS, ermProcessor);
        this.mProcessors.put(FXCMCommandType.GET_ACCT_ORDERS, ermProcessor);
        this.mProcessors.put(FXCMCommandType.GET_TRADER_CLOSEDPOSITIONS, rpaProcessor);
        this.mProcessors.put(FXCMCommandType.GET_LOGIN_CLOSEDPOSITIONS, rpaProcessor);
        this.mProcessors.put(FXCMCommandType.GET_DEALER_CLOSEDPOSITIONS, rpaProcessor);
        this.mProcessors.put(FXCMCommandType.GET_ACCT_CLOSEDPOSITIONS, rpaProcessor);
        this.mProcessors.put(FXCMCommandType.GET_CHECK_SESSION, urProcessor);
        this.mProcessors.put(FXCMCommandType.GET_ACCT_ACCOUNTS, ciaProcessor);
        this.mProcessors.put(FXCMCommandType.GET_LOGIN_ACCOUNTS, ciaProcessor);
        this.mProcessors.put(FXCMCommandType.GET_POSID_OPENPOSITIONS, rpaProcessor);
        this.mProcessors.put(FXCMCommandType.GET_ORDERID_OPENPOSITIONS, rpaProcessor);
        this.mProcessors.put(FXCMCommandType.GET_QID_OPENPOSITIONS, rpaProcessor);
        this.mProcessors.put(FXCMCommandType.GET_QTXT_OPENPOSITIONS, rpaProcessor);
        this.mProcessors.put(FXCMCommandType.GET_POSID_CLOSEDPOSITIONS, rpaProcessor);
        this.mProcessors.put(FXCMCommandType.GET_ORDERID_CLOSEDPOSITIONS, rpaProcessor);
        this.mProcessors.put(FXCMCommandType.GET_QID_CLOSEDPOSITIONS, rpaProcessor);
        this.mProcessors.put(FXCMCommandType.GET_QTXT_CLOSEDPOSITIONS, rpaProcessor);
        this.mProcessors.put(FXCMCommandType.GET_DEALER_ACCOUNTS, ciaProcessor);
        this.mProcessors.put(FXCMCommandType.GET_ORDER_STATUS, osrProcessor);
        this.mProcessors.put(FXCMCommandType.GET_ORDER_HISTORY, osrProcessor);
        this.mProcessors.put(FXCMCommandType.GET_SNAPSHOT_CLOSEDPOSITIONS, rpaProcessor);
    }

    @Override
    public void process(ITransportable aTransportable) throws GenericException {
        FXCMRequestReject resp = (FXCMRequestReject)aTransportable;
        FXCMCommandType key = FXCMCommandType.getCommandType(resp.getFXCMCommandID());
        String msgType = resp.getRefMsgType();
        if (msgType == null) {
            msgType = "U54";
        }
        if ("U54".equals(msgType)) {
            IProcessor processor = null;
            if (key != null) {
                processor = (IProcessor)this.mProcessors.get(key);
            }
            if (processor != null) {
                processor.process(aTransportable);
            } else {
                BusinessMessageReject bmr = new BusinessMessageReject();
                bmr.setBusinessRejectReason(BusinessRejectReasonFactory.OTHER);
                bmr.setBusinessRejectRefID(resp.getTestReqID());
                bmr.setText(resp.getErrorDetails());
                bmr.setFXCMErrorDetails(resp.getErrorDetails() + ":" + aTransportable);
                bmr.setFXCMRequestRejectReason(resp.getRequestReject());
                bmr.setRefMsgType("j");
                this.mSession.sendBackToUser(bmr);
            }
        } else {
            this.mSession.sendBackToUser(aTransportable);
        }
    }

    private class UserResponseProcessor
    extends AProcessor {
        private UserResponseProcessor() {
        }

        @Override
        protected ITransportable onProcess(FXCMRequestReject aMsg, String aTradingSessionID, String aTradingSessionSubID) {
            UserResponse resp = new UserResponse();
            resp.setUsername("[N/A]");
            resp.setUserRequestID(aMsg.getRequestID());
            resp.setUserStatusText("Trading session lost, please reconnect.");
            resp.setUserStatus(6);
            resp.setFXCMRequestRejectReason(3);
            resp.setFXCMErrorDetails(aMsg.getErrorDetails());
            return resp;
        }
    }

    private class OrderStatusRequestProcessor
    extends AProcessor {
        OrderStatusRequestProcessor() {
            super("H");
        }

        @Override
        protected ITransportable onProcess(FXCMRequestReject aMsg, String aTradingSessionID, String aTradingSessionSubID) {
            if (RejectProcessor.this.mLogger.isDebugEnabled()) {
                RejectProcessor.this.mLogger.debug("processing: " + aTradingSessionID + "=" + aTradingSessionSubID + " " + aMsg);
            }
            ExecutionReport exe = new ExecutionReport();
            exe.setAccount(aMsg.getParam("AcctReportID"));
            this.fillParties(aMsg.getParams(), exe.getParties());
            exe.setOrdRejReason(OrdRejReasonFactory.UNKNOWN_ORDER);
            exe.setFXCMOrdStatus(FXCMOrdStatusFactory.REJECTED);
            exe.setFXCMErrorDetails(aMsg.getErrorDetails());
            exe.setFXCMRequestRejectReason(aMsg.getRequestReject());
            exe.setText(aMsg.getErrorDetails());
            exe.setTradingSessionID(aTradingSessionID);
            exe.setTradingSessionSubID(aTradingSessionSubID);
            exe.setOrdStatusReqID(aMsg.getRequestID());
            String orderID = aMsg.getParam("OrderID");
            exe.setOrderID(orderID == null ? "NONE" : orderID);
            exe.setClOrdID(aMsg.getParam("OrderQID"));
            exe.setSecondaryClOrdID(aMsg.getParam("OrderQTXT"));
            exe.setInstrument(new Instrument("[N/A]"));
            exe.setSide(SideFactory.UNDISCLOSED);
            exe.setTransactTime(new UTCTimestamp());
            exe.setExecID("0");
            exe.setExecType(ExecTypeFactory.ORDER_STATUS);
            exe.setOrdStatus(OrdStatusFactory.REJECTED);
            return exe;
        }
    }

    private class CollateralInquiryAckProcessor
    extends AProcessor {
        CollateralInquiryAckProcessor() {
            super("BB");
        }

        @Override
        protected ITransportable onProcess(FXCMRequestReject aMsg, String aTradingSessionID, String aTradingSessionSubID) {
            if (RejectProcessor.this.mLogger.isDebugEnabled()) {
                RejectProcessor.this.mLogger.debug("processing: " + aTradingSessionID + "=" + aTradingSessionSubID + " " + aMsg);
            }
            CollateralInquiryAck cia = new CollateralInquiryAck();
            cia.setAccount(aMsg.getParam("AcctReportID"));
            this.fillParties(aMsg.getParams(), cia.getParties());
            cia.setCollInquiryID(aMsg.getTestReqID());
            cia.setCollInquiryResult(CollInquiryResultFactory.OTHER);
            cia.setCollInquiryStatus(CollInquiryStatusFactory.REJECTED);
            cia.setFXCMErrorDetails(aMsg.getErrorDetails());
            cia.setFXCMRequestRejectReason(aMsg.getRequestReject());
            cia.setText(aMsg.getErrorDetails());
            cia.setTotNumReports(0);
            cia.setTradingSessionID(aTradingSessionID);
            cia.setTradingSessionSubID(aTradingSessionSubID);
            return cia;
        }
    }

    private class RequestForPositionsAckProcessor
    extends AProcessor {
        RequestForPositionsAckProcessor() {
            super("AN");
        }

        @Override
        protected ITransportable onProcess(FXCMRequestReject aMsg, String aTradingSessionID, String aTradingSessionSubID) {
            if (RejectProcessor.this.mLogger.isDebugEnabled()) {
                RejectProcessor.this.mLogger.debug("processing: " + aTradingSessionID + "=" + aTradingSessionSubID + " " + aMsg);
            }
            RequestForPositionsAck rpa = new RequestForPositionsAck();
            rpa.setAccount(aMsg.getParam("AcctReportID"));
            rpa.setFXCMErrorDetails(aMsg.getErrorDetails());
            rpa.setFXCMRequestRejectReason(aMsg.getRequestReject());
            this.fillParties(aMsg.getParams(), rpa.getParties());
            rpa.setPosMaintRptID("0");
            rpa.setPosReqID(aMsg.getTestReqID());
            rpa.setPosReqResult(PosReqResultFactory.OTHER);
            rpa.setPosReqStatus(PosReqStatusFactory.REJECTED);
            rpa.setText(aMsg.getErrorDetails());
            rpa.setTotalNumPosReports(0);
            rpa.setTradingSessionID(aTradingSessionID);
            rpa.setTradingSessionSubID(aTradingSessionSubID);
            return rpa;
        }
    }

    private class ExecutionReportProcessor
    extends AProcessor {
        ExecutionReportProcessor(String aRefMsgType) {
            super(aRefMsgType);
        }

        @Override
        protected ITransportable onProcess(FXCMRequestReject aMsg, String aTradingSessionID, String aTradingSessionSubID) {
            ISide side;
            if (RejectProcessor.this.mLogger.isDebugEnabled()) {
                RejectProcessor.this.mLogger.debug("processing: " + aTradingSessionID + "=" + aTradingSessionSubID + " " + aMsg);
            }
            ExecutionReport ep = new ExecutionReport();
            ep.setAccount(aMsg.getParam("AcctReportID"));
            ep.setOrderID("NONE");
            this.fillParties(aMsg.getParams(), ep.getParties());
            ep.setTradingSessionID(aTradingSessionID);
            ep.setTradingSessionSubID(aTradingSessionSubID);
            ep.setTransactTime(new UTCTimestamp());
            ep.setExecID("0");
            ep.setExecType(ExecTypeFactory.REJECTED);
            ep.setLastRptRequested(true);
            ep.setOrdStatus(OrdStatusFactory.REJECTED);
            ep.setFXCMOrdStatus(FXCMOrdStatusFactory.REJECTED);
            ep.setText(aMsg.getErrorDetails());
            ep.setTotNumReports(0);
            ep.setFXCMErrorDetails(aMsg.getErrorDetails());
            ep.setFXCMRequestRejectReason(aMsg.getRequestReject());
            String param = aMsg.getParam("Quantity");
            if (param != null) {
                try {
                    ep.setOrderQty(Double.parseDouble(param));
                }
                catch (Exception e) {
                    RejectProcessor.this.mLogger.error(e.getMessage(), e);
                }
            }
            ep.setOrderPercent("Y".equalsIgnoreCase(aMsg.getParam("NET_QTY_FLG")) ? 1.0 : 0.0);
            ep.setOrdRejReason(OrdRejReasonFactory.OTHER);
            if (aMsg.getErrorDetails() != null) {
                if (aMsg.getErrorDetails().indexOf("ORA-20199") != -1) {
                    ep.setOrdRejReason(OrdRejReasonFactory.DUPLICATE_ORDER);
                } else if (aMsg.getErrorDetails().indexOf("ORA-20169") != -1) {
                    ep.setOrdRejReason(OrdRejReasonFactory.UNKNOWN_ORDER);
                }
            }
            if ((side = SideFactory.toCode(aMsg.getParam("SIDE"))) == null) {
                String buysell = aMsg.getParam("BuySell");
                side = "S".equalsIgnoreCase(buysell) ? SideFactory.SELL : ("B".equalsIgnoreCase(buysell) ? SideFactory.BUY : SideFactory.UNDISCLOSED);
            }
            ep.setSide(side);
            if ("AF".equals(this.mRefMsgType)) {
                ep.setMassStatusReqID(aMsg.getTestReqID());
                ep.setInstrument(new Instrument("[N/A]"));
                ep.setPrice(0.0);
                ep.setOrderQty(0.0);
            } else {
                IFXCMOrdType fxcmType;
                ep.setListID(aMsg.getParam("LIST_ID"));
                ep.setClOrdID(aMsg.getTestReqID());
                String s = aMsg.getParam("QTXT");
                if (s != null && s.length() > 0) {
                    ep.setSecondaryClOrdID(s);
                }
                ep.setInstrument(this.findInstrument(aMsg.getParams()));
                s = aMsg.getParam("TradeID");
                if (s != null && s.length() > 0) {
                    ep.setFXCMPosID(s);
                }
                s = aMsg.getParam("OrderType");
                IOrdType type = null;
                if (s != null && s.length() > 0 && (fxcmType = FXCMOrdTypeFactory.toCode(s)) != null) {
                    type = FixFXMsgParser.toOrdType(fxcmType);
                }
                if (type == null) {
                    type = OrdTypeFactory.MARKET;
                }
                ep.setOrdType(type);
                s = aMsg.getParam("GTC");
                if ("Y".equals(s)) {
                    ep.setTimeInForce(TimeInForceFactory.GOOD_TILL_CANCEL);
                } else {
                    ITimeInForce timeInForce = TimeInForceFactory.toCodeByLabel(s);
                    if (timeInForce == null) {
                        ep.setTimeInForce(TimeInForceFactory.IMMEDIATE_OR_CANCEL);
                    } else {
                        ep.setTimeInForce(timeInForce);
                    }
                }
                try {
                    TradingSecurity ts;
                    boolean set = false;
                    if (ep.getInstrument() instanceof TradingSecurity && !(ts = (TradingSecurity)ep.getInstrument()).isForex()) {
                        ep.setCurrency(ts.getCurrency());
                        set = true;
                    }
                    if (!set) {
                        ep.setCurrency(ep.getInstrument().getSymbol().substring(0, 3));
                    }
                }
                catch (Exception e) {
                    RejectProcessor.this.mLogger.error(e.getMessage(), e);
                }
                s = aMsg.getParam("Rate");
                if (s != null && s.length() > 0) {
                    try {
                        double d = Double.parseDouble(s);
                        if (ep.getOrdType() == OrdTypeFactory.STOP || ep.getOrdType() == OrdTypeFactory.STOP_LIMIT) {
                            ep.setStopPx(d);
                            ep.setPrice(d);
                        } else {
                            ep.setPrice(d);
                        }
                    }
                    catch (Exception e) {
                        RejectProcessor.this.mLogger.error(e.getMessage(), e);
                    }
                }
                if ((s = aMsg.getParam("Quantity")) != null && s.length() > 0) {
                    try {
                        int i = Integer.parseInt(s);
                        double d = RejectProcessor.this.mSession.getParser().lotsToAbsolute(i, ep.getInstrument().getFXCMSymID());
                        ep.setOrderQty(d);
                    }
                    catch (Exception e) {
                        RejectProcessor.this.mLogger.error(e.getMessage(), e);
                    }
                }
            }
            return ep;
        }
    }

    private class OrderCancelRejectProcessor
    extends AProcessor {
        OrderCancelRejectProcessor(String aRefMsgType) {
            super(aRefMsgType);
        }

        @Override
        protected ITransportable onProcess(FXCMRequestReject aMsg, String aTradingSessionID, String aTradingSessionSubID) {
            if (RejectProcessor.this.mLogger.isDebugEnabled()) {
                RejectProcessor.this.mLogger.debug("processing: " + aTradingSessionID + "=" + aTradingSessionSubID + " " + aMsg);
            }
            OrderCancelReject ocr = new OrderCancelReject();
            ocr.setAccount(aMsg.getParam("AcctReportID"));
            String s = aMsg.getParam("OrderID");
            if (s == null || s.length() == 0) {
                s = "NONE";
            }
            ocr.setOrderID(s);
            s = aMsg.getParam("OriginQID");
            if (s == null || s.length() == 0) {
                s = "[N/A]";
            }
            ocr.setOrigClOrdID(s);
            ocr.setClOrdID(aMsg.getTestReqID());
            ocr.setSecondaryClOrdID(aMsg.getParam("QTXT"));
            ocr.setTradingSessionID(aTradingSessionID);
            ocr.setTradingSessionSubID(aTradingSessionSubID);
            ocr.setTransactTime(new UTCTimestamp());
            ocr.setCxlRejReason(CxlRejReasonFactory.OTHER);
            if (aMsg.getErrorDetails() != null && aMsg.getErrorDetails().indexOf("ORA-20169") != -1) {
                ocr.setCxlRejReason(CxlRejReasonFactory.UNKNOWN_ORDER);
            }
            if (this.mRefMsgType.equals("G")) {
                ocr.setCxlRejResponseTo(CxlRejResponseToFactory.ORDER_CANCEL_REPLACE_REQUEST);
            } else {
                ocr.setCxlRejResponseTo(CxlRejResponseToFactory.ORDER_CANCEL_REQUEST);
            }
            ocr.setFXCMErrorDetails(aMsg.getErrorDetails());
            ocr.setFXCMRequestRejectReason(aMsg.getRequestReject());
            ocr.setOrdStatus(OrdStatusFactory.REJECTED);
            ocr.setText(aMsg.getErrorDetails());
            return ocr;
        }
    }

    private abstract class AProcessor
    implements IProcessor {
        protected String mRefMsgType;

        protected AProcessor() {
            this.mRefMsgType = "j";
        }

        protected AProcessor(String aRefMsgType) {
            this.mRefMsgType = aRefMsgType;
        }

        @Override
        public void process(ITransportable aTransportable) {
            ITransportable ret;
            FXCMRequestReject resp = (FXCMRequestReject)aTransportable;
            if (resp.getErrorDetails() != null) {
                resp.setErrorDetails(resp.getErrorDetails().replaceAll("\\r\\n|\\r|\\n", ""));
            }
            if (resp.getText() != null) {
                resp.setText(resp.getText().replaceAll("\\r\\n|\\r|\\n", ""));
            }
            if ((ret = this.onProcess(resp, RejectProcessor.this.mSession.getTradingSessionID(), RejectProcessor.this.mSession.getTradingSessionSubID())) == null) {
                BusinessMessageReject bmr = new BusinessMessageReject();
                bmr.setFXCMErrorDetails(resp.getErrorDetails());
                bmr.setFXCMRequestRejectReason(resp.getRequestReject());
                bmr.setBusinessRejectReason(BusinessRejectReasonFactory.OTHER);
                bmr.setBusinessRejectRefID(resp.getTestReqID());
                bmr.setRefMsgType(this.mRefMsgType);
                bmr.setText(resp.getErrorDetails());
                bmr.setTradingSessionID(RejectProcessor.this.mSession.getTradingSessionID());
                bmr.setTradingSessionSubID(RejectProcessor.this.mSession.getTradingSessionSubID());
                ret = bmr;
            }
            RejectProcessor.this.mSession.sendBackToUser(ret);
        }

        protected abstract ITransportable onProcess(FXCMRequestReject var1, String var2, String var3);

        protected void fillParties(Map aParams, Parties aParties) {
            if (aParams != null) {
                String acctID = (String)aParams.get("AcctID");
                if (acctID != null) {
                    try {
                        aParties.setFXCMAcctID(Long.parseLong(acctID));
                    }
                    catch (Exception e) {
                        RejectProcessor.this.mLogger.error(e.getMessage(), e);
                    }
                }
                aParties.setFXCMTraderLoginId((String)aParams.get("LoginID"));
            }
        }

        protected Instrument findInstrument(Map aParams) {
            String symbol;
            Instrument ret = null;
            if (aParams != null && (symbol = (String)aParams.get("CCY1CCY2")) != null && symbol.length() > 0) {
                ret = RejectProcessor.this.mSession.getTradingSessionStatus().getSecurity(symbol);
            }
            if (ret == null) {
                ret = new Instrument("[N/A]", 0, 0);
            }
            return ret;
        }
    }

    private class DummyProcessor
    implements IProcessor {
        private DummyProcessor() {
        }

        @Override
        public void process(ITransportable aTransportable) {
            RejectProcessor.this.mLogger.error("do nothing " + aTransportable);
        }
    }
}

