/*
 * Decompiled with CFR 0.152.
 */
package com.fxcm.messaging.util.fix.response;

import com.fxcm.GenericException;
import com.fxcm.fix.pretrade.inner.MarketDataEntry;
import com.fxcm.fix.pretrade.inner.MarketDataSnapshot;
import com.fxcm.messaging.ITransportable;
import com.fxcm.messaging.util.fix.IProcessor;
import com.fxcm.messaging.util.fix.ISessionStrategy;
import com.fxcm.messaging.util.fix.TradingSecurityAdj;
import com.fxcm.messaging.util.fix.TradingSessionStatusAdj;
import com.fxcm.util.Util;
import com.fxcm.util.logging.Utils;
import org.apache.commons.logging.Log;

public class MarketDataSnapshotProcessor
implements IProcessor {
    private final Log mLogger;
    private final ISessionStrategy mSession;

    public MarketDataSnapshotProcessor(ISessionStrategy aSession) {
        this.mSession = aSession;
        this.mLogger = Utils.getLog(this);
    }

    private boolean isAsk(String aType) {
        return "1".equals(aType) || "C".equals(aType) || "F".equals(aType) || "G".equals(aType) || "B".equals(aType);
    }

    private boolean isBid(String aType) {
        return "0".equals(aType) || "5".equals(aType) || "D".equals(aType) || "E".equals(aType) || "4".equals(aType);
    }

    @Override
    public void process(ITransportable aTransportable) throws GenericException {
        try {
            MarketDataSnapshot mds;
            TradingSecurityAdj ts;
            TradingSessionStatusAdj tss = this.mSession.getTradingSessionStatus();
            if (aTransportable != null && tss != null && (this.mSession.getMsgFlags() & 1L) == 0L && (ts = (TradingSecurityAdj)tss.getSecurity((mds = new MarketDataSnapshot((MarketDataSnapshot)aTransportable)).getInstrument().getSymbol())) != null) {
                mds.setInstrument(ts);
                if (!"PriceServer".equalsIgnoreCase(mds.getTradingSessionSubID()) && this.mSession.getUserKind() != 24) {
                    for (MarketDataEntry mde : mds.getMarketDataEntries()) {
                        if (ts.getBidAdjustment() != 0.0 && this.isBid(mde.getMDEntryType())) {
                            mde.setMDEntryPx(mde.getMDEntryPx() + ts.getBidAdjustment());
                        }
                        if (ts.getAskAdjustment() == 0.0 || !this.isAsk(mde.getMDEntryType())) continue;
                        mde.setMDEntryPx(mde.getMDEntryPx() + ts.getAskAdjustment());
                    }
                    mds.setMDReqID(null);
                }
                mds.setTradingSessionID(this.mSession.getTradingSessionID());
                mds.setTradingSessionSubID(this.mSession.getTradingSessionSubID());
                this.mSession.sendBackToUser(mds);
            }
        }
        catch (Exception e) {
            this.mLogger.error(Util.getStackTraceAsString(e), e);
        }
    }
}

