/*
 * Decompiled with CFR 0.152.
 */
package com.fxcm.messaging.util.fix.response;

import com.fxcm.GenericException;
import com.fxcm.fix.pretrade.MarketDataIncremental;
import com.fxcm.fix.pretrade.inner.MarketDataEntryIncremental;
import com.fxcm.messaging.ITransportable;
import com.fxcm.messaging.util.fix.IProcessor;
import com.fxcm.messaging.util.fix.ISessionStrategy;
import com.fxcm.messaging.util.fix.TradingSecurityAdj;
import com.fxcm.messaging.util.fix.TradingSessionStatusAdj;
import com.fxcm.util.Util;
import com.fxcm.util.logging.Utils;
import org.apache.commons.logging.Log;

public class MarketDataIncrementalProcessor
implements IProcessor {
    private final Log mLogger;
    private ISessionStrategy mSession;

    public MarketDataIncrementalProcessor(ISessionStrategy aSession) {
        this.mSession = aSession;
        this.mLogger = Utils.getLog(this);
    }

    @Override
    public void process(ITransportable aTransportable) throws GenericException {
        try {
            TradingSessionStatusAdj tss = this.mSession.getTradingSessionStatus();
            if (aTransportable != null && tss != null && (this.mSession.getMsgFlags() & 1L) == 0L) {
                MarketDataIncremental mdi = (MarketDataIncremental)aTransportable;
                MarketDataEntryIncremental[] incrementals = mdi.getMDEntries();
                for (int i = 0; i < incrementals.length; ++i) {
                    MarketDataEntryIncremental entry = incrementals[i];
                    TradingSecurityAdj ts = (TradingSecurityAdj)tss.getSecurity(entry.getInstrument().getSymbol());
                    if (ts == null) {
                        mdi.removeMDEntry(entry);
                        continue;
                    }
                    entry.setInstrument(ts);
                    if (this.mSession.getUserKind() == 24) continue;
                    if (ts.getBidAdjustment() != 0.0) {
                        if ("0".equals(entry.getMDEntryType())) {
                            entry.setMDEntryPx(entry.getMDEntryPx() + ts.getBidAdjustment());
                        }
                        if ("8".equals(entry.getMDEntryType()) && entry.getMDEntryPx() != 0.0) {
                            entry.setMDEntryPx(entry.getMDEntryPx() + ts.getBidAdjustment());
                        }
                    }
                    if (ts.getAskAdjustment() == 0.0) continue;
                    if ("1".equals(entry.getMDEntryType())) {
                        entry.setMDEntryPx(entry.getMDEntryPx() + ts.getAskAdjustment());
                    }
                    if (!"7".equals(entry.getMDEntryType()) || entry.getMDEntryPx() == 0.0) continue;
                    entry.setMDEntryPx(entry.getMDEntryPx() + ts.getAskAdjustment());
                }
                if (mdi.getMDEntries().length > 0) {
                    this.mSession.sendBackToUser(mdi);
                }
            }
        }
        catch (Exception e) {
            this.mLogger.error(Util.getStackTraceAsString(e), e);
        }
    }
}

