/*
 * Decompiled with CFR 0.152.
 */
package com.fxcm.messaging.util.fix.response;

import com.fxcm.GenericException;
import com.fxcm.fix.FXCMOrdStatusFactory;
import com.fxcm.fix.FixObjectFactory;
import com.fxcm.fix.Parameter;
import com.fxcm.fix.PriceStream;
import com.fxcm.fix.QuoteTypeFactory;
import com.fxcm.fix.SideFactory;
import com.fxcm.fix.UTCTimestamp;
import com.fxcm.fix.admin.Logout;
import com.fxcm.fix.custom.zdas.DasMessage;
import com.fxcm.fix.custom.zdas.DasMessageAnalyzer;
import com.fxcm.fix.posttrade.ClosedPositionReport;
import com.fxcm.fix.posttrade.CollateralReport;
import com.fxcm.fix.posttrade.PositionReport;
import com.fxcm.fix.pretrade.EMail;
import com.fxcm.fix.pretrade.MarketDataSnapshot;
import com.fxcm.fix.pretrade.Quote;
import com.fxcm.fix.pretrade.SecurityStatus;
import com.fxcm.messaging.ITransportable;
import com.fxcm.messaging.util.fix.ExecutionReportEx;
import com.fxcm.messaging.util.fix.IProcessor;
import com.fxcm.messaging.util.fix.ISessionStrategy;
import com.fxcm.messaging.util.fix.TradingSecurityAdj;
import com.fxcm.messaging.util.fix.TradingSessionStatusAdj;
import com.fxcm.util.Util;
import com.fxcm.util.logging.Utils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.apache.commons.logging.Log;

public class DasMsgProcessor
implements IProcessor {
    private Map mProcessors;
    private ISessionStrategy mSession;
    private final Log mLogger;

    public DasMsgProcessor(ISessionStrategy aSession) {
        this.mSession = aSession;
        this.mLogger = Utils.getLog(DasMsgProcessor.class);
        this.mProcessors = new HashMap();
        this.mProcessors.put("OFFER", new OfferProcessor());
        this.mProcessors.put("TRADE", new TradeProcessor());
        this.mProcessors.put("ORDER", new OrderProcessor());
        this.mProcessors.put("CLSDTRADE", new ClosedTradeProcessor());
        this.mProcessors.put("ACCT", new AccountProcessor());
        this.mProcessors.put("PARAM", new ParamProcessor());
        this.mProcessors.put("INSTRMT", new InstrmtProcessor());
        this.mProcessors.put("MAIL", new MailProcessor());
        this.mProcessors.put("RFQ", new RFQProcessor());
        this.mProcessors.put("SESSN", new SessionProcessor());
        this.mProcessors.put("TPOFFER", new TPOfferProcessor());
    }

    private DasMessage createDummyDasMessage(DasMessage aDasMessage, String aSubMsg) {
        if (this.mSession == null || aSubMsg == null || aDasMessage == null || this.mSession.isClosed()) {
            return null;
        }
        DasMessage dm = new DasMessage();
        dm.fill(aDasMessage);
        dm.setMessage(aSubMsg);
        return dm;
    }

    @Override
    public void process(ITransportable aTransportable) throws GenericException {
        try {
            if (aTransportable != null) {
                String[] messages;
                DasMessage dasMessage = (DasMessage)aTransportable;
                for (String subMsg : messages = Util.splitToArray(dasMessage.getMessage(), "\n")) {
                    String key;
                    IProcessor processor;
                    int pos;
                    long msgChannel;
                    long msgFlags = this.mSession.getMsgFlags();
                    if (!FixObjectFactory.isMsgReceiveOn(msgFlags, msgChannel = FixObjectFactory.getMessageChannel(DasMessageAnalyzer.getFixMsgType(subMsg))) || (pos = subMsg.indexOf(";")) <= 0 || (processor = (IProcessor)this.mProcessors.get(key = subMsg.substring(0, pos))) == null) continue;
                    processor.process(this.createDummyDasMessage(dasMessage, subMsg));
                }
            }
        }
        catch (Exception e) {
            this.mLogger.error(Util.getStackTraceAsString(e));
        }
    }

    private class TPOfferProcessor
    extends AProcessor {
        private TPOfferProcessor() {
        }

        @Override
        protected void onProcess(List aMsgs, String aMsg, String aTradingSessionID, String aTradingSessionSubID, int aUserKind) throws GenericException {
            String[] tokens = Util.splitToArray(aMsg, ";");
            String tpid = tokens[2];
            if (tpid.equalsIgnoreCase(DasMsgProcessor.this.mSession.getTradingSessionStatus().getTradeProfileID())) {
                DasMsgProcessor.this.mLogger.debug("processing = " + aMsg);
                String offerid = tokens[3];
                TradingSecurityAdj securityAdj = DasMsgProcessor.this.mSession.getTradingSessionStatus().getTradingSecurityAdj(Integer.parseInt(offerid));
                if (securityAdj != null) {
                    String psid = tokens[7];
                    String bidAdj = tokens[9];
                    String askAdj = tokens[10];
                    String baseUnitSize = tokens[12];
                    String psname = tokens[14];
                    DasMsgProcessor.this.mLogger.debug("before " + securityAdj);
                    try {
                        securityAdj.setPriceStream(new PriceStream(Integer.parseInt(psid), psname));
                    }
                    catch (Exception aException) {
                        DasMsgProcessor.this.mLogger.error(aException.getMessage(), aException);
                    }
                    try {
                        securityAdj.setFactor(Integer.parseInt(baseUnitSize));
                    }
                    catch (Exception aException) {
                        DasMsgProcessor.this.mLogger.error(aException.getMessage(), aException);
                    }
                    try {
                        securityAdj.setBidAdjustment(Double.parseDouble(bidAdj));
                    }
                    catch (Exception aException) {
                        DasMsgProcessor.this.mLogger.error(aException.getMessage(), aException);
                    }
                    try {
                        securityAdj.setAskAdjustment(Double.parseDouble(askAdj));
                    }
                    catch (Exception aException) {
                        DasMsgProcessor.this.mLogger.error(aException.getMessage(), aException);
                    }
                    DasMsgProcessor.this.mLogger.debug("after  " + securityAdj);
                }
            }
        }
    }

    private class SessionProcessor
    extends AProcessor {
        private SessionProcessor() {
        }

        @Override
        protected void onProcess(List aMsgs, String aMsg, String aTradingSessionID, String aTradingSessionSubID, int aUserKind) throws GenericException {
            DasMsgProcessor.this.mLogger.debug("processing = " + aMsg);
            String[] tokens = Util.splitToArray(aMsg, ";");
            if (tokens.length >= 3 && "D".equalsIgnoreCase(tokens[1]) && DasMsgProcessor.this.mSession.getSessionID().equals(tokens[2])) {
                Logout logout = new Logout();
                logout.setText("Trading session lost, please reconnect.");
                aMsgs.add(logout);
            }
        }
    }

    private class TradeProcessor
    extends AProcessor {
        private TradeProcessor() {
        }

        @Override
        protected void onProcess(List aMsgs, String aMsg, String aTradingSessionID, String aTradingSessionSubID, int aUserKind) throws GenericException {
            PositionReport pr = DasMsgProcessor.this.mSession.getParser().parseTrade(aMsg, aTradingSessionID, aTradingSessionSubID, aUserKind);
            if (pr != null) {
                pr.setLastRptRequested(true);
                pr.setUnsolicitedIndicator(true);
                aMsgs.add(pr);
            }
        }
    }

    private class RFQProcessor
    extends AProcessor {
        private RFQProcessor() {
        }

        @Override
        protected void onProcess(List aMsgs, String aMsg, String aTradingSessionID, String aTradingSessionSubID, int aUserKind) throws GenericException {
            Quote quote = DasMsgProcessor.this.mSession.getParser().parseRFQ(aMsg, aTradingSessionID, aTradingSessionSubID);
            if (quote != null) {
                aMsgs.add(quote);
            }
        }
    }

    private class ParamProcessor
    extends AProcessor {
        private ParamProcessor() {
        }

        @Override
        protected void onProcess(List aMsgs, String aMsg, String aTradingSessionID, String aTradingSessionSubID, int aUserKind) throws GenericException {
            Parameter param = DasMsgProcessor.this.mSession.getParser().parseParam(aMsg);
            if (param != null && DasMsgProcessor.this.mSession.updateParam(param)) {
                TradingSessionStatusAdj tss = DasMsgProcessor.this.mSession.getTradingSessionStatus();
                tss.setTradingSessionID(DasMsgProcessor.this.mSession.getTradingSessionID());
                tss.setTradingSessionSubID(DasMsgProcessor.this.mSession.getTradingSessionSubID());
                tss.setTradSesReqID(null);
                tss.setTransactTime(new UTCTimestamp());
                tss.setUnsolicitedIndicator("Y");
                aMsgs.add(tss);
            }
        }
    }

    private class OrderProcessor
    extends AProcessor {
        private OrderProcessor() {
        }

        @Override
        protected void onProcess(List aMsgs, String aMsg, String aTradingSessionID, String aTradingSessionSubID, int aUserKind) throws GenericException {
            ExecutionReportEx er = DasMsgProcessor.this.mSession.getParser().parseOrder(aMsg, aTradingSessionID, aTradingSessionSubID, aUserKind);
            if (er != null) {
                er.setLastRptRequested(true);
                aMsgs.add(er);
                if (er.getFXCMOrdStatus() == FXCMOrdStatusFactory.REQUOTED) {
                    Quote quote = new Quote();
                    quote.setAccount(er.getAccount());
                    quote.setInstrument(er.getInstrument());
                    quote.setParties(er.getParties());
                    quote.setTradingSessionID(aTradingSessionID);
                    quote.setTradingSessionSubID(aTradingSessionSubID);
                    quote.setTransactTime(new UTCTimestamp());
                    if (SideFactory.SELL == er.getSide()) {
                        quote.setBidPx(er.getPrice());
                    } else {
                        quote.setOfferPx(er.getPrice());
                    }
                    quote.setQuoteID("Requote-" + er.getOrderID());
                    quote.setQuoteReqID(null);
                    quote.setQuoteType(QuoteTypeFactory.INDICATIVE);
                    quote.setSide(er.getSide());
                    quote.setOrderQty(er.getOrderQty());
                    long expiration = System.currentTimeMillis() + (long)(er.getLifeTime() * 1000);
                    quote.setValidUntilTime(new UTCTimestamp(expiration));
                    quote.setCurrency(er.getCurrency());
                    aMsgs.add(quote);
                }
            }
        }
    }

    private class OfferProcessor
    extends AProcessor {
        private OfferProcessor() {
        }

        @Override
        protected void onProcess(List aMsgs, String aMsg, String aTradingSessionID, String aTradingSessionSubID, int aUserKind) throws GenericException {
            MarketDataSnapshot mds = DasMsgProcessor.this.mSession.getParser().parseOffer(aMsg, aTradingSessionID, aTradingSessionSubID, aUserKind);
            if (mds != null) {
                String symbol = mds.getInstrument().getSymbol();
                mds.setInstrument(DasMsgProcessor.this.mSession.getTradingSessionStatus().getSecurity(symbol));
                mds.setTradeable("A".equals(mds.getAskQuoteCondition()) && mds.getAskQuoteType() == 1 && "A".equals(mds.getBidQuoteCondition()) && mds.getBidQuoteType() == 1);
                aMsgs.add(mds);
            }
        }
    }

    private class MailProcessor
    extends AProcessor {
        private MailProcessor() {
        }

        @Override
        protected void onProcess(List aMsgs, String aMsg, String aTradingSessionID, String aTradingSessionSubID, int aUserKind) throws GenericException {
            EMail email = DasMsgProcessor.this.mSession.getParser().parseMail(aMsg, aTradingSessionID, aTradingSessionSubID);
            if (email != null) {
                aMsgs.add(email);
            }
        }
    }

    private class InstrmtProcessor
    extends AProcessor {
        private InstrmtProcessor() {
        }

        @Override
        protected void onProcess(List aMsgs, String aMsg, String aTradingSessionID, String aTradingSessionSubID, int aUserKind) throws GenericException {
            TradingSecurityAdj ts = DasMsgProcessor.this.mSession.getParser().parseInstrument(aMsg, 0);
            if (ts != null) {
                TradingSessionStatusAdj tss = DasMsgProcessor.this.mSession.getTradingSessionStatus();
                TradingSecurityAdj security = tss.getTradingSecurityAdj(ts.getFXCMSymID());
                TradingSecurityAdj send = null;
                if (security != null && security.getPriceStream() != null && ts.getPriceStream() != null && security.getPriceStream().equals(ts.getPriceStream())) {
                    security.fill(ts);
                    send = security;
                }
                if (send != null) {
                    SecurityStatus ss = new SecurityStatus();
                    ss.setTradingSecurity(send);
                    ss.setTradingSessionID(aTradingSessionID);
                    ss.setTradingSessionSubID(aTradingSessionSubID);
                    aMsgs.add(ss);
                } else {
                    DasMsgProcessor.this.mLogger.trace("ignoring,incorrect stream: " + ts);
                }
            }
        }
    }

    private class ClosedTradeProcessor
    extends AProcessor {
        private ClosedTradeProcessor() {
        }

        @Override
        protected void onProcess(List aMsgs, String aMsg, String aTradingSessionID, String aTradingSessionSubID, int aUserKind) throws GenericException {
            ClosedPositionReport cpr = DasMsgProcessor.this.mSession.getParser().parseClosedTrade(aMsg, 0, aTradingSessionID, aTradingSessionSubID, aUserKind);
            if (cpr != null) {
                cpr.setLastRptRequested(true);
                cpr.setUnsolicitedIndicator(true);
                aMsgs.add(cpr);
            }
        }
    }

    private class AccountProcessor
    extends AProcessor {
        private AccountProcessor() {
        }

        @Override
        protected void onProcess(List aMsgs, String aMsg, String aTradingSessionID, String aTradingSessionSubID, int aUserKind) throws GenericException {
            CollateralReport cr = DasMsgProcessor.this.mSession.getParser().parseAccount(aMsg, aTradingSessionID, aTradingSessionSubID);
            if (cr != null) {
                cr.setLastRptRequested(true);
                aMsgs.add(cr);
            }
        }
    }

    private abstract class AProcessor
    implements IProcessor {
        private AProcessor() {
        }

        protected abstract void onProcess(List var1, String var2, String var3, String var4, int var5) throws GenericException;

        @Override
        public void process(ITransportable aTransportable) throws GenericException {
            Vector msgs = new Vector();
            if (aTransportable != null) {
                String msg = ((DasMessage)aTransportable).getMessage();
                this.onProcess(msgs, msg, DasMsgProcessor.this.mSession.getTradingSessionID(), DasMsgProcessor.this.mSession.getTradingSessionSubID(), DasMsgProcessor.this.mSession.getUserKind());
                if (!msgs.isEmpty()) {
                    DasMsgProcessor.this.mSession.sendBackToUser(msgs);
                }
            }
        }
    }
}

